--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
--                       http://SmallEiffel.loria.fr
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class ONCE_RESULT
   --
   -- Pseudo variable `Result' inside a once function.
   --

inherit ABSTRACT_RESULT;

creation make

feature {NONE}

   run_feature_6: RUN_FEATURE_6

feature

   result_type: TYPE is
      do
         Result := run_feature_6.result_type;
      end;

   to_runnable(ct: TYPE): like Current is
      local
         rf6: RUN_FEATURE_6;
         rt1, rt2: TYPE;
      do
         Result := Current;
         rf6 ?= small_eiffel.top_rf;
         check
            rf6 /= Void
         end;
         if run_feature_6 = Void then
            run_feature_6 := rf6;
         else
            rt1 := rf6.result_type.run_type;
            rt2 := run_feature_6.result_type.run_type;
            if rt1.run_time_mark /= rt2.run_time_mark then
               eh.add_position(rt1.start_position);
               eh.add_position(rt2.start_position);
               run_feature_6.fe_vffd7;
            end;
         end;
      end;

   compile_to_c is
      do
         run_feature_6.cpp_once_result;
      end;

   compile_to_jvm is
      do
         run_feature_6.jvm_result_load;
      end;

   jvm_assign is
      do
         run_feature_6.jvm_result_store;
      end;

feature {CREATION_CALL}

   c_variable_name: STRING is
      do
         Result := run_feature_6.c_variable_name;
      end;

end -- ONCE_RESULT

