/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))


/* --- Mangling Table Start ---
A*1  T10   R PRINT_JVM_CLASS 10
A*1  T40   R SMALL_EIFFEL 40
A 2  T39   R STD_OUTPUT 41,39
A 1  T6    E BOOLEAN 6
A 1  T41   R STD_INPUT_OUTPUT 41
A*1  T18   R INTEGER_REF 18
A*1  T45   R CP_INFO 45
A 1  T2    E INTEGER 2
A 1  T52   E BIT 32 52
A 1  T3    E CHARACTER 3
A*1  T26   R FIXED_ARRAY[STRING] 26
A 1  T8    E POINTER 8
A*1  T37   R STD_ERROR 37
A*1  T36   R ECHO 36
A*1  T32   R STD_FILE_READ 32
A*1  T31   R SYSTEM_TOOLS 31
A*1  T47   R FIXED_ARRAY[CP_INFO] 47
A*1  T43   R FIXED_ARRAY[INTEGER] 43
A 1  T49   E BIT 8 49
A*1  T22   R BINARY_FILE_READ 22
A*1  T7    R STRING 7
A 1  T27   E NATIVE_ARRAY[STRING] 27
A*1  T35   R ARRAY[STRING] 35
A*1  T46   R CONSTANT_POOL 46
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T48   E NATIVE_ARRAY[CP_INFO] 48
A 1  T44   E NATIVE_ARRAY[INTEGER] 44
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S10 T10;
typedef void*T40;
typedef struct S39 T39;
typedef struct S41 T41;
typedef struct S18 T18;
typedef struct S45 T45;
typedef unsigned int T52;
typedef struct S26 T26;
typedef void*T37;
typedef struct S36 T36;
typedef struct S32 T32;
typedef struct S31 T31;
typedef struct S47 T47;
typedef struct S43 T43;
typedef unsigned char T49;
typedef struct S22 T22;
typedef struct S7 T7;
typedef struct S35 T35;
typedef struct S46 T46;

/*C Header Pass 2 :*/
typedef T0**T27;
typedef T3*T9;
typedef T0**T48;
typedef T2*T44;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
struct S10{T2 _constant_pool_count;T0* _access_flag;T2 _this_class_idx;T2 _super_class_idx;T2 _interfaces_count;T2 _fields_count;T2 _methods_count;T2 _attributes_count;};
extern T10 M10;
extern T40 M40;
struct S39{int id;};
extern T39 M39;
struct S41{int id;};
extern T41 M41;
struct S18{T2 _item;};
extern T18 M18;
struct S45{T3 _tag;T0* _info;};
extern T45 M45;
struct S26{T27 _storage;T2 _capacity;T2 _upper;};
extern T26 M26;
extern T37 M37;
struct S36{T6 _verbose;};
extern T36 M36;
struct S32{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T32 M32;
struct S31{T0* _system_name;T0* _sys_directory;T0* _bin_directory;};
extern T31 M31;
struct S47{T48 _storage;T2 _capacity;T2 _upper;};
extern T47 M47;
struct S43{T44 _storage;T2 _capacity;T2 _upper;};
extern T43 M43;
struct S22{T0* _path;T2 _last_byte;T8 _output_stream;};
extern T22 M22;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S35{T27 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T35 M35;
struct S46{T2 _cp_up;};
extern T46 M46;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
T6 r6_px_and(T6 C,T6 a1);
T2 r2_px_94(T2 C,T2 a1);
T3 r2digit(T2 C);
void r2append_in(T2 C,T0* a1);
T0* r3to_hexadecimal(T3 C);
void r3to_hexadecimal_in(T3 C,T0* a1);
T3 r3to_upper(T3 C);
T49 r49_px_646262(T49 C,T2 a1);
T6 r27equal_like(T0* a1,T0* a2);
void r27set_all_with(T27 C,T0* a1,T2 a2);
T2 r27index_of(T27 C,T0* a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
T48 r48realloc(T48 C,T2 a1,T2 a2);
void r48copy_from(T48 C,T48 a1,T2 a2);
void r48set_all_with(T48 C,T0* a1,T2 a2);
T44 r44realloc(T44 C,T2 a1,T2 a2);
void r44copy_from(T44 C,T44 a1,T2 a2);
T6 r7is_equal(T7* C,T0* a1);
T3 r7last(T7* C);
void r7make(T7* C,T2 a1);
T8 r7to_external(T7* C);
void r7swap(T7* C,T2 a1,T2 a2);
void r7copy(T7* C,T0* a1);
T0* r7substring(T7* C,T2 a1,T2 a2);
void r7remove_last(T7* C,T2 a1);
T0* r7twin(T7* C);
void r7append(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
void r7to_upper(T7* C);
void r7set_last(T7* C,T3 a1);
void r26make(T26* C,T2 a1);
void r47add_last(T47* C,T0* a1);
void r47make(T47* C,T2 a1);
void r43add_last(T43* C,T2 a1);
void r43with_capacity(T43* C,T2 a1);
T2 r35index_of(T35* C,T0* a1);
T0* r35item(T35* C,T2 a1);
void r39put_string(T39* C,T0* a1);
void r39flush(T39* C);
void r39put_character(T39* C,T3 a1);
void r41put_string(T41* C,T0* a1);
void r41put_integer(T41* C,T2 a1);
extern T0*oBC38tmp_string;
void r45clear(T45* C);
void r45set_double(T45* C,T0* a1);
void r45set_fieldref(T45* C,T0* a1);
void r45set_name_and_type(T45* C,T0* a1);
void r45set_methodref(T45* C,T0* a1);
T6 r45is_class(T45* C);
void r45set_long(T45* C,T0* a1);
void r45set_class(T45* C,T0* a1);
void r45view_in(T45* C,T0* a1);
void r45set_float(T45* C,T0* a1);
void r45set_interface_methodref(T45* C,T0* a1);
void r45set_integer(T45* C,T0* a1);
void r45set_utf8(T45* C,T0* a1);
extern T0*oBC12constant_pool;
void r45set_string(T45* C,T0* a1);
T2 r45u2_to_integer(T45* C,T2 a1);
void r37put_string(T37* C,T0* a1);
void r36put_string(T36* C,T0* a1);
void r36sfr_connect(T36* C,T0* a1,T0* a2);
void r36w_put_string(T0* a1);
void r36w_put_character(T3 a1);
extern T0*oBC1std_error;
extern T0*oBC1std_output;
void r32disconnect(T32* C);
void r32read_line_in(T32* C,T0* a1);
extern T0*oBC33last_string;
void r32read_line(T32* C);
void r32connect_to(T32* C,T0* a1);
T0* r31get_environment_variable(T31* C,T0* a1);
void r31make(T31* C);
extern T0*oBC12echo;
extern T0*oBC31system_list;
extern T0*oBC12tmp_file_read;
void r31bad_use_exit(T31* C,T0* a1);
T6 r31slash_separator(T31* C);
void r31add_directory(T31* C,T0* a1,T0* a2);
void r31parent_directory(T31* C,T0* a1);
T6 r31backslash_separator(T31* C);
void r22disconnect(T22* C);
T6 r22end_of_input(T22* C);
T8 r22bfr_open(T2 a1,T8 a2);
void r22read_byte(T22* C);
void r22connect_to(T22* C,T0* a1);
extern T0*oBC10tmp_string;
extern T0*oBC1io;
T0* r10hexa1_at(T2 a1);
T0* r10hexa2_at(T2 a1);
extern T0*oBC10bytes;
T0* r10u2_at(T2 a1);
void r10cp_info_tag_name_in(T3 a1,T0* a2);
T2 r10print_method_info(T10* C,T2 a1);
T2 r10u2_integer_at(T2 a1);
T0* r10hexa4_at(T2 a1);
T2 r10print_field_info(T10* C,T2 a1);
T0* r10u4_at(T2 a1);
T2 r10print_code_attribute(T10* C,T2 a1,T2 a2);
T0* r10u8_at(T2 a1);
T2 r10u4_integer_at(T2 a1);
extern T0*oBC12small_eiffel;
T0* r10hexa8_at(T2 a1);
void r10make(T10* C);
void r10inst_opcode(T0* a1);
void r10bad_class_file(T10* C,T0* a1,T2 a2);
void r10show_dump_line(T0* a1,T0* a2,T2 a3,T2 a4,T2 a5);
void r10print_cp_info_fields_methods(T10* C,T2 a1,T0* a2);
void r10view_pc(T2 a1,T2 a2);
void r10print_exception_table(T10* C,T2 a1,T2 a2);
T3 r10character_at(T2 a1);
void r10u2sign_extended_view(T0* a1,T2 a2);
T0* r10argument(T2 a1);
T2 r10load_cp_info(T10* C,T2 a1,T2 a2);
T2 r10print_attribute_info(T10* C,T2 a1);
extern T0*oBC10inst;
T2 r10print_cp_info(T10* C,T2 a1,T2 a2);
T2 r10u2_to_integer(T0* a1);
void r10inst_view(T10* C,T2 a1,T3 a2);
T2 r10print_one_instruction(T10* C,T2 a1,T2 a2);
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r10command_arguments(void);
extern int fBC12system_tools;
extern T0*oBC12system_tools;
T0* r10system_tools(void);
void r10extend_string(T0* a1,T3 a2,T2 a3);
void r10integer_to_hexa_in(T2 a1,T0* a2);
void r10print_byte_code(T10* C,T2 a1,T2 a2);
T6 r10is_flag_version(T10* C,T0* a1);
T0* r46add_last(T46* C);
T6 r46is_class(T2 a1);
extern T0*oBC46cp;
void r46reset(T46* C,T2 a1);
T6 r46valid_index(T46* C,T2 a1);
T0* r46item(T2 a1);
extern T10*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 53
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms10_21996aaaa;
extern T7*ms10_6930a;
extern T7*ms10_366aa;
extern T7*ms10_32aaa;
extern T7*ms10_288aa;
extern T7*ms10_180aa;
extern T7*ms10_8740a;
extern T7*ms10_6416a;
extern T7*ms10_5348a;
extern T7*ms10_2610a;
extern T7*ms10_6678a;
extern T7*ms10_128aa;
extern T7*ms10_102aa;
extern T7*ms10_1744a;
extern T7*ms10_422aa;
extern T7*ms10_428aa;
extern T7*ms10_408aa;
extern T7*ms10_1728a;
extern T7*ms10_5516a;
extern T7*ms10_4278a;
extern T7*ms10_336aa;
extern T7*ms10_144aa;
extern T7*ms10_1310a;
extern T7*ms10_21996aaaaaaaa;
extern T7*ms10_21996aaaaaaaaaaa;
extern T7*ms10_21996aaaaa;
extern T7*ms10_366aaa;
extern T7*ms10_17429a;
extern T7*ms10_336aaa;
extern T7*ms10_12958a;
extern T7*ms10_16448a;
extern T7*ms10_180aaa;
extern T7*ms10_408aaa;
extern T7*ms10_14994a;
extern T7*ms10_10864a;
extern T7*ms10_14364a;
extern T7*ms10_21996a;
extern T7*ms10_11219a;
extern T7*ms10_19656a;
extern T7*ms10_128aaa;
extern T7*ms10_1728aa;
extern T7*ms10_13986a;
extern T7*ms10_43877a;
extern T7*ms10_41384a;
extern T7*ms10_38718a;
extern T7*ms10_38853a;
extern T7*ms10_36270a;
extern T7*ms10_34000a;
extern T7*ms10_43920a;
extern T7*ms10_36693a;
extern T7*ms10_34424a;
extern T7*ms10_32225a;
extern T7*ms10_40687a;
extern T7*ms10_33748a;
extern T7*ms10_31575a;
extern T7*ms10_29472a;
extern T7*ms10_27439a;
extern T7*ms10_1310aa;
extern T7*ms10_67221a;
extern T7*ms10_31790a;
extern T7*ms10_34230a;
extern T7*ms10_0;
extern T7*ms10_10;
extern T7*ms10_41;
extern T7*ms10_32;
extern T7*ms10_34;
extern T7*ms10_21996aaaaaaaaa;
extern T7*ms10_270;
extern T7*ms10_310;
extern T7*ms10_180;
extern T7*ms10_960;
extern T7*ms10_990;
extern T7*ms10_380;
extern T7*ms13_160;
extern T7*ms13_270;
extern T7*ms31_210;
extern T7*ms31_690;
extern T7*ms10_422;
extern T7*ms10_102;
extern T7*ms10_393;
extern T7*ms10_993;
extern T7*ms10_103;
extern T7*ms10_624;
extern T7*ms10_414;
extern T7*ms10_144;
extern T7*ms10_12958aa;
extern T7*ms10_336aaaa;
extern T7*ms10_21996aa;
extern T7*ms10_408aaaa;
extern T7*ms10_128aaaa;
extern T7*ms10_19656aa;
extern T7*ms10_1310aaa;
extern T7*ms31_285;
extern T7*ms10_756;
extern T7*ms10_906;
extern T7*ms10_366;
extern T7*ms10_336;
extern T7*ms31_636;
extern T7*ms10_21996aaaaaa;
extern T7*ms10_288;
extern T7*ms10_418;
extern T7*ms10_438;
extern T7*ms10_448;
extern T7*ms10_428;
extern T7*ms10_108;
extern T7*ms10_408;
extern T7*ms10_128;
extern T7*ms31_948;
extern T7*ms31_738;
extern T7*ms10_21996aaaaaaaaaaaa;
extern T7*ms13_939;
extern T7*ms10_6930;
extern T7*ms10_3720;
extern T7*ms10_6320;
extern T7*ms10_8800;
extern T7*ms10_7780;
extern T7*ms10_8740;
extern T7*ms10_2610;
extern T7*ms10_9780;
extern T7*ms10_8580;
extern T7*ms10_8300;
extern T7*ms10_2800;
extern T7*ms10_6840;
extern T7*ms10_2670;
extern T7*ms10_7560;
extern T7*ms10_8960;
extern T7*ms10_8710;
extern T7*ms10_9240;
extern T7*ms10_1680;
extern T7*ms10_2650;
extern T7*ms10_7520;
extern T7*ms10_1800;
extern T7*ms10_1700;
extern T7*ms10_1720;
extern T7*ms10_1740;
extern T7*ms10_1620;
extern T7*ms10_5460;
extern T7*ms10_6660;
extern T7*ms10_6690;
extern T7*ms10_4230;
extern T7*ms10_4260;
extern T7*ms10_4620;
extern T7*ms10_8400;
extern T7*ms10_6990;
extern T7*ms10_7410;
extern T7*ms10_7800;
extern T7*ms10_1310;
extern T7*ms10_9261;
extern T7*ms10_8701;
extern T7*ms10_8561;
extern T7*ms10_4002;
extern T7*ms10_4942;
extern T7*ms10_4092;
extern T7*ms10_5362;
extern T7*ms10_7332;
extern T7*ms10_9282;
extern T7*ms10_1692;
extern T7*ms10_1712;
extern T7*ms10_1752;
extern T7*ms10_8722;
extern T7*ms10_8582;
extern T7*ms10_6672;
extern T7*ms10_4732;
extern T7*ms12_1592;
extern T7*ms31_8092;
extern T7*ms10_9093;
extern T7*ms10_8603;
extern T7*ms13_1053;
extern T7*ms10_5784;
extern T7*ms10_1664;
extern T7*ms10_1724;
extern T7*ms10_1744;
extern T7*ms10_5474;
extern T7*ms10_6564;
extern T7*ms10_8414;
extern T7*ms10_7614;
extern T7*ms17_2424;
extern T7*ms10_9845;
extern T7*ms10_7335;
extern T7*ms10_9205;
extern T7*ms10_2365;
extern T7*ms10_2625;
extern T7*ms10_2775;
extern T7*ms10_8715;
extern T7*ms10_5495;
extern T7*ms10_8435;
extern T7*ms31_2395;
extern T7*ms10_5306;
extern T7*ms10_8976;
extern T7*ms10_1136;
extern T7*ms10_6416;
extern T7*ms10_7536;
extern T7*ms10_9226;
extern T7*ms10_1656;
extern T7*ms10_1676;
extern T7*ms10_1716;
extern T7*ms10_1736;
extern T7*ms10_1756;
extern T7*ms10_1596;
extern T7*ms10_8736;
extern T7*ms10_8526;
extern T7*ms10_6666;
extern T7*ms10_6726;
extern T7*ms10_6516;
extern T7*ms10_6546;
extern T7*ms10_4296;
extern T7*ms10_5516;
extern T7*ms10_8096;
extern T7*ms10_5056;
extern T7*ms10_1516;
extern T7*ms31_9226;
extern T7*ms31_1316;
extern T7*ms31_1296;
extern T7*ms10_7407;
extern T7*ms10_4907;
extern T7*ms10_8827;
extern T7*ms10_8757;
extern T7*ms10_8547;
extern T7*ms10_5397;
extern T7*ms10_4038;
extern T7*ms10_7398;
extern T7*ms10_9888;
extern T7*ms10_5348;
extern T7*ms10_1448;
extern T7*ms10_1648;
extern T7*ms10_1688;
extern T7*ms10_1768;
extern T7*ms10_1728;
extern T7*ms10_1588;
extern T7*ms10_1608;
extern T7*ms10_8708;
extern T7*ms10_8778;
extern T7*ms10_6768;
extern T7*ms10_6678;
extern T7*ms10_6708;
extern T7*ms10_6498;
extern T7*ms10_6528;
extern T7*ms10_4248;
extern T7*ms10_4278;
extern T7*ms10_6929;
extern T7*ms10_4809;
extern T7*ms10_5439;
extern T7*ms10_41400;
extern T7*ms10_10600;
extern T7*ms10_23670;
extern T7*ms10_30520;
extern T7*ms10_48220;
extern T7*ms10_28590;
extern T7*ms10_22490;
extern T7*ms10_28210;
extern T7*ms10_35440;
extern T7*ms10_29040;
extern T7*ms10_19050;
extern T7*ms10_38070;
extern T7*ms10_64050;
extern T7*ms10_25320;
extern T7*ms10_35880;
extern T7*ms10_19620;
extern T7*ms10_17300;
extern T7*ms10_21930;
extern T7*ms10_16560;
extern T7*ms10_12220;
extern T7*ms10_11100;
extern T7*ms10_16230;
extern T7*ms10_33750;
extern T7*ms10_36270;
extern T7*ms10_34000;
extern T7*ms10_64610;
extern T7*ms10_87360;
extern T7*ms10_31280;
extern T7*ms10_20610;
extern T7*ms10_43920;
extern T7*ms10_31790;
extern T7*ms10_71440;
extern T7*ms10_13380;
extern T7*ms10_23820;
extern T7*ms10_34230;
extern T7*ms11_48220;
extern T7*ms11_28590;
extern T7*ms11_22490;
extern T7*ms11_28210;
extern T7*ms11_35440;
extern T7*ms11_29040;
extern T7*ms31_46640;
extern T7*ms31_41310;
extern T7*ms31_26180;
extern T7*ms31_38280;
extern T7*ms31_31980;
extern T7*ms31_19880;
extern T7*ms31_10010;
extern T7*ms17_24020;
extern T7*ms10_25011;
extern T7*ms10_14421;
extern T7*ms10_11761;
extern T7*ms10_12571;
extern T7*ms10_67221;
extern T7*ms31_43761;
extern T7*ms10_30912;
extern T7*ms10_19812;
extern T7*ms10_10452;
extern T7*ms10_65892;
extern T7*ms10_29472;
extern T7*ms10_85272;
extern T7*ms10_14092;
extern T7*ms10_13833;
extern T7*ms10_38853;
extern T7*ms10_36693;
extern T7*ms13_18623;
extern T7*ms13_13293;
extern T7*ms10_22344;
extern T7*ms10_28014;
extern T7*ms10_94514;
extern T7*ms10_14994;
extern T7*ms10_10864;
extern T7*ms10_14364;
extern T7*ms10_12474;
extern T7*ms10_41384;
extern T7*ms10_34424;
extern T7*ms10_11424;
extern T7*ms11_28014;
extern T7*ms22_53794;
extern T7*ms31_22824;
extern T7*ms17_10984;
extern T7*ms10_14955;
extern T7*ms10_14775;
extern T7*ms10_84915;
extern T7*ms10_36125;
extern T7*ms10_18445;
extern T7*ms10_34185;
extern T7*ms10_12025;
extern T7*ms10_18195;
extern T7*ms10_33775;
extern T7*ms10_32225;
extern T7*ms10_31575;
extern T7*ms10_33925;
extern T7*ms10_60295;
extern T7*ms11_84915;
extern T7*ms11_36125;
extern T7*ms10_21996aaa;
extern T7*ms10_128aaaaa;
extern T7*ms10_19656aaa;
extern T7*ms10_10a;
extern T7*ms10_34a;
extern T7*ms10_32a;
extern T7*ms10_20106;
extern T7*ms10_12116;
extern T7*ms10_13006;
extern T7*ms10_40086;
extern T7*ms10_15376;
extern T7*ms10_10416;
extern T7*ms10_21996;
extern T7*ms10_13986;
extern T7*ms10_16816;
extern T7*ms10_48256;
extern T7*ms10_28666;
extern T7*ms10_30096;
extern T7*ms10_97566;
extern T7*ms10_56576;
extern T7*ms10_16976;
extern T7*ms10_13286;
extern T7*ms10_19656;
extern T7*ms11_40086;
extern T7*ms31_12816;
extern T7*ms10_17347;
extern T7*ms10_14547;
extern T7*ms10_33327;
extern T7*ms10_18837;
extern T7*ms10_11297;
extern T7*ms10_18557;
extern T7*ms10_21417;
extern T7*ms10_43877;
extern T7*ms10_40687;
extern T7*ms11_14547;
extern T7*ms10_17888;
extern T7*ms10_13848;
extern T7*ms10_12958;
extern T7*ms10_16548;
extern T7*ms10_16448;
extern T7*ms10_17008;
extern T7*ms10_38718;
extern T7*ms10_33748;
extern T7*ms10_13488;
extern T7*ms36_26208;
extern T7*ms10_15309;
extern T7*ms10_17429;
extern T7*ms10_12259;
extern T7*ms10_11219;
extern T7*ms10_27439;
extern T7*ms10_34109;
extern T7*ms10_21996aaaaaaaaaa;
extern T7*ms10_126200;
extern T7*ms12_581900;
extern T7*ms10_21996aaaaaaa;
extern T7*ms10_100232;
extern T7*ms40_802392;
extern T7*ms31_716872;
extern T7*ms31_131716;
extern T7*ms31_848426;
extern T7*ms31_225848;
extern T7*ms10_393a;
extern T7*ms10_32aa;
extern T7*ms10_288a;
extern T7*ms10_180a;
extern T7*ms10_128a;
extern T7*ms10_960a;
extern T7*ms10_418a;
extern T7*ms10_438a;
extern T7*ms10_448a;
extern T7*ms10_422a;
extern T7*ms10_428a;
extern T7*ms10_408a;
extern T7*ms10_366a;
extern T7*ms10_336a;
extern T7*ms10_144a;
extern T7*ms10_102a;
extern T7*ms10_21996aaaaaaaaaaaaa;
T7*se_ms(int c,char*e);
T7*se_string_from_external_copy(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void se_msi5(void);
void se_msi6(void);
void se_msi7(void);
void se_msi8(void);
void se_msi9(void);
void*se_ma35(int argc,...);
void X39put_string(void *C,T0* a1);
void X39flush(void *C);

