/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))


/* --- Mangling Table Start ---
A*1  T31   R SMALL_EIFFEL 31
A*1  T29   R STD_OUTPUT 29
A 1  T6    E BOOLEAN 6
A*1  T39   R PARSER_BUFFER 39
A 1  T2    E INTEGER 2
A 1  T3    E CHARACTER 3
A*1  T27   R FIXED_ARRAY[STRING] 27
A 1  T8    E POINTER 8
A*1  T38   R STD_ERROR 38
A*1  T37   R ECHO 37
A*1  T34   R STD_FILE_READ 34
A*1  T33   R SYSTEM_TOOLS 33
A*1  T42   R FIXED_ARRAY[INTEGER] 42
A*1  T7    R STRING 7
A 1  T28   E NATIVE_ARRAY[STRING] 28
A*1  T10   R FINDER 10
A*1  T36   R ARRAY[STRING] 36
A*1  T41   R DICTIONARY[STRING,STRING] 41
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T43   E NATIVE_ARRAY[INTEGER] 43
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef void*T31;
typedef void*T29;
typedef struct S39 T39;
typedef struct S27 T27;
typedef void*T38;
typedef struct S37 T37;
typedef struct S34 T34;
typedef struct S33 T33;
typedef struct S42 T42;
typedef struct S7 T7;
typedef void*T10;
typedef struct S36 T36;
typedef struct S41 T41;

/*C Header Pass 2 :*/
typedef T0**T28;
typedef T3*T9;
typedef T2*T43;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
extern T31 M31;
extern T29 M29;
struct S39{T0* _path;T2 _count;};
extern T39 M39;
struct S27{T28 _storage;T2 _capacity;T2 _upper;};
extern T27 M27;
extern T38 M38;
struct S37{T6 _verbose;};
extern T37 M37;
struct S34{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T34 M34;
struct S33{T0* _system_name;T0* _sys_directory;T0* _bin_directory;};
extern T33 M33;
struct S42{T43 _storage;T2 _capacity;T2 _upper;};
extern T42 M42;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
extern T10 M10;
struct S36{T28 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T36 M36;
struct S41{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T41 M41;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
T3 r3to_lower(T3 C);
T6 r3is_separator(T3 C);
T3 r3to_upper(T3 C);
T28 r28realloc(T28 C,T2 a1,T2 a2);
T6 r28equal_like(T0* a1,T0* a2);
void r28copy_from(T28 C,T28 a1,T2 a2);
void r28set_all_with(T28 C,T0* a1,T2 a2);
T2 r28index_of(T28 C,T0* a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
T43 r43realloc(T43 C,T2 a1,T2 a2);
void r43copy_from(T43 C,T43 a1,T2 a2);
void r43set_all_with(T43 C,T2 a1,T2 a2);
void r7to_lower(T7* C);
T6 r7is_equal(T7* C,T0* a1);
void r7remove_first(T7* C,T2 a1);
T3 r7last(T7* C);
void r7remove_between(T7* C,T2 a1,T2 a2);
void r7make(T7* C,T2 a1);
T8 r7to_external(T7* C);
void r7prepend(T7* C,T0* a1);
void r7copy(T7* C,T0* a1);
T2 r7hash_code(T7* C);
void r7remove_last(T7* C,T2 a1);
void r7head(T7* C,T2 a1);
T0* r7twin(T7* C);
void r7append(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
void r7to_upper(T7* C);
void r7set_last(T7* C,T3 a1);
void r27add_last(T27* C,T0* a1);
void r27with_capacity(T27* C,T2 a1);
void r27make(T27* C,T2 a1);
void r27resize(T27* C,T2 a1);
void r42add_last(T42* C,T2 a1);
void r42make(T42* C,T2 a1);
void r42resize(T42* C,T2 a1);
void r36with_capacity(T36* C,T2 a1,T2 a2);
void r36add_last(T36* C,T0* a1);
T2 r36index_of(T36* C,T0* a1);
T2 r36count(T36* C);
T0* r36item(T36* C,T2 a1);
void r41with_capacity(T41* C,T2 a1);
void r41resize_buckets(T41* C,T2 a1);
void r41expand(T41* C);
T0* r41at(T41* C,T0* a1);
void r41put(T41* C,T0* a1,T0* a2);
T6 r41has(T41* C,T0* a1);
T0* r31find_path_for(T31* C,T0* a1);
extern T0*oBC31parser_buffer_path;
extern int fBC31loading_path;
extern T0*oBC31loading_path;
T0* r31loading_path(void);
extern int fBC31rename_dictionary;
extern T0*oBC31rename_dictionary;
T0* r31rename_dictionary(T31* C);
extern T0*oBC12echo;
extern T0*oBC12tmp_file_read;
extern int fBC12system_tools;
extern T0*oBC12system_tools;
T0* r31system_tools(void);
T6 r31parser_buffer_for(T31* C,T0* a1);
extern T0*oBC31tmp_tail;
extern T0*oBC12parser_buffer;
void r37put_string(T37* C,T0* a1);
void r37sfr_connect(T37* C,T0* a1,T0* a2);
void r37w_put_string(T0* a1);
void r37w_put_character(T3 a1);
extern T0*oBC1std_error;
extern T0*oBC1std_output;
void r39load_file(T39* C,T0* a1);
extern T0*oBC39text;
T0* r39get_line(T2 a1);
void r38put_string(T38* C,T0* a1);
void r34disconnect(T34* C);
void r34read_line_in(T34* C,T0* a1);
T6 r34end_of_input(T34* C);
extern T0*oBC35last_string;
void r34read_character(T34* C);
void r34read_line(T34* C);
void r34read_word(T34* C);
void r34connect_to(T34* C,T0* a1);
void r34skip_separators(T34* C);
void r33environment_variable_substitution(T33* C,T0* a1,T0* a2);
T6 r33backslash_separator(T33* C);
T0* r33get_environment_variable(T33* C,T0* a1);
void r33make(T33* C);
extern T0*oBC33system_list;
void r33bad_use_exit(T33* C,T0* a1);
T6 r33slash_separator(T33* C);
void r33append_lp_in(T33* C,T0* a1,T0* a2);
void r33loading_path_add(T33* C,T0* a1,T0* a2,T2 a3);
void r33add_directory(T33* C,T0* a1,T0* a2);
void r33parent_directory(T33* C,T0* a1);
void r33read_loading_path_in(T33* C,T0* a1);
void r29put_string(T29* C,T0* a1);
extern T0*oBC12small_eiffel;
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r10command_arguments(void);
void r10make(T10* C);
T0* r10argument(T2 a1);
T0* r10system_tools(void);
T6 r10is_flag_verbose(T0* a1);
T6 r10is_flag_version(T10* C,T0* a1);
extern T10*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 44
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms13_160;
extern T7*ms13_270;
extern T7*ms33_270;
extern T7*ms33_210;
extern T7*ms33_690;
extern T7*ms31_112;
extern T7*ms33_132;
extern T7*ms12_294;
extern T7*ms33_285;
extern T7*ms31_336;
extern T7*ms33_636;
extern T7*ms33_948;
extern T7*ms33_738;
extern T7*ms13_939;
extern T7*ms31_5160;
extern T7*ms10_7241;
extern T7*ms10_7212;
extern T7*ms12_1592;
extern T7*ms33_6412;
extern T7*ms33_8092;
extern T7*ms13_1053;
extern T7*ms11_2424;
extern T7*ms33_9785;
extern T7*ms33_2395;
extern T7*ms33_5166;
extern T7*ms33_3636;
extern T7*ms33_9226;
extern T7*ms33_1316;
extern T7*ms33_1296;
extern T7*ms33_8478;
extern T7*ms11_24020;
extern T7*ms31_12960;
extern T7*ms31_24060;
extern T7*ms33_82530;
extern T7*ms33_11880;
extern T7*ms33_33210;
extern T7*ms33_46640;
extern T7*ms33_41310;
extern T7*ms33_26180;
extern T7*ms33_38280;
extern T7*ms33_31980;
extern T7*ms33_19880;
extern T7*ms33_10010;
extern T7*ms33_43761;
extern T7*ms11_10272;
extern T7*ms31_55332;
extern T7*ms31_48112;
extern T7*ms13_18623;
extern T7*ms13_13293;
extern T7*ms11_10984;
extern T7*ms33_25494;
extern T7*ms33_22824;
extern T7*ms31_53165;
extern T7*ms33_76935;
extern T7*ms33_12816;
extern T7*ms37_26208;
extern T7*ms33_18029;
extern T7*ms12_581900;
extern T7*ms31_802392;
extern T7*ms33_716872;
extern T7*ms33_131716;
extern T7*ms33_848426;
extern T7*ms33_225848;
T7*se_ms(int c,char*e);
T7*se_string_from_external_copy(char*e);
void se_msi1(void);
void se_msi2(void);
void*se_ma36(int argc,...);

