/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))


/* --- Mangling Table Start ---
A 1  T145  R CALL_PREFIX_NOT 145
D 2  T154  R ABSTRACT_RESULT 155,156
A 1  T156  R ORDINARY_RESULT 156
A 1  T178  R LOCAL_VAR_LIST 178
A 1  T203  E NATIVE_ARRAY[INTEGER_CONSTANT] 203
D 8  T214  R ROUTINE 306,305,303,302,291,290,287,285
A 1  T339  E NATIVE_ARRAY[EFFECTIVE_ARG_LIST] 339
A 1  T281  E NATIVE_ARRAY[FORMAL_GENERIC_ARG] 281
A*1  T259  R ARRAY[TYPE] 259
A*1  T39   R SMALL_EIFFEL 39
A*1  T371  R DICTIONARY[TYPE_REF_TO_EXP,STRING] 371
A*1  T348  R DICTIONARY[MANIFEST_STRING,STRING] 348
A*1  T279  R ARRAY[FORMAL_GENERIC_ARG] 279
A 1  T269  R TYPE_NONE 269
A 1  T218  R E_CHECK 218
A 2  T360  R ARRAY[RUN_FEATURE] 360,361
A*1  T317  R ARRAY[EXPORT_ITEM] 317
A*1  T308  R ARRAY[DECLARATION] 308
A 1  T185  R ARRAY[LOCAL_NAME1] 185
A*1  T90   R ARRAY[RENAME_PAIR] 90
A 1  T245  R LOOP_VARIANT_2 245
A*1  T21   R STRING_ALIASER 21
A 1  T142  R PREFIX_NAME 142
A 1  T273  R TYPE_CLASS 273
A 1  T130  R CALL_INFIX_EQ 130
A*1  T93   R DICTIONARY[E_FEATURE,STRING] 93
A*1  T62   R DICTIONARY[RUN_CLASS,STRING] 62
A 1  T327  E NATIVE_ARRAY[RUN_FEATURE] 327
A 1  T319  E NATIVE_ARRAY[EXPORT_ITEM] 319
A 1  T309  E NATIVE_ARRAY[DECLARATION] 309
A 1  T224  E NATIVE_ARRAY[INSTRUCTION] 224
A 1  T186  E NATIVE_ARRAY[LOCAL_NAME1] 186
A 1  T91   E NATIVE_ARRAY[RENAME_PAIR] 91
A 1  T122  R CALL_INFIX_AND 122
A*1  T36   R STD_OUTPUT 36
A*1  T386  R MEMO[E_OLD] 386
A 1  T262  E NATIVE_ARRAY[TYPE] 262
A 1  T6    E BOOLEAN 6
A 1  T373  R FIXED_ARRAY[TYPE_REF_TO_EXP] 373
A 1  T208  R FIXED_ARRAY[MANIFEST_STRING] 208
A*1  T19   R INTEGER_REF 19
A 1  T211  R CST_ATT_REAL 211
A*1  T98   R FEATURE_CLAUSE 98
A 1  T374  E NATIVE_ARRAY[TYPE_REF_TO_EXP] 374
A 1  T312  E NATIVE_ARRAY[LOCAL_ARGUMENT1] 312
A 1  T209  E NATIVE_ARRAY[MANIFEST_STRING] 209
A 1  T78   E NATIVE_ARRAY[CREATION_CLAUSE] 78
A 1  T120  R CALL_INFIX_OR 120
A*1  T74   R PARSER_BUFFER 74
A*1  T334  R FIXED_ARRAY[DICTIONARY[RUN_FEATURE,STRING]] 334
A 1  T266  R TYPE_CHARACTER 266
A 1  T283  R REVERSE_ASSIGNMENT 283
A 1  T335  E NATIVE_ARRAY[DICTIONARY[RUN_FEATURE,STRING]] 335
A 1  T383  R PRECURSOR_NAME 383
A 1  T158  R WRITTEN_CURRENT 158
A 1  T313  R DECLARATION_1 313
A 1  T2    E INTEGER 2
A 1  T305  R ONCE_PROCEDURE 305
A*1  T198  R TMP_FEATURE 198
A*1  T103  R ASSERTION 103
A*1  T341  R MANIFEST_ARRAY_POOL 341
A*1  T96   R FORMAL_GENERIC_LIST 96
A*1  T97   R FEATURE_CLAUSE_LIST 97
A*1  T41   R ERROR_HANDLER 41
A*1  T83   R COMMENT 83
D 3  T162  R PROC_CALL 165,164,163
D 11 T55   R RUN_FEATURE 356,54,390,388,378,389,368,379,384,382,324
A 1  T3    E CHARACTER 3
A 1  T212  R CST_ATT_DOUBLE 212
A 1  T199  R CST_ATT_UNIQUE 199
A*1  T204  R COUNTER 204
A*1  T340  R FIXED_ARRAY[PARENT] 340
A*1  T31   R FIXED_ARRAY[STRING] 31
D 2  T237  R WHEN_ITEM 241,240
A 1  T8    E POINTER 8
A 1  T257  R TYPE_LIKE_CURRENT 257
A 1  T267  R TYPE_DOUBLE 267
A 1  T133  R CALL_INFIX_DIV 133
A 1  T147  R E_STRIP 147
A*1  T243  R LOOP_INVARIANT 243
A 1  T387  R IMPLICIT_CAST 387
A 1  T126  R CALL_INFIX_LT 126
A 1  T124  R CALL_INFIX_GT 124
A*1  T52   R STD_FILE_WRITE 52
A 1  T271  R TYPE_REAL 271
A*1  T357  R RUN_REQUIRE 357
A 1  T183  R LOCAL_NAME1 183
D 8  T200  R CST_ATT 213,206,210,205,207,199,212,211
A 1  T337  E NATIVE_ARRAY[CALL_PROC_CALL] 337
A 1  T192  E NATIVE_ARRAY[ARGUMENT_NAME1] 192
A 1  T100  E NATIVE_ARRAY[FEATURE_CLAUSE] 100
A 1  T261  R TYPE_ARRAY 261
A 1  T293  R NATIVE_WITH_CURRENT 293
A 1  T173  R REAL_CONSTANT 173
A*1  T347  R MANIFEST_STRING_POOL 347
A 1  T300  R NATIVE_JVM_INVOKEVIRTUAL 300
A 1  T180  R LOCAL_NAME2 180
A*1  T349  R ADDRESS_OF_POOL 349
A 1  T264  R TYPE_BOOLEAN 264
A 2  T94   R FIXED_ARRAY[E_FEATURE] 345,94
A*1  T63   R FIXED_ARRAY[RUN_CLASS] 63
A*1  T342  R DICTIONARY[TYPE,INTEGER] 342
A 1  T272  R TYPE_STRING 272
A 1  T135  R CALL_INFIX_INT_DIV 135
A*1  T344  R ONCE_ROUTINE_POOL 344
A*1  T322  R ARRAY[INDEX_CLAUSE] 322
D 5  T141  R CALL_0 143,144,139,150,145
A 1  T258  R TYPE_LIKE_ARGUMENT 258
A*1  T336  R FIXED_ARRAY[CALL_PROC_CALL] 336
D 2  T307  R DECLARATION 313,310
A 1  T366  R CECIL_TARGET 366
A 6  T326  R FIXED_ARRAY[RUN_FEATURE] 391,381,367,352,326,53
A*1  T217  R FIXED_ARRAY[INSTRUCTION] 217
A 1  T292  R NATIVE_SMALL_EIFFEL 292
A 1  T287  R DEFERRED_FUNCTION 287
D 1  T43   R CODE_PRINTER 42
A 1  T207  R CST_ATT_STRING 207
D 2  T129  R CALL_INFIX2 128,130
A*1  T75   R CREATION_CLAUSE_LIST 75
A 1  T231  R E_RETRY 231
A*1  T45   R STD_ERROR 45
A 1  T111  R MANIFEST_ARRAY 111
A 1  T163  R PROC_CALL_0 163
A 1  T134  R CALL_INFIX_INT_REM 134
D 2  T184  R LOCAL_ARGUMENT1 190,183
A 1  T240  R WHEN_ITEM_1 240
D 27 T117  R CALL 113,119,132,143,128,131,136,144,194,139,153,137,123,121,125,127,150,152,134,135,124,126,133,120,122,130,145
A 1  T230  R EXPRESSION_WITH_COMMENT 230
A 1  T164  R PROC_CALL_1 164
A*1  T35   R ECHO 35
A 1  T285  R DEFERRED_PROCEDURE 285
A 1  T4    E REAL 4
A 1  T247  R CREATION_CALL_1 247
A 1  T232  R E_INSPECT 232
A*1  T40   R RUN_CLASS 40
A 1  T152  R CALL_1_C 152
A 1  T150  R CALL_0_C 150
A*1  T234  R WHEN_LIST 234
D 2  T311  R ARRAY[LOCAL_ARGUMENT1] 191,185
A 1  T221  R ARRAY[MANIFEST_STRING] 221
A*1  T77   R ARRAY[CREATION_CLAUSE] 77
A 1  T127  R CALL_INFIX_LE 127
A 1  T125  R CALL_INFIX_GE 125
D 4  T301  R EFFECTIVE_ROUTINE 306,302,303,305
A 1  T241  R WHEN_ITEM_2 241
A*1  T216  R COMPOUND 216
A 1  T73   E NATIVE_ARRAY[POSITION] 73
D 22 T58   R TYPE 372,375,280,277,276,275,274,273,272,271,270,269,268,267,266,264,263,261,260,258,257,255
A 1  T160  R ADDRESS_OF 160
A 1  T298  R NATIVE_JVM_INVOKESTATIC 298
A 1  T379  R RUN_FEATURE_1 379
A*1  T47   R STD_FILE_READ 47
A 1  T310  R DECLARATION_GROUP 310
A 1  T59   R BIT_CONSTANT 59
A 1  T222  R IFTHENELSE 222
A*1  T50   R RUN_CONTROL 50
A 1  T280  R TYPE_FORMAL_GENERIC 280
A 1  T351  E NATIVE_ARRAY[ADDRESS_OF] 351
A 1  T197  E NATIVE_ARRAY[CLASS_NAME] 197
A 1  T112  E NATIVE_ARRAY[EXPRESSION] 112
A 1  T70   E NATIVE_ARRAY[BASE_CLASS] 70
A 1  T250  R CREATION_CALL_2 250
A*1  T316  R EXPORT_ITEM 316
A*1  T107  R TAG_NAME 107
A 1  T392  E NATIVE_ARRAY[RUN_FEATURE_5] 392
A 1  T369  E NATIVE_ARRAY[RUN_FEATURE_9] 369
A 1  T362  E NATIVE_ARRAY[RUN_FEATURE_2] 362
A 1  T353  E NATIVE_ARRAY[RUN_FEATURE_3] 353
A 1  T346  E NATIVE_ARRAY[ONCE_FUNCTION] 346
A 1  T56   E NATIVE_ARRAY[RUN_FEATURE_6] 56
A*1  T215  R E_ENSURE 215
A*1  T66   R CLASS_NAME 66
A 1  T270  R TYPE_POINTER 270
A 1  T268  R TYPE_INTEGER 268
A*1  T46   R SYSTEM_TOOLS 46
A 1  T356  R RUN_FEATURE_2 356
A 1  T138  R INFIX_NAME 138
D 6  T265  R TYPE_BASIC_EIFFEL_EXPANDED 268,270,264,271,267,266
A*1  T44   R DOUBLE_REF 44
A 1  T121  R CALL_INFIX_OR_ELSE 121
D 17 T161  R INSTRUCTION 283,282,254,252,250,247,244,232,231,222,225,220,218,177,165,164,163
A*1  T27   R FIXED_ARRAY[INTEGER] 27
A 1  T275  R TYPE_EXPANDED 275
A 1  T291  R EXTERNAL_FUNCTION 291
A*1  T333  R DICTIONARY[DICTIONARY[RUN_FEATURE,STRING],STRING] 333
A 1  T123  R CALL_INFIX_AND_THEN 123
A 1  T148  R SIMPLE_FEATURE_NAME 148
A 1  T165  R PROC_CALL_N 165
A*1  T109  R TMP_NAME 109
A 1  T331  E SWITCH_COLLECTION 331
A 1  T315  R FROZEN_FEATURE_NAME 315
A 1  T252  R CREATION_CALL_3 252
D 2  T242  R LOOP_VARIANT 246,245
A 1  T5    E DOUBLE 5
A 1  T324  R RUN_FEATURE_3 324
A*1  T89   R RENAME_PAIR 89
D 7  T288  R NATIVE 300,298,297,296,295,293,292
A 1  T314  R WRITABLE_ATTRIBUTE 314
A 1  T290  R EXTERNAL_PROCEDURE 290
D 30 T118  R CALL_PROC_CALL 113,119,132,143,128,131,136,144,194,139,153,137,165,123,121,125,127,150,152,164,134,163,135,124,126,133,120,122,130,145
A 1  T391  R FIXED_ARRAY[RUN_FEATURE_5] 391
A 1  T381  R FIXED_ARRAY[RUN_FEATURE_2] 381
A 1  T367  R FIXED_ARRAY[RUN_FEATURE_9] 367
A 1  T352  R FIXED_ARRAY[RUN_FEATURE_3] 352
A 1  T345  R FIXED_ARRAY[ONCE_FUNCTION] 345
A 1  T53   R FIXED_ARRAY[RUN_FEATURE_6] 53
A 1  T157  R E_VOID 157
A 1  T388  R RUN_FEATURE_4 388
A 1  T254  R CREATION_CALL_4 254
A 1  T361  R ARRAY[RUN_FEATURE_2] 361
A 1  T177  R E_PRECURSOR_PROCEDURE 177
A*1  T101  R CLIENT_LIST 101
A*1  T10   R COMPILE_TO_C 10
A 1  T332  E SWITCH 332
A*1  T7    R STRING 7
D 2  T284  R DEFERRED_ROUTINE 285,287
A 1  T168  R E_TRUE 168
A*1  T364  R CECIL_POOL 364
A 1  T236  E NATIVE_ARRAY[E_WHEN] 236
A 1  T229  E NATIVE_ARRAY[IFTHEN] 229
A 1  T82   E NATIVE_ARRAY[PARENT] 82
A 1  T32   E NATIVE_ARRAY[STRING] 32
A 1  T137  R CALL_INFIX_FREEOP 137
A 1  T303  R FUNCTION 303
A 1  T146  R E_OLD 146
A*1  T226  R IFTHEN 226
A 1  T205  R CST_ATT_BOOLEAN 205
A*1  T87   R RENAME_LIST 87
A 1  T297  R NATIVE_INLINE_WITHOUT_CURRENT 297
D 2  T176  R E_PRECURSOR 175,177
A*1  T79   R PARENT_LIST 79
A 1  T390  R RUN_FEATURE_5 390
A 1  T153  R CALL_N 153
A*1  T102  R ID_PROVIDER 102
A 1  T139  R CALL_PREFIX_FREEOP 139
A*1  T72   R POSITION 72
A*1  T278  R FORMAL_GENERIC_ARG 278
A*1  T354  R ARRAY[BOOLEAN] 354
A*1  T172  R ARRAY[INTEGER] 172
A*1  T233  R E_WHEN 233
A 1  T263  R TYPE_NATIVE_ARRAY 263
D 5  T84   R FEATURE_NAME 383,315,148,138,142
A 1  T155  R ONCE_RESULT 155
A*1  T320  R INDEX_CLAUSE 320
A 1  T54   R RUN_FEATURE_6 54
A 1  T244  R E_LOOP 244
A*1  T80   R PARENT 80
A 1  T210  R CST_ATT_BIT 210
A 1  T175  R E_PRECURSOR_FUNCTION 175
A 1  T377  E NATIVE_ARRAY[TYPE_BIT_REF] 377
A 1  T329  E NATIVE_ARRAY[BIT_CONSTANT] 329
A 1  T323  E NATIVE_ARRAY[INDEX_CLAUSE] 323
A 1  T88   E NATIVE_ARRAY[FEATURE_NAME] 88
A*1  T318  R EXPORT_LIST 318
A*1  T235  R ARRAY[E_WHEN] 235
A*1  T228  R ARRAY[IFTHEN] 228
A*1  T81   R ARRAY[PARENT] 81
A*1  T49   R ARRAY[STRING] 49
A*1  T358  R ARRAY[E_REQUIRE] 358
A*1  T328  R ARRAY[RUN_CLASS] 328
A*1  T238  R ARRAY[WHEN_ITEM] 238
A*1  T104  R ARRAY[ASSERTION] 104
D 2  T304  R ONCE_ROUTINE 306,305
A 1  T295  R NATIVE_INLINE_WITH_CURRENT 295
A 1  T389  R RUN_FEATURE_7 389
A 1  T274  R TYPE_GENERIC 274
A 1  T350  R FIXED_ARRAY[ADDRESS_OF] 350
A*1  T196  R FIXED_ARRAY[CLASS_NAME] 196
A 5  T151  R FIXED_ARRAY[EXPRESSION] 61,350,208,202,151
A*1  T69   R FIXED_ARRAY[BASE_CLASS] 69
A 3  T343  R FIXED_ARRAY[TYPE] 376,373,343
D 2  T289  R EXTERNAL_ROUTINE 290,291
D 2  T179  R DECLARATION_LIST 187,178
A 1  T255  R TYPE_LIKE_FEATURE 255
D 52 T60   R EXPRESSION 387,366,190,183,230,113,119,120,121,122,123,124,126,125,127,128,130,131,132,133,134,135,136,194,137,146,193,188,180,175,174,173,59,171,170,169,168,160,158,157,156,155,153,152,150,148,147,139,143,144,145,111
A*1  T338  R FIXED_ARRAY[EFFECTIVE_ARG_LIST] 338
A 1  T194  R CALL_INFIX_POWER 194
A*1  T325  R DICTIONARY[RUN_FEATURE,STRING] 325
A 1  T378  R RUN_FEATURE_8 378
A*1  T363  R EXCEPTIONS_HANDLER 363
D 2  T57   R TYPE_BIT 277,276
A*1  T76   R CREATION_CLAUSE 76
A 1  T190  R ARGUMENT_NAME1 190
A*1  T219  R CHECK_INVARIANT 219
A*1  T71   R FIXED_ARRAY[POSITION] 71
A 4  T110  R ARRAY[EXPRESSION] 191,185,221,110
A 1  T368  R RUN_FEATURE_9 368
A*1  T330  R GC_HANDLER 330
A 1  T225  R INSTRUCTION_WITH_COMMENT 225
A*1  T42   R C_PRETTY_PRINTER 42
A 2  T149  R EFFECTIVE_ARG_LIST 365,149
A 1  T144  R CALL_PREFIX_PLUS 144
A 1  T136  R CALL_INFIX_TIMES 136
A 1  T131  R CALL_INFIX_MINUS 131
A*1  T23   R DICTIONARY[STRING,STRING] 23
A 1  T206  R CST_ATT_CHARACTER 206
A 1  T128  R CALL_INFIX_NEQ 128
A 1  T372  R TYPE_REF_TO_EXP 372
D 17 T92   R E_FEATURE 314,306,305,303,302,291,290,287,285,213,212,211,210,207,206,205,199
A 1  T359  E NATIVE_ARRAY[E_REQUIRE] 359
A 1  T239  E NATIVE_ARRAY[WHEN_ITEM] 239
A 1  T108  E NATIVE_ARRAY[ASSERTION] 108
A 1  T95   E NATIVE_ARRAY[E_FEATURE] 95
A 1  T64   E NATIVE_ARRAY[RUN_CLASS] 64
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T143  R CALL_PREFIX_MINUS 143
A*1  T68   R DICTIONARY[BASE_CLASS,STRING] 68
A 1  T375  R TYPE_BIT_REF 375
A 1  T376  R FIXED_ARRAY[TYPE_BIT_REF] 376
A*1  T86   R FIXED_ARRAY[FEATURE_NAME] 86
A 1  T61   R FIXED_ARRAY[BIT_CONSTANT] 61
A 1  T170  R CHARACTER_CONSTANT 170
D 2  T166  R BOOLEAN_CONSTANT 169,168
A 1  T188  R ARGUMENT_NAME2 188
A 1  T302  R PROCEDURE 302
A 1  T213  R CST_ATT_INTEGER 213
A 1  T132  R CALL_INFIX_PLUS 132
A 1  T382  R RUN_FEATURE_10 382
A*1  T227  R IFTHENLIST 227
A*1  T65   R BASE_CLASS 65
A 1  T306  R ONCE_FUNCTION 306
A 1  T202  R FIXED_ARRAY[INTEGER_CONSTANT] 202
A 1  T260  R TYPE_ANY 260
A 1  T51   E FILE_TOOLS 51
A 1  T276  R TYPE_BIT_1 276
A 1  T174  R INTEGER_CONSTANT 174
A 1  T282  R ASSIGNMENT 282
A 1  T169  R E_FALSE 169
A*1  T321  R INDEX_LIST 321
A 1  T119  R CALL_INFIX_XOR 119
A 1  T365  R CECIL_ARG_LIST 365
A*1  T85   R FEATURE_NAME_LIST 85
A 1  T220  R E_DEBUG 220
A 1  T191  R ARRAY[ARGUMENT_NAME1] 191
A*1  T99   R ARRAY[FEATURE_CLAUSE] 99
A 1  T171  R MANIFEST_STRING 171
A 1  T187  R FORMAL_ARG_LIST 187
A 1  T193  R IMPLICIT_CURRENT 193
A 1  T113  R CALL_INFIX_IMPLIES 113
A*1  T195  R CLASS_NAME_LIST 195
A*1  T105  R CLASS_INVARIANT 105
A*1  T286  R E_REQUIRE 286
A 1  T277  R TYPE_BIT_2 277
A 1  T355  E NATIVE_ARRAY[BOOLEAN] 355
A 1  T28   E NATIVE_ARRAY[INTEGER] 28
A 1  T246  R LOOP_VARIANT_1 246
A 1  T384  R RUN_FEATURE_11 384
A*1  T34   R EIFFEL_PARSER 34
A*1  T370  R ASSERTION_COLLECTOR 370
A 1  T296  R NATIVE_WITHOUT_CURRENT 296
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S145 T145;
typedef struct S156 T156;
typedef struct S178 T178;
typedef struct S174 T174;
typedef struct S149 T149;
typedef struct S278 T278;
typedef struct S259 T259;
typedef struct S39 T39;
typedef struct S371 T371;
typedef struct S348 T348;
typedef struct S279 T279;
typedef struct S269 T269;
typedef struct S218 T218;
typedef struct S360 T360;
typedef struct S317 T317;
typedef struct S308 T308;
typedef struct S185 T185;
typedef struct S90 T90;
typedef struct S245 T245;
typedef void*T21;
typedef struct S142 T142;
typedef struct S273 T273;
typedef struct S130 T130;
typedef struct S93 T93;
typedef struct S62 T62;
typedef struct S316 T316;
typedef struct S183 T183;
typedef struct S89 T89;
typedef struct S122 T122;
typedef void*T36;
typedef struct S386 T386;
typedef struct S373 T373;
typedef struct S208 T208;
typedef struct S19 T19;
typedef struct S211 T211;
typedef struct S98 T98;
typedef struct S372 T372;
typedef struct S171 T171;
typedef struct S76 T76;
typedef struct S120 T120;
typedef struct S74 T74;
typedef struct S334 T334;
typedef struct S266 T266;
typedef struct S283 T283;
typedef struct S325 T325;
typedef struct S383 T383;
typedef struct S158 T158;
typedef struct S313 T313;
typedef struct S305 T305;
typedef struct S198 T198;
typedef struct S103 T103;
typedef void*T341;
typedef struct S96 T96;
typedef struct S97 T97;
typedef struct S41 T41;
typedef struct S83 T83;
typedef struct S212 T212;
typedef struct S199 T199;
typedef struct S204 T204;
typedef struct S340 T340;
typedef struct S31 T31;
typedef struct S257 T257;
typedef struct S267 T267;
typedef struct S133 T133;
typedef struct S147 T147;
typedef struct S243 T243;
typedef struct S387 T387;
typedef struct S126 T126;
typedef struct S124 T124;
typedef struct S52 T52;
typedef struct S271 T271;
typedef struct S357 T357;
typedef struct S190 T190;
typedef struct S261 T261;
typedef struct S293 T293;
typedef struct S173 T173;
typedef void*T347;
typedef struct S300 T300;
typedef struct S180 T180;
typedef void*T349;
typedef struct S264 T264;
typedef struct S94 T94;
typedef struct S63 T63;
typedef struct S342 T342;
typedef struct S272 T272;
typedef struct S135 T135;
typedef void*T344;
typedef struct S322 T322;
typedef struct S258 T258;
typedef struct S336 T336;
typedef struct S366 T366;
typedef struct S326 T326;
typedef struct S217 T217;
typedef struct S292 T292;
typedef struct S287 T287;
typedef struct S207 T207;
typedef struct S75 T75;
typedef struct S231 T231;
typedef void*T45;
typedef struct S111 T111;
typedef struct S163 T163;
typedef struct S134 T134;
typedef struct S240 T240;
typedef struct S230 T230;
typedef struct S164 T164;
typedef struct S35 T35;
typedef struct S285 T285;
typedef struct S247 T247;
typedef struct S232 T232;
typedef struct S40 T40;
typedef struct S152 T152;
typedef struct S150 T150;
typedef struct S234 T234;
typedef struct S221 T221;
typedef struct S77 T77;
typedef struct S127 T127;
typedef struct S125 T125;
typedef struct S241 T241;
typedef struct S216 T216;
typedef struct S72 T72;
typedef struct S160 T160;
typedef struct S298 T298;
typedef struct S379 T379;
typedef struct S47 T47;
typedef struct S310 T310;
typedef struct S59 T59;
typedef struct S222 T222;
typedef struct S50 T50;
typedef struct S280 T280;
typedef struct S66 T66;
typedef struct S65 T65;
typedef struct S250 T250;
typedef struct S107 T107;
typedef struct S390 T390;
typedef struct S368 T368;
typedef struct S356 T356;
typedef struct S324 T324;
typedef struct S306 T306;
typedef struct S54 T54;
typedef struct S215 T215;
typedef struct S270 T270;
typedef struct S268 T268;
typedef struct S46 T46;
typedef struct S138 T138;
typedef struct S44 T44;
typedef struct S121 T121;
typedef struct S27 T27;
typedef struct S275 T275;
typedef struct S291 T291;
typedef struct S333 T333;
typedef struct S123 T123;
typedef struct S148 T148;
typedef struct S165 T165;
typedef struct S109 T109;
typedef int T331;
typedef struct S315 T315;
typedef struct S252 T252;
typedef struct S314 T314;
typedef struct S290 T290;
typedef struct S391 T391;
typedef struct S381 T381;
typedef struct S367 T367;
typedef struct S352 T352;
typedef struct S345 T345;
typedef struct S53 T53;
typedef struct S157 T157;
typedef struct S388 T388;
typedef struct S254 T254;
typedef struct S361 T361;
typedef struct S177 T177;
typedef struct S101 T101;
typedef struct S10 T10;
typedef int T332;
typedef struct S7 T7;
typedef struct S168 T168;
typedef struct S364 T364;
typedef struct S233 T233;
typedef struct S226 T226;
typedef struct S80 T80;
typedef struct S137 T137;
typedef struct S303 T303;
typedef struct S146 T146;
typedef struct S205 T205;
typedef struct S87 T87;
typedef struct S297 T297;
typedef struct S79 T79;
typedef struct S153 T153;
typedef struct S102 T102;
typedef struct S139 T139;
typedef struct S354 T354;
typedef struct S172 T172;
typedef struct S263 T263;
typedef struct S155 T155;
typedef struct S320 T320;
typedef struct S244 T244;
typedef struct S210 T210;
typedef struct S175 T175;
typedef struct S375 T375;
typedef struct S318 T318;
typedef struct S235 T235;
typedef struct S228 T228;
typedef struct S81 T81;
typedef struct S49 T49;
typedef struct S358 T358;
typedef struct S328 T328;
typedef struct S238 T238;
typedef struct S104 T104;
typedef struct S295 T295;
typedef struct S389 T389;
typedef struct S274 T274;
typedef struct S350 T350;
typedef struct S196 T196;
typedef struct S151 T151;
typedef struct S69 T69;
typedef struct S343 T343;
typedef struct S255 T255;
typedef struct S338 T338;
typedef struct S194 T194;
typedef struct S378 T378;
typedef struct S363 T363;
typedef struct S219 T219;
typedef struct S71 T71;
typedef struct S110 T110;
typedef struct S330 T330;
typedef struct S225 T225;
typedef struct S42 T42;
typedef struct S144 T144;
typedef struct S136 T136;
typedef struct S131 T131;
typedef struct S23 T23;
typedef struct S206 T206;
typedef struct S128 T128;
typedef struct S286 T286;
typedef struct S143 T143;
typedef struct S68 T68;
typedef struct S376 T376;
typedef struct S86 T86;
typedef struct S61 T61;
typedef struct S170 T170;
typedef struct S188 T188;
typedef struct S302 T302;
typedef struct S213 T213;
typedef struct S132 T132;
typedef struct S382 T382;
typedef struct S227 T227;
typedef struct S202 T202;
typedef struct S260 T260;
typedef int T51;
typedef struct S276 T276;
typedef struct S282 T282;
typedef struct S169 T169;
typedef struct S321 T321;
typedef struct S119 T119;
typedef struct S365 T365;
typedef struct S85 T85;
typedef struct S220 T220;
typedef struct S191 T191;
typedef struct S99 T99;
typedef struct S187 T187;
typedef struct S193 T193;
typedef struct S113 T113;
typedef struct S195 T195;
typedef struct S105 T105;
typedef struct S277 T277;
typedef struct S246 T246;
typedef struct S384 T384;
typedef struct S34 T34;
typedef struct S370 T370;
typedef struct S296 T296;

/*C Header Pass 2 :*/
typedef T0**T203;
typedef T0**T339;
typedef T0**T281;
typedef T0**T327;
typedef T0**T319;
typedef T0**T309;
typedef T0**T224;
typedef T0**T186;
typedef T0**T91;
typedef T0**T262;
typedef T0**T374;
typedef T0**T312;
typedef T0**T209;
typedef T0**T78;
typedef T0**T335;
typedef T0**T337;
typedef T0**T192;
typedef T0**T100;
typedef T0**T73;
typedef T0**T351;
typedef T0**T197;
typedef T0**T112;
typedef T0**T70;
typedef T0**T392;
typedef T0**T369;
typedef T0**T362;
typedef T0**T353;
typedef T0**T346;
typedef T0**T56;
typedef T0**T236;
typedef T0**T229;
typedef T0**T82;
typedef T0**T32;
typedef T0**T377;
typedef T0**T329;
typedef T0**T323;
typedef T0**T88;
typedef T0**T359;
typedef T0**T239;
typedef T0**T108;
typedef T0**T95;
typedef T0**T64;
typedef T3*T9;
typedef T6*T355;
typedef T2*T28;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
struct S145{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T145 M145;
struct S156{int id;T0* _start_position;T0* _run_feature;};
extern T156 M156;
struct S178{int id;T0* _list;T0* _flat_list;};
extern T178 M178;
struct S259{T262 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T259 M259;
struct S39{T0* _root_procedure;T6 _is_ready;T6 _short_flag;T6 _pretty_flag;T2 _magic_count;T2 _top;};
extern T39 M39;
struct S371{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T371 M371;
struct S348{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T348 M348;
struct S279{T281 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T279 M279;
struct S269{int id;T0* _base_class_name;};
extern T269 M269;
struct S218{int id;T0* _check_invariant;T0* _current_type;};
extern T218 M218;
struct S360{int id;T327 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T360 M360;
struct S317{T319 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T317 M317;
struct S308{T309 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T308 M308;
struct S185{int id;T186 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T185 M185;
struct S90{T91 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T90 M90;
struct S245{int id;T0* _comment;T0* _expression;T0* _current_type;T0* _tag;};
extern T245 M245;
extern T21 M21;
struct S142{int id;T0* _to_string;T0* _start_position;T0* _to_key;};
extern T142 M142;
struct S273{int id;T0* _base_class_name;};
extern T273 M273;
struct S130{int id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T130 M130;
struct S93{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T93 M93;
struct S62{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T62 M62;
struct S122{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T122 M122;
extern T36 M36;
struct S386{T0* _item;};
extern T386 M386;
struct S373{int id;T374 _storage;T2 _capacity;T2 _upper;};
extern T373 M373;
struct S208{int id;T209 _storage;T2 _capacity;T2 _upper;};
extern T208 M208;
struct S19{T2 _item;};
extern T19 M19;
struct S211{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T211 M211;
struct S98{T0* _clients;T0* _comment;T0* _list;};
extern T98 M98;
struct S120{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T120 M120;
struct S74{T0* _path;T2 _count;};
extern T74 M74;
struct S334{T335 _storage;T2 _capacity;T2 _upper;};
extern T334 M334;
struct S266{int id;T0* _base_class_name;};
extern T266 M266;
struct S283{int id;T0* _left_side;T0* _right_side;T0* _current_type;};
extern T283 M283;
struct S383{int id;T0* _enclosing;T0* _to_key;};
extern T383 M383;
struct S158{int id;T0* _start_position;T0* _result_type;};
extern T158 M158;
struct S313{int id;T0* _name;};
extern T313 M313;
struct S305{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T305 M305;
struct S198{T0* _arguments;T0* _type;T0* _header_comment;T0* _obsolete_mark;T0* _require_assertion;T0* _local_vars;T0* _routine_body;};
extern T198 M198;
struct S103{T0* _tag;T0* _expression;T0* _comment;T0* _current_type;};
extern T103 M103;
extern T341 M341;
struct S96{T0* _start_position;T0* _list;};
extern T96 M96;
struct S97{T0* _list;};
extern T97 M97;
struct S41{T2 _error_counter;T2 _warning_counter;T6 _no_warning;};
extern T41 M41;
struct S83{T0* _start_position;T0* _list;};
extern T83 M83;
struct S212{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T212 M212;
struct S199{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _values;};
extern T199 M199;
struct S204{T2 _value;};
extern T204 M204;
struct S340{T82 _storage;T2 _capacity;T2 _upper;};
extern T340 M340;
struct S31{T32 _storage;T2 _capacity;T2 _upper;};
extern T31 M31;
struct S257{int id;T0* _start_position;T0* _run_type;};
extern T257 M257;
struct S267{int id;T0* _base_class_name;};
extern T267 M267;
struct S133{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T133 M133;
struct S147{int id;T0* _start_position;T0* _current_type;T0* _list;T0* _result_type_memory;};
extern T147 M147;
struct S243{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T243 M243;
struct S387{int id;T0* _expression;T0* _result_type;};
extern T387 M387;
struct S126{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T126 M126;
struct S124{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T124 M124;
struct S52{T0* _path;T8 _output_stream;};
extern T52 M52;
struct S271{int id;T0* _base_class_name;};
extern T271 M271;
struct S357{T0* _list;};
extern T357 M357;
struct S183{int id;T0* _start_position;T0* _to_string;T0* _result_type;T2 _rank;T6 _is_used;};
extern T183 M183;
struct S261{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T261 M261;
struct S293{int id;};
extern T293 M293;
struct S173{int id;T0* _start_position;T0* _to_string;};
extern T173 M173;
extern T347 M347;
struct S300{int id;};
extern T300 M300;
struct S180{int id;T0* _start_position;T2 _rank;T0* _local_var_list;};
extern T180 M180;
extern T349 M349;
struct S264{int id;T0* _base_class_name;};
extern T264 M264;
struct S94{int id;T95 _storage;T2 _capacity;T2 _upper;};
extern T94 M94;
struct S63{T64 _storage;T2 _capacity;T2 _upper;};
extern T63 M63;
struct S342{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T342 M342;
struct S272{int id;T0* _base_class_name;};
extern T272 M272;
struct S135{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T135 M135;
extern T344 M344;
struct S322{T323 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T322 M322;
struct S258{int id;T0* _start_position;T0* _like_what;T0* _written_mark;T0* _run_feature;};
extern T258 M258;
struct S336{T337 _storage;T2 _capacity;T2 _upper;};
extern T336 M336;
struct S366{int id;T0* _run_feature;};
extern T366 M366;
struct S326{int id;T327 _storage;T2 _capacity;T2 _upper;};
extern T326 M326;
struct S217{T224 _storage;T2 _capacity;T2 _upper;};
extern T217 M217;
struct S292{int id;};
extern T292 M292;
struct S287{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _result_type;};
extern T287 M287;
struct S207{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _first_value;T0* _remainder;};
extern T207 M207;
struct S75{T0* _list;};
extern T75 M75;
struct S231{int id;T0* _start_position;T0* _run_feature;};
extern T231 M231;
extern T45 M45;
struct S111{int id;T0* _start_position;T0* _list;T0* _result_type;T0* _current_type;};
extern T111 M111;
struct S163{int id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T163 M163;
struct S134{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T134 M134;
struct S240{int id;T0* _e_when;T0* _expression;T2 _expression_value;};
extern T240 M240;
struct S230{int id;T0* _expression;T0* _comment;};
extern T230 M230;
struct S164{int id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T164 M164;
struct S35{T6 _verbose;};
extern T35 M35;
struct S285{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;};
extern T285 M285;
struct S247{int id;T0* _start_position;T0* _writable;T0* _current_type;};
extern T247 M247;
struct S232{int id;T0* _start_position;T0* _expression;T0* _when_list;T0* _else_position;T0* _else_compound;T0* _current_type;};
extern T232 M232;
struct S40{T0* _current_type;T2 _id;T6 _at_run_time;T0* _running;T0* _class_invariant;T6 _compile_to_c_done;T0* _feature_dictionary;T2 _tagged_mem;T0* _actuals_clients;T0* _writable_attributes_mem;T6 _strip_used;T6 _runnable_class_invariant_done;T2 _c_header_pass_level_done;};
extern T40 M40;
struct S152{int id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T152 M152;
struct S150{int id;T0* _target;T0* _feature_name;T0* _run_feature;};
extern T150 M150;
struct S234{T0* _e_inspect;T0* _list;};
extern T234 M234;
struct S221{int id;T209 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T221 M221;
struct S77{T78 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T77 M77;
struct S127{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T127 M127;
struct S125{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T125 M125;
struct S241{int id;T0* _e_when;T0* _upper;T0* _lower;T2 _lower_value;T2 _upper_value;};
extern T241 M241;
struct S216{T0* _header_comment;T0* _current_type;T0* _first_one;T0* _remainder;};
extern T216 M216;
struct S160{int id;T0* _feature_name;T0* _current_type;T0* _run_feature;};
extern T160 M160;
struct S298{int id;};
extern T298 M298;
struct S379{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _value;T0* _result_type;};
extern T379 M379;
struct S47{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T47 M47;
struct S310{int id;T0* _name_list;};
extern T310 M310;
struct S59{int id;T0* _start_position;T0* _value;T0* _result_type;T0* _hexa;};
extern T59 M59;
struct S222{int id;T0* _start_position;T0* _ifthenlist;T0* _else_compound;T0* _current_type;};
extern T222 M222;
struct S50{T2 _level;T6 _trace;T0* _root_class;T6 _generating_type_used;T6 _generator_used;T0* _cecil_path;T0* _root_procedure_memory;};
extern T50 M50;
struct S280{int id;T0* _formal_name;T2 _rank;T0* _run_type;};
extern T280 M280;
struct S250{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _type;};
extern T250 M250;
struct S316{T0* _clients;T0* _list;};
extern T316 M316;
struct S107{T0* _to_string;T0* _start_position;};
extern T107 M107;
struct S215{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_ensure_then;};
extern T215 M215;
struct S66{T0* _to_string;T0* _start_position;};
extern T66 M66;
struct S270{int id;T0* _base_class_name;};
extern T270 M270;
struct S268{int id;T0* _base_class_name;};
extern T268 M268;
struct S46{T0* _system_name;T0* _sys_directory;T0* _bin_directory;T0* _c_compiler;T6 _no_strip;};
extern T46 M46;
struct S356{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _result_type;};
extern T356 M356;
struct S138{int id;T0* _to_string;T0* _start_position;T0* _to_key;};
extern T138 M138;
struct S44{T5 _item;};
extern T44 M44;
struct S121{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T121 M121;
struct S27{T28 _storage;T2 _capacity;T2 _upper;};
extern T27 M27;
struct S275{int id;T0* _start_position;T0* _written_mark;T0* _mapped;T0* _run_time_mark;T0* _run_type;};
extern T275 M275;
struct S291{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;T0* _result_type;};
extern T291 M291;
struct S333{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T333 M333;
struct S123{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T123 M123;
struct S148{int id;T0* _to_string;T0* _start_position;T0* _run_feature_2;};
extern T148 M148;
struct S165{int id;T0* _target;T0* _feature_name;T0* _run_feature;T0* _arguments;};
extern T165 M165;
struct S109{T2 _column;T2 _line;T0* _aliased_string_memory;};
extern T109 M109;
extern T331 M331;
struct S315{int id;T0* _feature_name;};
extern T315 M315;
struct S252{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _run_feature;T0* _call;};
extern T252 M252;
struct S324{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;T2 _in_line_status;};
extern T324 M324;
struct S89{T0* _new_name;T0* _old_name;};
extern T89 M89;
struct S314{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;};
extern T314 M314;
struct S290{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _native;T0* _alias_string;};
extern T290 M290;
struct S391{int id;T392 _storage;T2 _capacity;T2 _upper;};
extern T391 M391;
struct S381{int id;T362 _storage;T2 _capacity;T2 _upper;};
extern T381 M381;
struct S367{int id;T369 _storage;T2 _capacity;T2 _upper;};
extern T367 M367;
struct S352{int id;T353 _storage;T2 _capacity;T2 _upper;};
extern T352 M352;
struct S345{int id;T346 _storage;T2 _capacity;T2 _upper;};
extern T345 M345;
struct S53{int id;T56 _storage;T2 _capacity;T2 _upper;};
extern T53 M53;
struct S157{int id;T0* _start_position;};
extern T157 M157;
struct S388{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;T2 _static_value_mem;T2 _in_line_status;T6 _is_static_flag;};
extern T388 M388;
struct S254{int id;T0* _start_position;T0* _writable;T0* _current_type;T0* _run_feature;T0* _call;T0* _type;};
extern T254 M254;
struct S361{int id;T362 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T361 M361;
struct S177{int id;T0* _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T177 M177;
struct S101{T0* _start_position;T0* _list;};
extern T101 M101;
struct S10{T0* _level_flag;};
extern T10 M10;
extern T332 M332;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S168{int id;T0* _start_position;};
extern T168 M168;
struct S364{T0* _user_cecil_list;T0* _user_cecil_name;T0* _user_path_h;};
extern T364 M364;
struct S137{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T137 M137;
struct S303{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T303 M303;
struct S146{int id;T0* _expression;T0* _current_type;T0* _local_c_name_memory;};
extern T146 M146;
struct S226{T0* _expression;T0* _then_compound;T0* _current_type;};
extern T226 M226;
struct S205{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T205 M205;
struct S87{T0* _list;};
extern T87 M87;
struct S297{int id;};
extern T297 M297;
struct S79{T0* _base_class;T0* _start_position;T0* _heading_comment;T0* _list;};
extern T79 M79;
struct S390{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T390 M390;
struct S153{int id;T0* _target;T0* _feature_name;T0* _arguments;T0* _run_feature;};
extern T153 M153;
struct S102{T0* _mem_id;T0* _mem_str;};
extern T102 M102;
struct S139{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T139 M139;
struct S72{T0* _base_class_name;T2 _mem_line_column;};
extern T72 M72;
struct S278{T0* _name;T0* _constraint;};
extern T278 M278;
struct S354{T355 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T354 M354;
struct S172{T28 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T172 M172;
struct S233{T0* _start_position;T0* _list;T0* _header_comment;T0* _compound;T0* _when_list;T0* _values;};
extern T233 M233;
struct S263{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type;};
extern T263 M263;
struct S155{int id;T0* _start_position;T0* _run_feature_6;};
extern T155 M155;
struct S320{T0* _tag;T0* _list;};
extern T320 M320;
struct S54{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T54 M54;
struct S244{int id;T0* _start_position;T0* _initialize;T0* _invariant_clause;T0* _variant_clause;T0* _until_expression;T0* _loop_body;T0* _current_type;};
extern T244 M244;
struct S80{T0* _parent_list;T0* _type;T0* _comment;T0* _rename_list;T0* _export_list;T0* _undefine_list;T0* _redefine_list;T0* _select_list;T0* _undefine_memory1;T0* _undefine_memory2;};
extern T80 M80;
struct S210{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T210 M210;
struct S175{int id;T0* _start_position;T0* _parent;T0* _current_type;T0* _arguments;T0* _run_feature;};
extern T175 M175;
struct S318{T0* _start_position;T0* _items;};
extern T318 M318;
struct S235{T236 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T235 M235;
struct S228{T229 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T228 M228;
struct S81{T82 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T81 M81;
struct S49{T32 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T49 M49;
struct S358{T359 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T358 M358;
struct S328{T64 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T328 M328;
struct S238{T239 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T238 M238;
struct S104{T108 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T104 M104;
struct S295{int id;};
extern T295 M295;
struct S389{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _ensure_assertion;};
extern T389 M389;
struct S274{int id;T0* _base_class_name;T0* _generic_list;T0* _written_mark;T0* _run_type_memory;};
extern T274 M274;
struct S350{int id;T351 _storage;T2 _capacity;T2 _upper;};
extern T350 M350;
struct S196{T197 _storage;T2 _capacity;T2 _upper;};
extern T196 M196;
struct S151{int id;T112 _storage;T2 _capacity;T2 _upper;};
extern T151 M151;
struct S69{T70 _storage;T2 _capacity;T2 _upper;};
extern T69 M69;
struct S343{int id;T262 _storage;T2 _capacity;T2 _upper;};
extern T343 M343;
struct S255{int id;T0* _start_position;T0* _like_what;T0* _written_mark;T0* _run_type;};
extern T255 M255;
struct S338{T339 _storage;T2 _capacity;T2 _upper;};
extern T338 M338;
struct S194{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T194 M194;
struct S325{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T325 M325;
struct S378{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T2 _static_value_mem;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T378 M378;
struct S363{T6 _used;};
extern T363 M363;
struct S76{T0* _start_position;T0* _clients;T0* _comment;T0* _procedure_list;};
extern T76 M76;
struct S190{int id;T0* _start_position;T0* _to_string;T0* _result_type;T2 _rank;};
extern T190 M190;
struct S219{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T219 M219;
struct S71{T73 _storage;T2 _capacity;T2 _upper;};
extern T71 M71;
struct S110{int id;T112 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T110 M110;
struct S368{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _ensure_assertion;};
extern T368 M368;
struct S330{T6 _is_off;T6 _info_flag;T6 _dispose_flag;};
extern T330 M330;
struct S225{int id;T0* _instruction;T0* _comment;};
extern T225 M225;
struct S42{T0* _output_name;T2 _inlined_procedure_count;T2 _inlined_function_count;T2 _procedure_count;T2 _function_count;T2 _real_procedure_count;T2 _real_function_count;T2 _static_expression_count;T2 _top;T2 _check_id_count;T2 _direct_call_count;T2 _sure_void_count;T2 _switch_count;T6 _no_split;T6 _no_main;T0* _out_h;T0* _current_out;T0* _to_expanded_mem;T0* _to_reference_mem;T0* _check_assertion_mode;T2 _inspect_level;T2 _inline_level;T2 _split_count;T2 _elt_c_count;T6 _sprintf_double_flag;T6 _basic_directory_used;T0* _bit_constant_pool;T2 _se_tmp_level;};
extern T42 M42;
struct S149{int id;T0* _first_one;T0* _remainder;T0* _current_type;};
extern T149 M149;
struct S144{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T144 M144;
struct S136{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T136 M136;
struct S131{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T131 M131;
struct S23{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _count;};
extern T23 M23;
struct S206{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T206 M206;
struct S128{int id;T0* _target;T0* _arguments;T0* _feature_name;};
extern T128 M128;
struct S372{int id;T0* _run_class;T0* _written_mark;T0* _expanded_type;};
extern T372 M372;
struct S143{int id;T0* _target;T0* _run_feature;T0* _feature_name;};
extern T143 M143;
struct S68{T0* _keys;T0* _store;T2 _modulus;T0* _buckets;T0* _chain;T2 _first_free_slot;T2 _cache_keys_idx;T2 _cache_user_idx;T2 _cache_buckets_idx;T2 _count;};
extern T68 M68;
struct S375{int id;T0* _type_bit;T0* _written_mark;T0* _run_time_mark;};
extern T375 M375;
struct S376{int id;T377 _storage;T2 _capacity;T2 _upper;};
extern T376 M376;
struct S86{T88 _storage;T2 _capacity;T2 _upper;};
extern T86 M86;
struct S61{int id;T329 _storage;T2 _capacity;T2 _upper;};
extern T61 M61;
struct S170{int id;T0* _start_position;T3 _value;T2 _pretty_print_mode;};
extern T170 M170;
struct S188{int id;T0* _start_position;T2 _rank;T0* _formal_arg_list;};
extern T188 M188;
struct S302{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;};
extern T302 M302;
struct S213{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _result_type;T0* _value_mem;};
extern T213 M213;
struct S132{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T132 M132;
struct S382{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T382 M382;
struct S227{T0* _list;T0* _current_type;};
extern T227 M227;
struct S65{T2 _id;T0* _path;T0* _index_list;T0* _heading_comment1;T6 _is_deferred;T6 _is_expanded;T0* _name;T0* _formal_generic_list;T0* _heading_comment2;T0* _obsolete_type_string;T0* _parent_list;T0* _creation_clause_list;T0* _feature_clause_list;T0* _class_invariant;T0* _end_comment;T0* _feature_dictionary;T0* _once_mark_list;T0* _isom;};
extern T65 M65;
struct S306{int id;T0* _base_class;T0* _names;T0* _header_comment;T0* _clients;T0* _arguments;T0* _obsolete_mark;T0* _require_assertion;T0* _ensure_assertion;T0* _end_comment;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T2 _use_current_state;T0* _result_type;};
extern T306 M306;
struct S202{int id;T203 _storage;T2 _capacity;T2 _upper;};
extern T202 M202;
struct S260{int id;T0* _base_class_name;};
extern T260 M260;
extern T51 M51;
struct S276{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;};
extern T276 M276;
struct S174{int id;T0* _start_position;T2 _value;};
extern T174 M174;
struct S282{int id;T0* _left_side;T0* _right_side;};
extern T282 M282;
struct S169{int id;T0* _start_position;};
extern T169 M169;
struct S321{T0* _list;};
extern T321 M321;
struct S119{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T119 M119;
struct S365{int id;T0* _first_one;T0* _remainder;T0* _current_type;};
extern T365 M365;
struct S85{T0* _first;T0* _remainder;};
extern T85 M85;
struct S220{int id;T0* _start_position;T0* _list;T0* _compound;T0* _current_type;};
extern T220 M220;
struct S191{int id;T192 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T191 M191;
struct S99{T100 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T99 M99;
struct S171{int id;T0* _start_position;T0* _to_string;T0* _break;T0* _ascii;T0* _percent;T0* _mangling;};
extern T171 M171;
struct S187{int id;T0* _list;T0* _flat_list;};
extern T187 M187;
struct S193{int id;T0* _start_position;T0* _result_type;};
extern T193 M193;
struct S113{int id;T0* _target;T0* _arguments;T0* _feature_name;T0* _run_feature;T2 _static_value_mem;};
extern T113 M113;
struct S195{T0* _first;T0* _remainder;};
extern T195 M195;
struct S105{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;};
extern T105 M105;
struct S286{T0* _start_position;T0* _header_comment;T0* _list;T0* _current_type;T0* _run_feature;T6 _is_require_else;};
extern T286 M286;
struct S277{int id;T0* _start_position;T0* _written_mark;T0* _run_time_mark;T0* _n;T2 _nb;};
extern T277 M277;
struct S246{int id;T0* _comment;T0* _expression;T0* _current_type;};
extern T246 M246;
struct S384{int id;T0* _current_type;T0* _clients_memory;T0* _name;T2 _use_current_state;T0* _base_feature;T0* _arguments;T0* _result_type;T0* _require_assertion;T0* _local_vars;T0* _routine_body;T0* _rescue_compound;T0* _ensure_assertion;};
extern T384 M384;
struct S34{T6 _case_insensitive;T6 _no_style_warning;T6 _drop_comments;T6 _is_running;T2 _column;T2 _line;T0* _current_line;T3 _cc;T0* _last_comments;T6 _inside_function;T6 _inside_once_function;T0* _formal_generic_list;T6 _in_ensure;T6 _in_rescue;T0* _arguments;T0* _local_vars;T6 _ok;T2 _last_ascii_code;T0* _last_base_class;T0* _last_base_type;T0* _last_binary;T0* _last_bit_constant;T0* _last_boolean_constant;T0* _last_character_constant;T0* _last_class_name;T0* _last_class_type;T0* _last_expression;T0* _last_feature_declaration;T0* _last_feature_name;T0* _last_feature_name_list;T0* _last_keyword;T0* _last_type_formal_generic;T0* _last_infix;T0* _last_prefix;T0* _last_integer_constant;T0* _last_instruction;T0* _last_index_value;T0* _last_manifest_constant;T0* _last_manifest_string;T0* _last_parent;T0* _last_real_constant;T0* _last_type;T0* _last_tag_mark;T2 _start_column;T2 _start_line;};
extern T34 M34;
struct S370{T6 _processing_require;T0* _header_comment;};
extern T370 M370;
struct S296{int id;};
extern T296 M296;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
T2 r2min(T2 C,T2 a1);
T2 r2max(T2 C,T2 a1);
extern T0*oBC2tmp_string;
T2 r2to_octal(T2 C);
T2 r2_px_94(T2 C,T2 a1);
T2 r2hash_code(T2 C);
T3 r2digit(T2 C);
T3 r2hexadecimal_digit(T2 C);
void r2append_in(T2 C,T0* a1);
T0* r2to_string(T2 C);
T3 r3to_lower(T3 C);
T2 r3value(T3 C);
T6 r3is_letter(T3 C);
T6 r3_px_6061(T3 C,T3 a1);
T6 r3_px_6261(T3 C,T3 a1);
T6 r3is_separator(T3 C);
T6 r3same_as(T3 C,T3 a1);
T6 r3is_digit(T3 C);
T6 r3_px_60(T3 C,T3 a1);
T3 r3to_upper(T3 C);
extern int fBC5tmp_native_array;
extern T9 oBC5tmp_native_array;
T9 r5tmp_native_array(void);
void r5append_in_format(T5 C,T0* a1,T2 a2);
T203 r203realloc(T203 C,T2 a1,T2 a2);
void r203copy_from(T203 C,T203 a1,T2 a2);
void r203set_all_with(T203 C,T0* a1,T2 a2);
void r203clear_all(T203 C,T2 a1);
T339 r339realloc(T339 C,T2 a1,T2 a2);
void r339copy_from(T339 C,T339 a1,T2 a2);
void r339set_all_with(T339 C,T0* a1,T2 a2);
T281 r281realloc(T281 C,T2 a1,T2 a2);
void r281copy_from(T281 C,T281 a1,T2 a2);
void r327clear(T327 C,T2 a1,T2 a2);
T327 r327realloc(T327 C,T2 a1,T2 a2);
void r327move(T327 C,T2 a1,T2 a2,T2 a3);
void r327copy_from(T327 C,T327 a1,T2 a2);
void r327set_all_with(T327 C,T0* a1,T2 a2);
T2 r327fast_index_of(T327 C,T0* a1,T2 a2);
T319 r319realloc(T319 C,T2 a1,T2 a2);
void r319copy_from(T319 C,T319 a1,T2 a2);
T309 r309realloc(T309 C,T2 a1,T2 a2);
void r309copy_from(T309 C,T309 a1,T2 a2);
T224 r224realloc(T224 C,T2 a1,T2 a2);
void r224copy_from(T224 C,T224 a1,T2 a2);
void r224clear_all(T224 C,T2 a1);
T186 r186realloc(T186 C,T2 a1,T2 a2);
void r186copy_from(T186 C,T186 a1,T2 a2);
void r186set_all_with(T186 C,T0* a1,T2 a2);
T91 r91realloc(T91 C,T2 a1,T2 a2);
void r91copy_from(T91 C,T91 a1,T2 a2);
T262 r262realloc(T262 C,T2 a1,T2 a2);
void r262copy_from(T262 C,T262 a1,T2 a2);
void r262set_all_with(T262 C,T0* a1,T2 a2);
T374 r374realloc(T374 C,T2 a1,T2 a2);
void r374copy_from(T374 C,T374 a1,T2 a2);
void r374set_all_with(T374 C,T0* a1,T2 a2);
T209 r209realloc(T209 C,T2 a1,T2 a2);
void r209copy_from(T209 C,T209 a1,T2 a2);
void r209set_all_with(T209 C,T0* a1,T2 a2);
void r209clear_all(T209 C,T2 a1);
T78 r78realloc(T78 C,T2 a1,T2 a2);
void r78copy_from(T78 C,T78 a1,T2 a2);
T335 r335realloc(T335 C,T2 a1,T2 a2);
void r335copy_from(T335 C,T335 a1,T2 a2);
void r335set_all_with(T335 C,T0* a1,T2 a2);
T337 r337realloc(T337 C,T2 a1,T2 a2);
void r337copy_from(T337 C,T337 a1,T2 a2);
void r337set_all_with(T337 C,T0* a1,T2 a2);
T192 r192realloc(T192 C,T2 a1,T2 a2);
void r192copy_from(T192 C,T192 a1,T2 a2);
void r192set_all_with(T192 C,T0* a1,T2 a2);
T100 r100realloc(T100 C,T2 a1,T2 a2);
void r100copy_from(T100 C,T100 a1,T2 a2);
T73 r73realloc(T73 C,T2 a1,T2 a2);
T6 r73equal_like(T0* a1,T0* a2);
void r73copy_from(T73 C,T73 a1,T2 a2);
T2 r73fast_index_of(T73 C,T0* a1,T2 a2);
T2 r73index_of(T73 C,T0* a1,T2 a2);
T351 r351realloc(T351 C,T2 a1,T2 a2);
void r351copy_from(T351 C,T351 a1,T2 a2);
void r351set_all_with(T351 C,T0* a1,T2 a2);
void r351clear_all(T351 C,T2 a1);
T197 r197realloc(T197 C,T2 a1,T2 a2);
void r197copy_from(T197 C,T197 a1,T2 a2);
T112 r112realloc(T112 C,T2 a1,T2 a2);
void r112copy_from(T112 C,T112 a1,T2 a2);
void r112set_all_with(T112 C,T0* a1,T2 a2);
void r112clear_all(T112 C,T2 a1);
T70 r70realloc(T70 C,T2 a1,T2 a2);
void r70copy_from(T70 C,T70 a1,T2 a2);
void r70set_all_with(T70 C,T0* a1,T2 a2);
T2 r70fast_index_of(T70 C,T0* a1,T2 a2);
T392 r392realloc(T392 C,T2 a1,T2 a2);
void r392copy_from(T392 C,T392 a1,T2 a2);
void r392set_all_with(T392 C,T0* a1,T2 a2);
T2 r392fast_index_of(T392 C,T0* a1,T2 a2);
T369 r369realloc(T369 C,T2 a1,T2 a2);
void r369copy_from(T369 C,T369 a1,T2 a2);
void r369set_all_with(T369 C,T0* a1,T2 a2);
T2 r369fast_index_of(T369 C,T0* a1,T2 a2);
void r362clear(T362 C,T2 a1,T2 a2);
T362 r362realloc(T362 C,T2 a1,T2 a2);
void r362move(T362 C,T2 a1,T2 a2,T2 a3);
void r362copy_from(T362 C,T362 a1,T2 a2);
void r362set_all_with(T362 C,T0* a1,T2 a2);
T2 r362fast_index_of(T362 C,T0* a1,T2 a2);
T353 r353realloc(T353 C,T2 a1,T2 a2);
void r353copy_from(T353 C,T353 a1,T2 a2);
void r353set_all_with(T353 C,T0* a1,T2 a2);
T2 r353fast_index_of(T353 C,T0* a1,T2 a2);
T346 r346realloc(T346 C,T2 a1,T2 a2);
void r346copy_from(T346 C,T346 a1,T2 a2);
void r346set_all_with(T346 C,T0* a1,T2 a2);
T2 r346fast_index_of(T346 C,T0* a1,T2 a2);
void r346clear_all(T346 C,T2 a1);
T56 r56realloc(T56 C,T2 a1,T2 a2);
void r56copy_from(T56 C,T56 a1,T2 a2);
void r56set_all_with(T56 C,T0* a1,T2 a2);
T2 r56fast_index_of(T56 C,T0* a1,T2 a2);
T236 r236realloc(T236 C,T2 a1,T2 a2);
void r236copy_from(T236 C,T236 a1,T2 a2);
T229 r229realloc(T229 C,T2 a1,T2 a2);
void r229copy_from(T229 C,T229 a1,T2 a2);
T82 r82realloc(T82 C,T2 a1,T2 a2);
void r82copy_from(T82 C,T82 a1,T2 a2);
T32 r32realloc(T32 C,T2 a1,T2 a2);
T6 r32equal_like(T0* a1,T0* a2);
void r32copy_from(T32 C,T32 a1,T2 a2);
void r32set_all_with(T32 C,T0* a1,T2 a2);
T2 r32fast_index_of(T32 C,T0* a1,T2 a2);
T2 r32index_of(T32 C,T0* a1,T2 a2);
T377 r377realloc(T377 C,T2 a1,T2 a2);
void r377copy_from(T377 C,T377 a1,T2 a2);
void r377set_all_with(T377 C,T0* a1,T2 a2);
T329 r329realloc(T329 C,T2 a1,T2 a2);
void r329copy_from(T329 C,T329 a1,T2 a2);
void r329set_all_with(T329 C,T0* a1,T2 a2);
void r329clear_all(T329 C,T2 a1);
T323 r323realloc(T323 C,T2 a1,T2 a2);
void r323copy_from(T323 C,T323 a1,T2 a2);
T88 r88realloc(T88 C,T2 a1,T2 a2);
void r88copy_from(T88 C,T88 a1,T2 a2);
void r88set_all_with(T88 C,T0* a1,T2 a2);
T359 r359realloc(T359 C,T2 a1,T2 a2);
void r359copy_from(T359 C,T359 a1,T2 a2);
T239 r239realloc(T239 C,T2 a1,T2 a2);
void r239copy_from(T239 C,T239 a1,T2 a2);
T108 r108realloc(T108 C,T2 a1,T2 a2);
void r108copy_from(T108 C,T108 a1,T2 a2);
void r108set_all_with(T108 C,T0* a1,T2 a2);
T2 r108fast_index_of(T108 C,T0* a1,T2 a2);
T95 r95realloc(T95 C,T2 a1,T2 a2);
void r95copy_from(T95 C,T95 a1,T2 a2);
void r95set_all_with(T95 C,T0* a1,T2 a2);
void r95clear_all(T95 C,T2 a1);
T64 r64realloc(T64 C,T2 a1,T2 a2);
void r64copy_from(T64 C,T64 a1,T2 a2);
void r64set_all_with(T64 C,T0* a1,T2 a2);
T2 r64fast_index_of(T64 C,T0* a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
T355 r355realloc(T355 C,T2 a1,T2 a2);
void r355clear(T355 C,T2 a1,T2 a2);
void r355move(T355 C,T2 a1,T2 a2,T2 a3);
void r355copy_from(T355 C,T355 a1,T2 a2);
void r355set_all_with(T355 C,T6 a1,T2 a2);
T28 r28realloc(T28 C,T2 a1,T2 a2);
void r28copy_from(T28 C,T28 a1,T2 a2);
void r28set_all_with(T28 C,T2 a1,T2 a2);
T2 r28fast_index_of(T28 C,T2 a1,T2 a2);
T6 r7has_string(T7* C,T0* a1);
T6 r7is_equal(T7* C,T0* a1);
T3 r7last(T7* C);
void r7add_first(T7* C,T3 a1);
T8 r7to_external(T7* C);
T6 r7same_as(T7* C,T0* a1);
void r7prepend(T7* C,T0* a1);
void r7copy(T7* C,T0* a1);
void r7swap(T7* C,T2 a1,T2 a2);
T2 r7to_integer(T7* C);
void r7head(T7* C,T2 a1);
T0* r7twin(T7* C);
void r7append(T7* C,T0* a1);
void r7to_lower(T7* C);
void r7remove_first(T7* C,T2 a1);
T2 r7index_of_string(T7* C,T0* a1);
void r7remove_between(T7* C,T2 a1,T2 a2);
void r7make(T7* C,T2 a1);
void r7to_hexadecimal(T7* C);
T6 r7has_prefix(T7* C,T0* a1);
T2 r7hash_code(T7* C);
void r7reverse(T7* C);
void r7remove_last(T7* C,T2 a1);
T6 r7_px_60(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
void r7to_upper(T7* C);
void r7set_last(T7* C,T3 a1);
void r259add_last(T259* C,T0* a1);
void r259copy(T259* C,T0* a1);
T0* r259twin(T259* C);
T2 r259count(T259* C);
T0* r259item(T259* C,T2 a1);
void r279add_last(T279* C,T0* a1);
T2 r279count(T279* C);
T0* r279item(T279* C,T2 a1);
void r360make(T360* C,T2 a1,T2 a2);
void r360force(T360* C,T0* a1,T2 a2);
void r360resize(T360* C,T2 a1,T2 a2);
void r360clear_all(T360* C);
T0* r360item(T360* C,T2 a1);
void r317add_last(T317* C,T0* a1);
T2 r317count(T317* C);
T0* r317item(T317* C,T2 a1);
void r308add_last(T308* C,T0* a1);
T2 r308count(T308* C);
T0* r308item(T308* C,T2 a1);
void r185add_last(T185* C,T0* a1);
void r185make(T185* C,T2 a1,T2 a2);
void r185copy(T185* C,T0* a1);
T0* r185twin(T185* C);
T2 r185count(T185* C);
T0* r185item(T185* C,T2 a1);
void r90add_last(T90* C,T0* a1);
T2 r90count(T90* C);
T0* r90item(T90* C,T2 a1);
void r373with_capacity(T373* C,T2 a1);
void r373add_last(T373* C,T0* a1);
void r373make(T373* C,T2 a1);
void r373resize(T373* C,T2 a1);
void r208add_last(T208* C,T0* a1);
void r208with_capacity(T208* C,T2 a1);
void r208make(T208* C,T2 a1);
void r208copy(T208* C,T0* a1);
void r208resize(T208* C,T2 a1);
T0* r208twin(T208* C);
void r334make(T334* C,T2 a1);
void r334resize(T334* C,T2 a1);
void r340add_last(T340* C,T0* a1);
void r340with_capacity(T340* C,T2 a1);
T6 r340empty(T340* C);
T0* r340last(T340* C);
void r340remove_last(T340* C);
void r31add_last(T31* C,T0* a1);
void r31with_capacity(T31* C,T2 a1);
void r31make(T31* C,T2 a1);
T6 r31fast_has(T31* C,T0* a1);
T2 r31fast_index_of(T31* C,T0* a1);
void r31resize(T31* C,T2 a1);
T6 r31valid_index(T31* C,T2 a1);
void r94add_last(T94* C,T0* a1);
void r94with_capacity(T94* C,T2 a1);
T6 r94empty(T94* C);
void r94make(T94* C,T2 a1);
void r94copy(T94* C,T0* a1);
void r94resize(T94* C,T2 a1);
T0* r94twin(T94* C);
void r94clear_all(T94* C);
T2 r94count(T94* C);
T0* r94item(T94* C,T2 a1);
void r63add_last(T63* C,T0* a1);
void r63with_capacity(T63* C,T2 a1);
void r63make(T63* C,T2 a1);
T6 r63fast_has(T63* C,T0* a1);
T2 r63fast_index_of(T63* C,T0* a1);
void r63resize(T63* C,T2 a1);
T6 r63valid_index(T63* C,T2 a1);
void r322add_last(T322* C,T0* a1);
T2 r322count(T322* C);
void r336make(T336* C,T2 a1);
void r336resize(T336* C,T2 a1);
void r326add_last(T326* C,T0* a1);
void r326with_capacity(T326* C,T2 a1);
void r326make(T326* C,T2 a1);
T6 r326fast_has(T326* C,T0* a1);
T2 r326fast_index_of(T326* C,T0* a1);
void r326resize(T326* C,T2 a1);
T6 r326valid_index(T326* C,T2 a1);
void r326clear_all(T326* C);
T2 r326count(T326* C);
T0* r326item(T326* C,T2 a1);
void r217with_capacity(T217* C,T2 a1);
void r217add_last(T217* C,T0* a1);
void r217copy(T217* C,T0* a1);
T0* r217twin(T217* C);
void r221add_last(T221* C,T0* a1);
void r221copy(T221* C,T0* a1);
T0* r221twin(T221* C);
T2 r221count(T221* C);
T0* r221item(T221* C,T2 a1);
void r77add_last(T77* C,T0* a1);
T2 r77count(T77* C);
T0* r77item(T77* C,T2 a1);
void r27with_capacity(T27* C,T2 a1);
void r27add_last(T27* C,T2 a1);
void r27make(T27* C,T2 a1);
T6 r27fast_has(T27* C,T2 a1);
T2 r27fast_index_of(T27* C,T2 a1);
void r27resize(T27* C,T2 a1);
T6 r27valid_index(T27* C,T2 a1);
void r391add_last(T391* C,T0* a1);
void r391with_capacity(T391* C,T2 a1);
void r391make(T391* C,T2 a1);
T6 r391fast_has(T391* C,T0* a1);
T2 r391fast_index_of(T391* C,T0* a1);
void r391resize(T391* C,T2 a1);
T6 r391valid_index(T391* C,T2 a1);
void r381add_last(T381* C,T0* a1);
void r381with_capacity(T381* C,T2 a1);
T6 r381empty(T381* C);
void r381make(T381* C,T2 a1);
T6 r381fast_has(T381* C,T0* a1);
T2 r381fast_index_of(T381* C,T0* a1);
void r381resize(T381* C,T2 a1);
T6 r381valid_index(T381* C,T2 a1);
void r367add_last(T367* C,T0* a1);
void r367with_capacity(T367* C,T2 a1);
void r367make(T367* C,T2 a1);
T6 r367fast_has(T367* C,T0* a1);
T2 r367fast_index_of(T367* C,T0* a1);
void r367resize(T367* C,T2 a1);
T6 r367valid_index(T367* C,T2 a1);
void r352add_last(T352* C,T0* a1);
void r352with_capacity(T352* C,T2 a1);
void r352make(T352* C,T2 a1);
T6 r352fast_has(T352* C,T0* a1);
T2 r352fast_index_of(T352* C,T0* a1);
void r352resize(T352* C,T2 a1);
T6 r352valid_index(T352* C,T2 a1);
void r345add_last(T345* C,T0* a1);
void r345with_capacity(T345* C,T2 a1);
T6 r345empty(T345* C);
void r345make(T345* C,T2 a1);
T6 r345fast_has(T345* C,T0* a1);
void r345copy(T345* C,T0* a1);
T2 r345fast_index_of(T345* C,T0* a1);
void r345resize(T345* C,T2 a1);
T0* r345twin(T345* C);
T6 r345valid_index(T345* C,T2 a1);
void r53add_last(T53* C,T0* a1);
void r53with_capacity(T53* C,T2 a1);
void r53make(T53* C,T2 a1);
T6 r53fast_has(T53* C,T0* a1);
T2 r53fast_index_of(T53* C,T0* a1);
void r53resize(T53* C,T2 a1);
T6 r53valid_index(T53* C,T2 a1);
void r361add_last(T361* C,T0* a1);
void r361make(T361* C,T2 a1,T2 a2);
void r361force(T361* C,T0* a1,T2 a2);
void r361swap(T361* C,T2 a1,T2 a2);
void r361resize(T361* C,T2 a1,T2 a2);
T2 r361count(T361* C);
T0* r361item(T361* C,T2 a1);
void r354make(T354* C,T2 a1,T2 a2);
void r354set_slice_with(T354* C,T6 a1,T2 a2,T2 a3);
void r354force(T354* C,T6 a1,T2 a2);
void r354resize(T354* C,T2 a1,T2 a2);
T6 r354valid_index(T354* C,T2 a1);
T6 r354item(T354* C,T2 a1);
void r172add_last(T172* C,T2 a1);
T2 r172count(T172* C);
void r235add_last(T235* C,T0* a1);
void r235copy(T235* C,T0* a1);
T0* r235twin(T235* C);
T2 r235count(T235* C);
T0* r235item(T235* C,T2 a1);
void r228add_last(T228* C,T0* a1);
void r228copy(T228* C,T0* a1);
T0* r228twin(T228* C);
T2 r228count(T228* C);
T0* r228item(T228* C,T2 a1);
void r81add_last(T81* C,T0* a1);
T2 r81count(T81* C);
T0* r81item(T81* C,T2 a1);
void r49with_capacity(T49* C,T2 a1,T2 a2);
void r49add_last(T49* C,T0* a1);
T6 r49fast_has(T49* C,T0* a1);
T2 r49fast_index_of(T49* C,T0* a1);
T2 r49index_of(T49* C,T0* a1);
T6 r49valid_index(T49* C,T2 a1);
T2 r49count(T49* C);
T0* r49item(T49* C,T2 a1);
void r358with_capacity(T358* C,T2 a1,T2 a2);
void r358add_last(T358* C,T0* a1);
void r358swap(T358* C,T2 a1,T2 a2);
T2 r358count(T358* C);
T0* r358item(T358* C,T2 a1);
void r328with_capacity(T328* C,T2 a1,T2 a2);
void r328add_last(T328* C,T0* a1);
T6 r328fast_has(T328* C,T0* a1);
void r328copy(T328* C,T0* a1);
void r328swap(T328* C,T2 a1,T2 a2);
T2 r328fast_index_of(T328* C,T0* a1);
T6 r328valid_index(T328* C,T2 a1);
T2 r328count(T328* C);
T0* r328item(T328* C,T2 a1);
void r238add_last(T238* C,T0* a1);
void r238copy(T238* C,T0* a1);
T0* r238twin(T238* C);
T2 r238count(T238* C);
T0* r238item(T238* C,T2 a1);
void r104with_capacity(T104* C,T2 a1,T2 a2);
void r104add_last(T104* C,T0* a1);
void r104clear(T104* C);
T6 r104empty(T104* C);
void r104make(T104* C,T2 a1,T2 a2);
T6 r104fast_has(T104* C,T0* a1);
void r104copy(T104* C,T0* a1);
T2 r104fast_index_of(T104* C,T0* a1);
T6 r104valid_index(T104* C,T2 a1);
T0* r104twin(T104* C);
T2 r104count(T104* C);
T0* r104item(T104* C,T2 a1);
void r350add_last(T350* C,T0* a1);
void r350with_capacity(T350* C,T2 a1);
void r350make(T350* C,T2 a1);
void r350copy(T350* C,T0* a1);
void r350resize(T350* C,T2 a1);
T0* r350twin(T350* C);
void r196with_capacity(T196* C,T2 a1);
void r196add_last(T196* C,T0* a1);
void r151with_capacity(T151* C,T2 a1);
void r151add_last(T151* C,T0* a1);
void r151make(T151* C,T2 a1);
void r151copy(T151* C,T0* a1);
void r151resize(T151* C,T2 a1);
T0* r151twin(T151* C);
void r151clear_all(T151* C);
T2 r151count(T151* C);
T0* r151item(T151* C,T2 a1);
void r69add_last(T69* C,T0* a1);
void r69with_capacity(T69* C,T2 a1);
void r69make(T69* C,T2 a1);
T6 r69fast_has(T69* C,T0* a1);
T2 r69fast_index_of(T69* C,T0* a1);
void r69resize(T69* C,T2 a1);
T6 r69valid_index(T69* C,T2 a1);
void r343add_last(T343* C,T0* a1);
void r343with_capacity(T343* C,T2 a1);
void r343make(T343* C,T2 a1);
void r343resize(T343* C,T2 a1);
void r343clear_all(T343* C);
T2 r343count(T343* C);
T0* r343item(T343* C,T2 a1);
void r338make(T338* C,T2 a1);
void r338resize(T338* C,T2 a1);
void r71add_last(T71* C,T0* a1);
void r71with_capacity(T71* C,T2 a1);
T6 r71empty(T71* C);
T6 r71fast_has(T71* C,T0* a1);
T2 r71fast_index_of(T71* C,T0* a1);
T2 r71index_of(T71* C,T0* a1);
T6 r71valid_index(T71* C,T2 a1);
T6 r71has(T71* C,T0* a1);
void r110add_last(T110* C,T0* a1);
void r110copy(T110* C,T0* a1);
T0* r110twin(T110* C);
T2 r110count(T110* C);
T0* r110item(T110* C,T2 a1);
void r376add_last(T376* C,T0* a1);
void r376with_capacity(T376* C,T2 a1);
void r376make(T376* C,T2 a1);
void r376resize(T376* C,T2 a1);
void r86with_capacity(T86* C,T2 a1);
void r86add_last(T86* C,T0* a1);
void r86make(T86* C,T2 a1);
void r61with_capacity(T61* C,T2 a1);
void r61add_last(T61* C,T0* a1);
void r61make(T61* C,T2 a1);
void r61copy(T61* C,T0* a1);
void r61resize(T61* C,T2 a1);
T0* r61twin(T61* C);
void r202add_last(T202* C,T0* a1);
void r202with_capacity(T202* C,T2 a1);
void r202make(T202* C,T2 a1);
void r202copy(T202* C,T0* a1);
void r202resize(T202* C,T2 a1);
T0* r202twin(T202* C);
void r191add_last(T191* C,T0* a1);
void r191make(T191* C,T2 a1,T2 a2);
void r191copy(T191* C,T0* a1);
T0* r191twin(T191* C);
T2 r191count(T191* C);
T0* r191item(T191* C,T2 a1);
void r99add_last(T99* C,T0* a1);
T2 r99count(T99* C);
T0* r99item(T99* C,T2 a1);
void r371with_capacity(T371* C,T2 a1);
void r371resize_buckets(T371* C,T2 a1);
void r371expand(T371* C);
T0* r371at(T371* C,T0* a1);
void r371put(T371* C,T0* a1,T0* a2);
T6 r371has(T371* C,T0* a1);
void r348with_capacity(T348* C,T2 a1);
void r348resize_buckets(T348* C,T2 a1);
void r348expand(T348* C);
void r348remove(T348* C,T0* a1);
void r348set_cache_user_idx(T348* C,T2 a1);
void r348put(T348* C,T0* a1,T0* a2);
T6 r348has(T348* C,T0* a1);
T0* r348item(T348* C,T2 a1);
void r93with_capacity(T93* C,T2 a1);
void r93resize_buckets(T93* C,T2 a1);
void r93expand(T93* C);
T0* r93at(T93* C,T0* a1);
void r93put(T93* C,T0* a1,T0* a2);
T6 r93has(T93* C,T0* a1);
void r62with_capacity(T62* C,T2 a1);
void r62resize_buckets(T62* C,T2 a1);
void r62expand(T62* C);
T0* r62at(T62* C,T0* a1);
void r62set_cache_user_idx(T62* C,T2 a1);
void r62put(T62* C,T0* a1,T0* a2);
T6 r62has(T62* C,T0* a1);
T0* r62item(T62* C,T2 a1);
void r342with_capacity(T342* C,T2 a1);
void r342resize_buckets(T342* C,T2 a1);
void r342expand(T342* C);
void r342set_cache_user_idx(T342* C,T2 a1);
void r342put(T342* C,T0* a1,T2 a2);
T6 r342has(T342* C,T2 a1);
T0* r342item(T342* C,T2 a1);
void r333with_capacity(T333* C,T2 a1);
void r333resize_buckets(T333* C,T2 a1);
void r333expand(T333* C);
T0* r333at(T333* C,T0* a1);
void r333set_cache_user_idx(T333* C,T2 a1);
void r333put(T333* C,T0* a1,T0* a2);
T6 r333has(T333* C,T0* a1);
T0* r333item(T333* C,T2 a1);
void r325with_capacity(T325* C,T2 a1);
void r325resize_buckets(T325* C,T2 a1);
void r325expand(T325* C);
void r325remove(T325* C,T0* a1);
T0* r325at(T325* C,T0* a1);
void r325set_cache_user_idx(T325* C,T2 a1);
void r325put(T325* C,T0* a1,T0* a2);
T6 r325has(T325* C,T0* a1);
T0* r325item(T325* C,T2 a1);
void r23with_capacity(T23* C,T2 a1);
void r23resize_buckets(T23* C,T2 a1);
void r23expand(T23* C);
T0* r23at(T23* C,T0* a1);
void r23put(T23* C,T0* a1,T0* a2);
T6 r23has(T23* C,T0* a1);
void r68with_capacity(T68* C,T2 a1);
void r68resize_buckets(T68* C,T2 a1);
void r68expand(T68* C);
T0* r68at(T68* C,T0* a1);
void r68set_cache_user_idx(T68* C,T2 a1);
void r68put(T68* C,T0* a1,T0* a2);
T6 r68has(T68* C,T0* a1);
T0* r68item(T68* C,T2 a1);
void r145compile_to_c_old(T145* C);
extern T0*oBC12cpp;
T0* r145runnable_expression(T0* a1,T0* a2);
void r145run_feature_has_result(T145* C);
T2 r145static_value(T145* C);
extern T0*oBC12eh;
void r145run_feature_match(T145* C);
T0* r145add_comment(T145* C,T0* a1);
void r145with(T145* C,T0* a1,T0* a2,T0* a3);
void r145mapping_c_target(T145* C,T0* a1);
void r145afd_check(T145* C);
void r145c_declare_for_old(T145* C);
void r145collect_c_tmp(T145* C);
T0* r145operator(void);
T6 r145use_current(T145* C);
T0* r145to_runnable(T145* C,T0* a1);
T2 r145to_integer(T145* C);
T6 r145is_static(T145* C);
void r145finalize(T145* C);
void r145error(T0* a1,T0* a2);
T0* r145result_type(T145* C);
T6 r145can_be_dropped(T145* C);
T0* r145run_feature_for(T145* C,T0* a1,T0* a2);
extern T331 oBC12switch_collection;
T0* r145static_result_base_class(T145* C);
void r145make(T145* C,T0* a1,T0* a2);
void r145fatal_error(T0* a1);
extern T0*oBC12run_control;
void r145assertion_check(T145* C,T3 a1);
void r145compile_to_c(T145* C);
void r145mapping_c_arg(T145* C,T0* a1);
T0* r156add_comment(T156* C,T0* a1);
void r156mapping_c_target(T156* C,T0* a1);
T0* r156to_runnable(T156* C,T0* a1);
T2 r156to_integer(T156* C);
void r156error(T0* a1,T0* a2);
T0* r156result_type(T156* C);
extern T0*oBC12small_eiffel;
T0* r156static_result_base_class(void);
void r156compile_to_c(T156* C);
void r156mapping_c_arg(T156* C,T0* a1);
void r178add_last(T178* C,T0* a1);
void r178initialize_expanded(T178* C);
void r178inline_one_pc(T178* C);
T2 r178rank_of(T178* C,T0* a1);
void r178fatal_error(T0* a1);
void r178check_name_clash(T178* C,T0* a1);
void r178declaration_list_make(T178* C,T0* a1);
T6 r178produce_c(T178* C);
void r178c_declare(T178* C);
T0* r178to_runnable(T178* C,T0* a1);
T0* r178twin(T178* C);
T0* r178type(T178* C,T2 a1);
void r178dynamic_runnable(T178* C,T0* a1);
void r178error(T0* a1,T0* a2);
T6 r178is_runnable(T178* C,T0* a1);
void r42se_tmp_add(T0* a1);
void r42push_check(T42* C,T0* a1,T0* a2,T0* a3);
T2 r42se_tmp_open(T0* a1);
void r42se_trace_ins(T42* C,T0* a1);
void r42put_ith_argument(T42* C,T2 a1);
void r42connect_cecil_out_h(T42* C,T0* a1);
void r42push_inline_dca(T42* C,T0* a1,T0* a2);
void r42incr_procedure_count(T42* C);
void r42really_define_c_main(T42* C,T0* a1);
extern T0*oBC12tmp_file_read;
void r42push_direct(T42* C,T0* a1,T0* a2,T0* a3);
void r42put_file(T0* a1,T0* a2);
extern T0*oBC43stack_rf;
void r42backup_sfw_connect(T42* C,T0* a1,T0* a2);
void r42put_inspect(T42* C);
void r42incr_direct_call_count(T42* C);
void r42put_c_inline_c(T42* C);
extern T0*oBC43stack_target;
void r42set_output_name(T42* C,T0* a1);
void r42put_extern5(T42* C,T0* a1,T0* a2);
void r42finished_run_class(T42* C);
extern T0*oBC43stack_code;
void r42stack_overflow(T42* C);
T0* r42get_inline_ms(T42* C);
void r42conversion_name(T2 a1);
extern T0*oBC42out_make;
void r42bit_constant_definition(T42* C);
extern T0*oBC12echo;
void r42push_switch(T42* C,T0* a1,T0* a2);
void r42check_assertion(T42* C,T0* a1,T0* a2);
void r42increment_static_expression_count(T42* C,T2 a1);
void r42current_class_invariant(T0* a1);
void r42incr_switch_count(T42* C);
void r42put_to_pointer(T42* C);
void r42put_cpc(T42* C,T0* a1);
void r42put_target_as_value(T42* C);
void r42put_string_c(T0* a1);
extern T0*oBC42c_inline_h_mem;
void r42put_trace_switch(T42* C);
void r42define_initialize_eiffel_runtime(T42* C,T0* a1);
void r42put_position(T42* C,T0* a1);
void r42se_tmp_close_declaration(T42* C);
void r42put_extern6(T42* C,T0* a1,T2 a2);
T6 r42stupid_switch_n(T0* a1,T0* a2);
void r42sys_runtime_c(T0* a1);
void r42swap_on_h(T42* C);
void r42put_generator(T42* C,T0* a1);
void r42define_to_reference(T42* C);
void r42put_error0(T42* C,T0* a1);
void r42pop(T42* C);
void r42se_tmp_close(T2 a1);
extern T0*oBC43stack_static_rf;
void r42register_bit_constant(T42* C,T0* a1);
void r42to_reference(T42* C,T0* a1,T0* a2);
void r42define_to_expanded(T42* C);
extern T0*oBC12gc_handler;
void r42incr_real_function_count(T42* C);
void r42write_make_file_no_split(T42* C);
void r42get_started(T42* C);
void r42put_object_size(T42* C,T0* a1);
void r42customize_runtime(T42* C);
void r42sys_runtime_h(T42* C,T0* a1);
void r42put_c_inline_h(T42* C);
void r42put_array1(T42* C,T3 a1,T2 a2);
void r42sys_runtime_h_and_c(T42* C,T0* a1);
void r42put_arguments(T42* C);
void r42fatal_error(T0* a1);
void r42put_extern7(T42* C,T0* a1);
void r42expanded_attributes(T42* C,T0* a1);
void r42incr_real_procedure_count(T42* C);
void r42write_make_file(T42* C);
void r42put_recompilation_comment(T2 a1);
T6 r42file_exists(T0* a1);
extern int fBC12system_tools;
extern T0*oBC12system_tools;
T0* r42system_tools(void);
T6 r42stupid_switch(T0* a1);
void r42put_position_in_ds(T0* a1);
void r42se_trace_exp(T42* C,T0* a1);
void r42put_se_string_from_external_copy(T42* C,T0* a1);
void r42incr_function_count(T42* C);
void r42put_extern1(T42* C,T0* a1);
void r42incr_static_expression_count(T42* C);
void r42incr_inlined_procedure_count(T42* C);
void r42stack_push(T42* C,T2 a1);
void r42incr_inlined_function_count(T42* C);
extern T0*oBC42out_c;
void r42to_expanded(T42* C,T0* a1,T0* a2);
void r42variant_check(T42* C,T0* a1);
extern T0*oBC42tmp_string;
extern T0*oBC43pre_computed_once;
void r42incr_elt_c_count(T42* C,T2 a1);
void r42push_new(T42* C,T0* a1,T0* a2);
void r42common_put_target(T42* C);
extern T0*oBC12exceptions_handler;
T6 r42target_cannot_be_dropped(T42* C);
void r42use_switch(T42* C,T0* a1,T0* a2,T0* a3,T0* a4);
T6 r42call_invariant_start(T0* a1);
void r42put_extern2(T42* C,T0* a1,T3 a2);
extern T51 oBC1file_tools;
void r42check_id(T42* C,T0* a1,T2 a2);
void r42define_used_basics(T42* C);
extern T0*oBC43stack_cpc;
extern T0*oBC42tmp_string2;
extern T0*oBC12cecil_pool;
extern int fBC42path_c;
extern T0*oBC42path_c;
T0* r42path_c(T42* C);
extern T0*oBC12eiffel_parser;
void r42path_c_in(T0* a1,T2 a2);
void r42define_main(T42* C,T0* a1);
void r42print_argument(T42* C,T2 a1);
T6 r42attribute_read_removal(T0* a1,T0* a2);
void r42write_make_file_split(T42* C);
void r42put_c_heading(T42* C,T0* a1);
extern int fBC42path_make;
extern T0*oBC42path_make;
T0* r42path_make(void);
void r42inline_level_incr(T42* C);
void r42inline_level_decr(T42* C);
T6 r42se_tmp_open_declaration(T42* C);
T0* r42need_invariant(T0* a1);
void r42put_banner(T0* a1);
void r42inspect_incr(T42* C);
void r42inspect_decr(T42* C);
void r42sfw_connect(T42* C,T0* a1,T0* a2);
extern T0*oBC12manifest_string_pool;
void r42starting_manifest_string_definition(T42* C,T2 a1);
void r42put_comment_line(T42* C,T0* a1);
void r42put_target_as_target(T42* C);
void r42put_c_function(T42* C,T0* a1,T0* a2);
extern T0*oBC12c_frame_descriptor_format;
void r42push_cpc(T42* C,T0* a1,T0* a2,T0* a3,T0* a4);
T6 r42arguments_cannot_be_dropped(T42* C);
void r42put_generating_type(T42* C,T0* a1);
void r42push_void(T42* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC43stack_args;
T6 r42no_args_to_eval(T42* C);
T6 r42cannot_drop_all(T42* C);
void r42cecil_define(T42* C);
void r42put_extern4(T42* C,T0* a1,T0* a2,T2 a3);
extern T0*oBC42se_tmp_list;
void r42print_current(T42* C);
void r42finished_switch(T42* C,T2 a1);
void r42expanded_writable(T42* C,T0* a1,T0* a2);
void r42trace_boolean_expression(T42* C,T0* a1);
void r42macro_def(T42* C,T0* a1,T2 a2);
extern int fBC42path_h;
extern T0*oBC42path_h;
T0* r42path_h(void);
void r42push_same_target(T42* C,T0* a1,T0* a2);
void r42push_precursor(T42* C,T0* a1,T0* a2);
void r42inside_twin(T42* C,T0* a1);
void r42print_local(T42* C,T0* a1);
void r42put_comment(T42* C,T0* a1);
T0* r269generic_list(T269* C);
void r269cast_to_ref(T269* C);
void r269gc_call_new_in(T0* a1);
T0* r269base_class(T269* C);
T0* r269look_up_for(T269* C,T0* a1,T0* a2);
T6 r269has_creation(T269* C,T0* a1);
void r269error(T0* a1,T0* a2);
T6 r269is_a_in(T269* C,T0* a1,T0* a2);
T6 r269is_native_array(T269* C);
void r269make(T269* C,T0* a1);
void r269fatal_error_generic_list(T269* C);
T0* r269smallest_ancestor(T0* a1);
void r269gc_mark_in(T0* a1);
void r269c_type_for_external_in(T0* a1);
T0* r269run_time_mark(void);
void r269demangling_in(T0* a1);
T0* r269written_mark(void);
T2 r269space_for_pointer(void);
void r218make(T218* C,T0* a1,T0* a2,T0* a3);
T0* r218add_comment(T218* C,T0* a1);
void r218compile_to_c(T218* C);
void r218afd_check(T218* C);
T6 r218use_current(T218* C);
T0* r218to_runnable(T218* C,T0* a1);
T6 r218is_pre_computable(T218* C);
T0* r218start_position(T218* C);
void r245make(T245* C,T0* a1,T0* a2,T0* a3);
void r245afd_check(T245* C);
T6 r245use_current(T245* C);
T0* r245to_runnable(T245* C,T0* a1);
T0* r245twin(T245* C);
void r245error(T0* a1,T0* a2);
T0* r245start_position(T245* C);
void r138declaration_in(T138* C,T0* a1);
void r138make(T138* C,T0* a1,T0* a2);
void r138undefine_in(T138* C,T0* a1);
extern int fBC12string_aliaser;
extern T0*oBC12string_aliaser;
T0* r138string_aliaser(void);
T0* r138origin_base_class(T138* C);
T0* r138name_in(T138* C,T0* a1);
void r138error(T0* a1,T0* a2);
extern T0*oBC39parser_buffer_path;
extern int fBC12type_string;
extern T0*oBC12type_string;
T0* r39type_string(void);
void r39warning(T0* a1,T0* a2);
T0* r39top_rf(T39* C);
extern T0*oBC39stack_rf;
T0* r39base_class(T39* C,T0* a1);
void r39incr_magic_count(T39* C);
T0* r39load_class(T39* C,T0* a1);
extern int fBC39loading_path;
extern T0*oBC39loading_path;
T0* r39loading_path(void);
extern T0*oBC12address_of_pool;
T0* r39get_class(T0* a1);
T0* r39memory_class_used(void);
extern T0*oBC39c_code;
extern T0*oBC39registered_for_c_define;
extern T0*oBC12manifest_array_pool;
extern T0*oBC39tmp_tail;
extern T0*oBC12parser_buffer;
T6 r39is_tagged(T0* a1);
T6 r39string_at_run_time(void);
void r39afd_check_deferred(T0* a1);
extern int fBC39rename_dictionary;
extern T0*oBC39rename_dictionary;
T0* r39rename_dictionary(T39* C);
void r39pop(T39* C);
extern T0*oBC39base_class_dictionary;
T6 r39parser_buffer_for(T39* C,T0* a1);
void r39push(T39* C,T0* a1);
void r39get_started(T39* C,T0* a1,T0* a2);
T6 r39is_used(T0* a1);
void r39add_class(T39* C,T0* a1);
T0* r39run_class(T0* a1);
void r39fatal_error(T0* a1);
T0* r39system_tools(void);
void r39compile_to_c(T39* C);
extern T0*oBC39run_class_dictionary;
extern int fBC39tmp_class_name;
extern T0*oBC39tmp_class_name;
T0* r39tmp_class_name(void);
extern T0*oBC39rf9_memory;
extern int fBC12id_provider;
extern T0*oBC12id_provider;
T0* r39id_provider(void);
void r273standard_c_object_model(T273* C);
void r273gc_free_in(T273* C,T0* a1);
void r273standard_gc_info_in(T273* C,T0* a1);
T0* r273generic_list(T273* C);
T6 r273need_gc_mark_function(T273* C);
void r273standard_c_print_function(T273* C);
T2 r273id(T273* C);
void r273cast_to_ref(T273* C);
void r273just_before_gc_mark_in(T273* C,T0* a1);
void r273c_header_pass3(T273* C);
void r273gc_call_new_in(T273* C,T0* a1);
void r273standard_c_struct(T273* C);
T0* r273base_class(T273* C);
void r273gc_store_chunk_in(T273* C,T0* a1);
T0* r273look_up_for(T273* C,T0* a1,T0* a2);
T6 r273has_creation(T273* C,T0* a1);
T6 r273need_c_struct(T273* C);
void r273mapping_cast(T273* C);
void r273gc_align_mark_in(T273* C,T0* a1);
T6 r273is_a_in(T273* C,T0* a1,T0* a2);
void r273standard_c_typedef(T273* C);
T6 r273is_native_array(T273* C);
T6 r273is_a(T273* C,T0* a1);
extern T0*oBC273check_memory;
void r273gc_store_left_in(T273* C,T0* a1);
void r273used_as_reference(T273* C);
T6 r273is_reference(T273* C);
void r273standard_gc_define2_for_expanded(T273* C);
void r273fatal_error_generic_list(T273* C);
void r273c_initialize_in(T273* C,T0* a1);
T0* r273smallest_ancestor(T273* C,T0* a1);
void r273standard_gc_define2(T273* C);
void r273c_header_pass4(T273* C);
void r273to_reference(T273* C);
T0* r273to_runnable(T273* C,T0* a1);
void r273standard_gc_define1(T273* C);
void r273standard_just_before_gc_mark_in(T273* C,T0* a1);
void r273gc_define1(T273* C);
void r273gc_mark_in(T273* C,T0* a1);
void r273gc_info_nb_in(T273* C,T0* a1);
void r273c_type_for_argument_in(T273* C,T0* a1);
void r273c_type_for_external_in(T273* C,T0* a1);
T2 r273space_for_variable(T273* C);
void r273gc_store_in(T273* C,T0* a1);
T0* r273run_class(T273* C);
T6 r273is_dummy_expanded(T273* C);
T2 r273standard_space_for_object(T273* C);
void r273c_type_for_target_in(T273* C,T0* a1);
T6 r273is_expanded(T273* C);
void r273c_type_for_result_in(T273* C,T0* a1);
T0* r273expanded_initializer(T273* C);
void r273demangling_in(T273* C,T0* a1);
void r273c_initialize(T273* C);
void r273c_frame_descriptor(T273* C);
void r273c_initialize_expanded(T273* C);
void r273gc_info_in(T273* C,T0* a1);
void r273gc_define2(T273* C);
T2 r273space_for_integer(void);
T2 r273space_for_pointer(void);
void r130compile_to_c_old(T130* C);
T2 r130static_value(T130* C);
T2 r130static_eq_void(T0* a1);
void r130afd_check(T130* C);
T6 r130is_manifest_array(T0* a1);
void r130c_declare_for_old(T130* C);
void r130collect_c_tmp(T130* C);
T0* r130operator(void);
void r130cmp_bit(T130* C,T6 a1,T0* a2);
void r130cmp_basic_eiffel_expanded(T130* C,T6 a1,T0* a2,T0* a3);
T0* r130runnable_args(T0* a1,T0* a2);
void r130bit_limitation(T130* C,T0* a1,T0* a2);
void r130error(T0* a1,T0* a2);
void r130dca_inline(T130* C,T0* a1);
void r130cmp_basic_ref(T130* C,T6 a1);
extern int fBC12type_boolean;
extern T0*oBC12type_boolean;
T0* r130type_boolean(void);
void r130make(T130* C,T0* a1,T0* a2,T0* a3);
void r130error_comparison(T130* C,T0* a1,T0* a2);
T6 r130is_static_eq_void(T0* a1);
void r130mapping_c_arg(T130* C,T0* a1);
T0* r130runnable_expression(T0* a1,T0* a2);
void r130check_comparison(T130* C,T0* a1);
T0* r130add_comment(T130* C,T0* a1);
void r130mapping_c_target(T130* C,T0* a1);
void r130with(T130* C,T0* a1,T0* a2,T0* a3);
T6 r130use_current(T130* C);
T0* r130to_runnable(T130* C,T0* a1);
T2 r130to_integer(T130* C);
T6 r130is_static(T130* C);
T0* r130arg1(T130* C);
void r130cmp_user_expanded(T130* C,T6 a1,T0* a2);
T0* r130static_result_base_class(void);
void r130fatal_error(T0* a1);
void r130c2c_exp_ref(T0* a1,T0* a2,T0* a3,T0* a4);
void r130assertion_check(T130* C,T3 a1);
void r130compile_to_c(T130* C);
void r122compile_to_c_old(T122* C);
T0* r122runnable_expression(T0* a1,T0* a2);
void r122run_feature_has_result(T122* C);
void r122run_feature_match(T122* C,T0* a1);
T0* r122add_comment(T122* C,T0* a1);
void r122with(T122* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r122mapping_c_target(T122* C,T0* a1);
void r122afd_check(T122* C);
void r122c_declare_for_old(T122* C);
void r122collect_c_tmp(T122* C);
T0* r122operator(void);
T6 r122use_current(T122* C);
T0* r122runnable_args(T0* a1,T0* a2);
T0* r122to_runnable(T122* C,T0* a1);
T2 r122to_integer(T122* C);
T6 r122is_static(T122* C);
void r122finalize(T122* C);
void r122error(T0* a1,T0* a2);
T0* r122result_type(T122* C);
T0* r122arg1(T122* C);
T0* r122run_feature_for(T122* C,T0* a1,T0* a2);
T0* r122static_result_base_class(T122* C);
void r122make(T122* C,T0* a1,T0* a2,T0* a3);
void r122fatal_error(T0* a1);
void r122assertion_check(T122* C,T3 a1);
void r122mapping_c_arg(T122* C,T0* a1);
void r36put_string(T36* C,T0* a1);
void r36put_integer(T36* C,T2 a1);
extern T0*oBC37tmp_string;
void r36put_double_format(T36* C,T5 a1,T2 a2);
T6 r211is_merge_with(T211* C,T0* a1,T0* a2);
T6 r211is_merge_with2aux(T211* C,T0* a1,T0* a2);
T0* r211try_to_undefine_aux(T211* C,T0* a1,T0* a2);
T0* r211try_to_undefine(T211* C,T0* a1,T0* a2);
void r211check_obsolete(T211* C,T0* a1);
T6 r211is_merge_with1(T211* C,T0* a1);
T6 r211is_merge_with2(T211* C,T0* a1,T0* a2);
T0* r211to_run_feature(T211* C,T0* a1,T0* a2);
void r211error(T0* a1,T0* a2);
void r211make(T211* C,T0* a1,T0* a2,T0* a3);
void r211add_into(T211* C,T0* a1);
T6 r211can_hide(T211* C,T0* a1,T0* a2);
T6 r211stupid_switch(T0* a1,T0* a2);
void r211merge_header_comments(T211* C,T0* a1);
T0* r211start_position(T211* C);
void r98make(T98* C,T0* a1,T0* a2,T0* a3);
void r98add_into(T98* C,T0* a1);
void r120compile_to_c_old(T120* C);
T0* r120runnable_expression(T0* a1,T0* a2);
void r120run_feature_has_result(T120* C);
void r120run_feature_match(T120* C,T0* a1);
T0* r120add_comment(T120* C,T0* a1);
void r120with(T120* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r120mapping_c_target(T120* C,T0* a1);
void r120afd_check(T120* C);
void r120c_declare_for_old(T120* C);
void r120collect_c_tmp(T120* C);
T0* r120operator(void);
T6 r120use_current(T120* C);
T0* r120runnable_args(T0* a1,T0* a2);
T0* r120to_runnable(T120* C,T0* a1);
T2 r120to_integer(T120* C);
T6 r120is_static(T120* C);
void r120finalize(T120* C);
void r120error(T0* a1,T0* a2);
T0* r120result_type(T120* C);
T0* r120arg1(T120* C);
T0* r120run_feature_for(T120* C,T0* a1,T0* a2);
T0* r120static_result_base_class(T120* C);
void r120make(T120* C,T0* a1,T0* a2,T0* a3);
void r120fatal_error(T0* a1);
void r120assertion_check(T120* C,T3 a1);
void r120mapping_c_arg(T120* C,T0* a1);
T6 r34a_manifest_string(T34* C);
void r34disconnect(T34* C);
void r34a_indexing(T34* C);
T0* r34current_position(T34* C);
T0* r34a_actuals(T34* C);
T0* r34a_clients(T34* C);
T6 r34a_strip(T34* C);
extern T0*oBC34forbidden_class;
extern T0*oBC34tmp_name;
void r34a_after_a_dot(T34* C,T6 a1,T0* a2);
extern T0*oBC34faof;
T6 r34a_integer(T34* C);
void r34a_parent_list(T34* C,T0* a1,T0* a2);
T6 r34a_actual(T34* C);
void r34a_rename_list(T34* C);
T6 r34a_local_variable(T34* C);
T6 r34a_infix(T34* C);
T0* r34analyse_class(T34* C,T0* a1);
void r34skip_comments(T34* C);
T6 r34a_inspect(T34* C);
T6 r34a_current(T34* C);
void r34next_char(T34* C);
T6 r34a_unary(T34* C);
T6 r34a_conditional(T34* C);
void r34a_base_class_name1(T34* C);
T6 r34a_retry(T34* C);
extern T0*oBC34tmp_string;
T6 r34a_e10(T34* C);
T6 r34a_tag_mark(T34* C);
T0* r34a_routine_body(T34* C);
T6 r34a_feature_declaration(T34* C);
void r34a_r10(T34* C,T6 a1,T0* a2,T0* a3,T0* a4);
T6 r34a_keyword(T34* C,T0* a1);
T6 r34a_class_type(T34* C);
T6 r34a_feature_name_list(T34* C);
T6 r34a_feature_name(T34* C);
T0* r34a_assertion(T34* C);
void r34a_ascii_code(T34* C);
T6 r34a_void(T34* C);
void r34a_formal_generic_list(T34* C);
T6 r34a_index_value(T34* C);
void r34a_assignment_aux(T34* C,T6 a1);
T0* r34to_proc_call(T34* C,T0* a1,T0* a2,T0* a3);
T6 r34a_expression(T34* C);
T0* r34a_routine(T34* C);
T6 r34a_creation(T34* C);
T6 r34a_bit_constant(T34* C);
T6 r34a_boolean_constant(T34* C);
T0* r34a_external(T34* C);
T6 r34a_type(T34* C);
T6 r34skip1unless2(T34* C,T3 a1,T3 a2);
T6 r34a_real(T34* C);
T6 r34a_index_clause(T34* C);
void r34a_procedure_call(T34* C);
T6 r34a_parent(T34* C);
T0* r34a_compound1(T34* C);
T6 r34a_instruction(T34* C);
T6 r34a_debug(T34* C);
T0* r34connect_to_cecil(T34* C);
void r34to_frozen_feature_name(T34* C);
T6 r34a_manifest_constant(T34* C);
T6 r34a_base_type(T34* C);
T6 r34a_result(T34* C);
T6 r34a_base_class_name(T34* C);
void r34a_formal_arg_list(T34* C);
T6 r34a_identifier(T34* C);
void r34wcpefnc(T34* C,T0* a1,T0* a2);
T6 r34skip1(T34* C,T3 a1);
T6 r34skip2(T34* C,T3 a1,T3 a2);
T6 r34a_integer_constant(T34* C);
T0* r34a_compound2(T34* C,T0* a1,T0* a2);
void r34a_new_export_list(T34* C);
void r34a_creation_clause(T34* C,T0* a1);
void r34show_nb(T2 a1,T0* a2);
T6 r34a_identifier1(T34* C);
void r34fcp(T34* C,T0* a1);
T6 r34a_character_constant(T34* C);
T0* r34parse_feature_name(T34* C);
extern T0*oBC34lcs;
void r34a_local_var_list(T34* C);
T0* r34pos(T2 a1,T2 a2);
T6 r34a_loop(T34* C);
T6 r34a_free_operator(T34* C);
T6 r34a_binary(T34* C,T0* a1);
T6 r34a_check(T34* C);
void r34a_then_part_list(T34* C,T0* a1);
T0* r34parse_c_name(T34* C);
T6 r34a_precursor(T34* C,T6 a1);
T6 r34a_prefix(T34* C);
void r34fatal_error(T0* a1);
T6 r34a_identifier2(T34* C);
void r34warning(T0* a1,T0* a2);
extern T0*oBC34tmp_feature;
T0* r34get_comments(T34* C);
T0* r34parse_run_type(T34* C);
void r34error(T0* a1,T0* a2);
T0* r34to_call(T0* a1,T0* a2,T0* a3);
T6 r34a_then_part(T34* C,T0* a1);
T6 r34a_type_formal_generic(T34* C);
void r34go_back_at(T34* C,T2 a1,T2 a2);
T6 r34a_when_part(T34* C,T0* a1);
T6 r34a_argument(T34* C);
T6 r34a_assignment_or_call(T34* C);
T6 r34a_constant(T34* C);
T6 r34a_e0(T34* C);
T6 r34a_e1(T34* C);
T6 r34a_e2(T34* C);
T6 r34a_e3(T34* C);
T6 r34a_e4(T34* C);
T6 r34a_e5(T34* C);
T6 r34a_e6(T34* C);
T6 r34a_e7(T34* C);
void r34a_function_call(T34* C);
T6 r34a_e8(T34* C);
T6 r34a_e9(T34* C);
T6 r34end_of_input(T34* C);
T6 r34a_real_constant(T34* C);
T6 r34a_rename_pair(T34* C);
void r34a_r1(T34* C,T0* a1);
void r34a_r2(T34* C,T0* a1);
void r34a_r3(T34* C,T0* a1);
void r34a_r4(T34* C,T0* a1);
void r34a_r5(T34* C,T0* a1);
void r34a_r6(T34* C,T0* a1);
void r34a_r7(T34* C,T0* a1);
T0* r34last_result(T34* C);
void r34a_r8(T34* C,T0* a1);
T0* r34a_alias(T34* C);
void r34a_feature_clause(T34* C);
void r34err_exp(T0* a1,T0* a2);
void r34a_class_declaration(T34* C);
T0* r266generic_list(T266* C);
void r266gc_call_new_in(T0* a1);
T0* r266base_class(T266* C);
T0* r266look_up_for(T266* C,T0* a1,T0* a2);
T6 r266has_creation(T266* C,T0* a1);
void r266error(T0* a1,T0* a2);
T6 r266is_a_in(T266* C,T0* a1,T0* a2);
T6 r266is_native_array(T266* C);
T6 r266is_a(T266* C,T0* a1);
void r266make(T266* C,T0* a1);
extern int fBC266used_as_reference;
void r266used_as_reference(void);
void r266fatal_error_generic_list(T266* C);
T0* r266smallest_ancestor(T266* C,T0* a1);
extern int fBC266check_type;
void r266check_type(T266* C);
extern int fBC12type_character_ref;
extern T0*oBC12type_character_ref;
T0* r266type_character_ref(void);
void r266load_ref(T0* a1);
T0* r266to_runnable(T266* C,T0* a1);
void r266gc_mark_in(T0* a1);
void r266c_type_for_external_in(T0* a1);
void r266c_type_for_argument_in(T0* a1);
T0* r266run_time_mark(void);
T0* r266run_class(T266* C);
void r266demangling_in(T0* a1);
T0* r266written_mark(void);
T0* r283left_type(T283* C);
void r283make(T283* C,T0* a1,T0* a2);
void r283fatal_error(T0* a1);
void r283warning(T0* a1,T0* a2);
T0* r283add_comment(T283* C,T0* a1);
void r283compile_to_c(T283* C);
void r283afd_check(T283* C);
void r283collect_c_tmp(T283* C);
T6 r283use_current(T283* C);
T0* r283to_runnable(T283* C,T0* a1);
T0* r283right_type(T283* C);
void r283error(T0* a1,T0* a2);
T0* r283start_position(T283* C);
void r383refer_to(T383* C,T2 a1,T0* a2);
void r383undefine_in(T383* C,T0* a1);
T0* r383string_aliaser(void);
T0* r383origin_base_class(T383* C);
T0* r383name_in(T383* C,T0* a1);
T6 r383is_frozen(T383* C);
T0* r383to_string(T383* C);
void r383error(T0* a1,T0* a2);
T0* r383start_position(T383* C);
T0* r158add_comment(T158* C,T0* a1);
void r158mapping_c_target(T0* a1);
T0* r158to_runnable(T158* C,T0* a1);
T2 r158to_integer(T158* C);
void r158error(T0* a1,T0* a2);
void r158compile_to_c(T158* C);
void r158mapping_c_arg(T158* C,T0* a1);
void r313make(T313* C,T0* a1,T0* a2);
void r313append_in(T313* C,T0* a1);
T6 r305is_merge_with(T305* C,T0* a1,T0* a2);
T6 r305is_merge_with2aux(T305* C,T0* a1,T0* a2);
T0* r305try_to_undefine_aux(T305* C,T0* a1,T0* a2);
T0* r305try_to_undefine(T305* C,T0* a1,T0* a2);
void r305check_obsolete(T305* C,T0* a1);
T6 r305is_merge_with1(T305* C,T0* a1);
T6 r305is_merge_with2(T305* C,T0* a1,T0* a2);
T0* r305to_run_feature(T305* C,T0* a1,T0* a2);
void r305error(T0* a1,T0* a2);
void r305set_header_comment(T305* C,T0* a1);
void r305make_routine(T305* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r305make(T305* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r305add_into(T305* C,T0* a1);
T6 r305can_hide(T305* C,T0* a1,T0* a2);
T6 r305stupid_switch(T305* C,T0* a1,T0* a2);
void r305merge_header_comments(T305* C,T0* a1);
void r305mapping_c_name_in(T305* C,T0* a1);
T0* r305start_position(T305* C);
void r103compile_to_c_old(T103* C);
T6 r103is_always_true(T103* C);
void r103make(T103* C,T0* a1,T0* a2,T0* a3);
void r103afd_check(T103* C);
void r103compile_to_c(T103* C);
void r103c_declare_for_old(T103* C);
void r103collect_c_tmp(T103* C);
T6 r103use_current(T103* C);
T0* r103to_runnable(T103* C,T0* a1,T3 a2);
T6 r103is_pre_computable(T103* C);
void r103error(T0* a1,T0* a2);
T0* r103start_position(T103* C);
void r96make(T96* C,T0* a1,T0* a2);
void r96fatal_error(T0* a1);
void r96check_generic_formal_arguments(T96* C);
T2 r96index_of(T96* C,T0* a1);
void r97get_started(T97* C,T0* a1);
void r41add_position(T0* a1);
void r41print_as_fatal_error(T41* C);
T6 r41empty(void);
void r41fatal_error(T0* a1);
extern T0*oBC41explanation;
void r41feature_not_found(T0* a1);
extern T0*oBC41positions;
void r41print_as_warning(T41* C);
void r41add_feature_name(T0* a1);
void r41add_type(T0* a1,T0* a2);
void r41do_print(T0* a1);
void r41print_as_error(T41* C);
void r83good_end(T83* C,T0* a1);
void r83make(T83* C,T0* a1,T0* a2);
void r83warning(T0* a1,T0* a2);
void r83append(T83* C,T0* a1);
T6 r212is_merge_with(T212* C,T0* a1,T0* a2);
T6 r212is_merge_with2aux(T212* C,T0* a1,T0* a2);
T0* r212try_to_undefine_aux(T212* C,T0* a1,T0* a2);
T0* r212try_to_undefine(T212* C,T0* a1,T0* a2);
void r212check_obsolete(T212* C,T0* a1);
T6 r212is_merge_with1(T212* C,T0* a1);
T6 r212is_merge_with2(T212* C,T0* a1,T0* a2);
T0* r212to_run_feature(T212* C,T0* a1,T0* a2);
void r212error(T0* a1,T0* a2);
void r212make(T212* C,T0* a1,T0* a2,T0* a3);
void r212add_into(T212* C,T0* a1);
T6 r212can_hide(T212* C,T0* a1,T0* a2);
T6 r212stupid_switch(T0* a1,T0* a2);
void r212merge_header_comments(T212* C,T0* a1);
T0* r212start_position(T212* C);
T6 r199is_merge_with(T199* C,T0* a1,T0* a2);
T6 r199is_merge_with2aux(T199* C,T0* a1,T0* a2);
T0* r199try_to_undefine_aux(T199* C,T0* a1,T0* a2);
extern T0*oBC199counter;
T0* r199try_to_undefine(T199* C,T0* a1,T0* a2);
void r199check_obsolete(T199* C,T0* a1);
T6 r199is_merge_with1(T199* C,T0* a1);
T6 r199is_merge_with2(T199* C,T0* a1,T0* a2);
T0* r199to_run_feature(T199* C,T0* a1,T0* a2);
void r199error(T0* a1,T0* a2);
void r199make(T199* C,T0* a1,T0* a2);
void r199add_into(T199* C,T0* a1);
T6 r199can_hide(T199* C,T0* a1,T0* a2);
T6 r199stupid_switch(T0* a1,T0* a2);
void r199merge_header_comments(T199* C,T0* a1);
T0* r199start_position(T199* C);
T0* r257generic_list(T257* C);
T6 r257need_gc_mark_function(T257* C);
void r257to_expanded(T257* C);
T2 r257id(T257* C);
void r257cast_to_ref(T257* C);
void r257c_header_pass1(T257* C);
void r257just_before_gc_mark_in(T257* C,T0* a1);
void r257c_header_pass3(T257* C);
void r257gc_call_new_in(T257* C,T0* a1);
T6 r257is_array(T257* C);
T0* r257base_class(T257* C);
T0* r257look_up_for(T257* C,T0* a1,T0* a2);
T6 r257has_creation(T257* C,T0* a1);
T6 r257need_c_struct(T257* C);
void r257mapping_cast(T257* C);
T6 r257is_a_in(T257* C,T0* a1,T0* a2);
T6 r257is_native_array(T257* C);
T6 r257is_boolean(T257* C);
T6 r257is_a(T257* C,T0* a1);
T6 r257is_generic(T257* C);
void r257used_as_reference(T257* C);
T6 r257is_reference(T257* C);
T6 r257is_real(T257* C);
T6 r257is_user_expanded(T257* C);
T6 r257is_integer(T257* C);
T6 r257is_any(T257* C);
void r257fatal_error_generic_list(T257* C);
T6 r257is_string(T257* C);
void r257c_initialize_in(T257* C,T0* a1);
T0* r257smallest_ancestor(T257* C,T0* a1);
void r257c_header_pass2(T257* C);
void r257with(T257* C,T0* a1,T0* a2);
void r257c_header_pass4(T257* C);
T6 r257is_double(T257* C);
void r257to_reference(T257* C);
T6 r257is_none(T257* C);
T0* r257to_runnable(T257* C,T0* a1);
T6 r257is_pointer(T257* C);
void r257gc_define1(T257* C);
void r257gc_mark_in(T257* C,T0* a1);
void r257c_type_for_argument_in(T257* C,T0* a1);
void r257c_type_for_external_in(T257* C,T0* a1);
T0* r257run_time_mark(T257* C);
T2 r257space_for_variable(T257* C);
T0* r257run_class(T257* C);
T6 r257is_dummy_expanded(T257* C);
T6 r257is_expanded(T257* C);
void r257c_type_for_result_in(T257* C,T0* a1);
void r257c_type_for_target_in(T257* C,T0* a1);
T0* r257expanded_initializer(T257* C);
T6 r257is_basic_eiffel_expanded(T257* C);
void r257demangling_in(T257* C,T0* a1);
void r257c_initialize(T257* C);
T6 r257is_character(T257* C);
T0* r257written_mark(void);
T0* r257base_class_name(T257* C);
void r257c_frame_descriptor(T257* C);
T6 r257is_bit(T257* C);
void r257gc_info_in(T257* C,T0* a1);
void r257gc_define2(T257* C);
T0* r267generic_list(T267* C);
extern int fBC12type_double_ref;
extern T0*oBC12type_double_ref;
T0* r267type_double_ref(void);
void r267gc_call_new_in(T0* a1);
T0* r267base_class(T267* C);
T0* r267look_up_for(T267* C,T0* a1,T0* a2);
T6 r267has_creation(T267* C,T0* a1);
void r267error(T0* a1,T0* a2);
T6 r267is_a_in(T267* C,T0* a1,T0* a2);
T6 r267is_native_array(T267* C);
T6 r267is_a(T267* C,T0* a1);
void r267make(T267* C,T0* a1);
extern int fBC267used_as_reference;
void r267used_as_reference(void);
void r267fatal_error_generic_list(T267* C);
T0* r267smallest_ancestor(T267* C,T0* a1);
extern int fBC267check_type;
void r267check_type(T267* C);
void r267load_ref(T0* a1);
T0* r267to_runnable(T267* C,T0* a1);
void r267gc_mark_in(T0* a1);
void r267c_type_for_external_in(T0* a1);
void r267c_type_for_argument_in(T0* a1);
T0* r267run_time_mark(void);
T2 r267space_for_variable(void);
T0* r267run_class(T267* C);
void r267demangling_in(T0* a1);
T0* r267written_mark(void);
void r133compile_to_c_old(T133* C);
T0* r133runnable_expression(T0* a1,T0* a2);
void r133run_feature_has_result(T133* C);
void r133run_feature_match(T133* C,T0* a1);
T0* r133add_comment(T133* C,T0* a1);
void r133with(T133* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r133mapping_c_target(T133* C,T0* a1);
void r133afd_check(T133* C);
void r133c_declare_for_old(T133* C);
void r133collect_c_tmp(T133* C);
T0* r133operator(void);
T6 r133use_current(T133* C);
T0* r133runnable_args(T0* a1,T0* a2);
T0* r133to_runnable(T133* C,T0* a1);
T2 r133to_integer(T133* C);
void r133finalize(T133* C);
void r133error(T0* a1,T0* a2);
T0* r133result_type(T133* C);
T0* r133arg1(T133* C);
T0* r133run_feature_for(T133* C,T0* a1,T0* a2);
T0* r133static_result_base_class(T133* C);
void r133make(T133* C,T0* a1,T0* a2,T0* a3);
void r133fatal_error(T0* a1);
void r133assertion_check(T133* C,T3 a1);
void r133mapping_c_arg(T133* C,T0* a1);
extern int fBC12type_any;
extern T0*oBC12type_any;
T0* r147type_any(void);
void r147vwst1_check(T147* C,T0* a1);
T2 r147array_count(T147* C,T0* a1);
T0* r147add_comment(T147* C,T0* a1);
T0* r147to_runnable(T147* C,T0* a1);
T2 r147to_integer(T147* C);
void r147error(T0* a1,T0* a2);
T0* r147result_type(T147* C);
T0* r147static_result_base_class(void);
void r147make(T147* C,T0* a1,T0* a2);
void r147compile_to_c(T147* C);
T6 r243is_always_true(T243* C);
T0* r243check_assertion_mode(void);
void r243make(T243* C,T0* a1,T0* a2,T0* a3);
void r243compile_to_c(T243* C);
void r243afd_check(T243* C);
T6 r243use_current(T243* C);
T0* r243to_runnable(T243* C,T0* a1);
T0* r243twin(T243* C);
extern T0*oBC12assertion_collector;
void r387compile_to_c_old(T387* C);
T2 r387static_value(T387* C);
T6 r387is_current(T387* C);
T0* r387static_result_base_class(T387* C);
void r387make(T387* C,T0* a1,T0* a2);
void r387dca_inline_argument(T387* C,T0* a1);
T0* r387add_comment(T387* C,T0* a1);
void r387assertion_check(T387* C,T3 a1);
void r387compile_to_c(T387* C);
void r387mapping_c_target(T387* C,T0* a1);
void r387afd_check(T387* C);
void r387c_declare_for_old(T387* C);
void r387collect_c_tmp(T387* C);
T6 r387is_result(T387* C);
T6 r387use_current(T387* C);
T0* r387to_runnable(T387* C,T0* a1);
T2 r387to_integer(T387* C);
T6 r387is_static(T387* C);
void r387mapping_c_arg(T387* C,T0* a1);
T6 r387is_pre_computable(T387* C);
void r387error(T0* a1,T0* a2);
T2 r387isa_dca_inline_argument(T387* C);
T6 r387c_simple(T387* C);
T6 r387can_be_dropped(T387* C);
T0* r387start_position(T387* C);
void r126compile_to_c_old(T126* C);
T0* r126runnable_expression(T0* a1,T0* a2);
void r126run_feature_has_result(T126* C);
void r126run_feature_match(T126* C,T0* a1);
T0* r126add_comment(T126* C,T0* a1);
void r126with(T126* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r126mapping_c_target(T126* C,T0* a1);
void r126afd_check(T126* C);
void r126c_declare_for_old(T126* C);
void r126collect_c_tmp(T126* C);
T0* r126operator(void);
T6 r126use_current(T126* C);
T0* r126runnable_args(T0* a1,T0* a2);
T0* r126to_runnable(T126* C,T0* a1);
T2 r126to_integer(T126* C);
T6 r126is_static(T126* C);
void r126finalize(T126* C);
void r126error(T0* a1,T0* a2);
T0* r126result_type(T126* C);
T0* r126arg1(T126* C);
T0* r126run_feature_for(T126* C,T0* a1,T0* a2);
T0* r126static_result_base_class(T126* C);
void r126make(T126* C,T0* a1,T0* a2,T0* a3);
void r126fatal_error(T0* a1);
void r126assertion_check(T126* C,T3 a1);
void r126compile_to_c(T126* C);
void r126mapping_c_arg(T126* C,T0* a1);
void r126c2c_cast_op(T126* C,T0* a1,T0* a2);
void r124compile_to_c_old(T124* C);
T0* r124runnable_expression(T0* a1,T0* a2);
void r124run_feature_has_result(T124* C);
void r124run_feature_match(T124* C,T0* a1);
T0* r124add_comment(T124* C,T0* a1);
void r124with(T124* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r124mapping_c_target(T124* C,T0* a1);
void r124afd_check(T124* C);
void r124c_declare_for_old(T124* C);
void r124collect_c_tmp(T124* C);
T0* r124operator(void);
T6 r124use_current(T124* C);
T0* r124runnable_args(T0* a1,T0* a2);
T0* r124to_runnable(T124* C,T0* a1);
T2 r124to_integer(T124* C);
T6 r124is_static(T124* C);
void r124finalize(T124* C);
void r124error(T0* a1,T0* a2);
T0* r124result_type(T124* C);
T0* r124arg1(T124* C);
T0* r124run_feature_for(T124* C,T0* a1,T0* a2);
T0* r124static_result_base_class(T124* C);
void r124make(T124* C,T0* a1,T0* a2,T0* a3);
void r124fatal_error(T0* a1);
void r124assertion_check(T124* C,T3 a1);
void r124compile_to_c(T124* C);
void r124mapping_c_arg(T124* C,T0* a1);
void r124c2c_cast_op(T124* C,T0* a1,T0* a2);
void r52disconnect(T52* C);
void r52put_string(T52* C,T0* a1);
void r52put_integer(T52* C,T2 a1);
void r52connect_to(T52* C,T0* a1);
T0* r271generic_list(T271* C);
void r271gc_call_new_in(T0* a1);
T0* r271base_class(T271* C);
T0* r271look_up_for(T271* C,T0* a1,T0* a2);
T6 r271has_creation(T271* C,T0* a1);
void r271error(T0* a1,T0* a2);
T6 r271is_a_in(T271* C,T0* a1,T0* a2);
T6 r271is_native_array(T271* C);
T6 r271is_a(T271* C,T0* a1);
void r271make(T271* C,T0* a1);
extern int fBC12type_real_ref;
extern T0*oBC12type_real_ref;
T0* r271type_real_ref(void);
extern int fBC271used_as_reference;
void r271used_as_reference(void);
extern int fBC12type_double;
extern T0*oBC12type_double;
T0* r271type_double(void);
void r271fatal_error_generic_list(T271* C);
T0* r271smallest_ancestor(T271* C,T0* a1);
extern int fBC271check_type;
void r271check_type(T271* C);
void r271load_ref(T0* a1);
T0* r271to_runnable(T271* C,T0* a1);
void r271gc_mark_in(T0* a1);
void r271c_type_for_external_in(T0* a1);
void r271c_type_for_argument_in(T0* a1);
T0* r271run_time_mark(void);
T2 r271space_for_variable(void);
T0* r271run_class(T271* C);
void r271demangling_in(T0* a1);
T0* r271written_mark(void);
void r357make(T357* C,T0* a1);
void r357add(T357* C,T0* a1);
void r357afd_check(T357* C);
void r357compile_to_c(T357* C);
T6 r357use_current(T357* C);
void r357clear_run_feature(T357* C);
T0* r183base_class_written(T183* C);
extern T0*oBC181tmp_string;
void r183warning(T0* a1,T0* a2);
T0* r183add_comment(T183* C,T0* a1);
void r183mapping_c_target(T183* C,T0* a1);
T0* r183to_runnable(T183* C,T0* a1);
T2 r183to_integer(T183* C);
extern T0*oBC12c_frame_descriptor_locals;
T0* r183twin(T183* C);
void r183error(T0* a1,T0* a2);
T0* r183static_result_base_class(T183* C);
void r183make(T183* C,T0* a1,T0* a2);
void r183name_clash_for(T183* C,T0* a1,T0* a2);
T6 r183produce_c(T183* C);
void r183c_declare(T183* C);
void r183mapping_c_arg(T183* C,T0* a1);
void r183c_frame_descriptor(T183* C,T0* a1);
extern T0*oBC12c_frame_descriptor_local_count;
T0* r183written_in(T183* C);
void r261standard_c_object_model(T261* C);
void r261gc_free_in(T261* C,T0* a1);
void r261standard_gc_info_in(T261* C,T0* a1);
void r261standard_c_print_function(T261* C);
T2 r261id(T261* C);
void r261cast_to_ref(T261* C);
void r261gc_call_new_in(T261* C,T0* a1);
void r261standard_c_struct(T261* C);
T0* r261base_class(T261* C);
void r261gc_store_chunk_in(T261* C,T0* a1);
T0* r261look_up_for(T261* C,T0* a1,T0* a2);
T6 r261has_creation(T261* C,T0* a1);
void r261mapping_cast(T261* C);
void r261gc_align_mark_in(T261* C,T0* a1);
T6 r261is_a_in(T261* C,T0* a1,T0* a2);
void r261standard_c_typedef(T261* C);
T6 r261is_native_array(T261* C);
T6 r261is_a(T261* C,T0* a1);
extern T0*oBC261tmp_written_mark;
void r261make(T261* C,T0* a1,T0* a2);
void r261gc_store_left_in(T261* C,T0* a1);
T0* r261run_type(T261* C);
void r261load_basic_features(T261* C);
T6 r261is_run_type(T261* C);
T0* r261smallest_ancestor(T261* C,T0* a1);
T0* r261string_aliaser(void);
void r261standard_gc_define2(T261* C);
void r261with(T261* C,T0* a1,T0* a2,T0* a3);
void r261c_header_pass4(T261* C);
T0* r261to_runnable(T261* C,T0* a1);
void r261standard_gc_define1(T261* C);
void r261standard_just_before_gc_mark_in(T261* C,T0* a1);
void r261gc_mark_in(T261* C,T0* a1);
void r261gc_info_nb_in(T261* C,T0* a1);
void r261c_type_for_external_in(T0* a1);
T0* r261run_time_mark(T261* C);
void r261gc_store_in(T261* C,T0* a1);
T0* r261run_class(T261* C);
void r261final(T261* C,T0* a1,T0* a2);
void r261fatal_error(T0* a1);
void r261c_type_for_target_in(T261* C,T0* a1);
void r261demangling_in(T261* C,T0* a1);
void r261c_frame_descriptor(T261* C);
T2 r261space_for_pointer(void);
T0* r174add_comment(T174* C,T0* a1);
T0* r174to_real_constant(T174* C);
void r174error(T0* a1,T0* a2);
extern int fBC174result_type;
extern T0*oBC174result_type;
T0* r174result_type(void);
void r174unary_minus(T174* C);
T0* r174static_result_base_class(void);
void r174make(T174* C,T2 a1,T0* a2);
void r174mapping_c_arg(T174* C,T0* a1);
T2 r174isa_dca_inline_argument(void);
void r180refer_to(T180* C,T0* a1,T0* a2,T2 a3);
T0* r180add_comment(T180* C,T0* a1);
void r180mapping_c_target(T180* C,T0* a1);
T0* r180to_runnable(T180* C,T0* a1);
T2 r180to_integer(T180* C);
T0* r180to_string(T180* C);
void r180error(T0* a1,T0* a2);
T0* r180result_type(T180* C);
T0* r180static_result_base_class(T180* C);
void r180fatal_error(T0* a1);
void r180assertion_check(T180* C,T3 a1);
void r180mapping_c_arg(T180* C,T0* a1);
T0* r264generic_list(T264* C);
void r264gc_call_new_in(T0* a1);
T0* r264base_class(T264* C);
T0* r264look_up_for(T264* C,T0* a1,T0* a2);
T6 r264has_creation(T264* C,T0* a1);
void r264error(T0* a1,T0* a2);
T6 r264is_a_in(T264* C,T0* a1,T0* a2);
T6 r264is_native_array(T264* C);
T6 r264is_a(T264* C,T0* a1);
void r264make(T264* C,T0* a1);
extern int fBC264used_as_reference;
void r264used_as_reference(void);
void r264fatal_error_generic_list(T264* C);
T0* r264smallest_ancestor(T264* C,T0* a1);
extern int fBC264check_type;
void r264check_type(T264* C);
void r264load_ref(T0* a1);
T0* r264to_runnable(T264* C,T0* a1);
extern int fBC12type_boolean_ref;
extern T0*oBC12type_boolean_ref;
T0* r264type_boolean_ref(void);
void r264gc_mark_in(T0* a1);
void r264c_type_for_external_in(T0* a1);
void r264c_type_for_argument_in(T0* a1);
T0* r264run_time_mark(void);
T2 r264space_for_variable(void);
T0* r264run_class(T264* C);
void r264demangling_in(T0* a1);
T0* r264written_mark(void);
void r330falling_down(T330* C,T0* a1);
void r330define_gc_info(T0* a1);
extern T0*oBC330header;
T0* r330type_string(void);
void r330initialize_runtime(T330* C);
void r330allocation_of(T330* C,T0* a1,T0* a2);
void r330switch_for(T330* C,T0* a1);
extern T0*oBC12once_routine_pool;
void r330new_native9_in(T330* C,T0* a1,T6 a2);
void r330define_gc_start(T330* C,T0* a1,T0* a2);
void r330just_before_mark(T0* a1);
extern T0*oBC330run_class_list;
void r330new_manifest_string_in(T330* C,T0* a1,T6 a2);
void r330c_dicho(T330* C,T0* a1,T2 a2,T2 a3);
void r330no_gc(T330* C);
void r330allocation(T330* C,T0* a1);
void r330define2(T330* C);
void r330set_info_flag(T330* C);
void r330sort_running(T0* a1);
void r330mark_for(T0* a1,T0* a2,T0* a3);
T0* r330system_tools(void);
void r330memory_dispose(T0* a1,T0* a2,T0* a3);
void r330gc_info_before_exit(T330* C);
extern T0*oBC330body;
void r135compile_to_c_old(T135* C);
T0* r135runnable_expression(T0* a1,T0* a2);
void r135run_feature_has_result(T135* C);
void r135run_feature_match(T135* C,T0* a1);
T0* r135add_comment(T135* C,T0* a1);
void r135with(T135* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r135mapping_c_target(T135* C,T0* a1);
void r135afd_check(T135* C);
void r135c_declare_for_old(T135* C);
void r135collect_c_tmp(T135* C);
T0* r135operator(void);
T6 r135use_current(T135* C);
T0* r135runnable_args(T0* a1,T0* a2);
T0* r135to_runnable(T135* C,T0* a1);
T2 r135to_integer(T135* C);
T6 r135is_static(T135* C);
void r135finalize(T135* C);
void r135error(T0* a1,T0* a2);
T0* r135result_type(T135* C);
T0* r135arg1(T135* C);
T0* r135run_feature_for(T135* C,T0* a1,T0* a2);
T0* r135static_result_base_class(T135* C);
void r135make(T135* C,T0* a1,T0* a2,T0* a3);
void r135fatal_error(T0* a1);
void r135assertion_check(T135* C,T3 a1);
void r135mapping_c_arg(T135* C,T0* a1);
void r187external_prototype_in(T187* C,T0* a1);
T2 r187rank_of(T187* C,T0* a1);
extern T0*oBC187tmp_string;
void r187check_name_clash(T187* C,T0* a1);
void r187declaration_list_make(T187* C,T0* a1);
void r187with(T187* C,T0* a1,T0* a2);
T0* r187type(T187* C,T2 a1);
void r187dynamic_runnable(T187* C,T0* a1);
void r187error(T0* a1,T0* a2);
void r187add_last(T187* C,T0* a1);
T6 r187is_a_in(T187* C,T0* a1,T0* a2);
void r187inline_one_pc(T187* C);
void r187make(T187* C,T0* a1);
void r187fatal_error(T0* a1);
void r187compile_to_c_in(T187* C,T0* a1);
T6 r187is_runnable(T187* C,T0* a1);
T0* r187start_position(T187* C);
T0* r366static_result_base_class(T366* C);
T0* r366add_comment(T366* C,T0* a1);
void r366compile_to_c(T366* C);
void r366mapping_c_target(T366* C,T0* a1);
T2 r366to_integer(void);
void r366error(T0* a1,T0* a2);
T0* r366result_type(T366* C);
T6 r287is_merge_with(T287* C,T0* a1,T0* a2);
T6 r287is_merge_with2aux(T287* C,T0* a1,T0* a2);
T0* r287try_to_undefine(T287* C,T0* a1,T0* a2);
void r287check_obsolete(T287* C,T0* a1);
T6 r287is_merge_with1(T287* C,T0* a1);
T6 r287is_merge_with2(T287* C,T0* a1,T0* a2);
T0* r287to_run_feature(T287* C,T0* a1,T0* a2);
void r287error(T0* a1,T0* a2);
void r287set_header_comment(T287* C,T0* a1);
void r287set_rescue_compound(T287* C,T0* a1);
void r287make_routine(T287* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r287make(T287* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r287add_into(T287* C,T0* a1);
T6 r287can_hide(T287* C,T0* a1,T0* a2);
void r287from_effective(T287* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
void r287merge_header_comments(T287* C,T0* a1);
void r287mapping_c_name_in(T287* C,T0* a1);
T0* r287start_position(T287* C);
T0* r207value(T207* C,T2 a1);
T6 r207is_merge_with(T207* C,T0* a1,T0* a2);
T6 r207is_merge_with2aux(T207* C,T0* a1,T0* a2);
T0* r207try_to_undefine_aux(T207* C,T0* a1,T0* a2);
T0* r207try_to_undefine(T207* C,T0* a1,T0* a2);
void r207check_obsolete(T207* C,T0* a1);
T6 r207is_merge_with1(T207* C,T0* a1);
T6 r207is_merge_with2(T207* C,T0* a1,T0* a2);
T0* r207to_run_feature(T207* C,T0* a1,T0* a2);
void r207error(T0* a1,T0* a2);
void r207make(T207* C,T0* a1,T0* a2,T0* a3);
void r207add_into(T207* C,T0* a1);
T6 r207can_hide(T207* C,T0* a1,T0* a2);
T6 r207stupid_switch(T0* a1,T0* a2);
void r207merge_header_comments(T207* C,T0* a1);
T0* r207start_position(T207* C);
void r75check_expanded_with(T75* C,T0* a1);
T0* r75root_procedure_name(T75* C,T0* a1);
void r75fatal_error(T0* a1);
T0* r75expanded_initializer(T75* C,T0* a1);
T0* r75get_clause(T75* C,T0* a1);
T0* r75start_position(T75* C);
T0* r231add_comment(T231* C,T0* a1);
void r231compile_to_c(T231* C);
T0* r231to_runnable(T231* C,T0* a1);
void r45put_string(T45* C,T0* a1);
void r45put_integer(T45* C,T2 a1);
void r111compile_to_c_old(T111* C);
T0* r111type_any(void);
T0* r111add_comment(T111* C,T0* a1);
void r111mapping_c_target(T111* C,T0* a1);
void r111afd_check(T111* C);
void r111c_declare_for_old(T111* C);
T6 r111use_current(T111* C);
T0* r111to_runnable(T111* C,T0* a1);
T2 r111to_integer(T111* C);
void r111error(T0* a1,T0* a2);
T0* r111static_result_base_class(void);
void r111make(T111* C,T0* a1,T0* a2);
void r111assertion_check(T111* C,T3 a1);
void r111compile_to_c(T111* C);
T6 r111is_pre_computable(T111* C);
T0* r163runnable_expression(T0* a1,T0* a2);
T0* r163run_feature_for(T163* C,T0* a1,T0* a2);
void r163make(T163* C,T0* a1,T0* a2);
void r163fatal_error(T0* a1);
void r163run_feature_has_no_result(T163* C);
void r163run_feature_match(T163* C);
T0* r163add_comment(T163* C,T0* a1);
void r163compile_to_c(T163* C);
void r163afd_check(T163* C);
void r163collect_c_tmp(T163* C);
T6 r163use_current(T163* C);
T0* r163to_runnable(T163* C,T0* a1);
T0* r163make_runnable(T163* C,T0* a1,T0* a2,T0* a3);
void r163finalize(T163* C);
T0* r163start_position(T163* C);
void r134compile_to_c_old(T134* C);
T0* r134runnable_expression(T0* a1,T0* a2);
void r134run_feature_has_result(T134* C);
void r134run_feature_match(T134* C,T0* a1);
T0* r134add_comment(T134* C,T0* a1);
void r134with(T134* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r134mapping_c_target(T134* C,T0* a1);
void r134afd_check(T134* C);
void r134c_declare_for_old(T134* C);
void r134collect_c_tmp(T134* C);
T0* r134operator(void);
T6 r134use_current(T134* C);
T0* r134runnable_args(T0* a1,T0* a2);
T0* r134to_runnable(T134* C,T0* a1);
T2 r134to_integer(T134* C);
T6 r134is_static(T134* C);
void r134finalize(T134* C);
void r134error(T0* a1,T0* a2);
T0* r134result_type(T134* C);
T0* r134arg1(T134* C);
T0* r134run_feature_for(T134* C,T0* a1,T0* a2);
T0* r134static_result_base_class(T134* C);
void r134make(T134* C,T0* a1,T0* a2,T0* a3);
void r134fatal_error(T0* a1);
void r134assertion_check(T134* C,T3 a1);
void r134mapping_c_arg(T134* C,T0* a1);
T0* r240to_runnable_integer(T240* C,T0* a1);
T0* r240to_runnable_character(T240* C,T0* a1);
T0* r240twin(T240* C);
void r240error(T0* a1,T0* a2);
T0* r240start_position(T240* C);
void r230compile_to_c_old(T230* C);
T2 r230static_value(T230* C);
T6 r230is_current(T230* C);
T0* r230static_result_base_class(T230* C);
void r230make(T230* C,T0* a1,T0* a2);
T6 r230is_manifest_string(T230* C);
void r230dca_inline_argument(T230* C,T0* a1);
T0* r230add_comment(T230* C,T0* a1);
void r230assertion_check(T230* C,T3 a1);
void r230compile_to_c(T230* C);
void r230mapping_c_target(T230* C,T0* a1);
void r230afd_check(T230* C);
void r230c_declare_for_old(T230* C);
void r230collect_c_tmp(T230* C);
T6 r230is_result(T230* C);
T6 r230use_current(T230* C);
T0* r230to_runnable(T230* C,T0* a1);
T2 r230to_integer(T230* C);
T6 r230is_void(T230* C);
T6 r230is_static(T230* C);
void r230mapping_c_arg(T230* C,T0* a1);
T6 r230is_pre_computable(T230* C);
void r230error(T0* a1,T0* a2);
T2 r230isa_dca_inline_argument(T230* C);
T0* r230result_type(T230* C);
T6 r230c_simple(T230* C);
T6 r230can_be_dropped(T230* C);
T0* r230start_position(T230* C);
T0* r164runnable_expression(T0* a1,T0* a2);
void r164run_feature_match(T164* C,T0* a1);
T0* r164add_comment(T164* C,T0* a1);
void r164with(T164* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r164afd_check(T164* C);
void r164collect_c_tmp(T164* C);
T6 r164use_current(T164* C);
T0* r164runnable_args(T0* a1,T0* a2);
T0* r164to_runnable(T164* C,T0* a1);
T0* r164make_runnable(T164* C,T0* a1,T0* a2,T0* a3);
void r164finalize(T164* C);
T0* r164arg1(T164* C);
T0* r164run_feature_for(T164* C,T0* a1,T0* a2);
void r164make(T164* C,T0* a1,T0* a2,T0* a3);
void r164fatal_error(T0* a1);
void r164run_feature_has_no_result(T164* C);
T6 r164standard_use_current(T164* C);
void r164compile_to_c(T164* C);
T0* r164start_position(T164* C);
void r35print_count(T35* C,T0* a1,T2 a2);
void r35put_string(T35* C,T0* a1);
void r35sfr_connect_or_exit(T35* C,T0* a1,T0* a2);
void r35put_integer(T35* C,T2 a1);
void r35sfr_connect(T35* C,T0* a1,T0* a2);
T0* r35read_word_in(T35* C,T0* a1);
void r35w_put_string(T0* a1);
void r35w_put_integer(T2 a1);
T6 r35file_exists(T0* a1);
void r35file_renaming(T35* C,T0* a1,T0* a2);
void r35file_removing(T35* C,T0* a1);
void r35w_put_character(T3 a1);
extern T0*oBC1std_error;
void r35put_character(T35* C,T3 a1);
extern T0*oBC1std_output;
void r35put_double_format(T35* C,T5 a1,T2 a2);
T6 r285is_merge_with(T285* C,T0* a1,T0* a2);
T6 r285is_merge_with2aux(T285* C,T0* a1,T0* a2);
T0* r285try_to_undefine(T285* C,T0* a1,T0* a2);
void r285check_obsolete(T285* C,T0* a1);
T6 r285is_merge_with1(T285* C,T0* a1);
T6 r285is_merge_with2(T285* C,T0* a1,T0* a2);
T0* r285to_run_feature(T285* C,T0* a1,T0* a2);
void r285error(T0* a1,T0* a2);
void r285set_header_comment(T285* C,T0* a1);
void r285set_rescue_compound(T285* C,T0* a1);
void r285make_routine(T285* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r285add_into(T285* C,T0* a1);
T6 r285can_hide(T285* C,T0* a1,T0* a2);
void r285from_effective(T285* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r285merge_header_comments(T285* C,T0* a1);
void r285mapping_c_name_in(T285* C,T0* a1);
T0* r285start_position(T285* C);
void r247make(T247* C,T0* a1,T0* a2);
void r247fatal_error(T0* a1);
void r247warning(T0* a1,T0* a2);
void r247c2c_clear_expanded(T247* C,T2 a1);
void r247c2c_closing(T247* C,T0* a1);
T0* r247add_comment(T247* C,T0* a1);
void r247check_created_type(T247* C,T0* a1);
void r247compile_to_c(T247* C);
void r247check_creation_clause(T247* C,T0* a1);
void r247check_writable(T247* C,T0* a1);
T6 r247use_current(T247* C);
T0* r247to_runnable(T247* C,T0* a1);
void r247c2c_opening(T247* C,T0* a1);
T6 r247is_pre_computable(T247* C);
void r247error(T0* a1,T0* a2);
void r232make(T232* C,T0* a1,T0* a2);
T0* r232add_comment(T232* C,T0* a1);
void r232compile_to_c(T232* C);
void r232afd_check(T232* C);
void r232set_else_compound(T232* C,T0* a1,T0* a2);
T6 r232use_current(T232* C);
T0* r232to_runnable(T232* C,T0* a1);
T0* r232twin(T232* C);
void r232error(T0* a1,T0* a2);
void r232add_when(T232* C,T0* a1);
T6 r40is_wa_cycle(T40* C,T0* a1);
extern T0*oBC40tmp_string;
void r40c_header_pass1(T40* C);
void r40just_before_gc_mark_in(T40* C,T0* a1);
T0* r40at(T40* C,T0* a1);
void r40c_header_pass3(T40* C);
T0* r40base_class(T40* C);
void r40afd_check(T40* C);
T6 r40gt(T0* a1,T0* a2);
void r40really_compile_to_c(T40* C);
void r40c_print_function(T40* C);
void r40error(T0* a1,T0* a2);
void r40runnable_class_invariant(T40* C);
void r40demangling(T40* C);
void r40store_feature(T40* C,T0* a1);
void r40make(T40* C,T0* a1);
void r40c_object_model_in(T40* C,T0* a1);
extern T0*oBC40to_reference_memory;
void r40efnf(T40* C,T0* a1,T0* a2);
T0* r40writable_attributes(T40* C);
T6 r40is_running_of(T40* C,T0* a1);
void r40gc_set_fsoh_marked_in(T40* C,T0* a1);
void r40used_as_reference(T40* C);
T0* r40dynamic(T40* C,T0* a1);
void r40prepare_strip(T40* C);
T6 r40is_tagged(T40* C);
void r40add_rf(T40* C,T0* a1,T0* a2);
void r40falling_down(T40* C);
void r40mark_attribute(T40* C,T0* a1,T0* a2);
void r40c_header_pass2(T40* C);
extern int fBC12class_general;
extern T0*oBC12class_general;
T0* r40class_general(void);
void r40c_header_pass4(T40* C);
T0* r40get_feature(T40* C,T0* a1);
void r40sort_wam(T0* a1);
void r40set_at_run_time(T40* C);
T0* r40to_reference(T40* C);
void r40gc_define1(T40* C);
extern T0*oBC40wa_buf;
T0* r40get_memory_dispose(T40* C);
void r40gc_mark_fixed_size(T40* C,T6 a1,T0* a2);
void r40fatal_error(T0* a1);
T6 r40gc_mark_to_follow(T40* C);
T0* r40get_result_type(T40* C,T0* a1);
T0* r40get_or_fatal_error(T40* C,T0* a1);
extern T0*oBC40wa_cyclic_buf;
T0* r40get_copy(T40* C);
void r40gc_align_mark_fixed_size(T40* C,T0* a1);
T0* r40get_feature_with(T40* C,T0* a1);
void r40compile_to_c(T40* C,T2 a1);
extern T0*oBC40wa_cycle;
T0* r40get_rf_with(T40* C,T0* a1);
T0* r40base_class_name(T40* C);
void r40add_running(T40* C,T0* a1);
T2 r40offset_of(T40* C,T0* a1);
T6 r40need_gc_mark(T40* C);
void r40gc_info_in(T40* C,T0* a1);
T0* r40class_with(T0* a1);
void r40gc_define2(T40* C);
T0* r40id_provider(void);
void r40add_client(T40* C,T0* a1);
void r152compile_to_c_old(T152* C);
T0* r152runnable_expression(T0* a1,T0* a2);
void r152run_feature_has_result(T152* C);
T2 r152static_value(T152* C);
void r152run_feature_match(T152* C,T0* a1);
T0* r152add_comment(T152* C,T0* a1);
void r152with(T152* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r152mapping_c_target(T152* C,T0* a1);
void r152afd_check(T152* C);
void r152c_declare_for_old(T152* C);
void r152collect_c_tmp(T152* C);
T6 r152use_current(T152* C);
T0* r152runnable_args(T0* a1,T0* a2);
T0* r152to_runnable(T152* C,T0* a1);
T2 r152to_integer(T152* C);
T6 r152is_static(T152* C);
void r152finalize(T152* C);
void r152error(T0* a1,T0* a2);
T0* r152result_type(T152* C);
T0* r152arg1(T152* C);
T0* r152run_feature_for(T152* C,T0* a1,T0* a2);
T0* r152static_result_base_class(T152* C);
void r152make(T152* C,T0* a1,T0* a2,T0* a3);
void r152fatal_error(T0* a1);
void r152assertion_check(T152* C,T3 a1);
void r152mapping_c_arg(T152* C,T0* a1);
T0* r152start_position(T152* C);
void r150compile_to_c_old(T150* C);
T0* r150runnable_expression(T0* a1,T0* a2);
void r150run_feature_has_result(T150* C);
T2 r150static_value(T150* C);
void r150run_feature_match(T150* C);
T0* r150add_comment(T150* C,T0* a1);
void r150with(T150* C,T0* a1,T0* a2,T0* a3);
void r150mapping_c_target(T150* C,T0* a1);
void r150afd_check(T150* C);
void r150c_declare_for_old(T150* C);
void r150collect_c_tmp(T150* C);
T6 r150use_current(T150* C);
T0* r150to_runnable(T150* C,T0* a1);
T2 r150to_integer(T150* C);
T6 r150is_static(T150* C);
void r150finalize(T150* C);
void r150error(T0* a1,T0* a2);
T0* r150result_type(T150* C);
T6 r150can_be_dropped(T150* C);
T0* r150run_feature_for(T150* C,T0* a1,T0* a2);
T0* r150static_result_base_class(T150* C);
void r150make(T150* C,T0* a1,T0* a2);
void r150fatal_error(T0* a1);
void r150assertion_check(T150* C,T3 a1);
void r150compile_to_c(T150* C);
void r150mapping_c_arg(T150* C,T0* a1);
T6 r150is_pre_computable(T150* C);
T0* r150start_position(T150* C);
T0* r234to_runnable_integer(T234* C,T0* a1);
void r234from_when_list(T234* C,T0* a1);
void r234compile_to_c(T234* C,T0* a1);
void r234afd_check(T234* C);
T6 r234use_current(T234* C);
T0* r234to_runnable_character(T234* C,T0* a1);
T6 r234includes_integer(T234* C,T2 a1);
void r234error(T0* a1,T0* a2);
T0* r234start_position(T234* C);
void r127compile_to_c_old(T127* C);
T0* r127runnable_expression(T0* a1,T0* a2);
void r127run_feature_has_result(T127* C);
void r127run_feature_match(T127* C,T0* a1);
T0* r127add_comment(T127* C,T0* a1);
void r127with(T127* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r127mapping_c_target(T127* C,T0* a1);
void r127afd_check(T127* C);
void r127c_declare_for_old(T127* C);
void r127collect_c_tmp(T127* C);
T0* r127operator(void);
T6 r127use_current(T127* C);
T0* r127runnable_args(T0* a1,T0* a2);
T0* r127to_runnable(T127* C,T0* a1);
T2 r127to_integer(T127* C);
T6 r127is_static(T127* C);
void r127finalize(T127* C);
void r127error(T0* a1,T0* a2);
T0* r127result_type(T127* C);
T0* r127arg1(T127* C);
T0* r127run_feature_for(T127* C,T0* a1,T0* a2);
T0* r127static_result_base_class(T127* C);
void r127make(T127* C,T0* a1,T0* a2,T0* a3);
void r127fatal_error(T0* a1);
void r127assertion_check(T127* C,T3 a1);
void r127compile_to_c(T127* C);
void r127mapping_c_arg(T127* C,T0* a1);
void r127c2c_cast_op(T127* C,T0* a1,T0* a2);
void r125compile_to_c_old(T125* C);
T0* r125runnable_expression(T0* a1,T0* a2);
void r125run_feature_has_result(T125* C);
void r125run_feature_match(T125* C,T0* a1);
T0* r125add_comment(T125* C,T0* a1);
void r125with(T125* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r125mapping_c_target(T125* C,T0* a1);
void r125afd_check(T125* C);
void r125c_declare_for_old(T125* C);
void r125collect_c_tmp(T125* C);
T0* r125operator(void);
T6 r125use_current(T125* C);
T0* r125runnable_args(T0* a1,T0* a2);
T0* r125to_runnable(T125* C,T0* a1);
T2 r125to_integer(T125* C);
T6 r125is_static(T125* C);
void r125finalize(T125* C);
void r125error(T0* a1,T0* a2);
T0* r125result_type(T125* C);
T0* r125arg1(T125* C);
T0* r125run_feature_for(T125* C,T0* a1,T0* a2);
T0* r125static_result_base_class(T125* C);
void r125make(T125* C,T0* a1,T0* a2,T0* a3);
void r125fatal_error(T0* a1);
void r125assertion_check(T125* C,T3 a1);
void r125compile_to_c(T125* C);
void r125mapping_c_arg(T125* C,T0* a1);
void r125c2c_cast_op(T125* C,T0* a1,T0* a2);
T0* r241to_runnable_integer(T241* C,T0* a1);
void r241make(T241* C,T0* a1,T0* a2);
T0* r241to_runnable_character(T241* C,T0* a1);
T0* r241twin(T241* C);
void r241error(T0* a1,T0* a2);
T0* r241start_position(T241* C);
void r216make(T216* C,T0* a1,T0* a2,T0* a3);
void r216fatal_error(T0* a1);
void r216afd_check(T216* C);
void r216compile_to_c(T216* C);
T6 r216use_current(T216* C);
T0* r216to_runnable(T216* C,T0* a1);
void r216put(T216* C,T0* a1,T2 a2);
T2 r216count(T216* C);
T6 r216is_pre_computable(T216* C);
void r216from_compound(T216* C,T0* a1);
T0* r216start_position(T216* C);
T0* r216item(T216* C,T2 a1);
T0* r160add_comment(T160* C,T0* a1);
T0* r160to_runnable(T160* C,T0* a1);
T2 r160to_integer(T160* C);
void r160error(T0* a1,T0* a2);
extern int fBC12type_pointer;
extern T0*oBC12type_pointer;
T0* r160type_pointer(void);
T0* r160static_result_base_class(void);
void r160compile_to_c(T160* C);
T0* r160start_position(T160* C);
T2 r379static_value_mem(T379* C);
T2 r379id(T379* C);
T6 r379use_current(T379* C);
void r379fall_down(T379* C);
T6 r379is_static(T379* C);
T6 r379is_exported_in(T379* C,T0* a1);
T0* r379clients(T379* C);
void r379std_compute_use_current(T379* C);
void r379address_of_c_define(T379* C,T0* a1);
T6 r379is_deferred(T379* C);
void r379nothing_comment(T379* C);
T0* r379run_class(T379* C);
void r379make(T379* C,T0* a1,T0* a2,T0* a3);
void r379fatal_error(T0* a1);
void r379c_assertion_flag(T379* C);
void r379initialize(T379* C);
void r379mapping_c(T379* C);
void r379c_frame_descriptor_name_in(T379* C,T0* a1);
T0* r379start_position(T379* C);
void r47disconnect(T47* C);
void r47read_line_in(T47* C,T0* a1);
T6 r47same_as(T47* C,T0* a1);
T6 r47end_of_input(T47* C);
extern T0*oBC48last_string;
void r47read_character(T47* C);
void r47read_line(T47* C);
void r47read_word(T47* C);
void r47connect_to(T47* C,T0* a1);
void r47skip_separators(T47* C);
void r310make(T310* C,T0* a1,T0* a2);
void r310append_in(T310* C,T0* a1);
T2 r310count(T310* C);
T0* r59add_comment(T59* C,T0* a1);
T0* r59to_runnable(T59* C,T0* a1);
T2 r59to_integer(T59* C);
void r59c_define(T59* C);
void r59error(T0* a1,T0* a2);
T0* r59static_result_base_class(void);
void r59make(T59* C,T0* a1,T0* a2);
void r59compile_to_c(T59* C);
T0* r222add_comment(T222* C,T0* a1);
void r222compile_to_c(T222* C);
void r222afd_check(T222* C);
T6 r222use_current(T222* C);
void r222add_if_then(T222* C,T0* a1,T0* a2);
T0* r222to_runnable(T222* C,T0* a1);
T0* r222twin(T222* C);
T6 r50ensure_check(T50* C);
T6 r50debug_check(T50* C);
T6 r50no_check(T50* C);
T6 r50boost(T50* C);
T6 r50require_check(T50* C);
void r50compute_root_class(T50* C,T0* a1);
T6 r50loop_check(T50* C);
T6 r50invariant_check(T50* C);
T6 r50all_check(T50* C);
T0* r50root_procedure(T50* C);
T0* r280generic_list(T280* C);
T6 r280need_gc_mark_function(T280* C);
void r280to_expanded(T280* C);
T2 r280id(T280* C);
void r280warning(T0* a1,T0* a2);
void r280cast_to_ref(T280* C);
void r280c_header_pass1(T280* C);
void r280just_before_gc_mark_in(T280* C,T0* a1);
void r280c_header_pass3(T280* C);
void r280gc_call_new_in(T280* C,T0* a1);
T6 r280is_array(T280* C);
T0* r280base_class(T280* C);
T0* r280look_up_for(T280* C,T0* a1,T0* a2);
T6 r280has_creation(T280* C,T0* a1);
void r280error(T0* a1,T0* a2);
T6 r280need_c_struct(T280* C);
void r280mapping_cast(T280* C);
T6 r280is_a_in(T280* C,T0* a1,T0* a2);
T6 r280is_native_array(T280* C);
T6 r280is_boolean(T280* C);
T6 r280is_a(T280* C,T0* a1);
T6 r280is_generic(T280* C);
void r280make(T280* C,T0* a1,T2 a2);
void r280used_as_reference(T280* C);
T0* r280formal_generic_list(T280* C);
T6 r280is_reference(T280* C);
T6 r280is_real(T280* C);
T6 r280is_user_expanded(T280* C);
T6 r280is_integer(T280* C);
T6 r280is_any(T280* C);
void r280fatal_error_generic_list(T280* C);
T6 r280is_string(T280* C);
void r280c_initialize_in(T280* C,T0* a1);
T0* r280constraint(T280* C);
T0* r280smallest_ancestor(T280* C,T0* a1);
void r280c_header_pass2(T280* C);
void r280c_header_pass4(T280* C);
T6 r280is_double(T280* C);
void r280to_reference(T280* C);
T6 r280is_none(T280* C);
T0* r280to_runnable(T280* C,T0* a1);
T0* r280make_runnable(T280* C,T0* a1);
T0* r280twin(T280* C);
T6 r280is_pointer(T280* C);
T0* r280formal_arg(T280* C);
void r280gc_define1(T280* C);
void r280gc_mark_in(T280* C,T0* a1);
T0* r280static_base_class_name(T280* C);
void r280c_type_for_argument_in(T280* C,T0* a1);
void r280c_type_for_external_in(T280* C,T0* a1);
T0* r280run_time_mark(T280* C);
T2 r280space_for_variable(T280* C);
T0* r280run_class(T280* C);
T6 r280is_dummy_expanded(T280* C);
void r280fatal_error(T0* a1);
T6 r280is_expanded(T280* C);
void r280c_type_for_result_in(T280* C,T0* a1);
void r280c_type_for_target_in(T280* C,T0* a1);
T0* r280expanded_initializer(T280* C);
T6 r280is_basic_eiffel_expanded(T280* C);
void r280demangling_in(T280* C,T0* a1);
void r280c_initialize(T280* C);
T6 r280is_character(T280* C);
T0* r280base_class_name(T280* C);
void r280c_frame_descriptor(T280* C);
T6 r280is_bit(T280* C);
void r280gc_info_in(T280* C,T0* a1);
void r280gc_define2(T280* C);
void r250make(T250* C,T0* a1,T0* a2,T0* a3);
void r250fatal_error(T0* a1);
void r250warning(T0* a1,T0* a2);
void r250c2c_clear_expanded(T250* C,T2 a1);
void r250c2c_closing(T250* C,T0* a1);
T0* r250add_comment(T250* C,T0* a1);
void r250check_created_type(T250* C,T0* a1);
void r250compile_to_c(T250* C);
void r250check_creation_clause(T250* C,T0* a1);
void r250check_writable(T250* C,T0* a1);
T6 r250use_current(T250* C);
T0* r250to_runnable(T250* C,T0* a1);
void r250check_explicit_type(T250* C);
void r250c2c_opening(T250* C,T0* a1);
T6 r250is_pre_computable(T250* C);
void r250error(T0* a1,T0* a2);
void r316make(T316* C,T0* a1,T0* a2);
void r316make_all(T316* C,T0* a1);
T6 r316affect(T316* C,T0* a1);
void r107make(T107* C,T0* a1,T0* a2);
T0* r370runnable(T0* a1,T0* a2,T0* a3,T3 a4);
T0* r370require_end(T370* C,T0* a1,T0* a2);
void r370assertion_add_last(T370* C,T0* a1);
T0* r370ensure_end(T370* C,T0* a1,T0* a2);
void r370invariant_add_last(T370* C,T0* a1);
extern T0*oBC370collector;
void r370ensure_start(T370* C);
void r370require_start(T370* C);
T0* r370invariant_end(T370* C,T0* a1);
void r370error(T0* a1,T0* a2);
void r370invariant_start(T370* C);
T6 r66is_subclass_of(T66* C,T0* a1);
void r66make(T66* C,T0* a1,T0* a2);
T0* r66base_class(T66* C);
void r66make_unknown(T66* C);
T0* r270generic_list(T270* C);
void r270gc_call_new_in(T0* a1);
T0* r270base_class(T270* C);
T0* r270look_up_for(T270* C,T0* a1,T0* a2);
T6 r270has_creation(T270* C,T0* a1);
void r270error(T0* a1,T0* a2);
T6 r270is_a_in(T270* C,T0* a1,T0* a2);
T6 r270is_native_array(T270* C);
T6 r270is_a(T270* C,T0* a1);
void r270make(T270* C,T0* a1);
extern int fBC270used_as_reference;
void r270used_as_reference(void);
void r270fatal_error_generic_list(T270* C);
T0* r270smallest_ancestor(T270* C,T0* a1);
extern int fBC270check_type;
void r270check_type(T270* C);
void r270load_ref(T0* a1);
T0* r270to_runnable(T270* C,T0* a1);
extern int fBC12type_pointer_ref;
extern T0*oBC12type_pointer_ref;
T0* r270type_pointer_ref(void);
void r270gc_mark_in(T0* a1);
void r270c_type_for_external_in(T0* a1);
void r270c_type_for_argument_in(T0* a1);
T0* r270run_time_mark(void);
T0* r270run_class(T270* C);
void r270demangling_in(T0* a1);
T0* r270written_mark(void);
T2 r270space_for_pointer(void);
T0* r268generic_list(T268* C);
void r268gc_call_new_in(T0* a1);
T0* r268base_class(T268* C);
T0* r268look_up_for(T268* C,T0* a1,T0* a2);
T6 r268has_creation(T268* C,T0* a1);
void r268error(T0* a1,T0* a2);
T6 r268is_a_in(T268* C,T0* a1,T0* a2);
T6 r268is_native_array(T268* C);
T6 r268is_a(T268* C,T0* a1);
void r268make(T268* C,T0* a1);
extern int fBC268used_as_reference;
void r268used_as_reference(void);
void r268fatal_error_generic_list(T268* C);
T0* r268smallest_ancestor(T268* C,T0* a1);
extern int fBC268check_type;
void r268check_type(T268* C);
void r268load_ref(T0* a1);
T0* r268to_runnable(T268* C,T0* a1);
extern int fBC12type_integer_ref;
extern T0*oBC12type_integer_ref;
T0* r268type_integer_ref(void);
void r268gc_mark_in(T0* a1);
void r268c_type_for_external_in(T0* a1);
void r268c_type_for_argument_in(T0* a1);
T0* r268run_time_mark(void);
T0* r268run_class(T268* C);
void r268demangling_in(T0* a1);
T0* r268written_mark(void);
T2 r268space_for_integer(void);
void r46split_mode_c_compiler_command(T46* C,T0* a1,T0* a2);
void r46add_x_suffix(T46* C,T0* a1);
void r46environment_variable_substitution(T46* C,T0* a1,T0* a2);
void r46put_c_main_function_type(T46* C,T0* a1);
extern T0*oBC46compiler_list;
extern int fBC46object_suffix;
extern T0*oBC46object_suffix;
T0* r46object_suffix(T46* C);
void r46make(T46* C);
void r46bad_use_exit(T46* C,T0* a1);
void r46set_c_compiler(T46* C,T0* a1);
void r46loading_path_add(T46* C,T0* a1,T0* a2,T2 a3);
extern int fBC46make_suffix;
extern T0*oBC46make_suffix;
T0* r46make_suffix(T46* C);
extern int fBC46x_suffix;
extern T0*oBC46x_suffix;
T0* r46x_suffix(T46* C);
void r46show_compiler_list_then_exit(T46* C);
void r46no_split_mode_command(T46* C,T0* a1,T0* a2);
T2 r46extra_arg(T46* C,T0* a1,T2 a2,T0* a3);
extern int fBC46add_lib_math;
void r46add_lib_math(T46* C);
void r46add_objects(T46* C,T0* a1,T0* a2,T2 a3);
void r46put_c_main_function_exit(T46* C,T0* a1);
T6 r46backslash_separator(T46* C);
T0* r46get_environment_variable(T46* C,T0* a1);
T6 r46strip_executable(T46* C,T0* a1);
void r46put_mark_stack_and_registers(T46* C);
extern T0*oBC46system_list;
void r46add_output_name(T46* C,T0* a1);
T6 r46slash_separator(T46* C);
void r46sys_runtime(T46* C,T0* a1,T3 a2);
void r46append_lp_in(T46* C,T0* a1,T0* a2);
void r46list_add(T0* a1,T0* a2);
void r46add_directory(T46* C,T0* a1,T0* a2);
void r46parent_directory(T46* C,T0* a1);
T0* r46path_h(T46* C);
void r46split_mode_linker_command(T46* C,T0* a1,T0* a2,T2 a3);
void r46read_loading_path_in(T46* C,T0* a1);
T2 r356id(T356* C);
void r356afd_check(T356* C);
T6 r356use_current(T356* C);
void r356fall_down(T356* C);
T6 r356is_exported_in(T356* C,T0* a1);
T0* r356clients(T356* C);
void r356nothing_comment(T356* C);
T0* r356run_class(T356* C);
void r356make(T356* C,T0* a1,T0* a2,T0* a3);
void r356c_assertion_flag(T356* C);
void r356initialize(T356* C);
void r356mapping_c(T356* C);
void r356address_of_c_mapping(T356* C);
void r356c_frame_descriptor_name_in(T356* C,T0* a1);
void r121compile_to_c_old(T121* C);
T0* r121runnable_expression(T0* a1,T0* a2);
void r121run_feature_has_result(T121* C);
void r121run_feature_match(T121* C,T0* a1);
T0* r121add_comment(T121* C,T0* a1);
void r121with(T121* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r121mapping_c_target(T121* C,T0* a1);
void r121afd_check(T121* C);
void r121c_declare_for_old(T121* C);
void r121collect_c_tmp(T121* C);
T0* r121operator(void);
T6 r121use_current(T121* C);
T0* r121runnable_args(T0* a1,T0* a2);
T0* r121to_runnable(T121* C,T0* a1);
T2 r121to_integer(T121* C);
T6 r121is_static(T121* C);
void r121finalize(T121* C);
void r121error(T0* a1,T0* a2);
T0* r121result_type(T121* C);
T0* r121arg1(T121* C);
T0* r121run_feature_for(T121* C,T0* a1,T0* a2);
T0* r121static_result_base_class(T121* C);
void r121make(T121* C,T0* a1,T0* a2,T0* a3);
void r121fatal_error(T0* a1);
void r121assertion_check(T121* C,T3 a1);
void r121mapping_c_arg(T121* C,T0* a1);
void r275standard_c_object_model(T275* C);
T0* r275generic_list(T275* C);
T6 r275need_gc_mark_function(T275* C);
void r275standard_c_print_function(T275* C);
T2 r275id(T275* C);
void r275cast_to_ref(T275* C);
void r275c_header_pass3(T275* C);
void r275gc_call_new_in(T275* C,T0* a1);
void r275standard_c_struct(T275* C);
T0* r275base_class(T275* C);
T0* r275look_up_for(T275* C,T0* a1,T0* a2);
T6 r275has_creation(T275* C,T0* a1);
T6 r275need_c_struct(T275* C);
void r275mapping_cast(T275* C);
T0* r275compute_mark(T0* a1);
T6 r275is_a_in(T275* C,T0* a1,T0* a2);
void r275standard_c_typedef(T275* C);
T6 r275is_native_array(T275* C);
T6 r275is_boolean(T275* C);
T6 r275is_a(T275* C,T0* a1);
extern T0*oBC275tmp_written_mark;
T6 r275is_generic(T275* C);
void r275make(T275* C,T0* a1,T0* a2);
void r275used_as_reference(T275* C);
T6 r275is_real(T275* C);
T6 r275is_user_expanded(T275* C);
T6 r275is_integer(T275* C);
void r275standard_gc_define2_for_expanded(T275* C);
void r275from_other(T275* C,T0* a1,T0* a2);
void r275c_initialize_in(T275* C,T0* a1);
T0* r275smallest_ancestor(T275* C,T0* a1);
T0* r275string_aliaser(void);
T6 r275is_double(T275* C);
void r275to_reference(T275* C);
T0* r275to_runnable(T275* C,T0* a1);
T6 r275is_pointer(T275* C);
void r275gc_mark_in(T275* C,T0* a1);
void r275c_type_for_argument_in(T275* C,T0* a1);
void r275c_type_for_external_in(T275* C,T0* a1);
T0* r275run_class(T275* C);
T6 r275is_dummy_expanded(T275* C);
void r275fatal_error(T0* a1);
T2 r275standard_space_for_object(T275* C);
void r275c_type_for_result_in(T275* C,T0* a1);
void r275c_type_for_target_in(T275* C,T0* a1);
T0* r275expanded_initializer(T275* C);
T6 r275is_basic_eiffel_expanded(T275* C);
void r275demangling_in(T275* C,T0* a1);
void r275c_initialize(T275* C);
T6 r275is_character(T275* C);
T0* r275base_class_name(T275* C);
void r275c_frame_descriptor(T275* C);
void r275c_initialize_expanded(T275* C);
T6 r275is_bit(T275* C);
T2 r275space_for_integer(void);
T6 r291is_merge_with(T291* C,T0* a1,T0* a2);
T6 r291is_merge_with2aux(T291* C,T0* a1,T0* a2);
T0* r291try_to_undefine_aux(T291* C,T0* a1,T0* a2);
T0* r291try_to_undefine(T291* C,T0* a1,T0* a2);
void r291check_obsolete(T291* C,T0* a1);
T6 r291use_current(T291* C);
T6 r291is_merge_with1(T291* C,T0* a1);
T6 r291is_merge_with2(T291* C,T0* a1,T0* a2);
T0* r291to_run_feature(T291* C,T0* a1,T0* a2);
void r291error(T0* a1,T0* a2);
T0* r291external_c_name(T291* C);
void r291set_header_comment(T291* C,T0* a1);
void r291set_rescue_compound(T291* C,T0* a1);
void r291make_routine(T291* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r291make(T291* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r291make_external_routine(T291* C,T0* a1,T0* a2);
void r291add_into(T291* C,T0* a1);
T6 r291can_hide(T291* C,T0* a1,T0* a2);
T6 r291stupid_switch(T291* C,T0* a1,T0* a2);
void r291merge_header_comments(T291* C,T0* a1);
void r291mapping_c_name_in(T291* C,T0* a1);
T0* r291start_position(T291* C);
void r123compile_to_c_old(T123* C);
T0* r123runnable_expression(T0* a1,T0* a2);
void r123run_feature_has_result(T123* C);
void r123run_feature_match(T123* C,T0* a1);
T0* r123add_comment(T123* C,T0* a1);
void r123with(T123* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r123mapping_c_target(T123* C,T0* a1);
void r123afd_check(T123* C);
void r123c_declare_for_old(T123* C);
void r123collect_c_tmp(T123* C);
T0* r123operator(void);
T6 r123use_current(T123* C);
T0* r123runnable_args(T0* a1,T0* a2);
T0* r123to_runnable(T123* C,T0* a1);
T2 r123to_integer(T123* C);
T6 r123is_static(T123* C);
void r123finalize(T123* C);
void r123error(T0* a1,T0* a2);
T0* r123result_type(T123* C);
T0* r123arg1(T123* C);
T0* r123run_feature_for(T123* C,T0* a1,T0* a2);
T0* r123static_result_base_class(T123* C);
void r123make(T123* C,T0* a1,T0* a2,T0* a3);
void r123fatal_error(T0* a1);
void r123assertion_check(T123* C,T3 a1);
void r123mapping_c_arg(T123* C,T0* a1);
T0* r148add_comment(T148* C,T0* a1);
void r148with(T148* C,T0* a1,T0* a2);
void r148mapping_c_target(T148* C,T0* a1);
T0* r148to_runnable(T148* C,T0* a1);
T2 r148to_integer(T148* C);
void r148error(T0* a1,T0* a2);
T6 r148can_be_dropped(T148* C);
T0* r148run_feature(T148* C,T0* a1);
T0* r148static_result_base_class(T148* C);
void r148make(T148* C,T0* a1,T0* a2);
void r148fatal_error(T0* a1);
void r148undefine_in(T148* C,T0* a1);
T0* r148origin_base_class(T148* C);
T0* r148name_in(T148* C,T0* a1);
void r148compile_to_c(T148* C);
T0* r165runnable_expression(T0* a1,T0* a2);
T0* r165run_feature_for(T165* C,T0* a1,T0* a2);
void r165make(T165* C,T0* a1,T0* a2,T0* a3);
void r165fatal_error(T0* a1);
void r165run_feature_has_no_result(T165* C);
void r165run_feature_match(T165* C,T0* a1);
T0* r165add_comment(T165* C,T0* a1);
void r165with(T165* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r165compile_to_c(T165* C);
T2 r165arg_count(T165* C);
void r165afd_check(T165* C);
void r165collect_c_tmp(T165* C);
T6 r165use_current(T165* C);
T0* r165runnable_args(T0* a1,T0* a2);
T0* r165to_runnable(T165* C,T0* a1);
T0* r165make_runnable(T165* C,T0* a1,T0* a2,T0* a3);
void r165finalize(T165* C);
T0* r165start_position(T165* C);
void r315declaration_in(T315* C,T0* a1);
void r315undefine_in(T315* C,T0* a1);
T0* r315origin_base_class(T315* C);
T0* r315name_in(T315* C,T0* a1);
T0* r315to_key(T315* C);
void r315put_cpp_tag(T315* C);
T0* r315to_string(T315* C);
void r315error(T0* a1,T0* a2);
void r315mapping_c_in(T315* C,T0* a1);
T0* r315start_position(T315* C);
void r252warning(T0* a1,T0* a2);
void r252c2c_clear_expanded(T252* C,T2 a1);
void r252c2c_closing(T252* C,T0* a1);
T0* r252add_comment(T252* C,T0* a1);
void r252check_created_type(T252* C,T0* a1);
void r252afd_check(T252* C);
void r252check_writable(T252* C,T0* a1);
T6 r252use_current(T252* C);
T0* r252to_runnable(T252* C,T0* a1);
void r252error(T0* a1,T0* a2);
void r252c2c_expanded_initializer(T252* C,T0* a1);
T0* r252run_args(T252* C);
void r252make(T252* C,T0* a1,T0* a2,T0* a3);
void r252fatal_error(T0* a1);
void r252compile_to_c(T252* C);
T2 r252arg_count(T252* C);
void r252check_creation_clause(T252* C,T0* a1);
void r252c2c_opening(T252* C,T0* a1);
T6 r252is_pre_computable(T252* C);
void r252cp_not_found(T252* C,T0* a1);
void r324default_mapping_procedure(T324* C);
extern T0*oBC324tmp_string;
T2 r324id(T324* C);
void r324address_of_c_mapping_wrapper(T324* C);
void r324fall_down(T324* C);
void r324compute_use_current(T324* C);
void r324c_define(T324* C);
T6 r324need_local_vars(T324* C);
T0* r324clients(T324* C);
void r324put_c_name_tag(T324* C);
void r324std_compute_use_current(T324* C);
void r324address_of_c_define(T324* C,T0* a1);
T0* r324run_ensure(T324* C);
T0* r324is_attribute_writer(T324* C);
void r324nothing_comment(T324* C);
T6 r324empty_or_null_body(T324* C);
void r324address_of_wrapper_name_in(T324* C,T0* a1);
void r324make(T324* C,T0* a1,T0* a2,T0* a3);
T6 r324dca(T324* C);
void r324default_mapping_function(T324* C);
void r324c_assertion_flag(T324* C);
void r324c_define_opening(T324* C);
void r324c_define_closing(T324* C);
T0* r324memory_dispose(T324* C);
void r324initialize(T324* C);
void r324address_of_c_define_wrapper(T324* C,T0* a1);
void r324in_line(T324* C);
void r324mapping_c(T324* C);
void r324routine_afd_check(T324* C);
T0* r324body_one_dpca(T324* C);
T6 r324one_pc(T324* C);
T6 r324do_not_use_current(T324* C);
T0* r324run_require(T324* C);
void r324mapping_name(T324* C);
void r324c_initialize_ds_one_by_one(T324* C);
T6 r324isa_in_line(T324* C);
T6 r324use_current(T324* C);
T6 r324is_empty_or_null_body(T324* C);
T6 r324is_exported_in(T324* C,T0* a1);
T0* r324run_class(T324* C);
T6 r324attribute_writer(T324* C);
T6 r324direct_call(T324* C);
void r324define_prototype(T324* C);
void r324c_frame_descriptor(T324* C);
void r324address_of_c_mapping(T324* C);
void r324once_result_in(T324* C,T0* a1);
T6 r324is_pre_computable(T324* C);
void r324c_frame_descriptor_name_in(T324* C,T0* a1);
void r89make(T89* C,T0* a1,T0* a2);
void r89fatal_error(T0* a1);
T6 r314is_merge_with(T314* C,T0* a1,T0* a2);
T6 r314is_merge_with2aux(T314* C,T0* a1,T0* a2);
T0* r314try_to_undefine_aux(T314* C,T0* a1,T0* a2);
T0* r314try_to_undefine(T314* C,T0* a1,T0* a2);
void r314check_obsolete(T314* C,T0* a1);
T6 r314is_merge_with1(T314* C,T0* a1);
T6 r314is_merge_with2(T314* C,T0* a1,T0* a2);
T0* r314to_run_feature(T314* C,T0* a1,T0* a2);
void r314error(T0* a1,T0* a2);
void r314make(T314* C,T0* a1,T0* a2);
void r314add_into(T314* C,T0* a1);
T6 r314can_hide(T314* C,T0* a1,T0* a2);
T6 r314stupid_switch(T0* a1,T0* a2);
void r314merge_header_comments(T314* C,T0* a1);
T0* r314start_position(T314* C);
T6 r290is_merge_with(T290* C,T0* a1,T0* a2);
T6 r290is_merge_with2aux(T290* C,T0* a1,T0* a2);
T0* r290try_to_undefine_aux(T290* C,T0* a1,T0* a2);
T0* r290try_to_undefine(T290* C,T0* a1,T0* a2);
void r290check_obsolete(T290* C,T0* a1);
T6 r290use_current(T290* C);
T6 r290is_merge_with1(T290* C,T0* a1);
T6 r290is_merge_with2(T290* C,T0* a1,T0* a2);
T0* r290to_run_feature(T290* C,T0* a1,T0* a2);
void r290error(T0* a1,T0* a2);
T0* r290external_c_name(T290* C);
void r290set_header_comment(T290* C,T0* a1);
void r290set_rescue_compound(T290* C,T0* a1);
void r290make_routine(T290* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r290make(T290* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r290make_external_routine(T290* C,T0* a1,T0* a2);
void r290add_into(T290* C,T0* a1);
T6 r290can_hide(T290* C,T0* a1,T0* a2);
T6 r290stupid_switch(T290* C,T0* a1,T0* a2);
void r290merge_header_comments(T290* C,T0* a1);
void r290mapping_c_name_in(T290* C,T0* a1);
T0* r290start_position(T290* C);
T0* r157add_comment(T157* C,T0* a1);
T2 r157to_integer(T157* C);
void r157error(T0* a1,T0* a2);
extern int fBC157result_type;
extern T0*oBC157result_type;
T0* r157result_type(void);
extern T0*oBC388tmp_string;
T2 r388id(T388* C);
void r388address_of_c_mapping_wrapper(T388* C);
void r388collect_c_tmp(T388* C);
void r388fall_down(T388* C);
T0* r388body_one_result_dca(T388* C);
void r388compute_use_current(T388* C);
void r388c_define(T388* C);
T0* r388clients(T388* C);
void r388put_c_name_tag(T388* C);
T6 r388can_be_dropped(T388* C);
void r388std_compute_use_current(T388* C);
T6 r388a_eq_neq(T388* C);
void r388address_of_c_define(T388* C,T0* a1);
T0* r388run_ensure(T388* C);
void r388nothing_comment(T388* C);
T6 r388empty_or_null_body(T388* C);
T0* r388is_attribute_reader(T388* C);
T0* r388is_direct_call_on_attribute(T388* C);
void r388default_mapping_function(T388* C);
void r388address_of_wrapper_name_in(T388* C,T0* a1);
T6 r388dca(T388* C);
void r388make(T388* C,T0* a1,T0* a2,T0* a3);
void r388c_assertion_flag(T388* C);
void r388c_define_opening(T388* C);
void r388c_define_closing(T388* C);
void r388initialize(T388* C);
void r388in_line(T388* C);
void r388mapping_c(T388* C);
void r388address_of_c_define_wrapper(T388* C,T0* a1);
void r388routine_afd_check(T388* C);
T6 r388dc_pco1(T388* C);
T0* r388body_one_result(T388* C);
T0* r388body_one_dc_pco(T388* C);
T6 r388direct_cse_call(T388* C);
T0* r388run_require(T388* C);
T6 r388dc_pco2(T388* C);
void r388mapping_name(T388* C);
void r388c_initialize_ds_one_by_one(T388* C);
T6 r388isa_in_line(T388* C);
T6 r388use_current(T388* C);
T6 r388value_reader(T388* C);
T6 r388is_empty_or_null_body(T388* C);
T6 r388is_static(T388* C);
T6 r388is_exported_in(T388* C,T0* a1);
T0* r388run_class(T388* C);
void r388fatal_error(T0* a1);
T6 r388attribute_reader(T388* C);
T6 r388result_is_current(T388* C);
T6 r388direct_call(T388* C);
void r388define_prototype(T388* C);
void r388c_frame_descriptor(T388* C);
void r388address_of_c_mapping(T388* C);
void r388once_result_in(T388* C,T0* a1);
void r388c_frame_descriptor_name_in(T388* C,T0* a1);
void r254warning(T0* a1,T0* a2);
void r254c2c_clear_expanded(T254* C,T2 a1);
void r254c2c_closing(T254* C,T0* a1);
T0* r254add_comment(T254* C,T0* a1);
void r254check_created_type(T254* C,T0* a1);
void r254afd_check(T254* C);
void r254check_writable(T254* C,T0* a1);
T6 r254use_current(T254* C);
T0* r254to_runnable(T254* C,T0* a1);
void r254check_explicit_type(T254* C);
void r254error(T0* a1,T0* a2);
void r254c2c_expanded_initializer(T254* C,T0* a1);
T0* r254run_args(T254* C);
void r254make(T254* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r254fatal_error(T0* a1);
void r254compile_to_c(T254* C);
T2 r254arg_count(T254* C);
void r254check_creation_clause(T254* C,T0* a1);
void r254c2c_opening(T254* C,T0* a1);
T6 r254is_pre_computable(T254* C);
void r254cp_not_found(T254* C,T0* a1);
void r177prepare_arguments(T177* C,T0* a1);
void r177make(T177* C,T0* a1,T0* a2,T0* a3);
void r177fatal_error(T0* a1);
T0* r177precursor_name(T0* a1,T0* a2);
T0* r177add_comment(T177* C,T0* a1);
T0* r177super_feature(T177* C,T0* a1);
void r177compile_to_c(T177* C);
void r177afd_check(T177* C);
void r177collect_c_tmp(T177* C);
T0* r177to_runnable(T177* C,T0* a1);
void r177error(T0* a1,T0* a2);
void r101make(T101* C,T0* a1,T0* a2);
T0* r101merge_with(T101* C,T0* a1);
void r101merge(T101* C,T0* a1,T0* a2,T0* a3);
T6 r101gives_permission_to_any(T101* C);
T6 r101gives_permission_to(T101* C,T0* a1);
T0* r101append(T101* C,T0* a1);
void r101vape_check(T101* C,T0* a1,T0* a2);
void r101gives_permission_error(T101* C,T6 a1,T0* a2);
T0* r168add_comment(T168* C,T0* a1);
void r168error(T0* a1,T0* a2);
T0* r168type_boolean(void);
T0* r168static_result_base_class(void);
void r168mapping_c_arg(T0* a1);
T2 r168isa_dca_inline_argument(void);
void r137compile_to_c_old(T137* C);
T6 r137call_is_static(T137* C);
T0* r137runnable_expression(T0* a1,T0* a2);
void r137run_feature_has_result(T137* C);
void r137run_feature_match(T137* C,T0* a1);
T0* r137add_comment(T137* C,T0* a1);
void r137with(T137* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r137mapping_c_target(T137* C,T0* a1);
void r137afd_check(T137* C);
void r137c_declare_for_old(T137* C);
void r137collect_c_tmp(T137* C);
T6 r137use_current(T137* C);
T0* r137runnable_args(T0* a1,T0* a2);
T0* r137to_runnable(T137* C,T0* a1);
T2 r137to_integer(T137* C);
void r137finalize(T137* C);
void r137error(T0* a1,T0* a2);
T0* r137result_type(T137* C);
T0* r137arg1(T137* C);
T0* r137run_feature_for(T137* C,T0* a1,T0* a2);
T0* r137static_result_base_class(T137* C);
void r137make(T137* C,T0* a1,T0* a2,T0* a3);
void r137fatal_error(T0* a1);
void r137assertion_check(T137* C,T3 a1);
void r137mapping_c_arg(T137* C,T0* a1);
T6 r303is_merge_with(T303* C,T0* a1,T0* a2);
T6 r303is_merge_with2aux(T303* C,T0* a1,T0* a2);
T0* r303try_to_undefine_aux(T303* C,T0* a1,T0* a2);
extern T0*oBC303collection_names;
T0* r303try_to_undefine(T303* C,T0* a1,T0* a2);
void r303check_obsolete(T303* C,T0* a1);
T6 r303is_merge_with1(T303* C,T0* a1);
T6 r303is_merge_with2(T303* C,T0* a1,T0* a2);
T0* r303to_run_feature(T303* C,T0* a1,T0* a2);
void r303error(T0* a1,T0* a2);
void r303set_header_comment(T303* C,T0* a1);
T6 r303stupid_switch_for_collection(T0* a1,T0* a2);
void r303make_routine(T303* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r303make(T303* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r303add_into(T303* C,T0* a1);
T6 r303can_hide(T303* C,T0* a1,T0* a2);
T6 r303stupid_switch(T0* a1,T0* a2);
void r303merge_header_comments(T303* C,T0* a1);
void r303make_effective_routine(T303* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r303mapping_c_name_in(T303* C,T0* a1);
T0* r303start_position(T303* C);
void r146compile_to_c_old(T146* C);
extern T0*oBC146tmp_string;
T0* r146add_comment(T146* C,T0* a1);
void r146afd_check(T146* C);
void r146c_declare_for_old(T146* C);
T6 r146use_current(T146* C);
T0* r146to_runnable(T146* C,T0* a1);
T2 r146to_integer(T146* C);
void r146error(T0* a1,T0* a2);
T0* r146local_c_name(T146* C);
T0* r146result_type(T146* C);
T0* r146static_result_base_class(T146* C);
void r146assertion_check(T146* C,T3 a1);
extern T0*oBC146vaol_check_memory;
T0* r146start_position(T146* C);
void r226print_else(T6 a1);
void r226make(T226* C,T0* a1,T0* a2);
T2 r226compile_to_c(T226* C,T6 a1);
void r226afd_check(T226* C);
void r226collect_c_tmp(T226* C);
T6 r226use_current(T226* C);
T0* r226to_runnable(T226* C,T0* a1);
void r226error(T0* a1,T0* a2);
T6 r205is_merge_with(T205* C,T0* a1,T0* a2);
T6 r205is_merge_with2aux(T205* C,T0* a1,T0* a2);
T0* r205try_to_undefine_aux(T205* C,T0* a1,T0* a2);
T0* r205try_to_undefine(T205* C,T0* a1,T0* a2);
void r205check_obsolete(T205* C,T0* a1);
T6 r205is_merge_with1(T205* C,T0* a1);
T6 r205is_merge_with2(T205* C,T0* a1,T0* a2);
T0* r205to_run_feature(T205* C,T0* a1,T0* a2);
void r205error(T0* a1,T0* a2);
void r205make(T205* C,T0* a1,T0* a2,T0* a3);
void r205add_into(T205* C,T0* a1);
T6 r205can_hide(T205* C,T0* a1,T0* a2);
T6 r205stupid_switch(T0* a1,T0* a2);
void r205merge_header_comments(T205* C,T0* a1);
T0* r205start_position(T205* C);
void r87fatal_error(T0* a1);
T0* r87name_in_child(T87* C,T0* a1);
T0* r87name_in_parent(T87* C,T0* a1);
void r87get_started(T87* C,T0* a1);
T0* r79first_parent_for(T79* C,T0* a1);
T0* r79going_up(T79* C,T0* a1,T0* a2,T0* a3);
void r79inherit_cycle_check(T79* C);
T6 r79has_redefine(T79* C,T0* a1);
T0* r79repeated_inheritance(T79* C,T0* a1,T0* a2,T0* a3);
T0* r79precursor_for(T79* C,T0* a1,T0* a2);
void r79make(T79* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r79fatal_error(T0* a1);
T0* r79smallest_ancestor(T79* C,T0* a1,T0* a2);
T6 r79has_parent(T79* C,T0* a1);
T6 r79is_a_vncg(T79* C,T0* a1,T0* a2);
void r79collect_assertion(T79* C,T0* a1);
void r79collect_invariant(T79* C,T0* a1);
T0* r79clients_for(T79* C,T0* a1);
T0* r79look_up_for(T79* C,T0* a1,T0* a2);
T0* r79e_feature(T79* C,T0* a1);
void r79get_started(T79* C);
T0* r79up_to_original(T79* C,T0* a1,T0* a2);
T0* r79next_parent_for(T79* C,T0* a1,T0* a2);
void r390default_mapping_procedure(T390* C);
T2 r390id(T390* C);
void r390address_of_c_mapping_wrapper(T390* C);
void r390fall_down(T390* C);
void r390c_define(T390* C);
T0* r390clients(T390* C);
void r390put_c_name_tag(T390* C);
void r390std_compute_use_current(T390* C);
void r390address_of_c_define(T390* C,T0* a1);
T0* r390run_ensure(T390* C);
void r390default_mapping_function(T390* C);
void r390address_of_wrapper_name_in(T390* C,T0* a1);
void r390make(T390* C,T0* a1,T0* a2,T0* a3);
void r390c_assertion_flag(T390* C);
void r390once_boolean(T390* C);
void r390c_define_opening(T390* C);
void r390once_flag_in(T390* C,T0* a1);
void r390c_define_closing(T390* C);
void r390initialize(T390* C);
void r390address_of_c_define_wrapper(T390* C,T0* a1);
void r390routine_afd_check(T390* C);
T0* r390run_require(T390* C);
void r390mapping_name(T390* C);
void r390c_initialize_ds_one_by_one(T390* C);
T6 r390use_current(T390* C);
T0* r390once_mark(T390* C);
T6 r390is_exported_in(T390* C,T0* a1);
T0* r390run_class(T390* C);
void r390once_flag(T390* C);
void r390define_prototype(T390* C);
void r390c_frame_descriptor(T390* C);
void r390address_of_c_mapping(T390* C);
void r390once_result_in(T390* C,T0* a1);
void r390c_frame_descriptor_name_in(T390* C,T0* a1);
void r153compile_to_c_old(T153* C);
T0* r153runnable_expression(T0* a1,T0* a2);
void r153run_feature_has_result(T153* C);
T2 r153static_value(T153* C);
void r153run_feature_match(T153* C,T0* a1);
T0* r153add_comment(T153* C,T0* a1);
void r153with(T153* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r153mapping_c_target(T153* C,T0* a1);
void r153afd_check(T153* C);
void r153c_declare_for_old(T153* C);
void r153collect_c_tmp(T153* C);
T6 r153use_current(T153* C);
T0* r153runnable_args(T0* a1,T0* a2);
T0* r153to_runnable(T153* C,T0* a1);
T2 r153to_integer(T153* C);
T6 r153is_static(T153* C);
void r153finalize(T153* C);
void r153error(T0* a1,T0* a2);
T0* r153result_type(T153* C);
T0* r153run_feature_for(T153* C,T0* a1,T0* a2);
T0* r153static_result_base_class(T153* C);
void r153make(T153* C,T0* a1,T0* a2,T0* a3);
void r153fatal_error(T0* a1);
void r153assertion_check(T153* C,T3 a1);
T2 r153arg_count(T153* C);
void r153mapping_c_arg(T153* C,T0* a1);
T0* r153start_position(T153* C);
void r102make(T102* C);
T2 r102max_id(T102* C);
void r102add2(T102* C,T0* a1,T2 a2);
T2 r102hash_code(T0* a1);
T2 r102item(T102* C,T0* a1);
void r139compile_to_c_old(T139* C);
T0* r139runnable_expression(T0* a1,T0* a2);
void r139run_feature_has_result(T139* C);
T2 r139static_value(T139* C);
void r139run_feature_match(T139* C);
T0* r139add_comment(T139* C,T0* a1);
void r139with(T139* C,T0* a1,T0* a2,T0* a3);
void r139mapping_c_target(T139* C,T0* a1);
void r139afd_check(T139* C);
void r139c_declare_for_old(T139* C);
void r139collect_c_tmp(T139* C);
T6 r139use_current(T139* C);
T0* r139to_runnable(T139* C,T0* a1);
T2 r139to_integer(T139* C);
T6 r139is_static(T139* C);
void r139finalize(T139* C);
void r139error(T0* a1,T0* a2);
T0* r139result_type(T139* C);
T6 r139can_be_dropped(T139* C);
T0* r139run_feature_for(T139* C,T0* a1,T0* a2);
T0* r139static_result_base_class(T139* C);
void r139make(T139* C,T0* a1,T0* a2);
void r139fatal_error(T0* a1);
void r139assertion_check(T139* C,T3 a1);
void r139mapping_c_arg(T139* C,T0* a1);
T6 r72is_equal(T72* C,T0* a1);
void r72make(T72* C,T2 a1,T2 a2);
void r72fatal_error(T0* a1);
void r72set_line_column(T72* C,T2 a1,T2 a2);
void r72with(T72* C,T2 a1,T2 a2,T0* a3);
T0* r72base_class(T72* C);
void r72show(T72* C);
T6 r72before(T72* C,T0* a1);
T0* r72path(T72* C);
T0* r72get_line(T72* C);
void r278make(T278* C,T0* a1,T0* a2);
void r278fatal_error(T0* a1);
void r278check_generic_formal_arguments(T278* C);
void r233add_when_item_2(T233* C,T0* a1);
void r233add_value(T233* C,T0* a1);
T0* r233to_runnable_integer(T233* C,T0* a1);
void r233make(T233* C,T0* a1,T0* a2);
void r233from_e_when(T233* C,T0* a1);
void r233compile_to_c(T233* C);
void r233afd_check(T233* C);
void r233err_occ(T233* C,T2 a1,T0* a2);
T6 r233use_current(T233* C);
T0* r233to_runnable_character(T233* C,T0* a1);
void r233add_when_item_1(T233* C,T0* a1);
void r233add_slice(T233* C,T0* a1,T0* a2);
T6 r233includes_integer(T233* C,T2 a1);
void r233error(T0* a1,T0* a2);
void r263gc_na_env_in(T263* C,T0* a1);
void r263standard_c_print_function(T263* C);
T2 r263id(T263* C);
void r263cast_to_ref(T263* C);
void r263just_before_gc_mark_in(T263* C,T0* a1);
void r263gc_call_new_in(T263* C,T0* a1);
T0* r263base_class(T263* C);
T0* r263look_up_for(T263* C,T0* a1,T0* a2);
void r263mapping_cast(T263* C);
T6 r263is_a_in(T263* C,T0* a1,T0* a2);
T6 r263is_native_array(T263* C);
T6 r263is_a(T263* C,T0* a1);
void r263make(T263* C,T0* a1,T0* a2);
void r263load_basic_features(T263* C);
T6 r263is_run_type(T263* C);
T0* r263type_any(void);
T0* r263smallest_ancestor(T263* C,T0* a1);
void r263c_header_pass2(T263* C);
T0* r263string_aliaser(void);
T0* r263to_runnable(T263* C,T0* a1);
void r263make_runnable(T263* C,T0* a1,T0* a2);
T0* r263twin(T263* C);
void r263gc_define1(T263* C);
void r263gc_mark_in(T263* C,T0* a1);
void r263gc_info_nb_in(T263* C,T0* a1);
void r263c_type_for_external_in(T263* C,T0* a1);
void r263c_type_for_argument_in(T263* C,T0* a1);
T0* r263run_time_mark(T263* C);
T0* r263run_class(T263* C);
void r263fatal_error(T0* a1);
void r263gc_mark(T263* C,T6 a1);
void r263demangling_in(T263* C,T0* a1);
void r263c_type_in(T263* C,T0* a1);
void r263c_frame_descriptor(T263* C);
void r263gc_info_in(T263* C,T0* a1);
void r263gc_define2(T263* C);
T2 r263space_for_pointer(void);
T0* r155add_comment(T155* C,T0* a1);
void r155mapping_c_target(T155* C,T0* a1);
T0* r155to_runnable(T155* C,T0* a1);
T2 r155to_integer(T155* C);
void r155error(T0* a1,T0* a2);
T0* r155static_result_base_class(void);
void r155mapping_c_arg(T155* C,T0* a1);
void r320add_last(T320* C,T0* a1);
T2 r54id(T54* C);
void r54address_of_c_mapping_wrapper(T54* C);
void r54fall_down(T54* C);
extern T0*oBC54frozen_general;
void r54c_define(T54* C);
T0* r54clients(T54* C);
void r54put_c_name_tag(T54* C);
void r54std_compute_use_current(T54* C);
void r54address_of_c_define(T54* C,T0* a1);
T0* r54run_ensure(T54* C);
void r54default_mapping_function(T54* C);
void r54address_of_wrapper_name_in(T54* C,T0* a1);
void r54make(T54* C,T0* a1,T0* a2,T0* a3);
void r54c_assertion_flag(T54* C);
void r54once_boolean(T54* C);
void r54c_define_opening(T54* C);
void r54once_flag_in(T54* C,T0* a1);
void r54c_define_closing(T54* C);
void r54initialize(T54* C);
void r54mapping_c(T54* C);
void r54address_of_c_define_wrapper(T54* C,T0* a1);
void r54routine_afd_check(T54* C);
T0* r54run_require(T54* C);
void r54mapping_name(T54* C);
void r54c_initialize_ds_one_by_one(T54* C);
T0* r54c_variable_name(T54* C);
void r54cpp_once_result(T54* C);
T6 r54use_current(T54* C);
T0* r54once_mark(T54* C);
T6 r54is_exported_in(T54* C,T0* a1);
void r54c_pre_computing(T54* C);
T0* r54run_class(T54* C);
void r54fatal_error(T0* a1);
void r54once_flag(T54* C);
void r54define_prototype(T54* C);
void r54once_variable(T54* C);
void r54c_frame_descriptor(T54* C);
void r54address_of_c_mapping(T54* C);
void r54fe_vffd7(T54* C);
void r54once_result_in(T54* C,T0* a1);
T6 r54is_pre_computable(T54* C);
void r54c_frame_descriptor_name_in(T54* C,T0* a1);
void r244make(T244* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6);
T0* r244add_comment(T244* C,T0* a1);
void r244compile_to_c(T244* C);
void r244afd_check(T244* C);
T6 r244use_current(T244* C);
T0* r244to_runnable(T244* C,T0* a1);
void r244error(T0* a1,T0* a2);
T0* r80going_down(T80* C,T0* a1,T0* a2);
T0* r80runnable_type(T80* C,T0* a1);
T0* r80do_rename(T80* C,T0* a1);
T0* r80precursor_for(T80* C,T0* a1,T0* a2);
T0* r80consider_export(T80* C,T0* a1);
T0* r80apply_undefine(T80* C,T0* a1,T0* a2);
T6 r80is_a_vncg(T80* C,T0* a1,T0* a2);
T0* r80base_class(T80* C);
T0* r80look_up_for(T80* C,T0* a1,T0* a2);
void r80get_started(T80* C,T0* a1);
extern T0*oBC80forbidden_parent_list;
T0* r80up_to_original(T80* C,T0* a1,T0* a2);
void r80missing_select(T0* a1,T0* a2);
T0* r80going_up(T80* C,T0* a1,T0* a2,T0* a3);
T6 r80has_redefine(T80* C,T0* a1);
T0* r80get_new_name(T80* C,T0* a1);
void r80make(T80* C,T0* a1);
T0* r80get_old_name(T80* C,T0* a1);
void r80fatal_error(T0* a1);
void r80multiple_check(T80* C,T0* a1);
T6 r80has_select_for(T80* C,T0* a1);
T0* r80name_in_parent(T80* C,T0* a1);
T0* r80has_undefine(T80* C,T0* a1);
T0* r80clients_for(T80* C,T0* a1);
T0* r80e_feature(T80* C,T0* a1);
void r80select_conflict(T0* a1,T0* a2);
void r80add_rename(T80* C,T0* a1);
T0* r80start_position(T80* C);
T6 r210is_merge_with(T210* C,T0* a1,T0* a2);
T6 r210is_merge_with2aux(T210* C,T0* a1,T0* a2);
T0* r210try_to_undefine_aux(T210* C,T0* a1,T0* a2);
T0* r210try_to_undefine(T210* C,T0* a1,T0* a2);
void r210check_obsolete(T210* C,T0* a1);
T6 r210is_merge_with1(T210* C,T0* a1);
T6 r210is_merge_with2(T210* C,T0* a1,T0* a2);
T0* r210to_run_feature(T210* C,T0* a1,T0* a2);
void r210error(T0* a1,T0* a2);
void r210make(T210* C,T0* a1,T0* a2,T0* a3);
void r210add_into(T210* C,T0* a1);
T6 r210can_hide(T210* C,T0* a1,T0* a2);
T6 r210stupid_switch(T0* a1,T0* a2);
void r210merge_header_comments(T210* C,T0* a1);
T0* r210start_position(T210* C);
void r175compile_to_c_old(T175* C);
T0* r175add_comment(T175* C,T0* a1);
void r175afd_check(T175* C);
void r175c_declare_for_old(T175* C);
void r175collect_c_tmp(T175* C);
T0* r175to_runnable(T175* C,T0* a1);
T2 r175to_integer(T175* C);
void r175error(T0* a1,T0* a2);
void r175prepare_arguments(T175* C,T0* a1);
T0* r175static_result_base_class(T175* C);
void r175make(T175* C,T0* a1,T0* a2,T0* a3);
void r175fatal_error(T0* a1);
T0* r175precursor_name(T0* a1,T0* a2);
T0* r175super_feature(T175* C,T0* a1);
void r175compile_to_c(T175* C);
void r318make(T318* C,T0* a1,T0* a2);
T0* r318clients_for(T318* C,T0* a1);
void r389default_mapping_procedure(T389* C);
T2 r389id(T389* C);
void r389external_prototype(T389* C,T0* a1);
void r389fall_down(T389* C);
void r389compute_use_current(T389* C);
void r389c_define(T389* C);
T0* r389clients(T389* C);
void r389put_c_name_tag(T389* C);
void r389std_compute_use_current(T389* C);
T0* r389run_ensure(T389* C);
void r389default_mapping_function(T389* C);
void r389make(T389* C,T0* a1,T0* a2,T0* a3);
T2 r389arg_count(T389* C);
void r389c_define_opening(T389* C);
void r389c_define_closing(T389* C);
void r389c_assertion_flag(T389* C);
void r389initialize(T389* C);
void r389c_define_with_body(T389* C,T0* a1);
void r389mapping_c(T389* C);
void r389routine_afd_check(T389* C);
T0* r389run_require(T389* C);
void r389mapping_name(T389* C);
void r389c_initialize_ds_one_by_one(T389* C);
T6 r389use_current(T389* C);
T6 r389is_exported_in(T389* C,T0* a1);
T0* r389run_class(T389* C);
void r389define_prototype(T389* C);
void r389c_frame_descriptor(T389* C);
void r389once_result_in(T389* C,T0* a1);
void r389c_frame_descriptor_name_in(T389* C,T0* a1);
void r274gc_free_in(T274* C,T0* a1);
void r274standard_gc_info_in(T274* C,T0* a1);
T6 r274need_gc_mark_function(T274* C);
void r274standard_c_print_function(T274* C);
T6 r274is_written_runnable(T274* C);
void r274just_before_gc_mark_in(T274* C,T0* a1);
void r274c_header_pass3(T274* C);
void r274gc_call_new_in(T274* C,T0* a1);
void r274gc_store_chunk_in(T274* C,T0* a1);
T6 r274need_c_struct(T274* C);
void r274mapping_cast(T274* C);
void r274gc_align_mark_in(T274* C,T0* a1);
T6 r274is_a(T274* C,T0* a1);
void r274make(T274* C,T0* a1,T0* a2);
T0* r274run_type(T274* C);
T6 r274is_reference(T274* C);
void r274c_initialize_in(T274* C,T0* a1);
T0* r274string_aliaser(void);
void r274c_header_pass4(T274* C);
void r274to_reference(T274* C);
void r274standard_gc_define1(T274* C);
T0* r274twin(T274* C);
void r274standard_just_before_gc_mark_in(T274* C,T0* a1);
T0* r274run_class(T274* C);
T6 r274is_dummy_expanded(T274* C);
void r274fatal_error(T0* a1);
T6 r274is_expanded(T274* C);
void r274c_type_for_target_in(T274* C,T0* a1);
void r274c_type_for_result_in(T274* C,T0* a1);
T0* r274expanded_initializer(T274* C);
void r274c_initialize_expanded(T274* C);
T2 r274space_for_integer(void);
T2 r274space_for_pointer(void);
void r274standard_c_object_model(T274* C);
T2 r274id(T274* C);
void r274cast_to_ref(T274* C);
extern T0*oBC274tmp_mark;
void r274standard_c_struct(T274* C);
T0* r274base_class(T274* C);
T0* r274look_up_for(T274* C,T0* a1,T0* a2);
void r274basic_checks(T274* C);
T6 r274has_creation(T274* C,T0* a1);
T6 r274is_a_in(T274* C,T0* a1,T0* a2);
void r274standard_c_typedef(T274* C);
T6 r274is_native_array(T274* C);
void r274gc_store_left_in(T274* C,T0* a1);
void r274used_as_reference(T274* C);
T6 r274is_user_expanded(T274* C);
T6 r274is_run_type(T274* C);
void r274standard_gc_define2_for_expanded(T274* C);
T0* r274type_any(void);
T0* r274smallest_ancestor(T274* C,T0* a1);
void r274standard_gc_define2(T274* C);
T0* r274to_runnable(T274* C,T0* a1);
void r274make_runnable(T274* C,T0* a1,T0* a2);
void r274gc_define1(T274* C);
void r274gc_mark_in(T274* C,T0* a1);
void r274gc_info_nb_in(T274* C,T0* a1);
void r274c_type_for_argument_in(T274* C,T0* a1);
void r274c_type_for_external_in(T274* C,T0* a1);
T0* r274run_time_mark(T274* C);
T2 r274space_for_variable(T274* C);
void r274gc_store_in(T274* C,T0* a1);
T2 r274standard_space_for_object(T274* C);
void r274demangling_in(T274* C,T0* a1);
void r274c_initialize(T274* C);
void r274c_frame_descriptor(T274* C);
void r274gc_info_in(T274* C,T0* a1);
void r274gc_define2(T274* C);
T0* r255generic_list(T255* C);
T6 r255need_gc_mark_function(T255* C);
void r255to_expanded(T255* C);
T2 r255id(T255* C);
void r255cast_to_ref(T255* C);
void r255c_header_pass1(T255* C);
void r255just_before_gc_mark_in(T255* C,T0* a1);
void r255c_header_pass3(T255* C);
void r255gc_call_new_in(T255* C,T0* a1);
T6 r255is_array(T255* C);
T0* r255base_class(T255* C);
T0* r255look_up_for(T255* C,T0* a1,T0* a2);
T6 r255has_creation(T255* C,T0* a1);
T6 r255need_c_struct(T255* C);
void r255mapping_cast(T255* C);
T6 r255is_a_in(T255* C,T0* a1,T0* a2);
T6 r255is_native_array(T255* C);
T6 r255is_boolean(T255* C);
T6 r255is_a(T255* C,T0* a1);
T6 r255is_generic(T255* C);
void r255anchor_cycle_start(T255* C);
void r255make(T255* C,T0* a1,T0* a2);
void r255anchor_cycle_end(T255* C);
void r255used_as_reference(T255* C);
T6 r255is_reference(T255* C);
T6 r255is_real(T255* C);
T6 r255is_user_expanded(T255* C);
T6 r255is_integer(T255* C);
T6 r255is_any(T255* C);
void r255fatal_error_generic_list(T255* C);
T6 r255is_string(T255* C);
void r255c_initialize_in(T255* C,T0* a1);
T0* r255smallest_ancestor(T255* C,T0* a1);
void r255c_header_pass2(T255* C);
T0* r255string_aliaser(void);
void r255c_header_pass4(T255* C);
void r255with(T255* C,T0* a1,T0* a2);
T6 r255is_double(T255* C);
void r255to_reference(T255* C);
T6 r255is_none(T255* C);
T0* r255to_runnable(T255* C,T0* a1);
T6 r255is_pointer(T255* C);
void r255gc_define1(T255* C);
void r255gc_mark_in(T255* C,T0* a1);
T0* r255static_base_class_name(T255* C);
void r255c_type_for_argument_in(T255* C,T0* a1);
void r255c_type_for_external_in(T255* C,T0* a1);
T0* r255run_time_mark(T255* C);
T2 r255space_for_variable(T255* C);
T0* r255run_class(T255* C);
T6 r255is_dummy_expanded(T255* C);
void r255fatal_error(T0* a1);
T6 r255is_expanded(T255* C);
void r255c_type_for_result_in(T255* C,T0* a1);
void r255c_type_for_target_in(T255* C,T0* a1);
T0* r255expanded_initializer(T255* C);
T6 r255is_basic_eiffel_expanded(T255* C);
void r255demangling_in(T255* C,T0* a1);
void r255c_initialize(T255* C);
T6 r255is_character(T255* C);
T0* r255base_class_name(T255* C);
extern T0*oBC256visited;
void r255c_frame_descriptor(T255* C);
T6 r255is_bit(T255* C);
void r255gc_info_in(T255* C,T0* a1);
void r255gc_define2(T255* C);
void r194compile_to_c_old(T194* C);
T0* r194runnable_expression(T0* a1,T0* a2);
void r194run_feature_has_result(T194* C);
void r194run_feature_match(T194* C,T0* a1);
T0* r194add_comment(T194* C,T0* a1);
void r194with(T194* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r194mapping_c_target(T194* C,T0* a1);
void r194afd_check(T194* C);
void r194c_declare_for_old(T194* C);
void r194collect_c_tmp(T194* C);
T0* r194operator(void);
T6 r194use_current(T194* C);
T0* r194runnable_args(T0* a1,T0* a2);
T0* r194to_runnable(T194* C,T0* a1);
T2 r194to_integer(T194* C);
T6 r194is_static(T194* C);
void r194finalize(T194* C);
void r194error(T0* a1,T0* a2);
T0* r194result_type(T194* C);
T0* r194arg1(T194* C);
T0* r194run_feature_for(T194* C,T0* a1,T0* a2);
T0* r194static_result_base_class(T194* C);
void r194make(T194* C,T0* a1,T0* a2,T0* a3);
void r194fatal_error(T0* a1);
void r194assertion_check(T194* C,T3 a1);
void r194mapping_c_arg(T194* C,T0* a1);
T0* r378type_string(void);
T2 r378id(T378* C);
void r378external_prototype(T378* C,T0* a1);
void r378fall_down(T378* C);
void r378compute_use_current(T378* C);
void r378c_define(T378* C);
T0* r378clients(T378* C);
void r378put_c_name_tag(T378* C);
void r378std_compute_use_current(T378* C);
T0* r378run_ensure(T378* C);
void r378default_mapping_function(T378* C);
void r378make(T378* C,T0* a1,T0* a2,T0* a3);
T2 r378arg_count(T378* C);
void r378c_define_opening(T378* C);
void r378c_define_closing(T378* C);
void r378c_assertion_flag(T378* C);
void r378c_define_with_body(T378* C,T0* a1);
void r378initialize(T378* C);
void r378mapping_c(T378* C);
void r378routine_afd_check(T378* C);
T2 r378integer_value(T378* C,T0* a1);
T0* r378run_require(T378* C);
void r378mapping_name(T378* C);
void r378c_initialize_ds_one_by_one(T378* C);
T6 r378use_current(T378* C);
T6 r378is_static(T378* C);
T6 r378is_exported_in(T378* C,T0* a1);
void r378c_closing(T378* C);
T0* r378run_class(T378* C);
void r378fatal_error(T0* a1);
void r378c_opening(T378* C);
void r378define_prototype(T378* C);
void r378c_frame_descriptor(T378* C);
void r378once_result_in(T378* C,T0* a1);
void r378c_frame_descriptor_name_in(T378* C,T0* a1);
void r363initialize_runtime(T363* C);
void r363se_evobt(T363* C);
void r363incorrect_inspect_value(T363* C,T0* a1);
void r363get_started(T363* C);
void r76check_expanded_with(T76* C,T0* a1);
T0* r76root_procedure_name(T76* C,T0* a1);
void r76make(T76* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r76fatal_error(T0* a1);
T0* r76expanded_initializer(T76* C,T0* a1);
T6 r76has(T76* C,T0* a1);
T0* r190base_class_written(T190* C);
T0* r190add_comment(T190* C,T0* a1);
void r190mapping_c_target(T190* C,T0* a1);
T0* r190to_runnable(T190* C,T0* a1);
T2 r190to_integer(T190* C);
T0* r190twin(T190* C);
void r190error(T0* a1,T0* a2);
T0* r190static_result_base_class(T190* C);
void r190make(T190* C,T0* a1,T0* a2);
void r190name_clash_for(T190* C,T0* a1,T0* a2);
void r190compile_to_c(T190* C);
void r190mapping_c_arg(T190* C,T0* a1);
T0* r190written_in(T190* C);
T6 r219is_always_true(T219* C);
T0* r219check_assertion_mode(void);
void r219make(T219* C,T0* a1,T0* a2,T0* a3);
void r219compile_to_c(T219* C);
void r219afd_check(T219* C);
T6 r219use_current(T219* C);
T0* r219to_runnable(T219* C,T0* a1);
T0* r219twin(T219* C);
T6 r219is_pre_computable(T219* C);
void r368default_mapping_procedure(T368* C);
T2 r368id(T368* C);
void r368afd_check(T368* C);
void r368fall_down(T368* C);
void r368c_define(T368* C);
T0* r368clients(T368* C);
void r368put_c_name_tag(T368* C);
void r368address_of_c_define(T368* C,T0* a1);
T0* r368run_ensure(T368* C);
T6 r368is_deferred(T368* C);
void r368default_mapping_function(T368* C);
void r368make(T368* C,T0* a1,T0* a2,T0* a3);
void r368c_assertion_flag(T368* C);
void r368c_define_opening(T368* C);
void r368c_define_closing(T368* C);
void r368initialize(T368* C);
void r368mapping_c(T368* C);
void r368routine_afd_check(T368* C);
T0* r368start_position(T368* C);
T0* r368run_require(T368* C);
void r368mapping_name(T368* C);
void r368c_initialize_ds_one_by_one(T368* C);
T6 r368use_current(T368* C);
T6 r368is_exported_in(T368* C,T0* a1);
T0* r368run_class(T368* C);
void r368fatal_error(T0* a1);
void r368define_prototype(T368* C);
void r368c_frame_descriptor(T368* C);
void r368once_result_in(T368* C,T0* a1);
void r368c_frame_descriptor_name_in(T368* C,T0* a1);
void r225make(T225* C,T0* a1,T0* a2);
T0* r225add_comment(T225* C,T0* a1);
void r225compile_to_c(T225* C);
void r225afd_check(T225* C);
void r225collect_c_tmp(T225* C);
T6 r225use_current(T225* C);
T0* r225to_runnable(T225* C,T0* a1);
T6 r225is_pre_computable(T225* C);
void r225error(T0* a1,T0* a2);
T0* r225start_position(T225* C);
void r149compile_to_c_old(T149* C);
void r149afd_check(T149* C);
void r149c_declare_for_old(T149* C);
void r149collect_c_tmp(T149* C);
T6 r149use_current(T149* C);
T0* r149to_runnable(T149* C,T0* a1);
void r149dca_inline_ith(T149* C,T0* a1,T2 a2);
void r149compile_to_c_ith(T149* C,T0* a1,T2 a2);
T6 r149is_static(T149* C);
void r149put(T149* C,T0* a1,T2 a2);
T2 r149count(T149* C);
void r149error(T0* a1,T0* a2);
void r149dca_inline(T149* C,T0* a1);
T6 r149isa_dca_inline(T149* C,T0* a1,T0* a2);
T6 r149can_be_dropped(T149* C);
void r149match_with(T149* C,T0* a1,T0* a2);
void r149make_n(T149* C,T0* a1,T0* a2);
T0* r149run_class(T149* C);
T6 r149is_like_argument(T149* C,T0* a1,T0* a2,T0* a3);
void r149assertion_check(T149* C,T3 a1);
void r149compile_to_c(T149* C,T0* a1);
T0* r149expression(T149* C,T2 a1);
void r149from_model(T149* C,T0* a1);
extern T0*oBC149isa_dca_inline_memory;
T6 r149is_pre_computable(T149* C);
T0* r149start_position(T149* C);
void r144compile_to_c_old(T144* C);
T0* r144runnable_expression(T0* a1,T0* a2);
void r144run_feature_has_result(T144* C);
T2 r144static_value(T144* C);
void r144run_feature_match(T144* C);
void r144dca_inline_argument(T144* C,T0* a1);
T0* r144add_comment(T144* C,T0* a1);
void r144with(T144* C,T0* a1,T0* a2,T0* a3);
void r144mapping_c_target(T144* C,T0* a1);
void r144afd_check(T144* C);
void r144c_declare_for_old(T144* C);
void r144collect_c_tmp(T144* C);
T0* r144operator(void);
T6 r144use_current(T144* C);
T0* r144to_runnable(T144* C,T0* a1);
T2 r144to_integer(T144* C);
T6 r144is_static(T144* C);
void r144finalize(T144* C);
void r144error(T0* a1,T0* a2);
T0* r144result_type(T144* C);
T6 r144can_be_dropped(T144* C);
T0* r144run_feature_for(T144* C,T0* a1,T0* a2);
T0* r144static_result_base_class(T144* C);
void r144make(T144* C,T0* a1,T0* a2);
void r144fatal_error(T0* a1);
void r144assertion_check(T144* C,T3 a1);
void r144mapping_c_arg(T144* C,T0* a1);
T2 r144isa_dca_inline_argument(T144* C);
void r136compile_to_c_old(T136* C);
T0* r136runnable_expression(T0* a1,T0* a2);
void r136run_feature_has_result(T136* C);
void r136run_feature_match(T136* C,T0* a1);
T0* r136add_comment(T136* C,T0* a1);
void r136with(T136* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r136mapping_c_target(T136* C,T0* a1);
void r136afd_check(T136* C);
void r136c_declare_for_old(T136* C);
void r136collect_c_tmp(T136* C);
T0* r136operator(void);
T6 r136use_current(T136* C);
T0* r136runnable_args(T0* a1,T0* a2);
T0* r136to_runnable(T136* C,T0* a1);
T2 r136to_integer(T136* C);
T6 r136is_static(T136* C);
void r136finalize(T136* C);
void r136error(T0* a1,T0* a2);
T0* r136result_type(T136* C);
T0* r136arg1(T136* C);
T0* r136run_feature_for(T136* C,T0* a1,T0* a2);
T0* r136static_result_base_class(T136* C);
void r136make(T136* C,T0* a1,T0* a2,T0* a3);
void r136fatal_error(T0* a1);
void r136assertion_check(T136* C,T3 a1);
void r136mapping_c_arg(T136* C,T0* a1);
void r131compile_to_c_old(T131* C);
T0* r131runnable_expression(T0* a1,T0* a2);
void r131run_feature_has_result(T131* C);
void r131run_feature_match(T131* C,T0* a1);
void r131dca_inline_argument(T131* C,T0* a1);
T0* r131add_comment(T131* C,T0* a1);
void r131with(T131* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r131mapping_c_target(T131* C,T0* a1);
void r131afd_check(T131* C);
void r131c_declare_for_old(T131* C);
void r131collect_c_tmp(T131* C);
T0* r131operator(void);
T6 r131use_current(T131* C);
T0* r131runnable_args(T0* a1,T0* a2);
T0* r131to_runnable(T131* C,T0* a1);
T2 r131to_integer(T131* C);
T6 r131is_static(T131* C);
void r131finalize(T131* C);
void r131error(T0* a1,T0* a2);
T0* r131result_type(T131* C);
T0* r131arg1(T131* C);
T0* r131run_feature_for(T131* C,T0* a1,T0* a2);
T0* r131static_result_base_class(T131* C);
void r131make(T131* C,T0* a1,T0* a2,T0* a3);
void r131fatal_error(T0* a1);
void r131assertion_check(T131* C,T3 a1);
void r131mapping_c_arg(T131* C,T0* a1);
T2 r131isa_dca_inline_argument(T131* C);
T6 r206is_merge_with(T206* C,T0* a1,T0* a2);
T6 r206is_merge_with2aux(T206* C,T0* a1,T0* a2);
T0* r206try_to_undefine_aux(T206* C,T0* a1,T0* a2);
T0* r206try_to_undefine(T206* C,T0* a1,T0* a2);
void r206check_obsolete(T206* C,T0* a1);
T6 r206is_merge_with1(T206* C,T0* a1);
T6 r206is_merge_with2(T206* C,T0* a1,T0* a2);
T0* r206to_run_feature(T206* C,T0* a1,T0* a2);
void r206error(T0* a1,T0* a2);
void r206make(T206* C,T0* a1,T0* a2,T0* a3);
void r206add_into(T206* C,T0* a1);
T6 r206can_hide(T206* C,T0* a1,T0* a2);
T6 r206stupid_switch(T0* a1,T0* a2);
void r206merge_header_comments(T206* C,T0* a1);
T0* r206start_position(T206* C);
void r128compile_to_c_old(T128* C);
T2 r128static_value(T128* C);
T2 r128static_neq_void(T0* a1);
void r128afd_check(T128* C);
T6 r128is_manifest_array(T0* a1);
void r128c_declare_for_old(T128* C);
void r128collect_c_tmp(T128* C);
T0* r128operator(void);
void r128cmp_bit(T128* C,T6 a1,T0* a2);
void r128cmp_basic_eiffel_expanded(T128* C,T6 a1,T0* a2,T0* a3);
T0* r128runnable_args(T0* a1,T0* a2);
void r128bit_limitation(T128* C,T0* a1,T0* a2);
void r128error(T0* a1,T0* a2);
void r128dca_inline(T128* C,T0* a1);
void r128cmp_basic_ref(T128* C,T6 a1);
T0* r128type_boolean(void);
void r128make(T128* C,T0* a1,T0* a2,T0* a3);
void r128error_comparison(T128* C,T0* a1,T0* a2);
void r128mapping_c_arg(T128* C,T0* a1);
T0* r128runnable_expression(T0* a1,T0* a2);
void r128check_comparison(T128* C,T0* a1);
T0* r128add_comment(T128* C,T0* a1);
void r128mapping_c_target(T128* C,T0* a1);
void r128with(T128* C,T0* a1,T0* a2,T0* a3);
T6 r128use_current(T128* C);
T0* r128to_runnable(T128* C,T0* a1);
T2 r128to_integer(T128* C);
T6 r128is_static(T128* C);
T0* r128arg1(T128* C);
void r128cmp_user_expanded(T128* C,T6 a1,T0* a2);
T0* r128static_result_base_class(void);
void r128fatal_error(T0* a1);
void r128c2c_exp_ref(T0* a1,T0* a2,T0* a3,T0* a4);
void r128assertion_check(T128* C,T3 a1);
void r128compile_to_c(T128* C);
T6 r128is_static_neq_void(T0* a1);
void r372gc_free_in(T372* C,T0* a1);
T0* r372generic_list(T372* C);
void r372standard_gc_info_in(T372* C,T0* a1);
void r372cast_to_ref(T372* C);
void r372gc_call_new_in(T372* C,T0* a1);
T0* r372base_class(T372* C);
T0* r372look_up_for(T372* C,T0* a1,T0* a2);
void r372gc_store_chunk_in(T372* C,T0* a1);
void r372mapping_cast(T372* C);
void r372gc_align_mark_in(T372* C,T0* a1);
T6 r372is_a_in(T372* C,T0* a1,T0* a2);
void r372standard_c_typedef(T372* C);
T6 r372is_native_array(T372* C);
T6 r372is_a(T372* C,T0* a1);
T6 r372is_generic(T372* C);
void r372make(T372* C,T0* a1);
void r372gc_store_left_in(T372* C,T0* a1);
T0* r372smallest_ancestor(T0* a1);
T0* r372string_aliaser(void);
void r372standard_gc_define2(T372* C);
void r372c_header_pass4(T372* C);
void r372standard_gc_define1(T372* C);
void r372standard_just_before_gc_mark_in(T372* C,T0* a1);
void r372gc_mark_in(T372* C,T0* a1);
void r372gc_info_nb_in(T372* C,T0* a1);
T0* r372static_base_class_name(T372* C);
void r372c_type_for_external_in(T0* a1);
void r372gc_store_in(T372* C,T0* a1);
void r372fatal_error(T0* a1);
void r372c_type_for_target_in(T372* C,T0* a1);
void r372demangling_in(T372* C,T0* a1);
T0* r372base_class_name(T372* C);
void r372c_frame_descriptor(T372* C);
T2 r372space_for_pointer(void);
void r143compile_to_c_old(T143* C);
T0* r143runnable_expression(T0* a1,T0* a2);
void r143run_feature_has_result(T143* C);
T2 r143static_value(T143* C);
void r143run_feature_match(T143* C);
void r143dca_inline_argument(T143* C,T0* a1);
T0* r143add_comment(T143* C,T0* a1);
void r143with(T143* C,T0* a1,T0* a2,T0* a3);
void r143mapping_c_target(T143* C,T0* a1);
void r143afd_check(T143* C);
void r143c_declare_for_old(T143* C);
void r143collect_c_tmp(T143* C);
T0* r143operator(void);
T6 r143use_current(T143* C);
T0* r143to_runnable(T143* C,T0* a1);
T2 r143to_integer(T143* C);
T6 r143is_static(T143* C);
void r143finalize(T143* C);
void r143error(T0* a1,T0* a2);
T0* r143result_type(T143* C);
T6 r143can_be_dropped(T143* C);
T0* r143run_feature_for(T143* C,T0* a1,T0* a2);
T0* r143static_result_base_class(T143* C);
void r143make(T143* C,T0* a1,T0* a2);
void r143fatal_error(T0* a1);
void r143assertion_check(T143* C,T3 a1);
void r143compile_to_c(T143* C);
void r143mapping_c_arg(T143* C,T0* a1);
T2 r143isa_dca_inline_argument(T143* C);
void r375gc_free_in(T375* C,T0* a1);
T0* r375generic_list(T375* C);
void r375standard_gc_info_in(T375* C,T0* a1);
void r375standard_c_print_function(T375* C);
T2 r375id(T375* C);
void r375cast_to_ref(T375* C);
void r375gc_call_new_in(T375* C,T0* a1);
T0* r375base_class(T375* C);
T0* r375look_up_for(T375* C,T0* a1,T0* a2);
void r375gc_store_chunk_in(T375* C,T0* a1);
void r375mapping_cast(T375* C);
void r375gc_align_mark_in(T375* C,T0* a1);
T6 r375is_a_in(T375* C,T0* a1,T0* a2);
void r375standard_c_typedef(T375* C);
T6 r375is_native_array(T375* C);
T6 r375is_a(T375* C,T0* a1);
void r375make(T375* C,T0* a1);
void r375gc_store_left_in(T375* C,T0* a1);
void r375fatal_error_generic_list(T375* C);
T0* r375type_any(void);
T0* r375smallest_ancestor(T375* C,T0* a1);
void r375c_header_pass2(T375* C);
T0* r375string_aliaser(void);
void r375standard_gc_define2(T375* C);
void r375c_header_pass4(T375* C);
void r375standard_gc_define1(T375* C);
void r375standard_just_before_gc_mark_in(T375* C,T0* a1);
void r375gc_mark_in(T375* C,T0* a1);
void r375gc_info_nb_in(T375* C,T0* a1);
void r375c_type_for_external_in(T0* a1);
void r375gc_store_in(T375* C,T0* a1);
T0* r375run_class(T375* C);
void r375c_type_for_target_in(T375* C,T0* a1);
void r375demangling_in(T375* C,T0* a1);
extern int fBC375base_class_name;
extern T0*oBC375base_class_name;
T0* r375base_class_name(void);
void r375c_frame_descriptor(T375* C);
T2 r375space_for_pointer(void);
T0* r170add_comment(T170* C,T0* a1);
void r170error(T0* a1,T0* a2);
extern int fBC170result_type;
extern T0*oBC170result_type;
T0* r170result_type(void);
T0* r170static_result_base_class(void);
void r170make(T170* C,T0* a1,T3 a2,T2 a3);
void r170compile_to_c(T170* C);
void r170mapping_c_arg(T170* C,T0* a1);
T2 r170isa_dca_inline_argument(void);
void r188refer_to(T188* C,T0* a1,T0* a2,T2 a3);
T0* r188add_comment(T188* C,T0* a1);
void r188with(T188* C,T0* a1,T0* a2);
void r188mapping_c_target(T188* C,T0* a1);
T0* r188to_runnable(T188* C,T0* a1);
T2 r188to_integer(T188* C);
T0* r188to_string(T188* C);
void r188error(T0* a1,T0* a2);
T0* r188result_type(T188* C);
T0* r188static_result_base_class(T188* C);
void r188compile_to_c(T188* C);
void r188mapping_c_arg(T188* C,T0* a1);
T6 r302is_merge_with(T302* C,T0* a1,T0* a2);
T6 r302is_merge_with2aux(T302* C,T0* a1,T0* a2);
T0* r302try_to_undefine_aux(T302* C,T0* a1,T0* a2);
T0* r302try_to_undefine(T302* C,T0* a1,T0* a2);
void r302check_obsolete(T302* C,T0* a1);
T6 r302is_merge_with1(T302* C,T0* a1);
T6 r302is_merge_with2(T302* C,T0* a1,T0* a2);
void r302error(T0* a1,T0* a2);
T0* r302to_run_feature(T302* C,T0* a1,T0* a2);
void r302set_header_comment(T302* C,T0* a1);
T6 r302stupid_switch_for_collection(T0* a1,T0* a2);
void r302make_routine(T302* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r302make(T302* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r302add_into(T302* C,T0* a1);
T6 r302can_hide(T302* C,T0* a1,T0* a2);
T6 r302stupid_switch(T0* a1,T0* a2);
void r302merge_header_comments(T302* C,T0* a1);
void r302mapping_c_name_in(T302* C,T0* a1);
T0* r302start_position(T302* C);
T6 r213is_merge_with(T213* C,T0* a1,T0* a2);
T6 r213is_merge_with2aux(T213* C,T0* a1,T0* a2);
T0* r213try_to_undefine_aux(T213* C,T0* a1,T0* a2);
T0* r213try_to_undefine(T213* C,T0* a1,T0* a2);
void r213check_obsolete(T213* C,T0* a1);
T6 r213is_merge_with1(T213* C,T0* a1);
T6 r213is_merge_with2(T213* C,T0* a1,T0* a2);
T0* r213to_run_feature(T213* C,T0* a1,T0* a2);
void r213error(T0* a1,T0* a2);
void r213make(T213* C,T0* a1,T0* a2,T0* a3);
void r213add_into(T213* C,T0* a1);
T6 r213can_hide(T213* C,T0* a1,T0* a2);
T6 r213stupid_switch(T0* a1,T0* a2);
void r213merge_header_comments(T213* C,T0* a1);
T0* r213start_position(T213* C);
void r132compile_to_c_old(T132* C);
T0* r132runnable_expression(T0* a1,T0* a2);
void r132run_feature_has_result(T132* C);
void r132run_feature_match(T132* C,T0* a1);
void r132dca_inline_argument(T132* C,T0* a1);
T0* r132add_comment(T132* C,T0* a1);
void r132with(T132* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r132mapping_c_target(T132* C,T0* a1);
void r132afd_check(T132* C);
void r132c_declare_for_old(T132* C);
void r132collect_c_tmp(T132* C);
T0* r132operator(void);
T6 r132use_current(T132* C);
T0* r132runnable_args(T0* a1,T0* a2);
T0* r132to_runnable(T132* C,T0* a1);
T2 r132to_integer(T132* C);
T6 r132is_static(T132* C);
void r132finalize(T132* C);
void r132error(T0* a1,T0* a2);
T0* r132result_type(T132* C);
T0* r132arg1(T132* C);
T0* r132run_feature_for(T132* C,T0* a1,T0* a2);
T0* r132static_result_base_class(T132* C);
void r132make(T132* C,T0* a1,T0* a2,T0* a3);
void r132fatal_error(T0* a1);
void r132assertion_check(T132* C,T3 a1);
void r132mapping_c_arg(T132* C,T0* a1);
T2 r132isa_dca_inline_argument(T132* C);
void r382default_mapping_procedure(T382* C);
T2 r382id(T382* C);
void r382c_define(T382* C);
T0* r382clients(T382* C);
void r382put_c_name_tag(T382* C);
void r382std_compute_use_current(T382* C);
T0* r382run_ensure(T382* C);
T6 r382is_deferred(T382* C);
void r382make(T382* C,T0* a1,T0* a2,T0* a3);
void r382default_mapping_function(T382* C);
void r382c_assertion_flag(T382* C);
void r382c_define_opening(T382* C);
void r382c_define_closing(T382* C);
void r382initialize(T382* C);
void r382routine_afd_check(T382* C);
T0* r382start_position(T382* C);
T0* r382run_require(T382* C);
void r382mapping_name(T382* C);
void r382c_initialize_ds_one_by_one(T382* C);
T6 r382use_current(T382* C);
T6 r382is_exported_in(T382* C,T0* a1);
T0* r382run_class(T382* C);
void r382define_prototype(T382* C);
void r382c_frame_descriptor(T382* C);
void r382once_result_in(T382* C,T0* a1);
void r382c_frame_descriptor_name_in(T382* C,T0* a1);
T2 r227compile_to_c(T227* C);
void r227afd_check(T227* C);
void r227collect_c_tmp(T227* C);
T6 r227use_current(T227* C);
T0* r227to_runnable(T227* C,T0* a1);
T6 r65is_subclass_of(T65* C,T0* a1);
void r65check_expanded_with(T65* C,T0* a1);
void r65inherit_cycle_check(T65* C);
T0* r65root_procedure_name(T65* C,T0* a1);
T0* r65super_e_feature(T65* C,T0* a1);
void r65set_parent_list(T65* C,T0* a1,T0* a2,T0* a3);
extern int fBC12class_any;
extern T0*oBC12class_any;
T0* r65class_any(void);
void r65add_index_clause(T65* C,T0* a1);
void r65set_invariant(T65* C,T0* a1,T0* a2,T0* a3);
void r65warning(T0* a1,T0* a2);
void r65collect_assertion(T65* C,T0* a1);
void r65set_obsolete_type_string(T65* C,T0* a1);
T0* r65look_up_for(T65* C,T0* a1,T0* a2);
T6 r65has_creation(T65* C,T0* a1);
T0* r65up_to_original(T65* C,T0* a1,T0* a2);
void r65error(T0* a1,T0* a2);
void r65add_creation_clause(T65* C,T0* a1);
T6 r65proper_has(T65* C,T0* a1);
T6 r65has_redefine(T65* C,T0* a1);
T0* r65run_ensure(T65* C,T0* a1);
void r65make(T65* C);
void r65vdrd6(T0* a1,T0* a2,T0* a3);
T0* r65new_name_of_original(T65* C,T0* a1,T0* a2);
extern int fBC65mem_fn;
extern T0*oBC65mem_fn;
T0* r65mem_fn(void);
void r65check_generic_formal_arguments(T65* C);
void r65set_is_expanded(T65* C);
void r65set_is_deferred(T65* C);
void r65add_feature_clause(T65* C,T0* a1);
T0* r65new_name_of(T65* C,T0* a1,T0* a2);
T6 r65has(T65* C,T0* a1);
T0* r65root_procedure(T65* C,T0* a1);
T6 r65is_any(T65* C);
void r65fatal_undefine(T65* C,T0* a1);
T0* r65type_any(void);
T0* r65super_look_up_for(T65* C,T0* a1,T0* a2);
T0* r65smallest_ancestor(T65* C,T0* a1,T0* a2);
T0* r65run_require(T65* C,T0* a1);
T0* r65string_aliaser(void);
T6 r65is_a_vncg(T65* C,T0* a1,T0* a2);
void r65collect_invariant(T65* C,T0* a1);
T6 r65is_general(T65* C);
T6 r65has_simple_feature_name(T65* C,T0* a1);
void r65fatal_error_vdrd6(T0* a1,T0* a2,T0* a3);
void r65get_started(T65* C);
T0* r65going_up(T65* C,T0* a1,T0* a2,T0* a3);
T0* r65run_class(T65* C);
T0* r65run_feature_for(T65* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r65fatal_error(T0* a1);
T6 r65once_flag(T65* C,T0* a1);
T0* r65get_copy(T65* C);
T0* r65expanded_initializer(T65* C,T0* a1);
T6 r65is_subclass_of_aux(T65* C,T0* a1);
T0* r65clients_for(T65* C,T0* a1);
T0* r65e_feature(T65* C,T0* a1);
extern T0*oBC65going_up_trace;
extern T0*oBC65visited;
void r65mapping_c_in(T65* C,T0* a1);
T0* r65id_provider(void);
T0* r65class_with(T0* a1);
T6 r306is_merge_with(T306* C,T0* a1,T0* a2);
T6 r306is_merge_with2aux(T306* C,T0* a1,T0* a2);
T0* r306try_to_undefine_aux(T306* C,T0* a1,T0* a2);
T0* r306try_to_undefine(T306* C,T0* a1,T0* a2);
void r306check_obsolete(T306* C,T0* a1);
T6 r306is_merge_with1(T306* C,T0* a1);
T6 r306is_merge_with2(T306* C,T0* a1,T0* a2);
T0* r306to_run_feature(T306* C,T0* a1,T0* a2);
void r306error(T0* a1,T0* a2);
void r306set_header_comment(T306* C,T0* a1);
void r306make_routine(T306* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r306make(T306* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8);
void r306add_into(T306* C,T0* a1);
T6 r306can_hide(T306* C,T0* a1,T0* a2);
T6 r306stupid_switch(T306* C,T0* a1,T0* a2);
void r306merge_header_comments(T306* C,T0* a1);
void r306make_effective_routine(T306* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7);
void r306mapping_c_name_in(T306* C,T0* a1);
T0* r306start_position(T306* C);
void r260gc_free_in(T260* C,T0* a1);
void r260standard_c_object_model(T260* C);
void r260standard_gc_info_in(T260* C,T0* a1);
T0* r260generic_list(T260* C);
void r260standard_c_print_function(T260* C);
T2 r260id(T260* C);
void r260cast_to_ref(T260* C);
void r260gc_call_new_in(T260* C,T0* a1);
void r260standard_c_struct(T260* C);
T0* r260base_class(T260* C);
void r260gc_store_chunk_in(T260* C,T0* a1);
T0* r260look_up_for(T260* C,T0* a1,T0* a2);
T6 r260has_creation(T260* C,T0* a1);
void r260error(T0* a1,T0* a2);
T6 r260need_c_struct(T260* C);
void r260mapping_cast(T260* C);
void r260gc_align_mark_in(T260* C,T0* a1);
T6 r260is_a_in(T260* C,T0* a1,T0* a2);
void r260standard_c_typedef(T260* C);
T6 r260is_native_array(T260* C);
T6 r260is_a(T260* C,T0* a1);
void r260make(T260* C,T0* a1);
void r260gc_store_left_in(T260* C,T0* a1);
void r260fatal_error_generic_list(T260* C);
extern int fBC260check_type;
void r260check_type(T260* C);
void r260standard_gc_define2(T260* C);
void r260c_header_pass4(T260* C);
T0* r260to_runnable(T260* C,T0* a1);
void r260standard_gc_define1(T260* C);
void r260standard_just_before_gc_mark_in(T260* C,T0* a1);
void r260gc_mark_in(T260* C,T0* a1);
void r260gc_info_nb_in(T260* C,T0* a1);
void r260c_type_for_external_in(T0* a1);
T0* r260run_time_mark(void);
void r260gc_store_in(T260* C,T0* a1);
T0* r260run_class(T260* C);
void r260c_type_for_target_in(T260* C,T0* a1);
void r260demangling_in(T0* a1);
T0* r260written_mark(void);
void r260c_frame_descriptor(T260* C);
T2 r260space_for_pointer(void);
T0* r276generic_list(T276* C);
void r276standard_c_print_function(T276* C);
T2 r276id(T276* C);
extern T0*oBC57mem_type_bit_ref;
void r276c_header_pass1(T276* C);
void r276cast_to_ref(T276* C);
void r276gc_call_new_in(T276* C,T0* a1);
T0* r276base_class(T276* C);
T0* r276look_up_for(T276* C,T0* a1,T0* a2);
void r276mapping_cast(T276* C);
extern T0*oBC57mem_ref_nb;
T6 r276is_a_in(T276* C,T0* a1,T0* a2);
T6 r276is_native_array(T276* C);
T6 r276is_a(T276* C,T0* a1);
void r276make(T276* C,T0* a1,T0* a2);
T6 r276is_c_unsigned_ptr(T276* C);
void r276used_as_reference(T276* C);
void r276set_run_time_mark(T276* C);
void r276fatal_error_generic_list(T276* C);
T0* r276type_any(void);
void r276c_initialize_in(T276* C,T0* a1);
T0* r276smallest_ancestor(T276* C,T0* a1);
T2 r276unsigned_padding(T276* C);
T2 r276mapping_code(T276* C);
T0* r276string_aliaser(void);
void r276to_reference(T276* C);
T0* r276to_runnable(T276* C,T0* a1);
T2 r276nb_unsigned(T276* C);
void r276gc_mark_in(T276* C,T0* a1);
void r276c_type_for_external_in(T276* C,T0* a1);
void r276c_type_for_argument_in(T276* C,T0* a1);
T2 r276space_for_variable(T276* C);
T0* r276run_class(T276* C);
void r276to_runnable_1_2(T276* C);
void r276demangling_in(T276* C,T0* a1);
T6 r276is_c_int(T276* C);
void r276c_initialize(T276* C);
extern int fBC57base_class_name;
extern T0*oBC57base_class_name;
T0* r276base_class_name(void);
void r276c_frame_descriptor(T276* C);
T6 r276is_c_char(T276* C);
T0* r282left_type(T282* C);
void r282make(T282* C,T0* a1,T0* a2);
void r282fatal_error(T0* a1);
void r282warning(T0* a1,T0* a2);
void r282implicit_conversion(T282* C);
T0* r282add_comment(T282* C,T0* a1);
void r282compile_to_c(T282* C);
void r282afd_check(T282* C);
void r282collect_c_tmp(T282* C);
T6 r282use_current(T282* C);
void r282c_coding1(T282* C);
T0* r282to_runnable(T282* C,T0* a1);
T0* r282right_type(T282* C);
T6 r282is_pre_computable(T282* C);
void r282bit_into_bit(T282* C,T0* a1,T0* a2);
T0* r282start_position(T282* C);
T0* r169add_comment(T169* C,T0* a1);
void r169error(T0* a1,T0* a2);
T0* r169type_boolean(void);
T0* r169static_result_base_class(void);
void r169mapping_c_arg(T0* a1);
T2 r169isa_dca_inline_argument(void);
void r119compile_to_c_old(T119* C);
T0* r119runnable_expression(T0* a1,T0* a2);
void r119run_feature_has_result(T119* C);
void r119run_feature_match(T119* C,T0* a1);
T0* r119add_comment(T119* C,T0* a1);
void r119with(T119* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r119mapping_c_target(T119* C,T0* a1);
void r119afd_check(T119* C);
void r119c_declare_for_old(T119* C);
void r119collect_c_tmp(T119* C);
T0* r119operator(void);
T6 r119use_current(T119* C);
T0* r119runnable_args(T0* a1,T0* a2);
T0* r119to_runnable(T119* C,T0* a1);
T2 r119to_integer(T119* C);
T6 r119is_static(T119* C);
void r119finalize(T119* C);
void r119error(T0* a1,T0* a2);
T0* r119result_type(T119* C);
T0* r119arg1(T119* C);
T0* r119run_feature_for(T119* C,T0* a1,T0* a2);
T0* r119static_result_base_class(T119* C);
void r119make(T119* C,T0* a1,T0* a2,T0* a3);
void r119fatal_error(T0* a1);
void r119assertion_check(T119* C,T3 a1);
void r119mapping_c_arg(T119* C,T0* a1);
void r365compile_to_c_old(T365* C);
void r365afd_check(T365* C);
void r365c_declare_for_old(T365* C);
void r365collect_c_tmp(T365* C);
T6 r365use_current(T365* C);
void r365compile_to_c_ith(T365* C,T0* a1,T2 a2);
void r365dca_inline_ith(T365* C,T0* a1,T2 a2);
T0* r365to_runnable(T365* C,T0* a1);
T6 r365is_static(T365* C);
void r365put(T365* C,T0* a1,T2 a2);
T2 r365count(T365* C);
void r365error(T0* a1,T0* a2);
T6 r365isa_dca_inline(T365* C,T0* a1,T0* a2);
void r365dca_inline(T365* C,T0* a1);
T6 r365can_be_dropped(T365* C);
void r365run_feature(T365* C,T0* a1);
void r365match_with(T365* C,T0* a1,T0* a2);
void r365make_n(T365* C,T0* a1,T0* a2);
T0* r365run_class(T365* C);
T6 r365is_like_argument(T365* C,T0* a1,T0* a2,T0* a3);
void r365assertion_check(T365* C,T3 a1);
void r365compile_to_c(T365* C,T0* a1);
T0* r365expression(T365* C,T2 a1);
void r365from_model(T365* C,T0* a1);
T6 r365is_pre_computable(T365* C);
T0* r365start_position(T365* C);
void r85add_last(T85* C,T0* a1);
T0* r85root_procedure_name(T85* C,T0* a1);
void r85make_n(T85* C,T0* a1);
T0* r85feature_name(T85* C,T0* a1);
void r85fatal_error(T0* a1);
void r85fe_multiple(T0* a1,T0* a2);
T2 r85index_of(T85* C,T0* a1);
T2 r85count(T85* C);
T6 r85has(T85* C,T0* a1);
T0* r85item(T85* C,T2 a1);
void r220make(T220* C,T0* a1,T0* a2,T0* a3);
T0* r220add_comment(T220* C,T0* a1);
void r220compile_to_c(T220* C);
void r220afd_check(T220* C);
T6 r220use_current(T220* C);
T0* r220to_runnable(T220* C,T0* a1);
T0* r171type_string(void);
void r171add_ascii(T171* C,T3 a1);
T0* r171add_comment(T171* C,T0* a1);
T0* r171to_runnable(T171* C,T0* a1);
T2 r171to_integer(T171* C);
T0* r171twin(T171* C);
void r171error(T0* a1,T0* a2);
void r171break_line(T171* C);
T0* r171static_result_base_class(void);
void r171make(T171* C,T0* a1);
void r171compile_to_c(T171* C);
void r171add_percent(T171* C,T3 a1);
T0* r193add_comment(T193* C,T0* a1);
void r193mapping_c_target(T0* a1);
T0* r193to_runnable(T193* C,T0* a1);
T2 r193to_integer(T193* C);
void r193error(T0* a1,T0* a2);
void r193compile_to_c(T193* C);
void r193mapping_c_arg(T193* C,T0* a1);
void r113compile_to_c_old(T113* C);
T0* r113runnable_expression(T0* a1,T0* a2);
void r113run_feature_has_result(T113* C);
void r113run_feature_match(T113* C,T0* a1);
T0* r113add_comment(T113* C,T0* a1);
void r113with(T113* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5);
void r113mapping_c_target(T113* C,T0* a1);
void r113afd_check(T113* C);
void r113c_declare_for_old(T113* C);
void r113collect_c_tmp(T113* C);
T0* r113operator(void);
T6 r113use_current(T113* C);
T0* r113runnable_args(T0* a1,T0* a2);
T0* r113to_runnable(T113* C,T0* a1);
T2 r113to_integer(T113* C);
T6 r113is_static(T113* C);
void r113finalize(T113* C);
void r113error(T0* a1,T0* a2);
T0* r113result_type(T113* C);
T0* r113arg1(T113* C);
T0* r113run_feature_for(T113* C,T0* a1,T0* a2);
T0* r113static_result_base_class(T113* C);
void r113make(T113* C,T0* a1,T0* a2,T0* a3);
void r113fatal_error(T0* a1);
void r113assertion_check(T113* C,T3 a1);
void r113mapping_c_arg(T113* C,T0* a1);
void r195add_last(T195* C,T0* a1);
void r195warning(T0* a1,T0* a2);
void r195merge(T195* C,T0* a1,T0* a2);
T6 r195gives_permission_to_any(T195* C);
T2 r195index_of(T195* C,T0* a1);
T6 r195gives_permission_to(T195* C,T0* a1);
T2 r195count(T195* C);
T0* r195item(T195* C,T2 a1);
T6 r105is_always_true(T105* C);
T0* r105check_assertion_mode(void);
void r105make(T105* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC105c_code;
void r105add_into(T105* C,T0* a1);
void r105afd_check(T105* C);
void r105compile_to_c(T105* C);
void r105make_runnable(T105* C,T0* a1,T0* a2,T0* a3,T0* a4);
void r105c_define(T105* C);
T6 r286is_always_true(T286* C);
T0* r286check_assertion_mode(void);
void r286make(T286* C,T0* a1,T0* a2,T0* a3);
void r286add_into(T286* C,T0* a1);
void r286afd_check(T286* C);
void r286compile_to_c(T286* C);
T6 r286use_current(T286* C);
void r286make_runnable(T286* C,T0* a1,T0* a2,T0* a3,T0* a4);
T0* r277generic_list(T277* C);
void r277standard_c_print_function(T277* C);
T2 r277id(T277* C);
void r277cast_to_ref(T277* C);
void r277c_header_pass1(T277* C);
void r277gc_call_new_in(T277* C,T0* a1);
T0* r277base_class(T277* C);
T0* r277look_up_for(T277* C,T0* a1,T0* a2);
void r277mapping_cast(T277* C);
T6 r277is_a_in(T277* C,T0* a1,T0* a2);
T6 r277is_native_array(T277* C);
T6 r277is_a(T277* C,T0* a1);
void r277make(T277* C,T0* a1,T0* a2);
T6 r277is_c_unsigned_ptr(T277* C);
void r277used_as_reference(T277* C);
void r277set_run_time_mark(T277* C);
void r277fatal_error_generic_list(T277* C);
T0* r277type_any(void);
void r277c_initialize_in(T277* C,T0* a1);
T0* r277smallest_ancestor(T277* C,T0* a1);
T2 r277unsigned_padding(T277* C);
T2 r277mapping_code(T277* C);
T0* r277string_aliaser(void);
void r277to_reference(T277* C);
T0* r277to_runnable(T277* C,T0* a1);
T2 r277nb_unsigned(T277* C);
void r277gc_mark_in(T277* C,T0* a1);
void r277c_type_for_external_in(T277* C,T0* a1);
void r277c_type_for_argument_in(T277* C,T0* a1);
T2 r277space_for_variable(T277* C);
T0* r277run_class(T277* C);
void r277fatal_error(T0* a1);
void r277to_runnable_1_2(T277* C);
void r277demangling_in(T277* C,T0* a1);
T6 r277is_c_int(T277* C);
void r277c_initialize(T277* C);
T0* r277base_class_name(void);
void r277c_frame_descriptor(T277* C);
T6 r277is_c_char(T277* C);
void r246make(T246* C,T0* a1,T0* a2);
void r246afd_check(T246* C);
T6 r246use_current(T246* C);
T0* r246to_runnable(T246* C,T0* a1);
T0* r246twin(T246* C);
void r246error(T0* a1,T0* a2);
T0* r246start_position(T246* C);
T2 r384id(T384* C);
void r384collect_c_tmp(T384* C);
void r384c_define(T384* C);
T0* r384clients(T384* C);
void r384put_c_name_tag(T384* C);
void r384std_compute_use_current(T384* C);
T0* r384run_ensure(T384* C);
T6 r384is_deferred(T384* C);
void r384make(T384* C,T0* a1,T0* a2,T0* a3);
void r384default_mapping_function(T384* C);
void r384c_assertion_flag(T384* C);
void r384c_define_opening(T384* C);
void r384c_define_closing(T384* C);
void r384initialize(T384* C);
void r384mapping_c(T384* C);
void r384routine_afd_check(T384* C);
T0* r384start_position(T384* C);
T0* r384run_require(T384* C);
void r384mapping_name(T384* C);
void r384c_initialize_ds_one_by_one(T384* C);
T6 r384use_current(T384* C);
T6 r384is_exported_in(T384* C,T0* a1);
T0* r384run_class(T384* C);
void r384define_prototype(T384* C);
void r384c_frame_descriptor(T384* C);
void r384once_result_in(T384* C,T0* a1);
void r384c_frame_descriptor_name_in(T384* C,T0* a1);
T0* r21key_for_prefix_infix(T0* a1,T0* a2);
T0* r21item(T0* a1);
T0* r21for_prefix(T0* a1);
void r21add2(T0* a1);
T0* r21for_infix(T0* a1);
extern T0*oBC21memory;
void r142declaration_in(T142* C,T0* a1);
void r142make(T142* C,T0* a1,T0* a2);
void r142undefine_in(T142* C,T0* a1);
T0* r142string_aliaser(void);
T0* r142origin_base_class(T142* C);
T0* r142name_in(T142* C,T0* a1);
void r142error(T0* a1,T0* a2);
void r74load_file(T74* C,T0* a1);
extern T0*oBC74text;
T0* r74get_line(T2 a1);
T0* r74item(T2 a1);
T0* r173add_comment(T173* C,T0* a1);
T2 r173to_integer(T173* C);
void r173error(T0* a1,T0* a2);
extern int fBC173result_type;
extern T0*oBC173result_type;
T0* r173result_type(void);
T0* r173static_result_base_class(void);
void r173make(T173* C,T0* a1,T0* a2);
void r173mapping_c_arg(T173* C,T0* a1);
T2 r173isa_dca_inline_argument(void);
void r272standard_c_object_model(T272* C);
void r272gc_free_in(T0* a1);
void r272standard_gc_info_in(T0* a1);
T0* r272generic_list(T272* C);
T0* r272type_string(void);
void r272cast_to_ref(T272* C);
void r272gc_call_new_in(T0* a1);
void r272standard_c_struct(T272* C);
T0* r272base_class(T272* C);
void r272gc_store_chunk_in(T0* a1);
T0* r272look_up_for(T272* C,T0* a1,T0* a2);
T6 r272has_creation(T272* C,T0* a1);
void r272gc_align_mark_in(T0* a1);
T6 r272is_a_in(T272* C,T0* a1,T0* a2);
T6 r272is_native_array(T272* C);
T6 r272is_a(T272* C,T0* a1);
void r272make(T272* C,T0* a1);
void r272gc_store_left_in(T0* a1);
void r272fatal_error_generic_list(T272* C);
T0* r272smallest_ancestor(T272* C,T0* a1);
void r272standard_gc_define2(T272* C);
void r272c_header_pass4(T272* C);
extern int fBC272set_at_run_time;
void r272set_at_run_time(void);
void r272standard_gc_define1(T272* C);
void r272standard_just_before_gc_mark_in(T0* a1);
void r272gc_mark_in(T0* a1);
void r272gc_info_nb_in(T0* a1);
void r272c_type_for_external_in(T0* a1);
T0* r272run_time_mark(void);
void r272gc_store_in(T0* a1);
T0* r272run_class(T272* C);
void r272demangling_in(T0* a1);
T0* r272written_mark(void);
T2 r272space_for_pointer(void);
T0* r258generic_list(T258* C);
T6 r258need_gc_mark_function(T258* C);
void r258to_expanded(T258* C);
T2 r258id(T258* C);
void r258cast_to_ref(T258* C);
void r258c_header_pass1(T258* C);
void r258just_before_gc_mark_in(T258* C,T0* a1);
void r258c_header_pass3(T258* C);
void r258gc_call_new_in(T258* C,T0* a1);
T6 r258is_array(T258* C);
T0* r258base_class(T258* C);
T0* r258look_up_for(T258* C,T0* a1,T0* a2);
T6 r258has_creation(T258* C,T0* a1);
T6 r258need_c_struct(T258* C);
void r258mapping_cast(T258* C);
T6 r258is_a_in(T258* C,T0* a1,T0* a2);
T6 r258is_native_array(T258* C);
T6 r258is_boolean(T258* C);
T6 r258is_a(T258* C,T0* a1);
T6 r258is_generic(T258* C);
void r258anchor_cycle_start(T258* C);
void r258make(T258* C,T0* a1,T0* a2);
T0* r258run_type(T258* C);
void r258anchor_cycle_end(T258* C);
void r258used_as_reference(T258* C);
T6 r258is_reference(T258* C);
T6 r258is_real(T258* C);
T6 r258is_user_expanded(T258* C);
T6 r258is_run_type(T258* C);
T6 r258is_integer(T258* C);
T6 r258is_any(T258* C);
void r258fatal_error_generic_list(T258* C);
T6 r258is_string(T258* C);
void r258c_initialize_in(T258* C,T0* a1);
T0* r258smallest_ancestor(T258* C,T0* a1);
void r258c_header_pass2(T258* C);
T0* r258string_aliaser(void);
void r258c_header_pass4(T258* C);
void r258with(T258* C,T0* a1,T0* a2);
T6 r258is_double(T258* C);
void r258to_reference(T258* C);
T6 r258is_none(T258* C);
T0* r258to_runnable(T258* C,T0* a1);
T6 r258is_pointer(T258* C);
void r258gc_define1(T258* C);
void r258gc_mark_in(T258* C,T0* a1);
T0* r258static_base_class_name(T258* C);
void r258c_type_for_argument_in(T258* C,T0* a1);
void r258c_type_for_external_in(T258* C,T0* a1);
T0* r258run_time_mark(T258* C);
T2 r258space_for_variable(T258* C);
T0* r258run_class(T258* C);
T6 r258is_dummy_expanded(T258* C);
void r258fatal_error(T0* a1);
T6 r258is_expanded(T258* C);
void r258c_type_for_result_in(T258* C,T0* a1);
void r258c_type_for_target_in(T258* C,T0* a1);
T0* r258expanded_initializer(T258* C);
T6 r258is_basic_eiffel_expanded(T258* C);
void r258demangling_in(T258* C,T0* a1);
void r258c_initialize(T258* C);
T6 r258is_character(T258* C);
T0* r258base_class_name(T258* C);
void r258c_frame_descriptor(T258* C);
T6 r258is_bit(T258* C);
void r258gc_info_in(T258* C,T0* a1);
void r258gc_define2(T258* C);
void r215compile_to_c_old(T215* C);
T6 r215is_always_true(T215* C);
T0* r215check_assertion_mode(void);
void r215make(T215* C,T0* a1,T0* a2,T0* a3);
void r215add_into(T215* C,T0* a1);
void r215afd_check(T215* C);
void r215compile_to_c(T215* C);
void r215c_declare_for_old(T215* C);
T6 r215use_current(T215* C);
void r215make_runnable(T215* C,T0* a1,T0* a2,T0* a3,T0* a4);
T0* r198to_cst_att_character(T198* C,T0* a1);
void r198error(T0* a1,T0* a2);
T0* r198to_cst_att_real(T198* C,T0* a1);
T0* r198to_cst_att_unique(T198* C);
T0* r198to_cst_att_string(T198* C,T0* a1);
T0* r198to_procedure_or_function(T198* C);
T0* r198to_cst_att_bit(T198* C,T0* a1);
T0* r198n(void);
void r198to_cst_att_check_result_type(T198* C);
T0* r198to_cst_att_integer(T198* C,T0* a1);
T0* r198to_external_routine(T198* C,T0* a1,T0* a2);
void r198fatal_error(T0* a1);
void r198set_require(T198* C,T0* a1,T0* a2,T0* a3);
T0* r198to_deferred_routine(T198* C);
T0* r198to_writable_attribute(T198* C);
void r198add_synonym(T0* a1);
void r198set_require_else(T198* C,T0* a1,T0* a2,T0* a3);
void r198initialize(T198* C);
T0* r198to_once_routine(T198* C);
extern T0*oBC198names;
T0* r198to_cst_att_boolean(T198* C,T0* a1);
void r341c_define_for(T0* a1);
extern T0*oBC341manifest_array_types;
extern T0*oBC341header;
void r341c_call(T0* a1);
void r341register(T0* a1);
extern T0*oBC341body;
void r204increment(T204* C);
void r293c_define_procedure(T0* a1,T0* a2,T0* a3);
void r293c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r293c_define_function(T0* a1,T0* a2,T0* a3);
void r293c_mapping_function(T0* a1,T0* a2,T0* a3);
void r293wrapped_external_call(T0* a1,T2 a2);
void r293c_mapping_external(T0* a1,T2 a2);
void r347define_manifest_string_mark_header(T2 a1);
void r347define_se_ms(T6 a1);
T0* r347type_string(void);
extern T0*oBC347mangling_dictionary;
void r347used_for_c_inline(T0* a1);
void r347string_to_c_code(T0* a1,T0* a2);
void r347c_define2(T6 a1);
T0* r347register(T0* a1);
extern T0*oBC347body;
void r347c_define1(T6 a1);
void r347character_to_c_code(T3 a1,T0* a2);
void r300fe_c2c(T0* a1);
void r300fatal_error(T0* a1);
extern T0*oBC349registered;
void r349register_for(T0* a1);
extern T0*oBC349caller_memory;
void r344add_procedure(T0* a1);
extern T0*oBC344procedure_list;
void r344add_function(T0* a1);
extern T0*oBC344function_list;
void r344gc_mark_in(T0* a1);
void r292c_mapping_native_array_procedure(T0* a1,T0* a2);
void r292body_long_bit_put01(T0* a1,T3 a2,T3 a3,T3 a4);
void r292c_mapping_real_function(T0* a1,T0* a2);
void r292c_mapping_standard_twin(T0* a1,T0* a2);
void r292c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r292c_mapping_integer_function(T0* a1,T0* a2);
void r292c_mapping_double_function(T0* a1,T0* a2);
void r292c_define_function_bit(T0* a1,T0* a2);
void r292c_define_procedure(T0* a1,T0* a2,T0* a3);
void r292c_mapping_native_array_function(T0* a1,T0* a2);
void r292c_define_procedure_bit(T0* a1,T0* a2);
void r292c_define_function(T0* a1,T0* a2,T0* a3);
void r292c_mapping_function(T0* a1,T0* a2,T0* a3);
T0* r292system_tools(void);
T6 r292stupid_switch(T0* a1);
extern T0*oBC292tmp_string;
void r292c_define_standard_twin(T0* a1,T0* a2);
void r292c_define_twin(T0* a1,T0* a2,T0* a3,T0* a4);
void r292fe_long_bit(T0* a1);
void r292mapping_small_bit_put01(T0* a1,T3 a2,T3 a3,T2 a4);
T6 r292use_current(T0* a1);
void r292c_mapping_bit_procedure(T0* a1,T0* a2);
void r292c_mapping_bit_function(T0* a1,T0* a2);
void r298fe_c2c(T0* a1);
void r298fatal_error(T0* a1);
T6 r109is_current(void);
void r109reset(T109* C,T2 a1,T2 a2);
T0* r109to_tag_name(T109* C);
T0* r109to_argument_name2(T109* C,T0* a1,T2 a2);
T0* r109to_e_void(T109* C);
T0* r109to_local_name2(T109* C,T0* a1,T2 a2);
T0* r109to_simple_feature_name(T109* C);
T0* r109to_class_name(T109* C);
T6 r109isa_keyword(void);
T0* r109to_argument_name1(T109* C);
T0* r109start_position(T109* C);
T0* r109to_prefix_name(T109* C);
T0* r109string_aliaser(void);
T0* r109aliased_string(T109* C);
T0* r109to_infix_name(T109* C,T0* a1);
T0* r109pos(T2 a1,T2 a2);
T6 r109is_void(void);
T0* r109to_local_name1(T109* C);
T0* r109to_infix_name_use(T109* C);
T6 r109is_result(void);
void r331update_with(T0* a1);
void r331remove(T0* a1);
extern T0*oBC331dictionary;
void r331update(T0* a1,T0* a2);
T6 r10is_flag_no_warning(T0* a1);
void r10search_for_cc_flag(T2 a1);
T6 r10is_flag_debug_check(T0* a1);
T0* r10argument(T2 a1);
T6 r10is_flag_require_check(T10* C,T0* a1);
T0* r10string_aliaser(void);
T6 r10is_flag_verbose(T0* a1);
void r10check_for_level(T10* C,T0* a1);
T6 r10is_flag_no_check(T10* C,T0* a1);
T6 r10is_flag_o(T10* C,T0* a1,T2 a2,T2 a3,T0* a4);
T6 r10is_flag_trace(T0* a1);
T6 r10is_flag_all_check(T10* C,T0* a1);
T0* r10command_name(void);
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r10command_arguments(void);
T6 r10is_flag_ensure_check(T10* C,T0* a1);
T6 r10is_flag_cecil(T10* C,T0* a1,T2 a2,T2 a3);
T6 r10is_flag_no_style_warning(T0* a1);
T6 r10is_flag_case_insensitive(T0* a1);
void r10make(T10* C);
T6 r10is_flag_boost(T10* C,T0* a1);
T6 r10is_flag_invariant_check(T10* C,T0* a1);
void r10check_for_root_class(T10* C);
T0* r10system_tools(void);
T6 r10is_flag_loop_check(T10* C,T0* a1);
T6 r10is_flag_version(T10* C,T0* a1);
extern T0*oBC332running;
void r332put_arguments(T0* a1,T0* a2);
void r332put_ith_argument(T0* a1,T0* a2,T2 a3);
T0* r332name(T0* a1);
void r332sort_running(T0* a1);
extern T0*oBC332c_code;
void r332tail_opening(T0* a1,T0* a2);
void r332tail_closing(T0* a1,T0* a2);
void r332c_switch(T0* a1);
void r332c_define(int C,T0* a1);
void r332c_dicho(int C,T0* a1,T2 a2,T2 a3);
T0* r364type_any(void);
void r364c_define_for(T0* a1,T0* a2);
void r364c_define_for_list(T0* a1,T0* a2);
void r364fatal_error(T0* a1);
extern T0*oBC364tmp_string;
void r364c_define_users(T364* C);
void r364define_body_of(T0* a1);
void r364fill_up(T364* C);
void r297c_define_procedure(T0* a1,T0* a2,T0* a3);
void r297c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r297c_define_function(T0* a1,T0* a2,T0* a3);
void r297c_mapping_function(T0* a1,T0* a2,T0* a3);
void r297wrapped_external_call(T0* a1,T2 a2);
void r297c_mapping_external(T0* a1,T2 a2);
void r295c_define_procedure(T0* a1,T0* a2,T0* a3);
void r295c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r295c_define_function(T0* a1,T0* a2,T0* a3);
void r295c_mapping_function(T0* a1,T0* a2,T0* a3);
void r295wrapped_external_call(T0* a1,T2 a2);
void r295c_mapping_external(T0* a1,T2 a2);
extern T0*oBC51std_fr2;
T6 r51is_readable(T0* a1);
void r51rename_to(int C,T0* a1,T0* a2);
T6 r51file_exists(T0* a1);
extern T0*oBC51std_fr1;
T6 r51same_files(T0* a1,T0* a2);
void r51delete(int C,T0* a1);
void r296c_define_procedure(T0* a1,T0* a2,T0* a3);
void r296c_mapping_procedure(T0* a1,T0* a2,T0* a3);
void r296c_define_function(T0* a1,T0* a2,T0* a3);
void r296c_mapping_function(T0* a1,T0* a2,T0* a3);
void r296wrapped_external_call(T0* a1,T2 a2);
void r296c_mapping_external(T0* a1,T2 a2);
extern T10*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 393
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms332_176016;
extern T7*ms282_168036;
extern T7*ms282_173736;
extern T7*ms292_106656;
extern T7*ms284_124456;
extern T7*ms368_110836;
extern T7*ms176_268167;
extern T7*ms347_130677;
extern T7*ms105_112468;
extern T7*ms263_966348;
extern T7*ms58_1430624;
extern T7*ms183_106468;
extern T7*ms292_155838;
extern T7*ms175_366828;
extern T7*ms364_103068;
extern T7*ms288_129648;
extern T7*ms330_120379;
extern T7*ms198_147108;
extern T7*ms198_185909;
extern T7*ms379_106339;
extern T7*ms55_3073536;
extern T7*ms58_3073536;
extern T7*ms58_1591218;
extern T7*ms330_3171512;
extern T7*ms233_242a;
extern T7*ms292_820a;
extern T7*ms292_264a;
extern T7*ms292_824a;
extern T7*ms292_202a;
extern T7*ms292_170a;
extern T7*ms292_369a;
extern T7*ms13_1736a;
extern T7*ms13_7524a;
extern T7*ms13_1684a;
extern T7*ms13_2615a;
extern T7*ms14_1035a;
extern T7*ms14_2765a;
extern T7*ms14_2730a;
extern T7*ms42_3843a;
extern T7*ms42_5299a;
extern T7*ms42_1164a;
extern T7*ms34_1176a;
extern T7*ms34_9260a;
extern T7*ms34_9955a;
extern T7*ms46_1428a;
extern T7*ms46_6248a;
extern T7*ms46_0aaaa;
extern T7*ms58_248aa;
extern T7*ms58_9625a;
extern T7*ms288_3073536;
extern T7*ms263_8216a;
extern T7*ms292_170aa;
extern T7*ms292_1820a;
extern T7*ms292_1825a;
extern T7*ms292_824aa;
extern T7*ms40_17392a;
extern T7*ms40_20878a;
extern T7*ms14_22824a;
extern T7*ms14_12915a;
extern T7*ms42_12810a;
extern T7*ms34_78588a;
extern T7*ms34_82473a;
extern T7*ms34_28980a;
extern T7*ms34_13832a;
extern T7*ms34_44694a;
extern T7*ms34_37992a;
extern T7*ms72_56820a;
extern T7*ms55_11880a;
extern T7*ms55_14520a;
extern T7*ms46_6248aa;
extern T7*ms46_20265a;
extern T7*ms46_44388a;
extern T7*ms46_0aaaaa;
extern T7*ms39_23814a;
extern T7*ms39_23035a;
extern T7*ms58_9625aa;
extern T7*ms58_10944a;
extern T7*ms58_34060a;
extern T7*ms40_0;
extern T7*ms46_0;
extern T7*ms14_60;
extern T7*ms42_40;
extern T7*ms72_10;
extern T7*ms14_61;
extern T7*ms14_62;
extern T7*ms14_42;
extern T7*ms46_32;
extern T7*ms14_43;
extern T7*ms14_64;
extern T7*ms14_94;
extern T7*ms14_45;
extern T7*ms14_35;
extern T7*ms13_46;
extern T7*ms14_47;
extern T7*ms34_67;
extern T7*ms13_88;
extern T7*ms129_41;
extern T7*ms129_37536a;
extern T7*ms292_13897a;
extern T7*ms292_11187a;
extern T7*ms292_14894a;
extern T7*ms357_23664a;
extern T7*ms12_290;
extern T7*ms12_300;
extern T7*ms40_960;
extern T7*ms13_330;
extern T7*ms13_600;
extern T7*ms13_990;
extern T7*ms13_440;
extern T7*ms13_160;
extern T7*ms13_270;
extern T7*ms14_450;
extern T7*ms34_280;
extern T7*ms35_180;
extern T7*ms54_270;
extern T7*ms72_300;
extern T7*ms55_330;
extern T7*ms46_270;
extern T7*ms46_210;
extern T7*ms46_690;
extern T7*ms65_160;
extern T7*ms39_330;
extern T7*ms282_46;
extern T7*ms58_320;
extern T7*ms58_270;
extern T7*ms58_620;
extern T7*ms14_921;
extern T7*ms54_741;
extern T7*ms11_312;
extern T7*ms55_741;
extern T7*ms46_681;
extern T7*ms13_492;
extern T7*ms40_582;
extern T7*ms13_972;
extern T7*ms13_522;
extern T7*ms13_162;
extern T7*ms13_422;
extern T7*ms13_112;
extern T7*ms58_741;
extern T7*ms14_242;
extern T7*ms14_552;
extern T7*ms14_432;
extern T7*ms42_492;
extern T7*ms43_152;
extern T7*ms54_582;
extern T7*ms46_242;
extern T7*ms46_132;
extern T7*ms65_152;
extern T7*ms13_993;
extern T7*ms13_543;
extern T7*ms13_933;
extern T7*ms39_112;
extern T7*ms58_322;
extern T7*ms58_582;
extern T7*ms58_932;
extern T7*ms58_712;
extern T7*ms42_873;
extern T7*ms34_663;
extern T7*ms35_663;
extern T7*ms46_903;
extern T7*ms12_294;
extern T7*ms13_244;
extern T7*ms40_404;
extern T7*ms40_214;
extern T7*ms39_103;
extern T7*ms13_164;
extern T7*ms13_404;
extern T7*ms13_604;
extern T7*ms13_414;
extern T7*ms13_424;
extern T7*ms14_564;
extern T7*ms42_414;
extern T7*ms42_764;
extern T7*ms42_564;
extern T7*ms40_20878aa;
extern T7*ms72_144;
extern T7*ms46_314;
extern T7*ms46_414;
extern T7*ms46_534;
extern T7*ms46_564;
extern T7*ms13_375;
extern T7*ms66_684;
extern T7*ms34_28980aa;
extern T7*ms34_112140a;
extern T7*ms34_145656a;
extern T7*ms34_103845a;
extern T7*ms58_404;
extern T7*ms58_884;
extern T7*ms58_414;
extern T7*ms80_110836a;
extern T7*ms46_20265aa;
extern T7*ms46_44388aa;
extern T7*ms46_130240a;
extern T7*ms46_0aaaaaa;
extern T7*ms46_285;
extern T7*ms55_525;
extern T7*ms39_23035aa;
extern T7*ms13_166;
extern T7*ms40_576;
extern T7*ms13_266;
extern T7*ms13_336;
extern T7*ms58_585;
extern T7*ms58_10944aa;
extern T7*ms58_34060aa;
extern T7*ms58_783104a;
extern T7*ms41_366;
extern T7*ms14_696;
extern T7*ms14_246;
extern T7*ms14_216;
extern T7*ms42_486;
extern T7*ms54_716;
extern T7*ms46_306;
extern T7*ms46_286;
extern T7*ms46_786;
extern T7*ms46_576;
extern T7*ms46_396;
extern T7*ms46_636;
extern T7*ms39_116;
extern T7*ms39_406;
extern T7*ms39_486;
extern T7*ms13_957;
extern T7*ms39_336;
extern T7*ms58_936;
extern T7*ms34_657;
extern T7*ms13_108;
extern T7*ms40_248;
extern T7*ms13_188;
extern T7*ms13_178;
extern T7*ms13_138;
extern T7*ms14_368;
extern T7*ms14_188;
extern T7*ms42_218;
extern T7*ms43_728;
extern T7*ms72_208;
extern T7*ms46_948;
extern T7*ms11_729;
extern T7*ms55_308;
extern T7*ms46_528;
extern T7*ms46_918;
extern T7*ms46_428;
extern T7*ms46_738;
extern T7*ms39_308;
extern T7*ms13_939;
extern T7*ms58_248;
extern T7*ms14_669;
extern T7*ms55_759;
extern T7*ms105_450;
extern T7*ms330_110;
extern T7*ms128_700;
extern T7*ms263_620;
extern T7*ms390_780;
extern T7*ms129_170;
extern T7*ms292_820;
extern T7*ms292_170;
extern T7*ms292_960;
extern T7*ms292_280;
extern T7*ms106_741;
extern T7*ms263_101;
extern T7*ms263_741;
extern T7*ms292_741;
extern T7*ms292_411;
extern T7*ms106_522;
extern T7*ms106_712;
extern T7*ms233_242;
extern T7*ms233_522;
extern T7*ms332_522;
extern T7*ms332_892;
extern T7*ms332_162;
extern T7*ms263_552;
extern T7*ms292_522;
extern T7*ms292_582;
extern T7*ms292_372;
extern T7*ms292_202;
extern T7*ms356_972;
extern T7*ms243_993;
extern T7*ms272_543;
extern T7*ms330_824;
extern T7*ms233_244;
extern T7*ms216_174;
extern T7*ms147_214;
extern T7*ms372_944;
extern T7*ms292_804;
extern T7*ms292_264;
extern T7*ms292_824;
extern T7*ms283_444;
extern T7*ms21_1660;
extern T7*ms249_174;
extern T7*ms40_7140;
extern T7*ms40_1080;
extern T7*ms13_1320;
extern T7*ms13_1260;
extern T7*ms13_4320;
extern T7*ms330_965;
extern T7*ms40_6980;
extern T7*ms13_1020;
extern T7*ms13_2780;
extern T7*ms13_2810;
extern T7*ms13_7320;
extern T7*ms13_2830;
extern T7*ms13_2710;
extern T7*ms13_7260;
extern T7*ms13_8680;
extern T7*ms13_1700;
extern T7*ms13_2670;
extern T7*ms13_2550;
extern T7*ms13_2610;
extern T7*ms13_3720;
extern T7*ms286_984;
extern T7*ms41_2250;
extern T7*ms41_2610;
extern T7*ms14_1980;
extern T7*ms14_2600;
extern T7*ms14_2620;
extern T7*ms14_8750;
extern T7*ms14_2760;
extern T7*ms14_2440;
extern T7*ms14_7380;
extern T7*ms14_2730;
extern T7*ms14_7530;
extern T7*ms14_8820;
extern T7*ms14_1800;
extern T7*ms14_2780;
extern T7*ms42_1840;
extern T7*ms42_8010;
extern T7*ms42_2150;
extern T7*ms42_1750;
extern T7*ms42_1160;
extern T7*ms42_3450;
extern T7*ms42_8380;
extern T7*ms42_7970;
extern T7*ms34_6580;
extern T7*ms34_9260;
extern T7*ms34_7530;
extern T7*ms34_7510;
extern T7*ms35_8390;
extern T7*ms35_8610;
extern T7*ms54_3160;
extern T7*ms72_2120;
extern T7*ms55_8120;
extern T7*ms46_2150;
extern T7*ms46_2310;
extern T7*ms46_8280;
extern T7*ms46_2300;
extern T7*ms130_696;
extern T7*ms364_525;
extern T7*ms65_5320;
extern T7*ms65_1070;
extern T7*ms46_0a;
extern T7*ms57_7630;
extern T7*ms39_6110;
extern T7*ms39_2280;
extern T7*ms39_8130;
extern T7*ms39_6300;
extern T7*ms39_5160;
extern T7*ms231_716;
extern T7*ms58_6360;
extern T7*ms58_3810;
extern T7*ms58_2370;
extern T7*ms58_1230;
extern T7*ms58_1600;
extern T7*ms58_8540;
extern T7*ms330_276;
extern T7*ms13_9401;
extern T7*ms14_9801;
extern T7*ms14_1011;
extern T7*ms14_8211;
extern T7*ms14_9051;
extern T7*ms233_496;
extern T7*ms42_8411;
extern T7*ms42_8701;
extern T7*ms145_146;
extern T7*ms390_716;
extern T7*ms219_966;
extern T7*ms46_6281;
extern T7*ms292_286;
extern T7*ms292_166;
extern T7*ms11_6582;
extern T7*ms11_6462;
extern T7*ms356_156;
extern T7*ms356_606;
extern T7*ms356_546;
extern T7*ms248_156;
extern T7*ms12_1592;
extern T7*ms13_3122;
extern T7*ms40_1252;
extern T7*ms13_1792;
extern T7*ms13_6912;
extern T7*ms13_6822;
extern T7*ms13_9422;
extern T7*ms13_6852;
extern T7*ms13_5432;
extern T7*ms14_6702;
extern T7*ms14_1772;
extern T7*ms14_1672;
extern T7*ms14_6762;
extern T7*ms42_3512;
extern T7*ms34_5302;
extern T7*ms34_6402;
extern T7*ms54_5502;
extern T7*ms46_7392;
extern T7*ms46_6412;
extern T7*ms46_4542;
extern T7*ms46_6162;
extern T7*ms46_1472;
extern T7*ms46_1032;
extern T7*ms46_8092;
extern T7*ms11_7623;
extern T7*ms65_3102;
extern T7*ms40_6223;
extern T7*ms58_5802;
extern T7*ms13_8883;
extern T7*ms13_9023;
extern T7*ms13_7263;
extern T7*ms13_1053;
extern T7*ms14_6643;
extern T7*ms233_628;
extern T7*ms215_978;
extern T7*ms42_3843;
extern T7*ms332_258;
extern T7*ms263_248;
extern T7*ms372_248;
extern T7*ms292_628;
extern T7*ms11_2424;
extern T7*ms347_448;
extern T7*ms13_7014;
extern T7*ms375_248;
extern T7*ms105_999;
extern T7*ms13_6744;
extern T7*ms13_1664;
extern T7*ms13_8764;
extern T7*ms13_8184;
extern T7*ms13_1724;
extern T7*ms13_1684;
extern T7*ms13_1744;
extern T7*ms13_7524;
extern T7*ms14_9234;
extern T7*ms14_1644;
extern T7*ms14_1664;
extern T7*ms14_1724;
extern T7*ms14_1744;
extern T7*ms14_7314;
extern T7*ms42_1644;
extern T7*ms42_1164;
extern T7*ms42_6444;
extern T7*ms35_3084;
extern T7*ms54_2364;
extern T7*ms72_5784;
extern T7*ms55_7344;
extern T7*ms46_1444;
extern T7*ms46_4524;
extern T7*ms46_1044;
extern T7*ms292_339;
extern T7*ms292_549;
extern T7*ms292_459;
extern T7*ms292_369;
extern T7*ms65_4164;
extern T7*ms39_7464;
extern T7*ms13_1275;
extern T7*ms13_5895;
extern T7*ms13_5495;
extern T7*ms13_9485;
extern T7*ms13_2615;
extern T7*ms13_2595;
extern T7*ms41_2065;
extern T7*ms14_1915;
extern T7*ms14_6405;
extern T7*ms14_2765;
extern T7*ms14_2785;
extern T7*ms14_1035;
extern T7*ms14_2445;
extern T7*ms14_8505;
extern T7*ms14_9275;
extern T7*ms42_2755;
extern T7*ms42_2635;
extern T7*ms42_1635;
extern T7*ms42_1685;
extern T7*ms42_8295;
extern T7*ms34_2595;
extern T7*ms34_9955;
extern T7*ms46_9785;
extern T7*ms46_1715;
extern T7*ms46_1985;
extern T7*ms46_2325;
extern T7*ms46_2435;
extern T7*ms46_2395;
extern T7*ms11_7056;
extern T7*ms65_8175;
extern T7*ms39_8325;
extern T7*ms13_6996;
extern T7*ms40_6526;
extern T7*ms40_7116;
extern T7*ms58_1425;
extern T7*ms58_1725;
extern T7*ms58_9625;
extern T7*ms58_2785;
extern T7*ms58_2345;
extern T7*ms13_1656;
extern T7*ms40_6056;
extern T7*ms13_1736;
extern T7*ms13_2976;
extern T7*ms14_1216;
extern T7*ms14_6776;
extern T7*ms14_7576;
extern T7*ms14_4956;
extern T7*ms14_6846;
extern T7*ms14_1656;
extern T7*ms14_9436;
extern T7*ms14_7326;
extern T7*ms42_5936;
extern T7*ms42_4656;
extern T7*ms34_1176;
extern T7*ms34_7826;
extern T7*ms72_1116;
extern T7*ms55_7436;
extern T7*ms55_2226;
extern T7*ms46_5166;
extern T7*ms46_3636;
extern T7*ms46_6996;
extern T7*ms46_1076;
extern T7*ms46_9226;
extern T7*ms46_1316;
extern T7*ms46_1296;
extern T7*ms12_7497;
extern T7*ms13_8267;
extern T7*ms58_5346;
extern T7*ms13_5327;
extern T7*ms14_6307;
extern T7*ms14_8547;
extern T7*ms10_6348;
extern T7*ms39_4977;
extern T7*ms21_1688;
extern T7*ms12_3688;
extern T7*ms13_1248;
extern T7*ms40_1128;
extern T7*ms13_9878;
extern T7*ms58_6167;
extern T7*ms13_6448;
extern T7*ms13_6588;
extern T7*ms76_9977;
extern T7*ms13_7008;
extern T7*ms13_1768;
extern T7*ms13_6978;
extern T7*ms13_3038;
extern T7*ms41_8638;
extern T7*ms14_4728;
extern T7*ms14_5508;
extern T7*ms14_7928;
extern T7*ms14_1168;
extern T7*ms14_9408;
extern T7*ms14_1608;
extern T7*ms42_9808;
extern T7*ms42_5838;
extern T7*ms42_1188;
extern T7*ms42_8528;
extern T7*ms34_9888;
extern T7*ms35_4248;
extern T7*ms46_5868;
extern T7*ms55_1108;
extern T7*ms46_8478;
extern T7*ms46_6248;
extern T7*ms46_1428;
extern T7*ms39_1428;
extern T7*ms40_4109;
extern T7*ms13_7749;
extern T7*ms13_8799;
extern T7*ms42_5299;
extern T7*ms35_6929;
extern T7*ms65_4949;
extern T7*ms302_1180;
extern T7*ms303_1140;
extern T7*ms222_3240;
extern T7*ms232_2430;
extern T7*ms332_9760;
extern T7*ms332_8080;
extern T7*ms332_2220;
extern T7*ms332_4000;
extern T7*ms226_4830;
extern T7*ms263_1400;
extern T7*ms263_8130;
extern T7*ms129_9780;
extern T7*ms282_7560;
extern T7*ms282_5670;
extern T7*ms372_5490;
extern T7*ms292_1360;
extern T7*ms292_1830;
extern T7*ms292_1820;
extern T7*ms292_1810;
extern T7*ms292_5130;
extern T7*ms292_1850;
extern T7*ms292_2110;
extern T7*ms292_1290;
extern T7*ms292_5640;
extern T7*ms292_9190;
extern T7*ms292_7510;
extern T7*ms292_9020;
extern T7*ms292_9000;
extern T7*ms292_3730;
extern T7*ms292_6740;
extern T7*ms292_8360;
extern T7*ms292_9350;
extern T7*ms292_6800;
extern T7*ms292_2410;
extern T7*ms292_2420;
extern T7*ms292_6670;
extern T7*ms283_2220;
extern T7*ms347_6990;
extern T7*ms347_7020;
extern T7*ms375_5460;
extern T7*ms375_5430;
extern T7*ms375_1960;
extern T7*ms375_1020;
extern T7*ms330_8631;
extern T7*ms160_9711;
extern T7*ms200_1192;
extern T7*ms292_5691;
extern T7*ms292_3241;
extern T7*ms283_6651;
extern T7*ms303_1152;
extern T7*ms332_7792;
extern T7*ms332_4312;
extern T7*ms282_6712;
extern T7*ms292_5142;
extern T7*ms292_2982;
extern T7*ms292_8772;
extern T7*ms283_9552;
extern T7*ms375_1012;
extern T7*ms330_9243;
extern T7*ms330_4653;
extern T7*ms332_6153;
extern T7*ms244_8073;
extern T7*ms292_3663;
extern T7*ms292_3213;
extern T7*ms302_1184;
extern T7*ms303_1144;
extern T7*ms222_3224;
extern T7*ms330_8764;
extern T7*ms106_2184;
extern T7*ms10_13680;
extern T7*ms10_10680;
extern T7*ms10_10800;
extern T7*ms330_100072a;
extern T7*ms330_107092a;
extern T7*ms11_29440;
extern T7*ms11_20940;
extern T7*ms11_15230;
extern T7*ms11_24020;
extern T7*ms324_5624;
extern T7*ms226_3894;
extern T7*ms13_25640;
extern T7*ms146_7344;
extern T7*ms13_12870;
extern T7*ms263_9174;
extern T7*ms40_22050;
extern T7*ms40_12460;
extern T7*ms40_18290;
extern T7*ms13_17460;
extern T7*ms13_11460;
extern T7*ms40_42240;
extern T7*ms40_21900;
extern T7*ms13_10800;
extern T7*ms13_18080;
extern T7*ms13_23520;
extern T7*ms40_16400;
extern T7*ms13_66110;
extern T7*ms13_10880;
extern T7*ms13_10720;
extern T7*ms13_41100;
extern T7*ms390_2364;
extern T7*ms14_12550;
extern T7*ms14_10740;
extern T7*ms14_12030;
extern T7*ms14_10680;
extern T7*ms14_15070;
extern T7*ms14_15570;
extern T7*ms14_30660;
extern T7*ms14_26880;
extern T7*ms14_33240;
extern T7*ms14_60060;
extern T7*ms14_33270;
extern T7*ms14_53940;
extern T7*ms14_32730;
extern T7*ms14_27580;
extern T7*ms14_33990;
extern T7*ms14_16970;
extern T7*ms14_16770;
extern T7*ms14_16850;
extern T7*ms14_21300;
extern T7*ms14_56720;
extern T7*ms14_15650;
extern T7*ms14_22140;
extern T7*ms292_5154;
extern T7*ms292_5474;
extern T7*ms292_4374;
extern T7*ms292_1004;
extern T7*ms292_9954;
extern T7*ms42_16950;
extern T7*ms42_11000;
extern T7*ms42_67680;
extern T7*ms364_8184;
extern T7*ms42_25870;
extern T7*ms42_18400;
extern T7*ms42_16080;
extern T7*ms42_12810;
extern T7*ms42_13720;
extern T7*ms42_14560;
extern T7*ms42_33810;
extern T7*ms42_39480;
extern T7*ms34_14900;
extern T7*ms34_57450;
extern T7*ms34_82140;
extern T7*ms34_70550;
extern T7*ms34_28980;
extern T7*ms34_43830;
extern T7*ms34_11050;
extern T7*ms34_73800;
extern T7*ms34_91880;
extern T7*ms34_20060;
extern T7*ms34_90080;
extern T7*ms34_63690;
extern T7*ms34_37500;
extern T7*ms34_27720;
extern T7*ms34_28940;
extern T7*ms34_75620;
extern T7*ms34_32940;
extern T7*ms34_74830;
extern T7*ms34_97990;
extern T7*ms34_28720;
extern T7*ms34_57210;
extern T7*ms34_65170;
extern T7*ms34_47790;
extern T7*ms34_56460;
extern T7*ms80_22560;
extern T7*ms80_71750;
extern T7*ms80_93400;
extern T7*ms80_73570;
extern T7*ms303_2795;
extern T7*ms222_2345;
extern T7*ms330_9135;
extern T7*ms72_56820;
extern T7*ms46_46640;
extern T7*ms46_41310;
extern T7*ms46_15800;
extern T7*ms55_56160;
extern T7*ms55_36950;
extern T7*ms55_11880;
extern T7*ms55_57680;
extern T7*ms55_14520;
extern T7*ms55_25380;
extern T7*ms55_19400;
extern T7*ms55_23340;
extern T7*ms46_12780;
extern T7*ms46_82530;
extern T7*ms46_11880;
extern T7*ms46_33210;
extern T7*ms46_26180;
extern T7*ms46_38280;
extern T7*ms46_31980;
extern T7*ms46_19880;
extern T7*ms46_10010;
extern T7*ms314_1835;
extern T7*ms65_23730;
extern T7*ms92_19170;
extern T7*ms65_40050;
extern T7*ms341_2585;
extern T7*ms65_36270;
extern T7*ms65_17730;
extern T7*ms92_66660;
extern T7*ms65_32700;
extern T7*ms92_41470;
extern T7*ms39_26520;
extern T7*ms39_98400;
extern T7*ms39_13140;
extern T7*ms39_25720;
extern T7*ms39_12960;
extern T7*ms39_24060;
extern T7*ms244_1235;
extern T7*ms58_14570;
extern T7*ms58_13200;
extern T7*ms58_11760;
extern T7*ms58_55490;
extern T7*ms58_31680;
extern T7*ms58_51520;
extern T7*ms58_15800;
extern T7*ms58_34060;
extern T7*ms58_25080;
extern T7*ms58_17170;
extern T7*ms58_14920;
extern T7*ms146_2295;
extern T7*ms13_38641;
extern T7*ms13_45441;
extern T7*ms129_1855;
extern T7*ms372_2535;
extern T7*ms292_1335;
extern T7*ms292_1495;
extern T7*ms292_1835;
extern T7*ms292_1825;
extern T7*ms292_1815;
extern T7*ms283_1895;
extern T7*ms42_75241;
extern T7*ms79_23940;
extern T7*ms42_37791;
extern T7*ms89_91200;
extern T7*ms249_5995;
extern T7*ms105_2226;
extern T7*ms46_43761;
extern T7*ms341_4206;
extern T7*ms332_9146;
extern T7*ms332_5516;
extern T7*ms388_1095;
extern T7*ms11_34992;
extern T7*ms11_27832;
extern T7*ms11_10272;
extern T7*ms324_1986;
extern T7*ms13_67082;
extern T7*ms263_4656;
extern T7*ms263_4536;
extern T7*ms40_17392;
extern T7*ms263_8216;
extern T7*ms263_7326;
extern T7*ms13_84942;
extern T7*ms13_46782;
extern T7*ms13_11292;
extern T7*ms40_23562;
extern T7*ms13_14292;
extern T7*ms390_1116;
extern T7*ms129_6776;
extern T7*ms41_19162;
extern T7*ms14_16692;
extern T7*ms14_27272;
extern T7*ms14_34432;
extern T7*ms14_21192;
extern T7*ms14_13662;
extern T7*ms14_13752;
extern T7*ms292_2736;
extern T7*ms292_5166;
extern T7*ms292_5136;
extern T7*ms292_1316;
extern T7*ms292_8536;
extern T7*ms292_2976;
extern T7*ms292_4656;
extern T7*ms292_2946;
extern T7*ms42_10312;
extern T7*ms148_1076;
extern T7*ms42_29412;
extern T7*ms42_69812;
extern T7*ms34_38352;
extern T7*ms34_85332;
extern T7*ms34_76392;
extern T7*ms34_13832;
extern T7*ms34_19992;
extern T7*ms34_78192;
extern T7*ms34_45252;
extern T7*ms34_25992;
extern T7*ms34_37992;
extern T7*ms34_34992;
extern T7*ms80_35512;
extern T7*ms46_29002;
extern T7*ms55_47752;
extern T7*ms46_58212;
extern T7*ms65_63712;
extern T7*ms65_59892;
extern T7*ms341_4887;
extern T7*ms65_15152;
extern T7*ms92_64152;
extern T7*ms92_82612;
extern T7*ms83_44172;
extern T7*ms388_5216;
extern T7*ms11_17743;
extern T7*ms39_26502;
extern T7*ms39_33632;
extern T7*ms39_75712;
extern T7*ms39_55332;
extern T7*ms39_48112;
extern T7*ms39_70652;
extern T7*ms58_21552;
extern T7*ms58_14102;
extern T7*ms58_78572;
extern T7*ms58_12042;
extern T7*ms58_87312;
extern T7*ms13_63393;
extern T7*ms13_50483;
extern T7*ms13_18623;
extern T7*ms13_13293;
extern T7*ms14_16393;
extern T7*ms14_14193;
extern T7*ms14_27443;
extern T7*ms14_13833;
extern T7*ms79_50372;
extern T7*ms42_37893;
extern T7*ms42_36693;
extern T7*ms34_24843;
extern T7*ms347_5327;
extern T7*ms34_82473;
extern T7*ms34_60543;
extern T7*ms302_1188;
extern T7*ms80_98523;
extern T7*ms303_1148;
extern T7*ms330_1148;
extern T7*ms330_1188;
extern T7*ms330_6048;
extern T7*ms330_8118;
extern T7*ms72_62493;
extern T7*ms304_1308;
extern T7*ms46_17413;
extern T7*ms233_1028;
extern T7*ms341_7968;
extern T7*ms332_8088;
extern T7*ms11_18304;
extern T7*ms11_32474;
extern T7*ms11_10984;
extern T7*ms39_28313;
extern T7*ms226_3288;
extern T7*ms58_14003;
extern T7*ms76_28313;
extern T7*ms58_36693;
extern T7*ms13_14504;
extern T7*ms13_28644;
extern T7*ms40_22284;
extern T7*ms40_17064;
extern T7*ms40_20254;
extern T7*ms13_60064;
extern T7*ms13_47034;
extern T7*ms13_25714;
extern T7*ms13_10704;
extern T7*ms13_10544;
extern T7*ms14_12804;
extern T7*ms14_19124;
extern T7*ms14_11424;
extern T7*ms14_22524;
extern T7*ms14_19294;
extern T7*ms14_60104;
extern T7*ms14_11144;
extern T7*ms14_18964;
extern T7*ms14_21624;
extern T7*ms14_22824;
extern T7*ms14_12744;
extern T7*ms14_25584;
extern T7*ms292_9848;
extern T7*ms292_5148;
extern T7*ms292_2988;
extern T7*ms292_6168;
extern T7*ms292_1188;
extern T7*ms292_7658;
extern T7*ms292_1698;
extern T7*ms292_5768;
extern T7*ms292_5208;
extern T7*ms42_12114;
extern T7*ms283_3438;
extern T7*ms42_50464;
extern T7*ms42_45264;
extern T7*ms42_17424;
extern T7*ms42_60864;
extern T7*ms42_12444;
extern T7*ms42_79104;
extern T7*ms34_62784;
extern T7*ms34_68714;
extern T7*ms34_31374;
extern T7*ms34_70924;
extern T7*ms34_44694;
extern T7*ms34_63104;
extern T7*ms34_83144;
extern T7*ms34_79794;
extern T7*ms34_36624;
extern T7*ms34_48484;
extern T7*ms80_60064;
extern T7*ms80_34344;
extern T7*ms105_3199;
extern T7*ms330_5139;
extern T7*ms46_25494;
extern T7*ms46_11004;
extern T7*ms46_22824;
extern T7*ms65_72324;
extern T7*ms65_68094;
extern T7*ms65_89544;
extern T7*ms289_1268;
extern T7*ms39_23814;
extern T7*ms39_23374;
extern T7*ms39_33154;
extern T7*ms39_12204;
extern T7*ms39_30744;
extern T7*ms58_11044;
extern T7*ms58_39474;
extern T7*ms58_11024;
extern T7*ms58_10944;
extern T7*ms58_12444;
extern T7*ms58_19074;
extern T7*ms263_5159;
extern T7*ms40_15435;
extern T7*ms40_19825;
extern T7*ms129_6849;
extern T7*ms14_12595;
extern T7*ms14_13995;
extern T7*ms14_12915;
extern T7*ms14_14175;
extern T7*ms14_58075;
extern T7*ms292_5139;
extern T7*ms42_17115;
extern T7*ms42_34935;
extern T7*ms42_12945;
extern T7*ms42_18425;
extern T7*ms42_85125;
extern T7*ms34_41925;
extern T7*ms34_70945;
extern T7*ms34_60295;
extern T7*ms34_38675;
extern T7*ms34_71715;
extern T7*ms34_34845;
extern T7*ms34_74305;
extern T7*ms34_32955;
extern T7*ms34_12285;
extern T7*ms34_37125;
extern T7*ms34_65135;
extern T7*ms55_18175;
extern T7*ms55_30285;
extern T7*ms46_76935;
extern T7*ms46_20265;
extern T7*ms46_27855;
extern T7*ms10_30586;
extern T7*ms10_13356;
extern T7*ms39_40975;
extern T7*ms39_23035;
extern T7*ms39_27585;
extern T7*ms39_53165;
extern T7*ms58_94205;
extern T7*ms58_78075;
extern T7*ms13_11416;
extern T7*ms40_56916;
extern T7*ms40_50576;
extern T7*ms13_14056;
extern T7*ms40_61446;
extern T7*ms13_32336;
extern T7*ms13_37216;
extern T7*ms13_10776;
extern T7*ms13_11256;
extern T7*ms14_11776;
extern T7*ms14_29246;
extern T7*ms14_22596;
extern T7*ms14_60016;
extern T7*ms14_17886;
extern T7*ms14_11496;
extern T7*ms14_11336;
extern T7*ms14_26156;
extern T7*ms14_11376;
extern T7*ms14_22716;
extern T7*ms14_27456;
extern T7*ms46_0aa;
extern T7*ms42_22456;
extern T7*ms42_96186;
extern T7*ms42_11916;
extern T7*ms42_15576;
extern T7*ms42_24466;
extern T7*ms42_36256;
extern T7*ms42_12726;
extern T7*ms42_11136;
extern T7*ms34_85576;
extern T7*ms34_43966;
extern T7*ms34_33946;
extern T7*ms34_63096;
extern T7*ms34_47096;
extern T7*ms34_25156;
extern T7*ms34_85386;
extern T7*ms34_82066;
extern T7*ms34_63616;
extern T7*ms34_63456;
extern T7*ms34_98236;
extern T7*ms34_33396;
extern T7*ms34_33286;
extern T7*ms34_84626;
extern T7*ms34_53476;
extern T7*ms55_3073536a;
extern T7*ms35_72306;
extern T7*ms46_130240aa;
extern T7*ms46_13776;
extern T7*ms55_21346;
extern T7*ms55_11466;
extern T7*ms46_12816;
extern T7*ms39_23035aaa;
extern T7*ms65_35616;
extern T7*ms65_43966;
extern T7*ms92_51136;
extern T7*ms65_30576;
extern T7*ms11_24427;
extern T7*ms11_12807;
extern T7*ms39_20556;
extern T7*ms39_46376;
extern T7*ms58_15036;
extern T7*ms58_15456;
extern T7*ms13_37417;
extern T7*ms14_14817;
extern T7*ms14_19437;
extern T7*ms14_13707;
extern T7*ms14_13977;
extern T7*ms42_12027;
extern T7*ms42_17237;
extern T7*ms42_12087;
extern T7*ms42_14927;
extern T7*ms42_15717;
extern T7*ms34_14067;
extern T7*ms34_88647;
extern T7*ms46_18117;
extern T7*ms46_48887;
extern T7*ms55_21567;
extern T7*ms65_82177;
extern T7*ms11_27208;
extern T7*ms11_36958;
extern T7*ms11_20688;
extern T7*ms11_34188;
extern T7*ms39_20957;
extern T7*ms58_21437;
extern T7*ms76_66627;
extern T7*ms76_46407;
extern T7*ms21_17578;
extern T7*ms13_21528;
extern T7*ms40_21788;
extern T7*ms40_20878;
extern T7*ms13_33308;
extern T7*ms13_10608;
extern T7*ms13_10808;
extern T7*ms13_11328;
extern T7*ms13_19808;
extern T7*ms14_17448;
extern T7*ms14_10528;
extern T7*ms14_22248;
extern T7*ms14_22788;
extern T7*ms14_26908;
extern T7*ms14_21648;
extern T7*ms14_34528;
extern T7*ms14_40358;
extern T7*ms14_12978;
extern T7*ms42_49358;
extern T7*ms42_12948;
extern T7*ms42_25038;
extern T7*ms42_27278;
extern T7*ms43_25168;
extern T7*ms43_80668;
extern T7*ms34_63328;
extern T7*ms34_71128;
extern T7*ms34_36168;
extern T7*ms34_94248;
extern T7*ms34_42978;
extern T7*ms34_77508;
extern T7*ms34_78588;
extern T7*ms34_22168;
extern T7*ms34_26638;
extern T7*ms34_90558;
extern T7*ms34_40338;
extern T7*ms34_57288;
extern T7*ms34_29148;
extern T7*ms35_26208;
extern T7*ms55_10538;
extern T7*ms55_23008;
extern T7*ms46_44388;
extern T7*ms65_33618;
extern T7*ms65_36828;
extern T7*ms11_37859;
extern T7*ms39_33258;
extern T7*ms39_31538;
extern T7*ms39_16698;
extern T7*ms85_60608;
extern T7*ms12_21679;
extern T7*ms13_19839;
extern T7*ms41_10489;
extern T7*ms14_12529;
extern T7*ms14_13419;
extern T7*ms14_23829;
extern T7*ms42_14469;
extern T7*ms42_40579;
extern T7*ms34_53969;
extern T7*ms34_13509;
extern T7*ms330_19240;
extern T7*ms105_16200;
extern T7*ms105_22710;
extern T7*ms330_14660;
extern T7*ms330_47450;
extern T7*ms330_44550;
extern T7*ms330_78660;
extern T7*ms330_11020;
extern T7*ms35_25179;
extern T7*ms232_94240;
extern T7*ms232_18080;
extern T7*ms260_27080;
extern T7*ms233_18400;
extern T7*ms341_38540;
extern T7*ms332_10140;
extern T7*ms46_31119;
extern T7*ms55_10999;
extern T7*ms46_18029;
extern T7*ms270_38600;
extern T7*ms65_66429;
extern T7*ms253_22600;
extern T7*ms118_16290;
extern T7*ms190_12870;
extern T7*ms39_15779;
extern T7*ms146_24320;
extern T7*ms263_37550;
extern T7*ms263_54080;
extern T7*ms263_34440;
extern T7*ms58_24609;
extern T7*ms58_75669;
extern T7*ms58_28899;
extern T7*ms129_41400;
extern T7*ms363_16830;
extern T7*ms183_14240;
extern T7*ms183_33880;
extern T7*ms292_84900;
extern T7*ms292_16640;
extern T7*ms292_92690;
extern T7*ms292_17520;
extern T7*ms292_17190;
extern T7*ms292_32880;
extern T7*ms292_16800;
extern T7*ms148_56430;
extern T7*ms283_34500;
extern T7*ms283_38600;
extern T7*ms283_71400;
extern T7*ms283_10030;
extern T7*ms283_16260;
extern T7*ms364_12730;
extern T7*ms364_41940;
extern T7*ms356_12980;
extern T7*ms248_45900;
extern T7*ms149_16290;
extern T7*ms149_43200;
extern T7*ms347_87500;
extern T7*ms347_30540;
extern T7*ms347_53260;
extern T7*ms249_76570;
extern T7*ms375_22630;
extern T7*ms357_59180;
extern T7*ms195_54060;
extern T7*ms187_14440;
extern T7*ms269_29400;
extern T7*ms368_38160;
extern T7*ms105_23121;
extern T7*ms330_62871;
extern T7*ms106_19791;
extern T7*ms198_83790;
extern T7*ms270_23751;
extern T7*ms253_53041;
extern T7*ms129_88031;
extern T7*ms129_45961;
extern T7*ms282_55831;
extern T7*ms292_43401;
extern T7*ms292_25891;
extern T7*ms101_66792;
extern T7*ms101_43392;
extern T7*ms111_63162;
extern T7*ms149_89271;
extern T7*ms266_43011;
extern T7*ms347_42441;
extern T7*ms249_30681;
extern T7*ms141_50092;
extern T7*ms105_81302;
extern T7*ms105_21492;
extern T7*ms330_19812;
extern T7*ms233_20672;
extern T7*ms242_86032;
extern T7*ms332_20202;
extern T7*ms234_14812;
extern T7*ms244_78192;
extern T7*ms244_24012;
extern T7*ms163_50092;
extern T7*ms271_29392;
extern T7*ms109_84672;
extern T7*ms263_22032;
extern T7*ms263_10592;
extern T7*ms372_86602;
extern T7*ms292_10692;
extern T7*ms292_90972;
extern T7*ms292_43902;
extern T7*ms292_93912;
extern T7*ms274_35952;
extern T7*ms149_99162;
extern T7*ms275_41652;
extern T7*ms267_35472;
extern T7*ms187_26532;
extern T7*ms198_98482;
extern T7*ms198_97692;
extern T7*ms263_38493;
extern T7*ms263_35303;
extern T7*ms183_24263;
extern T7*ms292_53433;
extern T7*ms201_98784;
extern T7*ms248_36693;
extern T7*ms277_45873;
extern T7*ms330_99414;
extern T7*ms12_581900;
extern T7*ms232_11424;
extern T7*ms106_51064;
extern T7*ms233_29304;
extern T7*ms251_34344;
extern T7*ms341_57144;
extern T7*ms341_27534;
extern T7*ms42_190320;
extern T7*ms180_85234;
extern T7*ms42_142690;
extern T7*ms42_269780;
extern T7*ms42_630890;
extern T7*ms253_63264;
extern T7*ms244_41834;
extern T7*ms34_120520;
extern T7*ms34_666080;
extern T7*ms34_112140;
extern T7*ms34_112230;
extern T7*ms34_141350;
extern T7*ms34_196560;
extern T7*ms34_115740;
extern T7*ms34_191760;
extern T7*ms34_115650;
extern T7*ms263_25704;
extern T7*ms263_30404;
extern T7*ms263_32264;
extern T7*ms263_11424;
extern T7*ms372_20254;
extern T7*ms363_19224;
extern T7*ms292_14894;
extern T7*ms292_48804;
extern T7*ms265_99414;
extern T7*ms148_73044;
extern T7*ms46_129050;
extern T7*ms46_130240;
extern T7*ms149_40404;
extern T7*ms65_107460;
extern T7*ms65_147680;
extern T7*ms347_77844;
extern T7*ms347_54464;
extern T7*ms357_23664;
extern T7*ms84_116840;
extern T7*ms58_407960;
extern T7*ms58_356700;
extern T7*ms76_139750;
extern T7*ms179_36624;
extern T7*ms330_60885;
extern T7*ms330_47995;
extern T7*ms330_45315;
extern T7*ms330_23655;
extern T7*ms330_17445;
extern T7*ms331_30015;
extern T7*ms198_86564;
extern T7*ms242_20145;
extern T7*ms260_38075;
extern T7*ms117_53215;
extern T7*ms34_124691;
extern T7*ms264_37975;
extern T7*ms292_26895;
extern T7*ms292_17745;
extern T7*ms101_58386;
extern T7*ms46_122271;
extern T7*ms357_51975;
extern T7*ms268_38125;
extern T7*ms330_86976;
extern T7*ms330_63916;
extern T7*ms198_33465;
extern T7*ms233_63376;
extern T7*ms251_33396;
extern T7*ms341_93636;
extern T7*ms225_18176;
extern T7*ms253_45376;
extern T7*ms244_36096;
extern T7*ms244_14616;
extern T7*ms244_75456;
extern T7*ms280_18176;
extern T7*ms34_135632;
extern T7*ms34_349402;
extern T7*ms34_202032;
extern T7*ms34_128352;
extern T7*ms263_14616;
extern T7*ms263_47136;
extern T7*ms129_20976;
extern T7*ms129_37536;
extern T7*ms372_97536;
extern T7*ms292_72496;
extern T7*ms292_25146;
extern T7*ms274_16976;
extern T7*ms364_17496;
extern T7*ms256_86756;
extern T7*ms46_716872;
extern T7*ms176_63456;
extern T7*ms149_36216;
extern T7*ms65_171472;
extern T7*ms249_63756;
extern T7*ms39_111462;
extern T7*ms39_802392;
extern T7*ms187_36216;
extern T7*ms179_18096;
extern T7*ms96_233442;
extern T7*ms388_38496;
extern T7*ms162_66627;
extern T7*ms253_66627;
extern T7*ms226_32637;
extern T7*ms292_12727;
extern T7*ms292_32407;
extern T7*ms292_13897;
extern T7*ms292_11187;
extern T7*ms364_63327;
extern T7*ms231_10128;
extern T7*ms330_30498;
extern T7*ms12_570704;
extern T7*ms341_13678;
extern T7*ms341_23148;
extern T7*ms341_14118;
extern T7*ms332_20488;
extern T7*ms216_58608;
extern T7*ms226_74948;
extern T7*ms244_11988;
extern T7*ms280_50008;
extern T7*ms34_197274;
extern T7*ms263_40568;
extern T7*ms263_11808;
extern T7*ms263_13148;
extern T7*ms129_41868;
extern T7*ms282_17008;
extern T7*ms363_57028;
extern T7*ms372_11178;
extern T7*ms292_12688;
extern T7*ms292_17248;
extern T7*ms364_97888;
extern T7*ms364_12708;
extern T7*ms149_35088;
extern T7*ms347_28578;
extern T7*ms65_121824;
extern T7*ms249_11648;
extern T7*ms375_11178;
extern T7*ms58_666204;
extern T7*ms58_783104;
extern T7*ms105_54809;
extern T7*ms87_101934;
extern T7*ms87_121394;
extern T7*ms233_53969;
extern T7*ms341_11799;
extern T7*ms42_116405;
extern T7*ms34_166375;
extern T7*ms34_115695;
extern T7*ms34_114705;
extern T7*ms34_103845;
extern T7*ms34_116145;
extern T7*ms34_116865;
extern T7*ms273_49909;
extern T7*ms292_17459;
extern T7*ms292_21789;
extern T7*ms283_17459;
extern T7*ms65_140505;
extern T7*ms65_228345;
extern T7*ms65_130095;
extern T7*ms21_107916;
extern T7*ms42_135096;
extern T7*ms43_296296;
extern T7*ms34_145656;
extern T7*ms34_203856;
extern T7*ms80_110836;
extern T7*ms46_131716;
extern T7*ms46_848426;
extern T7*ms65_196786;
extern T7*ms58_103626;
extern T7*ms101_500000;
extern T7*ms58_454797;
extern T7*ms13_554698;
extern T7*ms341_130190;
extern T7*ms54_320658;
extern T7*ms118_180780;
extern T7*ms46_225848;
extern T7*ms263_114080;
extern T7*ms65_152958;
extern T7*ms147_112950;
extern T7*ms363_114030;
extern T7*ms292_328600;
extern T7*ms292_122910;
extern T7*ms283_101250;
extern T7*ms283_116100;
extern T7*ms79_162378;
extern T7*ms198_126960;
extern T7*ms54_203069;
extern T7*ms55_146179;
extern T7*ms292_143961;
extern T7*ms292_196511;
extern T7*ms13_188a;
extern T7*ms13_266a;
extern T7*ms13_160a;
extern T7*ms13_270a;
extern T7*ms13_933a;
extern T7*ms13_939a;
extern T7*ms13_178a;
extern T7*ms41_366a;
extern T7*ms347_110331;
extern T7*ms42_492a;
extern T7*ms34_280a;
extern T7*ms34_663a;
extern T7*ms34_657a;
extern T7*ms46_270a;
extern T7*ms46_242a;
extern T7*ms46_576a;
extern T7*ms46_681a;
extern T7*ms46_0aaa;
extern T7*ms330_130882;
extern T7*ms330_100072;
extern T7*ms330_107092;
extern T7*ms330_449242;
extern T7*ms65_160a;
extern T7*ms39_112a;
extern T7*ms39_406a;
extern T7*ms58_582a;
extern T7*ms58_248a;
extern T7*ms341_135412;
extern T7*ms129_382452;
extern T7*ms347_441672;
extern T7*ms278_305382;
extern T7*ms372_126893;
extern T7*ms177_358643;
extern T7*ms34_1419840;
extern T7*ms198_235773;
extern T7*ms198_141933;
extern T7*ms190_120244;
extern T7*ms263_146744;
extern T7*ms372_531024;
extern T7*ms363_106784;
extern T7*ms363_157934;
extern T7*ms292_304794;
extern T7*ms330_627165;
extern T7*ms198_157734;
extern T7*ms289_126054;
extern T7*ms146_153435;
extern T7*ms263_114205;
extern T7*ms292_452295;
extern T7*ms292_125195;
extern T7*ms40_1087422;
extern T7*ms40_2813102;
extern T7*ms330_511746;
extern T7*ms198_115695;
T7*se_ms(int c,char*e);
T7*se_string_from_external_copy(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void se_msi5(void);
void se_msi6(void);
void se_msi7(void);
void se_msi8(void);
void se_msi9(void);
void se_msi10(void);
void se_msi11(void);
void se_msi12(void);
void se_msi13(void);
void se_msi14(void);
void se_msi15(void);
void se_msi16(void);
void se_msi17(void);
void se_msi18(void);
void se_msi19(void);
void se_msi20(void);
void se_msi21(void);
void se_msi22(void);
void se_msi23(void);
void se_msi24(void);
void se_msi25(void);
void se_msi26(void);
void se_msi27(void);
void se_msi28(void);
void se_msi29(void);
void se_msi30(void);
void se_msi31(void);
void*se_ma99(int argc,...);
void*se_ma104(int argc,...);
void*se_ma110(int argc,...);
void*se_ma308(int argc,...);
void*se_ma317(int argc,...);
void*se_ma221(int argc,...);
void*se_ma322(int argc,...);
void*se_ma228(int argc,...);
void*se_ma328(int argc,...);
void*se_ma235(int argc,...);
void*se_ma238(int argc,...);
void*se_ma49(int argc,...);
void*se_ma259(int argc,...);
void*se_ma361(int argc,...);
void*se_ma172(int argc,...);
void*se_ma77(int argc,...);
void*se_ma81(int argc,...);
void*se_ma279(int argc,...);
void*se_ma185(int argc,...);
void*se_ma90(int argc,...);
void*se_ma191(int argc,...);
void X214set_rescue_compound(void *C,T0* a1);
void X360force(void *C,T0* a1,T2 a2);
T2 X162arg_count(void *C);
T0* X162arguments(void *C);
T0* X162make_runnable(void *C,T0* a1,T0* a2,T0* a3);
void X162finalize(void *C);
void X55address_of_c_define(void *C,T0* a1);
T6 X55is_deferred(void *C);
T2 X55static_value_mem(void *C);
T0* X55run_class(void *C);
void X55vape_check_from(void *C,T0* a1);
T2 X55id(void *C);
T0* X55local_vars(void *C);
void X55afd_check(void *C);
void X55c_assertion_flag(void *C);
void X55collect_c_tmp(void *C);
T6 X55use_current(void *C);
void X55fall_down(void *C);
T0* X55arguments(void *C);
void X55mapping_c(void *C);
T6 X55is_static(void *C);
T6 X55is_exported_in(void *C,T0* a1);
void X55c_define(void *C);
void X55address_of_c_mapping(void *C);
T0* X55clients(void *C);
T6 X55is_pre_computable(void *C);
T0* X55result_type(void *C);
T6 X55can_be_dropped(void *C);
T0* X55start_position(void *C);
T0* X237to_runnable_integer(void *C,T0* a1);
T0* X237to_runnable_character(void *C,T0* a1);
T0* X237twin(void *C);
T0* X200value(void *C,T2 a1);
T0* X200start_position(void *C);
void X94resize(void *C,T2 a1);
T0* X94twin(void *C);
T0* X141run_feature(void *C);
void X307append_in(void *C,T0* a1);
T2 X307count(void *C);
T6 X326fast_has(void *C,T0* a1);
T2 X326fast_index_of(void *C,T0* a1);
void X326resize(void *C,T2 a1);
T0* X129arg1(void *C);
void X129dca_inline(void *C,T0* a1);
void X184set_rank(void *C,T2 a1);
T0* X184to_string(void *C);
T0* X184start_position(void *C);
T2 X117arg_count(void *C);
T0* X117arguments(void *C);
void X117finalize(void *C);
T0* X117run_feature(void *C);
void X311put(void *C,T0* a1,T2 a2);
void X301mapping_c_name_in(void *C,T0* a1);
T0* X301result_type(void *C);
T0* X301start_position(void *C);
T0* X58generic_list(void *C);
T6 X58need_gc_mark_function(void *C);
void X58to_expanded(void *C);
T2 X58id(void *C);
void X58cast_to_ref(void *C);
void X58c_header_pass1(void *C);
void X58just_before_gc_mark_in(void *C,T0* a1);
void X58c_header_pass3(void *C);
void X58gc_call_new_in(void *C,T0* a1);
T0* X58base_class(void *C);
T6 X58is_array(void *C);
T0* X58look_up_for(void *C,T0* a1,T0* a2);
T6 X58has_creation(void *C,T0* a1);
T6 X58need_c_struct(void *C);
void X58mapping_cast(void *C);
T6 X58is_a_in(void *C,T0* a1,T0* a2);
T6 X58is_native_array(void *C);
T6 X58is_a(void *C,T0* a1);
T6 X58is_boolean(void *C);
T6 X58is_generic(void *C);
T0* X58run_type(void *C);
T6 X58is_like_argument(void *C);
void X58used_as_reference(void *C);
T6 X58is_reference(void *C);
T6 X58is_real(void *C);
T6 X58is_user_expanded(void *C);
T6 X58is_anchored(void *C);
T6 X58is_run_type(void *C);
T6 X58is_integer(void *C);
T0* X58start_position(void *C);
T6 X58is_any(void *C);
T6 X58is_string(void *C);
void X58c_initialize_in(void *C,T0* a1);
T0* X58smallest_ancestor(void *C,T0* a1);
T6 X58is_like_current(void *C);
void X58c_header_pass2(void *C);
void X58c_header_pass4(void *C);
T6 X58is_double(void *C);
void X58to_reference(void *C);
T6 X58is_none(void *C);
T0* X58to_runnable(void *C,T0* a1);
T6 X58is_pointer(void *C);
void X58gc_define1(void *C);
void X58gc_mark_in(void *C,T0* a1);
T0* X58static_base_class_name(void *C);
void X58c_type_for_external_in(void *C,T0* a1);
void X58c_type_for_argument_in(void *C,T0* a1);
T0* X58run_time_mark(void *C);
T2 X58space_for_variable(void *C);
T0* X58run_class(void *C);
T6 X58is_like_feature(void *C);
T6 X58is_dummy_expanded(void *C);
void X58c_type_for_result_in(void *C,T0* a1);
T6 X58is_expanded(void *C);
void X58c_type_for_target_in(void *C,T0* a1);
T0* X58expanded_initializer(void *C);
T6 X58is_basic_eiffel_expanded(void *C);
T6 X58is_formal_generic(void *C);
void X58demangling_in(void *C,T0* a1);
void X58c_initialize(void *C);
T0* X58written_mark(void *C);
T6 X58is_character(void *C);
T0* X58base_class_name(void *C);
void X58c_frame_descriptor(void *C);
T6 X58is_bit(void *C);
void X58gc_info_in(void *C,T0* a1);
void X58gc_define2(void *C);
T0* X265base_class(void *C);
T0* X161add_comment(void *C,T0* a1);
void X161compile_to_c(void *C);
void X161afd_check(void *C);
void X161collect_c_tmp(void *C);
T6 X161use_current(void *C);
T0* X161to_runnable(void *C,T0* a1);
T6 X161is_pre_computable(void *C);
T0* X161start_position(void *C);
void X242set_current_type(void *C,T0* a1);
void X242afd_check(void *C);
T6 X242use_current(void *C);
T0* X242to_runnable(void *C,T0* a1);
void X288c_define_procedure(void *C,T0* a1,T0* a2,T0* a3);
void X288c_mapping_procedure(void *C,T0* a1,T0* a2,T0* a3);
void X288c_define_function(void *C,T0* a1,T0* a2,T0* a3);
void X288c_mapping_function(void *C,T0* a1,T0* a2,T0* a3);
T6 X288stupid_switch(void *C,T0* a1);
T6 X288use_current(void *C,T0* a1);
T0* X118arguments(void *C);
T0* X118run_feature(void *C);
void X284mapping_c_name_in(void *C,T0* a1);
T0* X284result_type(void *C);
T0* X284start_position(void *C);
void X84declaration_in(void *C,T0* a1);
void X84undefine_in(void *C,T0* a1);
T0* X84origin_base_class(void *C);
T0* X84name_in(void *C,T0* a1);
T0* X84to_key(void *C);
void X84put_cpp_tag(void *C);
T6 X84is_frozen(void *C);
T0* X84to_string(void *C);
void X84mapping_c_in(void *C,T0* a1);
T0* X84start_position(void *C);
void X151resize(void *C,T2 a1);
T0* X151twin(void *C);
void X343resize(void *C,T2 a1);
T6 X289use_current(void *C);
T0* X289external_c_name(void *C);
void X179add_last(void *C,T0* a1);
void X60compile_to_c_old(void *C);
T2 X60static_value(void *C);
T6 X60is_current(void *C);
T0* X60static_result_base_class(void *C);
T6 X60is_manifest_string(void *C);
void X60dca_inline_argument(void *C,T0* a1);
T0* X60add_comment(void *C,T0* a1);
void X60assertion_check(void *C,T3 a1);
void X60mapping_c_target(void *C,T0* a1);
void X60compile_to_c(void *C);
void X60afd_check(void *C);
void X60c_declare_for_old(void *C);
void X60collect_c_tmp(void *C);
T6 X60is_result(void *C);
T6 X60use_current(void *C);
T0* X60to_runnable(void *C,T0* a1);
T2 X60to_integer(void *C);
T6 X60is_void(void *C);
T6 X60is_static(void *C);
void X60mapping_c_arg(void *C,T0* a1);
T6 X60is_pre_computable(void *C);
T2 X60isa_dca_inline_argument(void *C);
T0* X60result_type(void *C);
T6 X60c_simple(void *C);
T6 X60can_be_dropped(void *C);
T0* X60start_position(void *C);
void X57c_initialize_in(void *C,T0* a1);
T2 X57space_for_variable(void *C);
T2 X57id(void *C);
T6 X57is_c_unsigned_ptr(void *C);
T2 X57unsigned_padding(void *C);
T2 X57nb(void *C);
void X57cast_to_ref(void *C);
void X57c_type_for_target_in(void *C,T0* a1);
T6 X57is_c_int(void *C);
void X57mapping_cast(void *C);
T6 X57is_c_char(void *C);
T0* X110twin(void *C);
void X149compile_to_c_old(void *C);
void X149match_with(void *C,T0* a1,T0* a2);
void X149assertion_check(void *C,T3 a1);
void X149compile_to_c(void *C,T0* a1);
void X149afd_check(void *C);
void X149c_declare_for_old(void *C);
void X149collect_c_tmp(void *C);
T6 X149use_current(void *C);
void X149dca_inline_ith(void *C,T0* a1,T2 a2);
void X149compile_to_c_ith(void *C,T0* a1,T2 a2);
T0* X149expression(void *C,T2 a1);
T0* X149to_runnable(void *C,T0* a1);
T6 X149is_static(void *C);
T2 X149count(void *C);
T6 X149is_pre_computable(void *C);
void X149dca_inline(void *C,T0* a1);
T6 X149isa_dca_inline(void *C,T0* a1,T0* a2);
T6 X149can_be_dropped(void *C);
T0* X149start_position(void *C);
void X92set_header_comment(void *C,T0* a1);
T0* X92ensure_assertion(void *C);
T6 X92is_deferred(void *C);
T6 X92is_merge_with(void *C,T0* a1,T0* a2);
T6 X92is_merge_with2aux(void *C,T0* a1,T0* a2);
T6 X92can_hide(void *C,T0* a1,T0* a2);
void X92add_into(void *C,T0* a1);
T0* X92try_to_undefine(void *C,T0* a1,T0* a2);
T0* X92require_assertion(void *C);
void X92check_obsolete(void *C,T0* a1);
T6 X92stupid_switch(void *C,T0* a1,T0* a2);
T0* X92arguments(void *C);
T0* X92to_run_feature(void *C,T0* a1,T0* a2);
T0* X92result_type(void *C);
T0* X92start_position(void *C);
extern char*_spfd;

