/*
 * SCSTD.H - standard header for PACT codes
 *         - designed with portability, uniformity, and consistency
 *         - in mind
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#ifndef PCK_STD

#define PCK_STD

#include "cpyright.h"

/*--------------------------------------------------------------------------*/

/*                        STANDARD CONFIGURATIONS                           */

/*--------------------------------------------------------------------------*/

/* Intel Paragon predefines __PARAGON__ */
#ifdef __PARAGON__
# define PARAGON
#endif

/* SGI predefines __sgi */
#ifdef __sgi
# define SGI
#endif

/* CRI predefines _UNICOS */
#ifdef _UNICOS
# define UNICOS
#endif

/* SUN predefines sun */
#ifdef sun
# ifndef SOLARIS
#  define SUN
# endif
#endif

/* Borland predefines __BORLANDC__ */
#ifdef __BORLANDC__
# define TURBOC
#endif

/* MPW C predefines applec */
#ifdef applec
# define MPW
#endif

/* Think C compiler defines THINK_C; CodeWarrior defines __MWERKS__ */
#ifdef __MWERKS__
# include "scconfig.mac"
#endif

#ifdef THINK_C
# include "scconfig.mac"
#endif

#ifdef MPW
# include "scconfig.mpw"
#endif

#ifndef MAC
# include <scconfig.h>
#endif

#ifndef BINARY_MODE_R
# define BINARY_MODE_R         "rb"
#endif

#ifndef BINARY_MODE_W
# define BINARY_MODE_W         "wb"
#endif

#ifndef BINARY_MODE_A
# define BINARY_MODE_A         "ab"
#endif

#ifndef BINARY_MODE_RPLUS
# define BINARY_MODE_RPLUS     "r+b"
#endif

#ifndef BINARY_MODE_WPLUS
# define BINARY_MODE_WPLUS     "w+b"
#endif

#ifndef BINARY_MODE_APLUS
# define BINARY_MODE_APLUS     "a+b"
#endif

#ifdef __GNUC__
# define DEBUG_FUNC
#else
# define DEBUG_FUNC static
#endif

#ifdef NO_CONST
# define const
#endif

/*--------------------------------------------------------------------------*/

/*                          STANDARD INCLUDES                               */

/*--------------------------------------------------------------------------*/

#if ((defined PTHREAD_POSIX) || (defined PTHREAD_DRAFT4))

# include <pthread.h>
# define HAVE_THREADS

# ifdef SOLARIS
# define _REENTRANT
# define _POSIX_PTHREAD_SEMANTICS
# endif

#endif

#include <stdio.h>
#include <string.h>

#ifdef UNIX
# include <unistd.h>
# include <sys/stat.h>
#endif

/* CodeWarrior plays silly games with math header files... */
#ifdef __MWERKS__
# include <fp.h>
# include <fenv.h>
#else
# include <math.h>
#endif

#include <ctype.h>
#include <signal.h>
#include <setjmp.h>
#include <time.h>

#ifdef ANSI
# include <stdlib.h>
# include <stddef.h>
# include <stdarg.h>
# include <limits.h>
# include <errno.h>
# include <float.h>
#endif

#ifdef PCC
# ifndef BBN
#  include <malloc.h>
# else
#  include <errno.h>
# endif
# include <sys/types.h>
# include <varargs.h>
#endif

#ifdef MSC
# include <conio.h>
# include <malloc.h>
# include <sys\stat.h>
#endif

#ifdef TURBOC
# include <conio.h>
# include <alloc.h>
# include <sys\stat.h>
#endif

#ifdef MAC

# include <unix.h>
# include <console.h>

#else

# include <scdecls.h>

#endif

/*--------------------------------------------------------------------------*/

/*                           STANDARD PRAGMAS                               */

/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/

/*                      STANDARD CONSTANT MACROS                            */

/*--------------------------------------------------------------------------*/

#ifndef TRUE
# define TRUE 1
#endif
#ifndef FALSE
# define FALSE 0
#endif
 
#ifndef ON
# undef OFF
# define ON  1
# define OFF 0
#endif

#define SMALL   1.0e-100
#undef HUGE
#define HUGE    1.0e100

#ifdef LONG_MAX
# define HUGE_INT LONG_MAX
#else
# define HUGE_INT ((1 << (sizeof(long)-1)) - 1)
#endif

#define SC_BITS_BYTE      8

#define SC_CHAR_I        1
#define SC_SHORT_I       2
#define SC_INTEGER_I     3
#define SC_LONG_I        4
#define SC_FLOAT_I       5
#define SC_DOUBLE_I      6
#define SC_REAL_I        7
#define SC_STRING_I      8
#define SC_POINTER_I     9
#define SC_PCONS_P_I     10
#define SC_VOID_I        11
#define SC_SHORT_P_I     12
#define SC_INTEGER_P_I   13
#define SC_LONG_P_I      14
#define SC_FLOAT_P_I     15
#define SC_REAL_P_I      16
#define SC_DOUBLE_P_I    17
#define SC_PCONS_I       18
#define SC_STRUCT_I      19   /* is this pointer type? */
#define SC_UNKNOWN_I     20
#define SC_CHAR_8_I      21   /* for F77 users and interfacers */
#ifdef _LARGE_FILES
#define SC_LONGLONG_I    22
#define SC_LONGLONG_P_I  23
#define SC_OFF_T_I       SC_LONGLONG_I
#define SC_OFF_T_P_I     SC_LONGLONG_P_I
#else
#define SC_LONGLONG_I    SC_LONG_I
#define SC_LONGLONG_P_I  SC_LONG_P_I
#define SC_OFF_T_I       SC_LONG_I
#define SC_OFF_T_P_I     SC_LONG_P_I
#endif
#define SC_USER_I        24   /* first user defined index available */

#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#undef MAXLINE
#define MAXLINE 255

#define LRG_TXT_BUFFER 4096

#define ABS fabs

#ifndef POW
# define POW pow
#endif

/* get the ticks per second for clock straight */

#ifndef TICKS_SECOND
# ifdef CLOCKS_PER_SEC
#  define TICKS_SECOND CLOCKS_PER_SEC
# else
#  ifdef CLK_TCK
#   define TICKS_SECOND CLK_TCK
#  else
#   define TICKS_SECOND 1000000
#  endif
# endif
#endif


/* UNIX Constants */

#ifdef UNIX
# define directory_delim "/"
# define directory_delim_c '/'
#endif

/* DOS Constants */

#ifdef DOS
# define directory_delim "\\"
# define directory_delim_c '\\'
#endif

/* MAC Constants */

#ifdef MAC
# define directory_delim ":"
# define directory_delim_c ':'
#endif

#ifndef FIXNUM
# define FIXNUM long
#endif

#ifdef __cplusplus
# define FUNCTION_POINTER(t, n) typedef t n(...)
#else
# define FUNCTION_POINTER(t, n) typedef t n()
#endif

/*--------------------------------------------------------------------------*/

/*                           STANDARD TYPEDEFS                              */

/*--------------------------------------------------------------------------*/

FUNCTION_POINTER(void, (*PFVoid));

FUNCTION_POINTER(char, (*PFChar));
FUNCTION_POINTER(int, (*PFInt));
FUNCTION_POINTER(long, (*PFLong));
FUNCTION_POINTER(float, (*PFFloat));
FUNCTION_POINTER(double, (*PFDouble));
FUNCTION_POINTER(byte, (*PFByte));

FUNCTION_POINTER(char, *(*PFPChar));
FUNCTION_POINTER(int, *(*PFPInt));
FUNCTION_POINTER(long, *(*PFPLong));
FUNCTION_POINTER(float, *(*PFPFloat));
FUNCTION_POINTER(double, *(*PFPDouble));
FUNCTION_POINTER(byte, *(*PFPByte));
FUNCTION_POINTER(void, *(*PFPVoid));

FUNCTION_POINTER(char, **(*PFPPChar));

#ifdef SGI
# ifdef __cplusplus
   typedef void (*PFSignal_handler)(...);
#  define SIGNAL_HANDLER_DEFINED
# endif
#endif

#ifdef ANSI
# ifndef SIGNAL_HANDLER_DEFINED
   typedef void (*PFSignal_handler)(int sig);
#  define SIGNAL_HANDLER_DEFINED
# endif
#endif

#ifndef SIGNAL_HANDLER_DEFINED
# ifdef __cplusplus
  typedef void (*PFSignal_handler)(int sig);
# else
  typedef void (*PFSignal_handler)();
# endif
#endif

#undef SIGNAL_HANDLER_DEFINED

#ifndef MAC
# ifndef DOS
typedef char *CONST * CONST_STRINGS;
# else
typedef char ** CONST_STRINGS;
# endif
#endif

#ifdef _LARGE_FILES
#define F_SEEK fseeko
#define F_TELL ftello
#define OFF_T_MAX LONGLONG_MAX
#define BIGINT long long
#define atoadd SC_stoll
#define SC_STOADD SC_stoll
#else
#define F_SEEK fseek
#define F_TELL ftell
#define OFF_T_MAX LONG_MAX
#ifndef off_t
#define off_t long
#endif
#define BIGINT long
#define atoadd atol
#define SC_STOADD SC_stol
#endif

/*--------------------------------------------------------------------------*/

/*                       STANDARD PROCEDURAL MACROS                         */

/*--------------------------------------------------------------------------*/

/* DECLARE - space and error saving function declaration alternative */

#ifdef ANSI

#define DECLARE(n, a) n a
#define SC_DECLARE(n, a) n a
#define DECLFPTR(t, n, a) t (*n) a

#else

#define DECLARE(n, a) n()
#define SC_DECLARE(n, a) n()
#define DECLFPTR(t, n, a) t (*n)()

#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* DEREF - dereference a pointer */

#define DEREF(x) (*(char **) (x))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAKE - memory allocation and bookkeeping macro */

#define MAKE(x)                                                              \
    (SC_mem_stats_acc((long) sizeof(x), 0L), (x *) calloc(1, sizeof(x)))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAKE_N - allocate a block of type x and return a pointer to it */

#define MAKE_N(x, n)                                                         \
    (SC_mem_stats_acc((long) n*sizeof(x), 0L), (x *) calloc(n, sizeof(x)))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* REMAKE - memory reallocation and bookkeeping macro 
 *        - no book keeping here since we don't have sufficient info
 */

#define REMAKE(p, x) ((x *) realloc(p, (long) sizeof(x)))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* REMAKE_N - reallocate a block of type x and return a pointer to it
 *          - no book keeping here since we don't have sufficient info
 */

#define REMAKE_N(p, x, n) ((x *) realloc(p, n*sizeof(x)))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SFREE - release memory and do bookkeeping */

#define SFREE(x)                                                             \
   {SC_mem_stats_acc(0L, (long) sizeof(*x));                                 \
    free(x);                                                                 \
    x = NULL;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SFREE_N - release memory and do bookkeeping on arrays */

#define SFREE_N(x, n)                                                        \
   {SC_mem_stats_acc(0L, (long) n*sizeof(*x));                               \
    free(x);                                                                 \
    x = NULL;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAX - the oft wanted maximum */

#ifndef max
# define max(a, b) ((a > b) ? a : b)
#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MIN - companion to max */

#ifndef min
# define min(a, b) ((a < b) ? a : b)
#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* FOREIGN - attempt a uniform declaration for mixed languages
 *         - example of declaration
 *         -
 *         - FOREIGN(fortran)
 *         -  foo();
 */

#ifdef CRAY
# define FOREIGN(x)  x
#else
# define FOREIGN(x)  extern
#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* F77_ID - attempt a uniform naming of FORTRAN 77 functions which 
 *        - gets around loader naming conventions
 *        -
 *        - F77_ID(foo_, foo, FOO)(x, y, z)
 */

#ifdef ANSI_F77
# define F77_ID(x_, x, X)  X
#endif

#ifndef __GNUC__

# ifdef AIX
#  define F77_ID(x_, x, X)  x
# endif

# ifdef HPUX
#  define F77_ID(x_, x, X)  x
# endif

#endif

#ifndef F77_ID
# define F77_ID(x_, x, X)  x_
#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* F77_STRING - get around the problem of C and F77 vendors who can't
 *            - agree on what a string is
 *            - NOTE: Scot Futral contributed info and code here
 */

#ifdef UNICOS

# ifndef __cplusplus
#  include <fortran.h>

typedef _fcd F77_string;

#  define SC_F77_C_STRING(_f) _fcdtocp((_f))
#  define SC_C_F77_STRING(_c) _cptofcd((_c), ((_c) ? strlen((_c)) : 0))

# else

typedef char *F77_string;

#  define SC_F77_C_STRING(_f) ((char *) _f)
#  define SC_C_F77_STRING(_c) ((char *) _c)

# endif

#else

typedef char *F77_string;

#define SC_F77_C_STRING(_f) ((char *) _f)
#define SC_C_F77_STRING(_c) ((char *) _c)

#endif

#define SC_FORTRAN_STR_C(c_string, f_string, n_chars)                        \
   {strncpy(c_string, SC_F77_C_STRING(f_string), n_chars);                   \
    c_string[n_chars] = '\0';}

#if ((defined PTHREAD_POSIX) || (defined PTHREAD_DRAFT4))

# define SC_thread                      pthread_t
# define SC_thread_key                  pthread_key_t
# define SC_THREAD_SELF()               pthread_self()
# define SC_THREAD_EQUAL(t1, t2)        pthread_equal(t1, t2)
# ifdef AIX
#  define SC_CREATE_ATTACHED            PTHREAD_CREATE_UNDETACHED
# else
#  define SC_CREATE_ATTACHED            PTHREAD_CREATE_JOINABLE
# endif
# define SC_CREATE_DETACHED             PTHREAD_CREATE_DETACHED
# define SC_THREAD_JOIN(thread, status) pthread_join(thread, status)
# define SC_LOCKOFF(lock)                                                    \
     {if (SC_n_threads > 1)                                                  \
         pthread_mutex_unlock(&lock);}
# define SC_COND_WAIT(condv, lock)      pthread_cond_wait(&condv, &lock)

#  define SC_DECLARE_THREAD_CONDV(condv) extern pthread_cond_t condv
#  define SC_THREAD_CONDV(condv)                                             \
     pthread_cond_t condv = PTHREAD_COND_INITIALIZER
#  define SC_THREAD_SIGNAL(condv)        pthread_cond_signal(&condv)
#  define SC_THREAD_BROADCAST(condv)     pthread_cond_broadcast(&condv)

# define SC_localtime(t, tm)             (localtime_r(&t, &tm), &tm)
# define SC_strtok(s, d, n)                                                  \
    (n = (s != NULL) ? NULL : n, strtok_r(s, d, &n))
# define SC_ttyname(fd, buf, len)        (ttyname_r(fd, buf, len), buf)

# if (defined PTHREAD_POSIX)

typedef void *(*pthread_startroutine_t)(void *x);

#  define SC_DECLARE_THREAD_ATTR(attr)                                       \
     extern pthread_attr_t attr;                                             \
     extern void SC_DECLARE(attr##_init, (byte));                            \
     extern pthread_once_t attr##_once_block

#  define SC_THREAD_ATTR(attr)                                               \
     pthread_attr_t attr;                                                    \
     void attr##_init(byte)                                                  \
        {pthread_attr_init(&attr);                                           \
         pthread_attr_setdetachstate(&attr, SC_CREATE_DETACHED);             \
         return;}                                                            \
     pthread_once_t attr##_once_block = PTHREAD_ONCE_INIT

#  define SC_THREAD_CREATE(thread, attr, func, arg)                          \
     (pthread_once(&attr##_once_block, attr##_init),                         \
      pthread_create(&thread, &attr,                                         \
                     (pthread_startroutine_t) func, (void *) &arg))

#  define SC_DECLARE_THREAD_LOCK(lock)   extern pthread_mutex_t lock
#  define SC_THREAD_LOCK(lock)                                               \
     pthread_mutex_t lock = PTHREAD_MUTEX_INITIALIZER

#  define SC_LOCKON(lock)                                                    \
     {if (SC_n_threads > 1)                                                  \
         pthread_mutex_lock(&lock);}
         
#  define SC_CREATE_KEY(key, dest)       pthread_key_create(&key, dest)
#  define SC_SET_KEY(type, key, addr)    pthread_setspecific(key, addr)
#  define SC_GET_KEY(type, key, value)                                       \
     (value = *((type *) pthread_getspecific(key)))

#  define SC_GET_PKEY(type, key, value)                                       \
     (value = ((type *) pthread_getspecific(key)))

#  if (defined SOLARIS) && (defined __GNUC__)
#   define SC_ctime(t, buf, len)          (ctime_r(&t, buf, len), buf)
#  else
#   define SC_ctime(t, buf, len)          (ctime_r(&t, buf), buf)
#  endif

#  define SC_rand(seed, value)                                               \
      (rand_r((unsigned int *) &(seed), &value), value)

# else

#  define SC_DECLARE_THREAD_ATTR(attr)   extern pthread_attr_t *attr
#  define SC_THREAD_ATTR(attr)                                               \
     pthread_attr_t *attr = &pthread_attr_default

#  define SC_THREAD_CREATE(thread, attr, func, arg)                          \
     pthread_create(&thread, *attr,                                          \
                    (pthread_startroutine_t) func, (void *) &arg)

#  define SC_DECLARE_THREAD_LOCK(lock)                                       \
     extern pthread_mutex_t lock;                                            \
     extern void *SC_DECLARE(lock##_init, (byte));                           \
     extern pthread_once_t lock##_once_block

#  define SC_THREAD_LOCK(lock)                                               \
     pthread_mutex_t lock;                                                   \
     void *lock##_init(byte)                                                 \
        {pthread_mutex_init(&lock, pthread_mutexattr_default);               \
         return;}                                                            \
     pthread_once_t lock##_once_block = pthread_once_init

#  define SC_LOCKON(lock)                                                    \
     {if (SC_n_threads > 1)                                                  \
         {(pthread_once(&lock##_once_block,                                  \
           (pthread_initroutine_t) lock##_init),                             \
           pthread_mutex_lock(&lock));};}

#  define SC_CREATE_KEY(key, dest)       pthread_keycreate(&key, dest)
#  define SC_SET_KEY(type, key, addr)                                        \
     pthread_setspecific(key, (pthread_addr_t) addr)

#  define SC_GET_KEY(type, key, value)                                       \
     {pthread_addr_t pv = &value;                                            \
      pthread_getspecific(key, &pv);                                         \
      value = *((type *) pv);}

#  define SC_GET_PKEY(type, key, value)                                      \
     {pthread_addr_t pv = &value;                                            \
      pthread_getspecific(key, &pv);                                         \
      value = ((type *) pv);}

#  define SC_ctime(tm, buf, len)         (ctime_r(&tm, buf, len), buf)
#  define SC_rand(seed, value)                                               \
      (value = rand_r((unsigned int *) &(seed)))

# endif

#else

# define SC_thread                       int
# define SC_DECLARE_THREAD_ATTR(attr)    extern int attr
# define SC_THREAD_ATTR(attr)            int attr
# define SC_THREAD_SELF()                0
# define SC_THREAD_CREATE(thread, attr, func, arg)                           \
    (thread = 1,                                                             \
     (*func)(&arg))
# define SC_THREAD_JOIN(thread, status)  (thread = 0)
# define SC_DECLARE_THREAD_LOCK(lock)    extern int lock
# define SC_THREAD_LOCK(lock)            int lock
# define SC_LOCKON(lock)
# define SC_LOCKOFF(lock)

# define SC_COND_WAIT(condv, lock)
# define SC_DECLARE_THREAD_CONDV(condv)  extern int condv
# define SC_THREAD_CONDV(condv)          int condv
# define SC_THREAD_SIGNAL(condv)
# define SC_THREAD_BROADCAST(condv)

# define SC_thread_key                   int
# define SC_CREATE_KEY(key, dest)
# define SC_SET_KEY(type, key, addr)     (key = *((int *) (addr)))
# define SC_GET_KEY(int, key, value)     (value = key)
# define SC_GET_PKEY(int, key, value)    (value = &key)

# define SC_ctime(tm, buf, len)          strcpy(buf, ctime(&tm))
# define SC_localtime(t, tm)             (tm = *localtime(&t), &tm)
# define SC_rand(seed, value)            (value = rand())
# define SC_strtok(s, d, n)              (n = strtok(s, d))
# define SC_ttyname(fd, buf, len)        strcpy(buf, ttyname(fd))

#endif

/*--------------------------------------------------------------------------*/

/*                SCORE VARIABLE ARGUMENT LIST MACROS                       */

/*--------------------------------------------------------------------------*/

#ifdef ANSI

#define SC_VA_START(x)                                                       \
   {va_list __a__;                                                           \
    va_start(__a__, x)

#endif

#ifdef PCC

#define SC_VA_START(x)                                                       \
   {va_list __a__;                                                           \
    va_start(__a__)

#endif

#define SC_VA_ARG(x)      va_arg(__a__, x)

#define SC_VSPRINTF(s, f) vsprintf(s, f, __a__)

#define SC_VFPRINTF(s, f) vfprintf(s, f, __a__)

#define SC_VA_END                                                            \
    va_end(__a__);}

/* thanks to Lee Taylor */

#define SC_VA_VAR __a__

#define SC_VA_SAVE(x)                                                        \
    {va_list __a__;                                                          \
     __a__ = *(x)

#define SC_VA_RESTORE(x)                                                     \
     *(x) = __a__;}


#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------*/

/*                    STANDARD VARIABLE DECLARATIONS                        */

/*--------------------------------------------------------------------------*/

extern int
 *LAST;

/*--------------------------------------------------------------------------*/

/*                    STANDARD FUNCTION DECLARATIONS                        */

/*--------------------------------------------------------------------------*/

#ifdef __GNUC__

/*--------------------------------- Linux ----------------------------------*/

# ifdef LINUX

#  ifndef HAVE_GNU_LIBC_6
extern int
 SC_DECLARE(rexec, (char **ahost, int inport, const char *user,
                 const char *passwd,
		 const char *cmd, int *fd2p)),
 SC_DECLARE(bsd_ioctl, (int fildes, int request, ...)),
 SC_DECLARE(ioctl, (int fildes, int request, ...));

#  endif

extern int
 SC_DECLARE(wait, (void *p));

extern unsigned long
 SC_DECLARE(inet_addr, (char *cp));

# endif

/*---------------------------------- AIX -----------------------------------*/

# ifdef AIX

#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/socketvar.h>

extern int
 SC_DECLARE(gethostname, (char *name, int len)),
 SC_DECLARE(rexec, (char **ahost, int inport, const char *user,
                 const char *passwd,
		 const char *cmd, int *fd2p)),
 SC_DECLARE(ioctl, (int fildes, int request, ...)),
 SC_DECLARE(wait, (void *p)),
 SC_DECLARE(getrusage, (int who, struct rusage *rusage)),
 SC_DECLARE(gettimeofday, (struct timeval *tp, struct timezone *tzp)),
 SC_DECLARE(socketpair, (int domain, int type, int prot, int sv[2])),
 SC_DECLARE(socket, (int af, int type, int prot)),
 SC_DECLARE(bind, (int sockfd, struct sockaddr *addr, int addrlen)),
 SC_DECLARE(getsockname, (int sock, struct sockaddr *name, int *len)),
 SC_DECLARE(listen, (int sock, int backlog)),
 SC_DECLARE(accept, (int sock, struct sockaddr *addr, int *len)),
 SC_DECLARE(connect, (int sock, struct sockaddr *name, int len));


extern void
 SC_DECLARE(bzero, (char *b, int length));

extern unsigned long
 SC_DECLARE(inet_addr, (char *cp));

# endif

/*--------------------------------- SunOS ----------------------------------*/

# ifdef SUN
#  ifndef __GNUC__

extern int
 SC_DECLARE(rexec, (char **ahost, unsigned short inport, char *user,
		 char *passwd,
                 char *cmd, int *fd2p)),
 SC_DECLARE(select, (int nfds, fd_set *readfds, fd_set *writefds,
                  fd_set *exceptfds, struct timeval *timeout)),
 SC_DECLARE(ioctl, (int fildes, int request, ...)),
 SC_DECLARE(wait, (void *p));

extern void
 SC_DECLARE(bzero, (char *b, int length));

extern unsigned long
 SC_DECLARE(inet_addr, (char *cp));

#  endif
# endif

/*--------------------------------- HP UX ----------------------------------*/

# ifdef HPUX

extern int
 SC_DECLARE(rexec, (char **ahost, int inport, const char *user,
		 const char *passwd,
	         const char *cmd, int *fd2p)),
 SC_DECLARE(select, (size_t nfds, int *readfds, int *writefds,
	          int *exceptfds, const struct timeval *timeout)),
 SC_DECLARE(ioctl, (int fildes, int request, ...)),
 SC_DECLARE(wait, (void *p));

extern void
 SC_DECLARE(bzero, (char *b, int length));

extern unsigned long
 SC_DECLARE(inet_addr, (char *cp));

# endif

/*-------------------------------- SGI IRIX --------------------------------*/

# ifdef SGI

#include <sys/types.h>
#include <sys/time.h>

extern int
 SC_DECLARE(rexec, (char **ahost, int inport, const char *user,
		 const char *passwd,
	         const char *cmd, int *fd2p)),
 SC_DECLARE(select, (int nfds, fd_set *readfds, fd_set *writefds,
	          fd_set *exceptfds, struct timeval *timeout)),
 SC_DECLARE(gethostname, (char *name, int namelen)),
 SC_DECLARE(ioctl, (int fildes, int request, ...)),
 SC_DECLARE(wait, (void *p));

extern void
 SC_DECLARE(bzero, (char *b, int length));

extern unsigned long
 SC_DECLARE(inet_addr, (char *cp));

# endif

/*------------------------------- POTENTIAL --------------------------------*/

# if 0

extern int
 SC_DECLARE(getpid, (void)),
 SC_DECLARE(pipe, (int *p)),
 SC_DECLARE(dup2, (int s, int t)),
 SC_DECLARE(close, (int f)),
 SC_DECLARE(read, (int f, void *p, unsigned int n)),
 SC_DECLARE(write, (int f, const void *p, unsigned int n)),
 SC_DECLARE(execvp, (char *s, char **a)),
 SC_DECLARE(fork, (void));

extern unsigned int
 SC_DECLARE(alarm, (unsigned int i));

# endif

#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif

