/*
 * PCTMOD.C - terminal mode control routines for PPC
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "ppc.h"

#ifdef SYSV_TERMINAL

#define IS(flag, x) (trm.flag & x) ? "ON" : "OFF"

#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_SET_RAW_STATE - set the RAW processing on the given descriptor
 *                  - don't do anything else if you can't get the
 *                  - parameters for the stream
 *                  - this also weeds out descriptors (e.g. sockets
 *                  - and pipes) for which this is inappropriate
 *                  - (TTY's and PTY's need this stuff)
 */

int PC_set_raw_state(fd, trap)
   int fd, trap;
   {TERMINAL trm;

#ifndef OPENNT
#ifdef UNIX

    if (trap)
       {PC_ERR_TRAP(FALSE);};

    if (ioctl(fd, TIOCGETP, &trm) > -1)
       {

# ifdef BSD_TERMINAL

        trm.sg_flags |= RAW;
/*        trm.sg_flags &= ~ECHO; */

# endif

# ifdef SYSV_TERMINAL

#  ifndef SOLARIS
        trm.c_iflag  = ICRNL;
#  endif

        trm.c_oflag &= ~OPOST;

        trm.c_lflag &= ~( ISIG | ICANON | XCASE );
/*        trm.c_lflag &= ~(ISIG | ICANON | ECHO | XCASE); */

        trm.c_cflag &= ~(CSIZE | PARENB);
        trm.c_cflag |= CS8;

        trm.c_cc[VMIN]  = 1;    /* Force at least one character to be read */
        trm.c_cc[VTIME] = 1;    /* 10th second between chars */

# endif

        if (ioctl(fd, TIOCSETN, &trm) < 0)
           PC_error("COULDN'T SET I/O FLAGS %d - PC_SET_RAW_STATE",
                    errno);};

#endif

    return(TRUE);}

#else

    return(FALSE);}

#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_SET_COOKED_STATE - set the COOKED processing on the given descriptor
 *                     - don't do anything else if you can't get the
 *                     - parameters for the stream
 *                     - this also weeds out descriptors (e.g. sockets
 *                     - and pipes) for which this is inappropriate
 *                     - (TTY's and PTY's need this stuff)
 */

int PC_set_cooked_state(fd, trap)
   int fd, trap;
   {TERMINAL trm;

#ifndef OPENNT
#ifdef UNIX

    if (trap)
       {PC_ERR_TRAP(FALSE);};

    if (ioctl(fd, TIOCGETP, &trm) > -1)
       {

#ifdef BSD_TERMINAL

/* this is cooked */
        trm.sg_flags |= ( ECHO | CRMOD | CBREAK | TANDEM | ALLDELAY );

#endif

#ifdef SYSV_TERMINAL

        trm.c_iflag |= ( ICRNL | IXON );

/*        trm.c_oflag |= ( OPOST | ONLCR ); */
        trm.c_oflag |= ( OPOST | OCRNL );
        trm.c_oflag |= ( NLDLY | CRDLY | TABDLY | BSDLY | VTDLY | FFDLY );

        trm.c_lflag |= ( ISIG | ICANON | ECHO );

        trm.c_cflag |= ( CREAD | PARENB | CS7 );

        trm.c_cc[VMIN]  = 1;    /* Force at least one character to be read */
        trm.c_cc[VTIME] = 1;    /* 10th second between chars */

#endif

        if (ioctl(fd, TIOCSETN, &trm) < 0)
           PC_error("COULDN'T SET I/O FLAGS %d - PC_SET_COOKED_STATE",
                    errno);};

#endif

    return(TRUE);}

#else

    return(FALSE);}

#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_GET_TERM_STATE - get the terminal state on the given descriptor
 *                   - allocate and return a TERMINAL_STATE
 *                   - containing the old state
 *                   - don't do anything else if you can't get the
 *                   - parameters for the stream
 *                   - this also weeds out descriptors (e.g. sockets and
 *                   - pipes) for which this is inappropriate (PTY's need
 *                   - this stuff)
 */

TERMINAL_STATE *PC_get_term_state(fd)
   int fd;
   {TERMINAL_STATE *t;

#ifndef OPENNT
#ifdef UNIX

    t = FMAKE(TERMINAL_STATE, "PC_GET_TERM_STATE:t");
    t->fd        = fd;
    t->full_info = TRUE;

    if (ioctl(fd, TIOCGETP, &(t->term)) < 0)
       return(NULL);

#ifdef BSD

    if (ioctl(fd, TIOCGETC, &(t->tch)) < 0)
       return(NULL);

    if (ioctl(fd, TIOCGLTC, &(t->ltc)) < 0)
       return(NULL);

    if (ioctl(fd, TIOCLGET, &(t->localmode)) < 0)
       return(NULL);

    if (ioctl(fd, TIOCGETD, &(t->discipline)) < 0)
       return(NULL);

    if (ioctl(fd, TIOCGWINSZ, &(t->window_size)) < 0)
       return(NULL);

#endif

#endif

    return(t);}

#else

    return(NULL);}

#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_SET_TERM_STATE - set the terminal state on the given descriptor
 *                   - don't do anything else if you can't get the
 *                   - parameters for the stream
 *                   - this also weeds out descriptors (e.g. sockets and
 *                   - pipes) for which this is inappropriate (PTY's need
 *                   - this stuff)
 */

int PC_set_term_state(t, trmfd)
   TERMINAL_STATE *t;
   int trmfd;
   {int fd;

#ifndef OPENNT
#ifdef UNIX

    if (t == NULL)
       return(FALSE);

    if (trmfd >= 0)
       fd = trmfd;
    else
       fd = t->fd;

    if (ioctl(fd, TIOCSETP, &(t->term)) < 0)
       return(FALSE);

#ifdef BSD
    if (t->full_info)
       {if (ioctl(fd, TIOCSETC, &(t->tch)) < 0)
           return(FALSE);

        if (ioctl(fd, TIOCSLTC, &(t->ltc)) < 0)
           return(FALSE);

        if (ioctl(fd, TIOCLSET, &(t->localmode)) < 0)
           return(FALSE);

        if (ioctl(fd, TIOCSETD, &(t->discipline)) < 0)
           return(FALSE);

        if (ioctl(fd, TIOCSWINSZ, &(t->window_size)) < 0)
           return(FALSE);};
#endif

#endif

    return(TRUE);}

#else

    return(FALSE);}

#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_PRINT_TERM_STATE - print to the specified file the state of the
 *                     - specified file descriptor
 */

void PC_print_term_state(fp, fd)
   FILE *fp;
   int fd;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

