/*
 * PCCTST.C - test connections child side
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "ppc.h"

static void
 SC_DECLARE(send_binary, (long nitems, char *type));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAIN - start here */

int main(argc, argv, envp)
   int argc;
   char **argv, **envp;
   {int i, binary;
    char s[MAXLINE+2];

    SC_setbuf(stdout, NULL);

    binary = FALSE;
    for (i = 1; i < argc; i++)
        {if (argv[i][0] == '-')
            {switch (argv[i][1])
                {case 'b' :
                      binary = TRUE;
		      break;
		 case 'h' :
		      printf("\nUsage: pcctst [-b]\n");
                      printf("   Simple program which prints prompts and echos input\n");
                      printf("   In binary mode sends 100 longs and 10 doubles first\n");
		      printf("   Options:\n");
		      printf("      b - run in binary mode\n");
		      break;};};};

    if (binary)
       {send_binary(100, SC_LONG_S);
        send_binary(10,  SC_DOUBLE_S);};

    while (TRUE)
       {PRINT(stdout, "-> ");
        if (fgets(s, MAXLINE, stdin) != NULL)
           PRINT(stdout, "%s", s);

        if (strcmp(s, "end\n") == 0)
           break;};

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SEND_BINARY - do some binary data exchanges */

static void send_binary(nitems, type)
   long nitems;
   char *type;
   {long i;
    PDBfile *file;
    byte *space;
    double *src;
    PROCESS *pp;

    PRINT(stdout, ":B\n");

    PRINT(stdout, "%s %ld\n", type, nitems);

/* this is a testing mode check */
    if (PC_terminal == NULL)
       {char **argv;

        argv    = FMAKE_N(char *, 2, "SEND_BINARY:argv");
        argv[0] = SC_strsavef("VIF", "char*:SEND_BINARY:argv0");

        PC_terminal      = PC_mk_process(argv, "ab", PC_CHILD);
        PC_terminal->in  = 0;
        PC_terminal->out = 1;};

    pp   = PC_terminal;
    file = pp->vif;

    space = _PD_alloc_entry(file, type, nitems);
    src   = (double *) _PD_alloc_entry(file, SC_DOUBLE_S, nitems);
    for (i = 0L; i < nitems; i++)
        src[i] = (double) i;
    CONVERT(type, &space, SC_DOUBLE_S, src, (int) nitems, TRUE);

    if (PC_write(space, type, nitems, pp))
       printf("Binary data sent: %s %ld\n",
              type, nitems);

    else
       printf("Binary data send failed: %s %ld\n",
              type, nitems);

    PRINT(stdout, ":A\n");

    SFREE(space);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
