/*
 * GSDV_MPG.C - PGS MPEG device routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
#include "pgs.h"
#include "gsrast.h"

typedef int boolean;

extern void
 SC_DECLARE(save_image2file, (PG_device *dev)),
 SC_DECLARE(close_MPEGjob, (PG_device *dev));

extern boolean
 SC_DECLARE(init_MPEGjob, (PG_device *dev));

/* to use the MPEG device issue a call
 *
 *   PG_register_device("MPEG", PG_setup_mpeg_device);
 *
 */

/*--------------------------------------------------------------------------*/

/*                            PAGE STATE ROUTINES                           */

/*--------------------------------------------------------------------------*/

/* _PG_MP_FINISH_PLOT - do what's necessary to finish up a graphical image
 *                    - and get the device updated with the image
 *                    - after this function nothing more can be added to
 *                    - the image
 */
 
static void _PG_MP_finish_plot(dev)
   PG_device *dev;
   {     
    PG_make_device_current(dev);

    save_image2file(dev);

    PG_update_vs(dev);

    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_MP_OPEN - initialize a MPEG device */
 
static PG_device *_PG_MP_open(dev, xf, yf, dxf, dyf)
   PG_device *dev;
   double xf, yf, dxf, dyf;
   {PG_RAST_device *mdv;
    int Lightest, Light, Light_Gray, Dark_Gray, Dark, Darkest;
    int display_width, display_height, n_colors;
    char fname[MAXLINE], *name, *s;
    REAL intensity;
    REAL view_x_max, view_y_max;
    PG_font_family *ff;
    FILE *fh;

    PG_setup_markers();

    dev->type_index       = MPEG_DEVICE;
    dev->quadrant         = QUAD_FOUR;
    dev->hard_copy_device = TRUE;
    dev->print_labels     = TRUE;

    _PG_rst_set_dev_prop(dev, (int) dxf, (int) dyf, N_RAST_COLOR);

    strcpy(fname, dev->title);
    name = SC_strtok(fname, " \t\n\r\\?~.,;:<>/'`\"[]{}()=+|!@#$%^&*", s);

    strcat(fname, ".mpg");

    mdv = PG_make_raster_device((int) dxf, (int) dyf, fname,
				NULL, TRUE, NULL);
    if (mdv == NULL)
       return(NULL);

/* create a MPEG file */
    fh = fopen(fname, "wb");
    if (fh == NULL)
       return(NULL);

    mdv->fp = fh;

/* NOTE: sab's original gsdv_mp.c */
    mdv->quant  = 4;
    mdv->dctnum = 4;

    dev->file = (FILE *) mdv;

/* get the window shape in NDC */
    if ((xf == 0.0) && (yf == 0.0))
       {xf = 0.0;
        yf = 0.0;};

    if ((dxf == 0.0) && (dyf == 0.0))
       {dxf = 1.0;
        dyf = 1.0;};

    PG_query_screen(dev, &display_width, &display_height, &n_colors);

/* set device pixel coordinate limits */
    dev->min_pc_x = SHRT_MIN + display_width;
    dev->max_pc_x = SHRT_MAX - display_width;
    dev->min_pc_y = SHRT_MIN + display_height;
    dev->max_pc_y = SHRT_MAX - display_height;
 
    dev->window_x      = 0.0;
    dev->window_y      = 0.0;
    dev->window_width  = display_width;
    dev->window_height = display_height;

    dev->window_x_off  = dev->window_x;
    dev->window_y_off  = dev->window_y;

    Color_Map(dev, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);

    dev->ncolor = N_RAST_COLOR;
    dev->absolute_n_color = N_RAST_COLOR;

/* compute the view port */
    if (dev->view_x == 0.0)
       {dev->view_x = 0.175;
        dev->view_y = 0.175;};

    if (dev->view_width == 0.0)
       dev->view_width = 0.65;

    if (dev->view_height == 0.0)
       dev->view_height = 0.65;

    view_x_max = dev->view_x + dev->view_width;
    view_y_max = dev->view_y + dev->view_height;

/* set the view port */
    PG_set_viewport(dev, dev->view_x, view_x_max, dev->view_y, view_y_max);
    PG_set_window(dev, 0.0, 1.0, 0.0, 1.0);
 
/* initialize fonts */
    ff = PG_make_font_family(dev, "helvetica", NULL, 4,
                             "Helvetica",
                             "Helvetica-Oblique",
                             "Helvetica-Bold",
                             "Helvetica-BoldOblique");

    ff = PG_make_font_family(dev, "times", ff, 4,
                             "Times-Roman",
                             "Times-Italic",
                             "Times-Bold",
                             "Times-BoldItalic");

    ff = PG_make_font_family(dev, "courier", ff, 4,
                             "Courier",
                             "Courier-Oblique",
                             "Courier-Bold",
                             "Courier-BoldOblique");

    dev->font_family = ff;

    PG_set_font(dev, "helvetica", "medium", 12);

/* put in the default palettes */
    intensity  = dev->max_intensity*MAXPIX;
    Lightest   = 0;
    Light      = intensity;
    Light_Gray = 0.8*intensity;
    Dark_Gray  = 0.5*intensity;
    Dark       = 0;
    Darkest    = intensity;

    PG_setup_standard_palettes(dev, 64,
			       Light, Dark,
			       Light_Gray, Dark_Gray,
			       Lightest, Darkest);

    getln = (PFfgets) io_gets_hook;
    putln = (PFfprintf) io_printf_hook;

/* initialization of starting necessary MPEG job */
    if (!init_MPEGjob(dev))
       return(NULL);

    return(dev);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_MP_CLOSE_DEVICE - close a device */
 
static void _PG_MP_close_device(dev)
   PG_device *dev;
   {PG_RAST_device *mdv;

    GET_RAST_DEVICE(dev, mdv);

/* close the MPEG stuff */
    close_MPEGjob(dev);
    fclose(mdv->fp);
    _PG_free_frame(mdv->inner_frame);
    SFREE(mdv->out_fname);
    SFREE(mdv);

/* clean up the device */
   _PG_rl_device(dev);

   return;}

/*--------------------------------------------------------------------------*/

/*                            PGS INTERFACE ROUTINES                        */

/*--------------------------------------------------------------------------*/
 
/* PG_SETUP_MPEG_DEVICE - do the device dependent device initialization
 *                      - for PG_make_device
 */

void PG_setup_mpeg_device(d)
   PG_device *d;
   {

    PG_setup_raster_device(d);

    d->type_index   = MPEG_DEVICE;
    d->close_device = _PG_MP_close_device;
    d->finish_plot  = _PG_MP_finish_plot;
    d->open_screen  = _PG_MP_open;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

