/*
 * GSCLTS.C - test of graphics library
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

char
 *clrs[] = {"BLACK",
            "WHITE",
            "GRAY",
            "DARK_GRAY",
            "BLUE",
            "GREEN",
            "CYAN",
            "RED",
            "MAGENTA",
            "BROWN",
            "DARK_BLUE",
            "DARK_GREEN",
            "DARK_CYAN",
            "DARK_RED",
            "YELLOW",
            "DARK_MAGENTA"};

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

int main(argc, argv)
   int argc;
   char **argv;
   {int i, n, mapped;
    double y, dy;
    PG_device *SCR_dev, *SCR_dew, *PS_dev, *CGM_dev;

    mapped = TRUE;
    for (i = 1; i < argc; i++)
        {if (argv[i][0] == '-')
            {switch (argv[i][1])
                {case 'm' : mapped = FALSE;
                            break;};}
         else
            break;};

    SCR_dev = PG_make_device("WINDOW", "COLOR", "PGS Test A");
    PG_white_background(SCR_dev, TRUE);
    PG_set_viewport_pos(SCR_dev, 0.0, 0.0);
    PG_set_viewport_shape(SCR_dev, 1.0, 0.0, 1.0);
    PG_open_device(SCR_dev, 0.1, 0.1, 0.4, 0.4);

    PG_set_viewport(SCR_dev, 0.0, 1.0, 0.0, 1.0);
    PG_set_window(SCR_dev, 0.0, 1.0, 0.0, 1.0);

    SCR_dew = PG_make_device("WINDOW", "COLOR", "PGS Test B");
    PG_white_background(SCR_dew, FALSE);
    PG_set_viewport_pos(SCR_dew, 0.0, 0.0);
    PG_set_viewport_shape(SCR_dew, 1.0, 0.0, 1.0);
    PG_open_device(SCR_dew, 0.5, 0.1, 0.4, 0.4);

    PG_set_viewport(SCR_dew, 0.0, 1.0, 0.0, 1.0);
    PG_set_window(SCR_dew, 0.0, 1.0, 0.0, 1.0);

    PS_dev = PG_make_device("PS", "COLOR", "gsclts");
    PG_open_device(PS_dev, 0.0, 0.0, 0.0, 0.0);

    PG_set_viewport(PS_dev, 0.2, 0.8, 0.2, 0.8);
    PG_set_window(PS_dev, 0.0, 1.0, 0.0, 1.0);

    CGM_dev = PG_make_device("CGM", "COLOR", "gsclts");
    PG_open_device(CGM_dev, 0.0, 0.0, 0.0, 0.0);

    PG_set_viewport(CGM_dev, 0.0, 1.0, 0.0, 1.0);
    PG_set_window(CGM_dev, 0.0, 1.0, 0.0, 1.0);

/* clear screens - this also sets the CGM page properly and is mandatory */
    PG_clear_window(SCR_dev);
    PG_clear_window(SCR_dew);
    PG_clear_window(PS_dev);
    PG_clear_window(CGM_dev);

    n  = 16;
    dy = 1.0/(n + 1.0);
    y  = 0.5*dy;
    for (i = 0; i < n; i++)
        {PG_make_device_current(SCR_dev);
         PG_set_color_line(SCR_dev, i, mapped);
         PG_draw_line(SCR_dev, 0.0, y, 0.5, y);
         PG_set_color_text(SCR_dev, i, mapped);
         PG_write_WC(SCR_dev, 0.6, y, "%d %s", i, clrs[i]);

         PG_make_device_current(SCR_dew);
         PG_set_color_line(SCR_dew, i, mapped);
         PG_draw_line(SCR_dew, 0.0, y, 0.5, y);
         PG_set_color_text(SCR_dew, i, mapped);
         PG_write_WC(SCR_dew, 0.6, y, "%d %s", i, clrs[i]);

         PG_make_device_current(PS_dev);
         PG_set_color_line(PS_dev, i, mapped);
         PG_draw_line(PS_dev, 0.0, y, 0.5, y);
         PG_set_color_text(PS_dev, i, mapped);
         PG_write_WC(PS_dev, 0.6, y, "%d %s", i, clrs[i]);

         PG_make_device_current(CGM_dev);
         PG_set_color_line(CGM_dev, i, mapped);
         PG_draw_line(CGM_dev, 0.0, y, 0.5, y);
         PG_set_color_text(CGM_dev, i, mapped);
         PG_write_WC(CGM_dev, 0.6, y, "%d %s", i, clrs[i]);

         y += dy;};

    PG_update_vs(SCR_dew);
    PG_update_vs(SCR_dev);
    PG_update_vs(PS_dev);
    PG_update_vs(CGM_dev);

    SC_pause();

    PG_close_device(CGM_dev);
    PG_close_device(PS_dev);
    PG_close_device(SCR_dew);
    PG_close_device(SCR_dev);

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
