/*
 * PDSMP.C - Test smp i/o in pdblib
 *
 * Source Version: 9.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pdb.h"

#define NPTS 10

#define check_myplot1(xplot, rxplot)                                                                 \
        {int i;                                                                                      \
         if (strcmp(xplot.label, rxplot.label) != 0)                                                 \
            {printf("xplot.label differs from rxplot.label in %s\n", sname1);                        \
             printf("xplot.label: %s, rxplot.label: %s\n", xplot.label, rxplot.label);               \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot.view->x_min != rxplot.view->x_min)                                                \
            {printf("xplot.view->xmin differs from rxplot.view->xmin in %s\n", sname1);              \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot.view->x_max != rxplot.view->x_max)                                                \
            {printf("xplot.view->x_max differs from rxplot.view->x_max in %s\n", sname1);            \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot.view->y_min != rxplot.view->y_min)                                                \
            {printf("xplot.view->y_min differs from rxplot.view->y_min in %s\n", sname1);            \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot.view->y_max != rxplot.view->y_max)                                                \
            {printf("xplot.view->y_max differs from rxplot.view->y_max in %s\n", sname1);            \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot.npts != rxplot.npts)                                                              \
            {printf("xplot.npts differs from rxplot.npts in %s\n", sname1);                          \
             exit(1);}                                                                               \
                                                                                                     \
         for (i = 0; i < 10; i++)                                                                    \
             if (xplot.x_axis[i] != rxplot.x_axis[i])                                                \
                {printf("xplot.x_axis[%d] differs from rxplot.x_axis[%d] in %s\n", i, i, sname1);    \
                exit(1);};}            

#define check_myplot2(xplot, rxplot)                                                                 \
        {int i;                                                                                      \
         if (strcmp(xplot->label, rxplot->label) != 0)                                                   \
            {printf("xplot->label differs from rxplot->label in %s\n", sname1);                      \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot->view->x_min != rxplot->view->x_min)                                              \
            {printf("xplot->view->xmin differs from rxplot->view->xmin in %s\n", sname1);            \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot->view->x_max != rxplot->view->x_max)                                              \
            {printf("xplot->view->x_max differs from rxplot->view->x_max in %s\n", sname1);          \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot->view->y_min != rxplot->view->y_min)                                              \
            {printf("xplot->view->y_min differs from rxplot->view->y_min in %s\n", sname1);          \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot->view->y_max != rxplot->view->y_max)                                              \
            {printf("xplot->view->y_max differs from rxplot->view->y_max in %s\n", sname1);          \
             exit(1);}                                                                               \
                                                                                                     \
         if (xplot->npts != rxplot->npts)                                                            \
            {printf("xplot->npts differs from rxplot->npts in %s\n", sname1);                        \
             exit(1);}                                                                               \
                                                                                                     \
         for (i = 0; i < 10; i++)                                                                    \
             if (xplot->x_axis[i] != rxplot->x_axis[i])                                              \
                {printf("xplot->x_axis[%d] differs from rxplot->x_axis[%d] in %s\n", i, i, sname1);  \
                exit(1);};}        

struct s_l_frame
   {float x_min;
    float x_max;
    float y_min;
    float y_max;};

typedef struct s_l_frame l_frame;

struct s_plot
   {float x_axis[NPTS];
    float y_axis[NPTS];
    int npts;
    char *label;
    l_frame *view;};

typedef struct s_plot myplot;

float d[100], d2[100];

int   j[100], j2[100];
int n_iter = 10;

myplot mypl;

PDBfile *file, *file2;

void *writeit(void *x);
void *writeit2(void *x);
void *readit(void *x);
void *readit2(void *x);
void print_help();

/*--------------------------------------------------------------------------*/
  /*--------------------------------------------------------------------------*/

main(argc, argv)
   int argc;
   char **argv;
   {int nthreads;
    int i;
    pthread_t threads[10];

    for (i = 1; i < argc; i++)
        {if (argv[i][0] == '-')
            {switch (argv[i][1])
                {case 'h' : print_help();
                            return(1);
                 case 'i' : n_iter = atol(argv[++i]);
                            break;};}
         else
            break;};

    printf("%d iterations per thread\n", n_iter);

/* load up the output arrays */
    for (i = 0; i < 100; i++)
	{d[i] = d2[i] = (float) i;
         j[i] = j2[i] = i;}

    nthreads = 5;

/* initialize PDBlib for 5 threads (includes main thread) */
    PD_init_threads(nthreads, NULL);

/* create the output file */
    if ((file = PD_open("ptest.pdb", "w")) == NULL)
       {printf("Error creating ptest.pdb\n");
	exit(1);};

/* define the structures to the library */
    PD_defstr(file, "l_frame",
              " float x_min",
              "float x_max",
              "float y_min",
              "float y_max",
              LAST);

    PD_defstr(file, "myplot",
              "float x_axis(10)",
              "float y_axis(10)",
              "integer npts", 
              "char * label",
              "l_frame * view",
               LAST);

/* put some values in the structures */
    mypl.label = SC_strsavef("Myplot MYPL label", "PDPTST:main mypl");
    mypl.view = FMAKE(l_frame, "Myplot MYPL view");

    mypl.view->x_min = 0.1;
    mypl.view->x_max = 0.8;
    mypl.view->y_min = 0.2;
    mypl.view->y_max = 0.7;
    mypl.npts       = 10;
   
    for (i = 0; i < 10; i++)
        mypl.x_axis[i] = mypl.y_axis[i] = (float)i;

/* Two threads write the file */
    pthread_create(&threads[0], NULL, writeit, NULL);
    pthread_create(&threads[1], NULL, writeit2, NULL);

    pthread_join(threads[0], NULL);
    pthread_join(threads[1], NULL);

/* flush the tables to the file */
    if (!PD_flush(file))
       {printf("Error flushing file before reads\n");
        exit(1);};

/* Two threads read the file */
    pthread_create(&threads[2], NULL, readit, NULL);
    pthread_create(&threads[3], NULL, readit2, NULL);

    pthread_join(threads[2], NULL);
    pthread_join(threads[3], NULL);

/* close file */
    PD_close(file);

    exit(0);}

/*--------------------------------------------------------------------------    */
/*--------------------------------------------------------------------------    */

/* Write variables to the already opened file.  The number of variables written */
/* is a function of the number of iterations specified.                         */

void *writeit(arg)
   void *arg;
   {int i, n;
    myplot *xp;
    char sname1[100], sname2[100], sname3[100], suffix[10];

    xp = FMAKE(myplot, "Writeit:xp");
    xp->view = FMAKE(l_frame, "Writeit:xp->view");

    xp->label = SC_strsavef("Dynamic XP label", "char*:writeit:xp");
    xp->view->x_min = 0.2;
    xp->view->x_max = 0.9;
    xp->view->y_min = 0.33;
    xp->view->y_max = 0.99;
    xp->npts       = 10;

    for (i = 0; i < 10; i++)
        xp->x_axis[i] = xp->y_axis[i] = (float)i * 4.0;
         
    strcpy(sname1, "mypl_wr1a"); 
    strcpy(sname2, "xpl_wr1a"); 
    strcpy(sname3, "mypl_wr1b"); 

    for (n = 0; n < n_iter; n++)    
        {sprintf(suffix, "%d", n);

         strcpy(sname1+9, suffix);
         strcpy(sname2+8, suffix);
         strcpy(sname3+9, suffix);

        if (!PD_write(file, sname1, "myplot", &mypl))
           {printf("Error writing %s-exiting\n", sname1);
            exit(1);}

        if (!PD_write(file, sname2, "myplot *", &xp))
           {printf("Error writing %s-exiting\n", sname2);
            exit(1);}

        if (!PD_write(file, sname3, "myplot", &mypl))
           {printf("Error writing %s-exiting\n", sname3);
            exit(1);};}

    SFREE(xp->label);
    SFREE(xp->view);
    SFREE(xp);

    return NULL;}
     
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

void *writeit2(arg)
   void *arg;
   {int i, n;
    char sname1[100], sname2[100], suffix[100];
    myplot xplot;

    xplot.label = SC_strsavef("Myplot Xplot label", "char*:writeit2:xplot");
    xplot.view = FMAKE(l_frame, "Xplot.view:writeit2");

    xplot.view->x_min = 0.15;
    xplot.view->x_max = 0.85;
    xplot.view->y_min = 0.25;
    xplot.view->y_max = 0.75;
    xplot.npts       = 10;

    for (i = 0; i < 10; i++)
        xplot.x_axis[i] = xplot.y_axis[i] = (float)i;

    strcpy(sname1, "mypl_wr2a"); 
    strcpy(sname2, "xpl_wr2a"); 

    for (n = 0; n < n_iter; n++)
        {sprintf(suffix, "%d", n);

         strcpy(sname1+9, suffix);
         strcpy(sname2+8, suffix);

         if (!PD_write(file, sname1, "myplot", &xplot))
            {printf("Error writing %s-exiting\n", sname1);
             exit(1);}       

         if (!PD_write(file, sname2, "myplot", &xplot))
            {printf("Error writing %s-exiting\n", sname2);
             exit(1);};}

    SFREE(xplot.label);
    SFREE(xplot.view);
 
    return NULL;}
     
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

void *readit(arg)
   void *arg;
   {int i, n;
    myplot *xp, *rxp, rmypl;
    char sname1[100], sname2[100], sname3[100], suffix[10];

    xp = FMAKE(myplot, "Writeit:xp");
    xp->view = FMAKE(l_frame, "Writeit:xp->view");

    xp->label = SC_strsavef("Dynamic XP label", "char*:writeit:xp");
    xp->view->x_min = 0.2;
    xp->view->x_max = 0.9;
    xp->view->y_min = 0.33;
    xp->view->y_max = 0.99;
    xp->npts       = 10;

    for (i = 0; i < 10; i++)
        xp->x_axis[i] = xp->y_axis[i] = (float)i * 4.0;

    strcpy(sname1, "mypl_wr1a"); 
    strcpy(sname2, "xpl_wr1a"); 
    strcpy(sname3, "mypl_wr1b"); 

    for (n = 0; n < n_iter; n++)    
        {sprintf(suffix, "%d", n);

         strcpy(sname1+9, suffix);
         strcpy(sname2+8, suffix);
         strcpy(sname3+9, suffix);

        if (!PD_read(file, sname1, &rmypl))
           {printf("Error writing %s-exiting\n", sname1);
            exit(1);}

/* compare with original */
        check_myplot1(mypl, rmypl);

/* free the memory */    
        SFREE(rmypl.label);
        SFREE(rmypl.view);

        if (!PD_read(file, sname2, &rxp))
           {printf("Error writing %s-exiting\n", sname2);
            exit(1);}

/* compare with original */
        check_myplot2(xp, rxp);

/* free the memory   */ 
        SFREE(rxp->label);
        SFREE(rxp->view);
        SFREE(rxp);

        if (!PD_read(file, sname3, &rmypl))
           {printf("Error writing %s-exiting\n", sname3);
            exit(1);};

/* compare with original */
        check_myplot1(mypl, rmypl);

/* free the memory    */
        SFREE(rmypl.label);
        SFREE(rmypl.view);}


    SFREE(xp->label);
    SFREE(xp->view);
    SFREE(xp);

    return NULL;}
     
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

void *readit2(arg)
   void *arg;
   {int i, n;
    char sname1[100], sname2[100], suffix[100];
    myplot xplot, rxplot;

    xplot.label = SC_strsavef("Myplot Xplot label", "char*:writeit2:xplot");
    xplot.view = FMAKE(l_frame, "Xplot.view:writeit2");

    xplot.view->x_min = 0.15;
    xplot.view->x_max = 0.85;
    xplot.view->y_min = 0.25;
    xplot.view->y_max = 0.75;
    xplot.npts       = 10;

    for (i = 0; i < 10; i++)
        xplot.x_axis[i] = xplot.y_axis[i] = (float)i;

    strcpy(sname1, "mypl_wr2a"); 
    strcpy(sname2, "xpl_wr2a"); 

    for (n = 0; n < n_iter; n++)
        {sprintf(suffix, "%d", n);

         strcpy(sname1+9, suffix);
         strcpy(sname2+8, suffix);

         if (!PD_read(file, sname1, &rxplot))
            {printf("Error writing %s-exiting\n", sname1);
             exit(1);}       

/* compare with original */
         check_myplot1(xplot, rxplot);

/* free the memory    */
         SFREE(rxplot.label);
         SFREE(rxplot.view);

         if (!PD_read(file, sname2, &rxplot))
            {printf("Error writing %s-exiting\n", sname2);
             exit(1);};

/* compare with original */
         check_myplot1(xplot, rxplot);

/* free the memory    */
        SFREE(rxplot.label);
        SFREE(rxplot.view);}


    SFREE(xplot.label);
    SFREE(xplot.view);
 
    return NULL;}
     
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PRINT_HELP - print a help message */

void print_help()
   {PRINT(STDOUT, "\nPDSMP - run basic PDB smp test\n\n");
    PRINT(STDOUT, "Usage: pdsmp [-h] [-i n]\n");
    PRINT(STDOUT, "\n");
    PRINT(STDOUT, "       h - print this help message and exit\n");
    PRINT(STDOUT, "       i n - set number of iterations in reading and writing loops to n\n");
    PRINT(STDOUT, "\n");

    return;}
