/*
 * GLOIN.H - header supporting the internals for mesh generation
 *         - for the LR global package
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#ifndef PCK_GLOIN

#define PCK_GLOIN

#include <sx.h>
#include "global.h"
#include "mesh.h"

#define PARLLL      1
#define OPPST       0
#define INTERSECT  -1
#define CONTAINED  -2

/*--------------------------------------------------------------------------*/

/*                           PROCEDURAL MACROS                              */

/*--------------------------------------------------------------------------*/

/* INTRS_P - return TRUE if two segments with the same direction have
 *         - a non-vanishing intersection
 */

#define INTRS_P(x1, x2, x3, x4)                                              \
    !(((x1 < x2) && ((x2-x3 < TOLERANCE) || (x4-x1 < TOLERANCE))) ||         \
      ((x1 > x2) && ((x3-x2 < TOLERANCE) || (x1-x4 < TOLERANCE))))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* INTRS_A - return TRUE if two segments with opposite dircetion have
 *         - a non-vanishing intersection
 */

#define INTRS_A(x1, x2, x3, x4)                                              \
    !(((x1 < x2) && ((x2-x4 < TOLERANCE) || (x3-x1 < TOLERANCE))) ||         \
      ((x1 > x2) && ((x4-x2 < TOLERANCE) || (x1-x3 < TOLERANCE))))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SAME - return TRUE is the points are too close */

#define SAME(x1, y1, x2, y2)                                                 \
    ((ABS(x1-x2) < TOLERANCE) && (ABS(y1-y2) < TOLERANCE))

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* CLOSETO - return TRUE is the numbers are close enough */

#define CLOSETO(x1, x2)                                                      \
    ((ABS(x1-x2) < TOLERANCE))

/*--------------------------------------------------------------------------*/

/*                           TYPEDEFS AND STRUCTS                           */

/*--------------------------------------------------------------------------*/

struct s_mesh_quality
   {double skew;
    double jac;
    double orth;};

typedef struct s_mesh_quality mesh_quality;

/*--------------------------------------------------------------------------*/

/*                           PACKAGE VARIABLES                              */

/*--------------------------------------------------------------------------*/

extern int
 graphics_init,
 mesh_acolor,
 mesh_bcolor,
 mesh_bndry,
 mesh_bndry_r,
 mesh_grid,
 mesh_kmax,
 mesh_kmin,
 mesh_lmax,
 mesh_lmin,
 mesh_mcolor,
 mesh_mesh,
 mesh_mesh_r,
 mesh_plots,
 mesh_plot_log,
 mesh_plot_phys,
 mesh_plots_r,
 mesh_scatter,
 mesh_tcolor,
 mesh_vcolor,
 mesh_vectr,
 mesh_vectr_r,
 window_init;

extern HASHTAB
 *curves,
 *swtab;

extern double
 *apk,
 *apl,
 *kra,
 *lra;

extern int
 N_parts,
 N_plots,
 N_regs;

extern char
 *DOMAIN_MAP_S,
 *MESH_CURVE;

extern REAL
 mesh_botspace,
 mesh_gxmax,
 mesh_gxmin,
 mesh_gymax,
 mesh_gymin,
 mesh_leftspace,
 mesh_rightspace,
 mesh_topspace,
 mesh_xmax,
 mesh_xmin,
 mesh_ymax,
 mesh_ymin,
 pc,
 xmn,
 xmx,
 ymn,
 ymx;

extern PG_device
 *mesh_display,
 *mesh_PS_display;

/*--------------------------------------------------------------------------*/

/*                           PACKAGE FUNCTIONS                              */

/*--------------------------------------------------------------------------*/

/* GPLOT.C declarations */

extern void
 DECLARE(global_end_graphics, (int err)),
 DECLARE(turn, (byte)),
 DECLARE(viewh, (byte)),
 DECLARE(plot, (int new, char *name)),
 DECLARE(printh, (byte)),
 DECLARE(printscr, (int new, char *name));

extern int
 DECLARE(make_frame, (byte)),
 DECLARE(mesh_init_graphics_state, (byte)),
 DECLARE(mesh_set_graphics_state, (PG_device *d)),
 DECLARE(meshlmt, (byte)),
 DECLARE(plotw, (PG_device *dev, int new, char *name)),
 DECLARE(newframew, (PG_device *dev, int new)),
 DECLARE(matsw, (PG_device *dev, int refl)),
 DECLARE(plot_leg, (PG_device *dev, PM_side *base, int refl)),
 DECLARE(meshw, (PG_device *dev, int refl)),
 DECLARE(velw, (PG_device *dev, int refl));


/* GINIT.C declarations */

extern int
 DECLARE(LR_get_data, (double *pnz, double *pnc, double *pt, double *pdt,
		       char **prs, char **ped, char **ppp, char **pgf)),
 DECLARE(part_reg, (char *s));

extern void
 DECLARE(comp_volume, (byte)),
 DECLARE(assign_globals, (byte));


/* GMESH.C declarations */

extern double
 DECLARE(comp_ratio, (double b0, int nz));

extern void
 DECLARE(make_mesh, (byte)),
 DECLARE(clearh, (byte)),
 DECLARE(parth, (byte)),
 DECLARE(recth, (byte)),
 DECLARE(sideh, (byte)),
 DECLARE(endpth, (byte)),
 DECLARE(curveh, (byte)),
 DECLARE(LR_clean_variable, (double *v));

extern int
 DECLARE(what_axis, (char *s, char **sub)),
 DECLARE(rl_mesh, (byte)),
 DECLARE(make_lrm, (byte)),
 DECLARE(fill_mesh, (PM_part *parts)),
 DECLARE(resize, (int npt, int nz)),
 DECLARE(chck_part, (PM_part *parts)),
 DECLARE(map_tree, (PM_side *base)),
 DECLARE(map_base, (PM_side *base)),
 DECLARE(norm_cline, (PM_conic_curve *cp)),
 DECLARE(containsw, (double xr, double yr)),
 DECLARE(inside,
	 (double xr, double yr, double x1, double y1, double x2, double y2,
	  double x3, double y3, double x4, double y4)),
 DECLARE(gen_dumpw, (HASHTAB *curves));

extern PM_conic_curve
 *DECLARE(rd_cline, (char *s)),
 *DECLARE(atocur, (char *s));

extern mesh_quality
 *DECLARE(compute_mesh_quality, (byte));


/* GPP.C declarations */

extern PM_set
 *DECLARE(_LR_get_n_set, (PA_plot_request *pr, char *name)),
 *DECLARE(_LR_get_pseudo_set, (PA_plot_request *pr, char *name)),
 *DECLARE(LR_build_domain, (char *base_name, C_array *arr, double t)),
 *DECLARE(LR_get_set, (char *name, int *pcent, C_array *arr, int space));

extern PM_mapping
 *DECLARE(LR_build_mapping, (PA_plot_request *pr, double t)),
 *DECLARE(LR_build_pseudo_mapping, (PA_plot_request *pr, double t));

extern int
 DECLARE(LR_flatten_space, (PA_plot_request *pr)),
 DECLARE(LR_flatten_plots, (byte)),
 DECLARE(LR_get_domain_zone, (PA_plot_request *pr)),
 DECLARE(LR_plot_accept, (PA_plot_request *pr, ...));

extern void
 DECLARE(LR_init_io, (PA_package *pck, PFVoid func)),
 DECLARE(LR_set_set_limits, (int *maxes, int centering)),
 DECLARE(LR_expand_plot_data, (PA_plot_request *pr, int ni));

extern double
 *DECLARE(LR_map_centers, (double *data, int centering));

extern object
 *DECLARE(LR_int_plot, (PG_device *dev, char *rname, int centering,
			int nde, double **elem)),
 *DECLARE(LR_var_plot, (object *argl)),
 *DECLARE(LR_get_time_data, (byte)),
 *DECLARE(LR_get_mesh_data, (byte)),
 *DECLARE(LR_def_domain, (object *argl));

#endif

