
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: matrix.h,v 1.2 1999/07/06 19:47:59 stes Exp $
 */

#ifndef __CAMATRIX_HEADER__
#define __CAMATRIX_HEADER__

#include "cobject.h"

@interface Matrix : CAObject
{
  id rows;
  id scalarZero;
  id emptyVector;
}

+ diagonal:cltnOfScalars;
+ circulant:cltnOfScalars;
+ companion:cltnOfScalars;
+ hankel:rowScalars:colScalars;
+ toeplitz:rowScalars:colScalars;
+ hilbert:(int)n;

+ scalar:aScalar numRows:(int)numRows numColumns:(int)numColumns;
- copy;
- deepCopy;
- emptyVector;

- scalarZero;
- rows;
- (int) numRows;
- (int) numColumns;
- (BOOL) isEqual:aMatrix;
- (unsigned) hash;
- (BOOL) isDiagonal;
- (BOOL) isSymmetric;
- (BOOL) isAntiSymmetric;

- insertRow:aVector;
- insertRow:aVector at:(int)i;
- insertColumn:aCollection;
- insertColumn:aCollection at:(int)i;

- removeRow;
- removeRowAt:(int)i;
- removeColumn;
- removeColumnAt:(int)i;

- placeScalar:aScalar at:(int)i:(int)j;
- replaceScalarAt:(int)i:(int)j with:aScalar;

- asNumerical;
- asModp:(unsigned short)p;
- onCommonDenominator:(id *)denominator;

- rowAt:(int)i;
- eachRow;
- eachScalar;
- eachSequence;
- (float) floatValueAt:(int)i:(int)j;

- zero;
- negate;
- double;
- add:b;
- subtract:b;
- addScalar:s;
- subtractScalar:s;

- one;
- square;
- multiply:b;
- multiplyVector:aColumn;

- multiplyScalar:b;
- divideScalar:b;

- transpose;

- determinant;
- solveVector:y;
- inverse;
- divide:b;
- (int) rank;
- (int) nullity;
- kernel;
- image;

- trace;
- adjoint;

- printOn:(IOD)aFile;
@end

#endif /* __CAMATRIX_HEADER__ */
 
