(*
 *                     The OCaml-gtk interface
 *
 * Copyright (c) 1997-99   David Monniaux, Pascal Cuoq, Sven Luther
 *
 * This file is distributed under the conditions described in
 * the file LICENSE.  
 *)

(* $Id: gtk.ml,v 1.50 1999/09/17 12:06:55 cuoq Exp $ *)

type update_policy =
    UPDATE_CONTINUOUS
  | UPDATE_DISCONTINUOUS
  | UPDATE_DELAYED

type button_box_layout_style =
    BUTTONBOX_DEFAULT_STYLE
  | BUTTONBOX_SPREAD
  | BUTTONBOX_EDGE
  | BUTTONBOX_START
  | BUTTONBOX_END

type arrow_type =
    ARROW_UP
  | ARROW_DOWN
  | ARROW_LEFT
  | ARROW_RIGHT

type curve_type =
    CURVE_TYPE_LINEAR         (* linear interpolation *)
  | CURVE_TYPE_SPLINE         (* spline interpolation *)
  | CURVE_TYPE_FREE           (* free form curve *)

type direction_type =
    DIR_TAB_FORWARD
  | DIR_TAB_BACKWARD
  | DIR_UP
  | DIR_DOWN
  | DIR_LEFT
  | DIR_RIGHT

type justification =
    JUSTIFY_LEFT
  | JUSTIFY_RIGHT
  | JUSTIFY_CENTER
  | JUSTIFY_FILL

type pack_type =
    PACK_START
  | PACK_END

type position_type =
    POS_LEFT
  | POS_RIGHT
  | POS_TOP
  | POS_BOTTOM

type selection_type =
    SELECTION_SINGLE
  | SELECTION_BROWSE
  | SELECTION_MULTIPLE
  | SELECTION_EXTENDED

type shadow_type =
    SHADOW_NONE
  | SHADOW_IN
  | SHADOW_OUT
  | SHADOW_ETCHED_IN
  | SHADOW_ETCHED_OUT

type window_type =
    WINDOW_TOPLEVEL
  | WINDOW_DIALOG
  | WINDOW_POPUP

type style =
  {
    font : Gdk.font;
    fg_gc : Gdk.gc array;
    fg_gc_0 : Gdk.gc;
    fg_gc_1 : Gdk.gc;
    fg_gc_2 : Gdk.gc;
    fg_gc_3 : Gdk.gc;
    fg_gc_4 : Gdk.gc;
    black_gc : Gdk.gc;
    white_gc : Gdk.gc;
    colormap : Gdk.colormap
  } 

type allocation =
  {
    x : int;
    y : int;
    width : int;
    height : int;
  } 

module Unsafe = struct
open Glib

type gtkobject

type gtkArg =
    Unit
  | Other
  | Invalid
  | Bool of bool
  | Char of char
  | Int of int
  | Float of float
  | String of string
  | Pointer of Pointer.t

type gtkCallBack = gtkobject->gtkArg list->gtkArg

(* ###### 3. Objects *)
(* ### 3.1 Type utility functions *)
(* ### 3.2 Object functions *)
external object_set_data : gtkobject->string->'a->unit = "mlgtk_object_set_data"
external object_get_data : gtkobject->string->'a = "mlgtk_object_get_data"
external object_free_data : gtkobject->string->bool = "mlgtk_object_free_data"
let object_set_user_data gtkobj data = object_set_data gtkobj "user_data" data
let object_get_user_data gtkobj = object_get_data gtkobj "user_data"
let object_free_user_data gtkobj = object_free_data gtkobj "user_data"

(* ###### 4. Signals *)
(* signal_new : not enough doc *)
(* signal_lookup *)
(* signal_name *)
(* signal_emit *)
(* signal_emit_by_name *)
(* signal_emit_stop *)
(* signal_emit_stop_by_name *)
external signal_connect : gtkobject->string->gtkCallBack->int =
    "mlgtk_signal_connect" (* actually signal_connect_interp *)
(* signal_connect_after *)
(* signal_connect_object *)
(* signal_connect_object_after *)
(* signal_connect_interp : renamed to signal_connect *)
external signal_disconnect : gtkobject->int->unit = "mlgtk_signal_disconnect"
(* signal_disconnect_by_data *)
(* signal_handler_block *)
(* signal_handler_block_by_data *)
(* signal_handler_unblock *)
(* signal_handler_unblock_by_data *)
(* signal_handler_destroy *)
(* signal_default_marshaller *)
(* signal_set_funcs *)

(* ###### 5. Widgets *)
(* ### 5.1 Alignment widget *)
(* alignment_get_type *)
external alignment_new : float->float->float->float->gtkobject =
  "mlgtk_alignment_new"
external alignment_set : gtkobject->float->float->float->float->unit =
  "mlgtk_alignment_set"
(* ALIGNMENT *)
(* ALIGNMENT_CLASS *)
(* IS_ALIGNMENT *)

(* ### 5.2 Arrow widget *)
(* arrow_get_type *)
external arrow_new : arrow_type->shadow_type->gtkobject = "mlgtk_arrow_new"
external arrow_set : gtkobject->arrow_type->shadow_type->unit =
  "mlgtk_arrow_set"
(* ARROW *)
(* ARROW_CLASS *)
(* IS_ARROW *)

(* ### 5.3 Aspect frame widget *)
(* aspect_frame_get_type *)
external aspect_frame_new : string->float->float->float->bool->gtkobject =
  "mlgtk_aspect_frame_new"
external aspect_frame_set :
  gtkobject->float->float->float->bool->unit =
  "mlgtk_aspect_frame_set"
(* ASPECT_FRAME *)
(* ASPECT_FRAME_CLASS *)
(* IS_ASPECT_FRAME *)

(* ### 5.4 Bin widget *)
(* bin_get_type *)
(* BIN *)
(* BIN_CLASS *)
(* IS_BIN *)

(* ### 5.5 Box widget *)
(* box_get_type *)
external box_pack_start : gtkobject->gtkobject->bool->bool->int->unit 
    = "mlgtk_box_pack_start"
external box_pack_end : gtkobject->gtkobject->bool->bool->int->unit 
    = "mlgtk_box_pack_end"
let box_pack_start_defaults box widget= box_pack_start box widget true true 0
let box_pack_end_defaults box widget= box_pack_end box widget true true 0
external box_set_homogeneous : gtkobject->bool->unit 
    = "mlgtk_box_set_homogeneous"
external box_set_spacing : gtkobject->int->unit 
    = "mlgtk_box_set_spacing"
external box_reorder_child : gtkobject->gtkobject->int->unit 
    = "mlgtk_box_reorder_child"
external box_query_child_packing : 
    gtkobject -> gtkobject -> bool*bool*int*pack_type 
        = "mlgtk_box_query_child_packing" 
external box_set_child_packing :
  gtkobject->gtkobject->bool->bool->int->pack_type->unit 
      = "mlgtk_box_set_child_packing_bytecode" "mlgtk_box_set_child_packing"
(* BOX *)
(* BOX_CLASS *)
(* IS_BOX *)

(* ### 5.6 Button box widget *)
(* button_box_get_type *)
external button_box_set_child_size : gtkobject->int->int->unit=
  "mlgtk_button_box_set_child_size"
external button_box_set_child_ipadding : gtkobject->int->int->unit=
  "mlgtk_button_box_set_child_ipadding"
external button_box_set_layout : gtkobject->button_box_layout_style->unit=
  "mlgtk_button_box_set_layout"
external button_box_get_spacing : gtkobject->int=
  "mlgtk_button_box_get_spacing"
external button_box_get_child_size : gtkobject->int*int=
  "mlgtk_button_box_get_child_size"
external button_box_get_child_ipadding : gtkobject->int*int=
  "mlgtk_button_box_get_child_ipadding"
external button_box_get_layout : gtkobject->button_box_layout_style=
  "mlgtk_button_box_get_layout"
(* BUTTON_BOX *)
(* BUTTON_BOX_CLASS *)
(* IS_BUTTON_BOX *)

(* ### 5.7 Button widget *)
(* button_get_type *)
external button_new : unit->gtkobject = "gtk_button_new"
external button_new_with_label : string->gtkobject = "mlgtk_button_new_with_label"
external button_pressed : gtkobject->unit = "mlgtk_button_pressed"
external button_released : gtkobject->unit = "mlgtk_button_released"
external button_clicked : gtkobject->unit = "mlgtk_button_clicked"
external button_enter : gtkobject->unit = "mlgtk_button_enter"
external button_leave : gtkobject->unit = "mlgtk_button_leave"
(* BUTTON *)
(* BUTTON_CLASS *)
(* IS_BUTTON *)

(* ### 5.8 Check button widget *)
(* check_button_get_type *)
external check_button_new : unit->gtkobject = "gtk_check_button_new"
external check_button_new_with_label : string->gtkobject
    = "mlgtk_check_button_new_with_label"
(* CHECK_BUTTON *)
(* CHECK_BUTTON_CLASS *)
(* IS_CHECK_BUTTON *)

(* ### 5.9 Check menu item widget *)
(* check_menu_item_get_type *)
external check_menu_item_new : unit->gtkobject = "gtk_check_menu_item_new"
external check_menu_item_new_with_label : string->gtkobject = "mlgtk_check_menu_item_new_with_label"
external check_menu_item_set_state : gtkobject->bool->unit = "mlgtk_check_menu_item_set_state"
external check_menu_item_toggled : gtkobject->unit = "mlgtk_check_menu_item_toggled"
(* CHECK_MENU_ITEM *)
(* CHECK_MENU_ITEM_CLASS *)
(* IS_CHECK_MENU_ITEM *)

(* ### 5.10 Compound list *)
(* clist_get_type *)
external clist_new : int->gtkobject = "mlgtk_clist_new"
(* clist_new_with_titles $$$ *)
external clist_set_border : gtkobject->shadow_type->unit 
    = "mlgtk_clist_set_border"
external clist_set_selection_mode : gtkobject->selection_type->unit 
    = "mlgtk_clist_set_selection_mode"
external clist_freeze : gtkobject->unit = "mlgtk_clist_freeze"
external clist_thaw : gtkobject->unit = "mlgtk_clist_thaw"
external clist_column_titles_show : gtkobject->unit 
    = "mlgtk_clist_column_titles_show"
external clist_column_titles_hide : gtkobject->unit 
    = "mlgtk_clist_column_titles_hide"
external clist_set_column_title : gtkobject->int->string->unit 
    = "mlgtk_clist_set_column_title"
external clist_set_column_widget : gtkobject->int->gtkobject->unit 
    = "mlgtk_clist_set_column_widget"
external clist_set_column_justification : gtkobject->int->justification->unit 
    = "mlgtk_clist_set_column_justification"
external clist_set_column_width : gtkobject->int->int->unit 
    = "mlgtk_clist_set_column_width"
external clist_set_row_height : gtkobject->int->unit 
    = "mlgtk_clist_set_row_height"
external clist_moveto : gtkobject->int->int->float->float->unit 
    = "mlgtk_clist_moveto"
external clist_set_text : gtkobject->int->int->string->unit 
    = "mlgtk_clist_set_text"
external clist_get_text : gtkobject->int->int->string
    = "mlgtk_clist_get_text"
(* clist_set_pixmap $$$ *)
(* clist_setpixtext $$$ *)
(* clist_set_foreground $$$ *)
(* clist_set_background $$$ *)
external clist_set_shift : gtkobject->int->int->int->int->unit 
    = "mlgtk_clist_set_shift"
external clist_append : gtkobject->string array->int = "mlgtk_clist_append"
external clist_prepend : gtkobject->string array->int = "mlgtk_clist_prepend"
external clist_insert : gtkobject->int->string array->unit 
    = "mlgtk_clist_insert"
external clist_remove : gtkobject->int->unit = "mlgtk_clist_remove"
external clist_set_row_data : gtkobject->int->'a->unit =
  "mlgtk_clist_set_row_data"
external clist_get_row_data : gtkobject->int->'a =
  "mlgtk_clist_get_row_data"
external clist_select_row : gtkobject -> int -> int -> unit 
    = "mlgtk_clist_select_row"
external clist_unselect_row : gtkobject->int->int->unit 
    = "mlgtk_clist_unselect_row"
external clist_clear : gtkobject->unit = "mlgtk_clist_clear"
(* CLIST *)
(* CLIST_CLASS *)
(* IS_CLIST *)

(* ### 5.11 Color selector *)
(* color_selection_get_type *)
external color_selection_new : unit->gtkobject = "gtk_color_selection_new"
external color_selection_set_update_policy : gtkobject->update_policy->unit =
  "mlgtk_color_selection_set_update_policy"
external color_selection_set_color : gtkobject->(float*float*float*float)->unit
    = "mlgtk_color_selection_set_color"
external color_selection_get_color : gtkobject->(float*float*float*float) 
    = "mlgtk_color_selection_get_color"
external color_selection_set_opacity : gtkobject->bool->unit 
    = "mlgtk_color_selection_set_opacity"
(* color_selection_dialog_get_type *)
(* color_selection_dialog_new $$$ *)
(* COLOR_SELECTION *)
(* COLOR_SELECTION_CLASS *)
(* IS_COLOR_SELECTION *)

(* ### 5.12 Combo widget *)
(* combo_get_type *)
external combo_new : unit->gtkobject = "gtk_combo_new"
external combo_set_value_in_list : gtkobject->bool->bool->unit =
  "mlgtk_combo_set_value_in_list"
external combo_set_use_arrows : gtkobject->bool->unit = "mlgtk_combo_set_use_arrows"
external combo_set_use_arrows_always : gtkobject->bool->unit =
  "mlgtk_combo_set_use_arrows_always"
external combo_set_case_sensitive : gtkobject->bool->unit = "mlgtk_combo_set_case_sensitive"
external combo_set_item_string : gtkobject->gtkobject->string->unit =
  "mlgtk_combo_set_item_string"
external combo_set_popdown_strings : gtkobject->gtkobject GList.t->unit=
  "mlgtk_combo_set_popdown_strings"
external combo_get_entry : gtkobject -> gtkobject =
  "mlgtk_combo_get_entry"
external combo_get_button : gtkobject -> gtkobject =
  "mlgtk_combo_get_button"
external combo_disable_activate : gtkobject -> unit =
  "mlgtk_combo_disable_activate"
(* COMBO *)
(* COMBO_CLASS *)
(* IS_COMBO *)

(* ### 5.13 Container widget *)
(* container_get_type *)
external container_border_width : gtkobject->int->unit =
  "mlgtk_container_border_width"
external container_add : gtkobject->gtkobject->unit = "mlgtk_container_add"
external container_remove : gtkobject->gtkobject->unit = "mlgtk_container_remove"
external container_block_resize : gtkobject->unit = "mlgtk_container_block_resize"
external container_unblock_resize : gtkobject->unit = "mlgtk_container_unblock_resize"
external container_need_resize : gtkobject->unit = "mlgtk_container_need_resize"
external container_foreach : gtkobject->(gtkobject->unit)->unit= "mlgtk_container_foreach"
external container_focus : gtkobject->direction_type->unit= "mlgtk_container_focus"
external container_children : gtkobject->gtkobject GList.t= "gtk_container_children"
(* CONTAINER *)
(* CONTAINER_CLASS *)
(* IS_CONTAINER *)

(* ### 5.14 Multi-column tree widget *)
(* PAS DISPONIBLE DANS gtk 1.0.6 *)
(* ctree_get_type *)
(* ctree_new $$$ *)
(* ctree_new_with_titles $$$ *)
(* ctree_insert $$$ *)
(* ctree_remove $$$ *)
(* ctree_clear $$$ *)
(* ctree_post_recursive $$$ *)
(* ctree_pre_recursive $$$ *)
(* ctree_is_visible $$$ *)
(* CTREE *)
(* CTREE_CLASS *)
(* IS_CTREE *)

(* ### 5.15 Curve widget *)
(* curve_get_type *)
external curve_new : unit->gtkobject= "gtk_curve_new"
external curve_reset : gtkobject->unit= "mlgtk_curve_reset"
external curve_set_gamma : gtkobject->float->unit= "mlgtk_curve_set_gamma"
external curve_set_range : gtkobject->float->float->float->float->unit =
  "mlgtk_curve_set_range"
external curve_get_vector : gtkobject->float array->unit= "mlgtk_curve_get_vector"
external curve_set_vector : gtkobject->float array->unit= "mlgtk_curve_set_vector"
external curve_set_curve_type : gtkobject->curve_type->unit= "mlgtk_curve_set_curve_type"
(* CURVE *)
(* CURVE_CLASS *)
(* IS_CURVE *)

(* ### 5.16 Gamma curve widget *)
(* gamma_curve_get_type *)
external gamma_curve_new : unit->gtkobject= "gtk_gamma_curve_new"
(* GAMMACURVE *)
(* GAMMACURVE_CLASS *)
(* IS_GAMMACURVE *)

(* ### 5.17 Dialog widget *)
(* dialog_get_type *)
external dialog_new : unit->gtkobject = "gtk_dialog_new"
external dialog_get_action_area : gtkobject->gtkobject =
  "mlgtk_dialog_get_action_area"
external dialog_get_vbox : gtkobject -> gtkobject =
  "mlgtk_dialog_get_vbox" 
(* DIALOG *)
(* DIALOG_CLASS *)
(* IS_DIALOG *)

(* ### 5.18 Drawing area widget *)
(* drawing_area_get_type *)
external drawing_area_new : unit->gtkobject = "gtk_drawing_area_new"
external drawing_area_size : gtkobject -> int -> int -> unit
  = "mlgtk_drawing_area_size"
(* DRAWING_AREA *)
(* DRAWING_AREA_CLASS *)
(* IS_DRAWING_AREA *)

(* ### 5.19 Entry widget *)
(* entry_get_type *)
external entry_new : unit->gtkobject = "mlgtk_entry_new"
external entry_new_with_max_length : int->gtkobject = "mlgtk_entry_new_with_max_length"
external entry_set_text : gtkobject->string->unit = "mlgtk_entry_set_text"
external entry_append_text : gtkobject->string->unit = "mlgtk_entry_append_text"
external entry_prepend_text : gtkobject->string->unit = "mlgtk_entry_prepend_text"
external entry_set_position : gtkobject->int->unit="mlgtk_entry_set_position"
external entry_set_visibility : gtkobject->int->unit="mlgtk_entry_set_visibility"
external entry_get_text : gtkobject->string = "mlgtk_entry_get_text"
(* ENTRY *)
(* ENTRY_CLASS *)
(* IS_ENTRY *)

(* ### 5.20 Event box widget *)
(* event_box_get_type *)
(* event_box_new *)
(* EVENT_BOX *)
(* EVENT_BOX_CLASS *)
(* IS_EVENT_BOX *)

(* ### 5.21 File selection dialog widget *)
(* file_selection_get_type *)
external file_selection_new : string -> gtkobject =
  "mlgtk_file_selection_new"
external file_selection_set_filename : gtkobject -> string -> unit =
  "mlgtk_file_selection_set_filename"
external file_selection_get_filename : gtkobject -> string =
  "mlgtk_file_selection_get_filename"
external file_selection_get_ok_button : gtkobject -> gtkobject =
  "mlgtk_file_selection_get_ok_button"
external file_selection_get_cancel_button : gtkobject -> gtkobject =
  "mlgtk_file_selection_get_cancel_button"
(* FILE_SELECTION *)
(* FILE_SELECTION_CLASS *)
(* IS_FILE_SELECTION *)

(* ### 5.22 Fixed widget *)
(* fixed_get_type *)
(* fixed_new *)
(* fixed_put_new *)
(* fixed_move *)
(* FIXED *)
(* FIXED_CLASS *)
(* IS_FIXED *)

(* ### 5.23 Frame widget *)
(* frame_get_type *)
external frame_new : string -> gtkobject =
  "mlgtk_frame_new"
external frame_set_label : gtkobject -> string -> unit =
  "mlgtk_frame_set_label"
external frame_set_label_align : gtkobject -> float -> float -> unit =
  "mlgtk_frame_set_label_align"
external frame_set_shadow_type : gtkobject -> shadow_type -> unit =
  "mlgtk_frame_set_shadow_type"
(* FRAME *)
(* FRAME_CLASS *)
(* IS_FRAME *)

(* ### 5.24 Gamma widget !? bug in manual *)

(* ### 5.25 Horizontal box widget *)
(* hbox_get_type *)
external hbox_new : bool->int->gtkobject = "mlgtk_hbox_new"
(* HBOX *)
(* HBOX_CLASS *)
(* IS_HBOX *)

(* ### 5.26 Horizontal button box widget *)
(* hbutton_box_get_type *)
external hbutton_box_new : unit -> gtkobject = "gtk_hbutton_box_new"
(* hbutton_box_set_spacing_default *)
(* hbutton_box_set_layout_default *)
(* hbutton_box_get_spacing_default *)
(* hbutton_box_get_layout_default *)
(* HBUTTON_BOX *)
(* HBUTTON_BOX_CLASS *)
(* IS_HBUTTON_BOX *)

(* ### 5.27 Horizontal paned widget *)
(* hpaned_get_type *)
external hpaned_new : unit -> gtkobject = "mlgtk_hpaned_new"
(* HPANED *)
(* HPANED_CLASS *)
(* IS_HPANED *)

(* ### 5.28 Horizontal ruler widget *)
(* hruler_get_type *)
(* hruler_new *)
(* HRULER *)
(* HRULER_CLASS *)
(* IS_HRULER *)

(* ### 5.29 Horizontal scale widget *)
(* hscale_get_type *)
(* hscale_new *)
(* HSCALE *)
(* HSCALE_CLASS *)
(* IS_HSCALE *)

(* ### 5.30 Horizontal scrollbar widget *)
(* hscrollbar_get_type *)
external hscrollbar_new : gtkobject option -> gtkobject = "mlgtk_hscrollbar_new"
(* HSCROLLBAR *)
(* HSCROLLBAR_CLASS *)
(* IS_HSCROLLBAR *)

(* ### 5.31 Horizontal separator widget *)
(* hseparator_get_type *)
external hseparator_new : unit->gtkobject = "mlgtk_hseparator_new"
(* HSEPARATOR *)
(* HSEPARATOR_CLASS *)
(* IS_HSEPARATOR *)

(* ### 5.32 Image widget *)
(* image_get_type *)
(* image_new *)
(* image_set *)
(* image_get *)
(* IMAGE *)
(* IMAGE_CLASS *)
(* IS_IMAGE *)

(* ### 5.33 Input dialog widget *)
(* input_dialog_get_type *)
(* input_dialog_new *)
(* INPUTDIALOG *)
(* INPUTDIALOG_CLASS *)
(* IS_INPUTDIALOG *)

(* ### 5.34 Item widget *)
(* item_get_type *)
(* item_select *)
(* item_deselect *)
(* item_toggle *)
(* ITEM *)
(* ITEM_CLASS *)
(* IS_ITEM *)

(* ### 5.35 Label widget *)
(* label_get_type *)
external label_new : string->gtkobject = "mlgtk_label_new"
external label_set_text : gtkobject->string->unit = "mlgtk_label_set_text"
external label_get : gtkobject->string = "mlgtk_label_get"
(* LABEL *)
(* LABEL_CLASS *)
(* IS_LABEL *)

(* ### 5.36 List widget *)
(* list_get_type *)
external list_new : unit->gtkobject = "mlgtk_list_new"
external list_insert_items : gtkobject->gtkobject GList.t->int->unit = "mlgtk_list_insert_items"
external list_append_items : gtkobject->gtkobject GList.t->unit = "mlgtk_list_append_items"
(* list_prepend_items *)
(* list_remove_items *)
(* list_clear_items *)
(* list_select_item *)
(* list_unselect_item *)
(* list_select_child *)
(* list_unselect_child *)
(* list_child_position *)
(* list_set_selection_mode *)
(* LIST *)
(* LIST_CLASS *)
(* IS_LIST *)

(* ### 5.37 List item widget *)
(* list_item_get_type *)
(* list_item_new *)
external list_item_new_with_label : string->gtkobject = "mlgtk_list_item_new_with_label"
(* list_item_select *)
(* list_item_deselect *)
(* LIST_ITEM *)
(* LIST_ITEM_CLASS *)
(* IS_LIST_ITEM *)

(* ### 5.38 Menu widget *)
(* menu_get_type *)
external menu_new : unit->gtkobject = "mlgtk_menu_new"
external menu_append : gtkobject->gtkobject->unit = "mlgtk_menu_append"
external menu_prepend : gtkobject->gtkobject->unit = "mlgtk_menu_prepend" 
external menu_insert : gtkobject->gtkobject->int->unit = "mlgtk_menu_insert"
(* menu_popup *)
external menu_popdown : gtkobject->unit = "mlgtk_menu_popdown"
external menu_get_active : gtkobject->gtkobject = "mlgtk_menu_get_active"
external menu_set_active : gtkobject->int->gtkobject = "mlgtk_menu_set_active"
(* menu_set_accelerator_table *)
(* MENU *)
(* MENU_CLASS *)
(* IS_MENU *)

(* ### 5.39 Menu bar widget *)
(* menu_bar_get_type *)
external menu_bar_new : unit->gtkobject = "mlgtk_menu_bar_new"
external menu_bar_append : gtkobject->gtkobject->unit = "mlgtk_menu_bar_append"
external menu_bar_prepend : gtkobject->gtkobject->unit = "mlgtk_menu_bar_prepend"
external menu_bar_insert : gtkobject->gtkobject->int->unit = "mlgtk_menu_bar_insert"
(* MENU_BAR *)
(* MENU_BAR_CLASS *)
(* IS_MENU_BAR *)

(* ### 5.40 Menu item widget *)
(* menu_item_get_type *)
external menu_item_new : unit->gtkobject = "gtk_menu_item_new"
external menu_item_new_with_label : string->gtkobject = "mlgtk_menu_item_new_with_label"
external menu_item_set_submenu : gtkobject->gtkobject->unit = "mlgtk_menu_item_set_submenu"
(* menu_item_set_placement *)
(* menu_item_set_accelerator_size *)
(* menu_item_set_accelerator_text *)
(* menu_item_configure *)
external menu_item_select : gtkobject->unit = "mlgtk_menu_item_select" 
external menu_item_deselect : gtkobject->unit = "mlgtk_menu_item_deselect" 
(* menu_item_activate *)
(* MENU_ITEM *)
(* MENU_ITEM_CLASS *)
(* IS_MENU_ITEM *)

(* ### 5.41 Menu shell widget *)
(* menu_shell_get_type *)
external menu_shell_append : gtkobject->gtkobject->unit = "mlgtk_menu_shell_append"
external menu_shell_prepend : gtkobject->gtkobject->unit = "mlgtk_menu_shell_prepend"
external menu_shell_insert : gtkobject->gtkobject->int->unit = "mlgtk_menu_shell_insert"
(* menu_shell_deactivate *)
(* MENU_SHELL *)
(* MENU_SHELL_CLASS *)
(* IS_MENU_SHELL *)

(* ### 5.42 Misc widget *)
(* misc_get_type *)
(* misc_set_alignment *)
(* misc_set_padding *)
(* MISC *)
(* MISC_CLASS *)
(* IS_MISC *)

(* ### 5.43 Notebook widget *)
(* notebook_get_type *)
external notebook_new : unit -> gtkobject = "mlgtk_notebook_new"
external notebook_append_page : gtkobject -> gtkobject -> gtkobject -> unit =
  "mlgtk_notebook_append_page"
external notebook_prepend_page : gtkobject -> gtkobject -> gtkobject -> unit =
  "mlgtk_notebook_prepend_page"
external notebook_insert_page : gtkobject -> gtkobject -> gtkobject -> int -> unit =
  "mlgtk_notebook_insert_page"
external notebook_remove_page : gtkobject -> int -> unit = 
"mlgtk_notebook_remove_page"
external notebook_set_page : gtkobject -> int -> unit =
"mlgtk_notebook_set_page"
external notebook_next_page : gtkobject -> unit =
"mlgtk_notebook_next_page"
external notebook_prev_page : gtkobject -> unit =
"mlgtk_notebook_prev_page"
external notebook_set_tab_pos : gtkobject -> position_type -> unit =
  "mlgtk_notebook_set_tab_pos"
external notebook_set_show_tabs : gtkobject -> bool -> unit = 
"mlgtk_notebook_set_show_tabs"
external notebook_set_show_border : gtkobject -> bool -> unit = 
"mlgtk_notebook_set_show_border"
(* NOTEBOOK *)
(* NOTEBOOK_CLASS *)
(* IS_NOTEBOOK *)

(* ### 5.44 Option menu widget *)
(* option_menu_get_type *)
(* option_menu_new *)
(* option_menu_get_menu *)
(* option_menu_set_menu *)
(* option_menu_remove_menu *)
(* option_menu_set_history *)
(* OPTION_MENU *)
(* OPTION_MENU_CLASS *)
(* IS_OPTION_MENU *)

(* ### 5.45 Paned widget *)
(* paned_get_type *)
external paned_add1 : gtkobject -> gtkobject -> unit = "mlgtk_paned_add1"
external paned_add2 : gtkobject -> gtkobject -> unit = "mlgtk_paned_add2"
external paned_handle_size_unsafe : gtkobject -> int -> unit = 
	"mlgtk_paned_handle_size"
external paned_gutter_size_unsafe : gtkobject -> int -> unit = 
	"mlgtk_paned_gutter_size" 
let paned_handle_size obj size =
	if (size land (lnot 65535))<>0
	then invalid_arg "Gtk.Unsafe.paned_handle_size"
	else paned_handle_size_unsafe obj size 
let paned_gutter_size obj size =
	if (size land (lnot 65535))<>0
	then invalid_arg "Gtk.Unsafe.paned_gutter_size"
	else paned_gutter_size_unsafe obj size 
(* PANED *)
(* PANED_CLASS *)
(* IS_PANED *)

(* ### 5.46 Pixmap widget *)
(* pixmap_get_type *)
external pixmap_new : Gdk.pixmap -> Gdk.bitmap -> gtkobject =
  "mlgtk_pixmap_new"
(* pixmap_set *)
(* pixmap_get *)
(* PIXMAP *)
(* PIXMAP_CLASS *)
(* IS_PIXMAP *)

(* ### 5.47 Preview widget *)
(* preview_get_type *)
(* preview_uninit *)
(* preview_new *)
(* preview_size *)
(* preview_put *)
(* preview_put_row *)
(* preview_draw_row *)
(* preview_set_expand *)
(* preview_set_gamma *)
(* preview_set_color_cube *)
(* preview_set_install_cmap *)
(* preview_set_reserved *)
(* preview_get_visual *)
(* preview_get_cmap *)
(* preview_get_info *)
(* PREVIEW *)
(* PREVIEW_CLASS *)
(* IS_PREVIEW *)

(* ### 5.48 Progress bar widget *)
(* progress_bar_get_type *)
external progress_bar_new : unit->gtkobject = "mlgtk_progress_bar_new"
external progress_bar_update : gtkobject->float->unit = "mlgtk_progress_bar_update"
(* PROGRESS_BAR *)
(* PROGRESS_BAR_CLASS *)
(* IS_PROGRESS_BAR *)

(* ### 5.49 Radio button widget *)
(* radio_button_get_type *)
(* radio_button_new *)
external radio_button_new_with_label : (gtkobject GSList.t option)->string->gtkobject = "mlgtk_radio_button_new_with_label"
external radio_button_group : gtkobject->gtkobject GSList.t = "gtk_radio_button_group"
(* RADIO_BUTTON *)
(* RADIO_BUTTON_CLASS *)
(* IS_RADIO_BUTTON *)

(* ### 5.50 Radio menu item widget *)
(* radio_menu_item_get_type *)
(* radio_menu_item_new *)
external radio_menu_item_new_with_label : (gtkobject GSList.t option)->string->gtkobject = "mlgtk_radio_menu_item_new_with_label"
external radio_menu_item_group : gtkobject->gtkobject GSList.t = "gtk_radio_menu_item_group"
(* RADIO_MENU_ITEM *)
(* RADIO_MENU_ITEM_CLASS *)
(* IS_RADIO_MENU_ITEM *)

(* ### 5.51 Range widget *)
(* range_get_type *)
(* range_get_adjustment *)
(* range_set_update_policy *)
(* range_set_adjustment *)
(* range_draw_background *)
(* range_draw_through *)
(* range_draw_slider *)
(* range_draw_step_forw *)
(* range_draw_step_BACK *)
(* range_slider_update *)
(* range_through_click *)
(* range_default_hslider_update *)
(* range_default_vslider_update *)
(* range_default_hthrough_click *)
(* range_default_vthrough_click *)
(* range_default_hmotion *)
(* range_default_vmotion *)
(* range_calc_value *)
(* RANGE *)
(* RANGE_CLASS *)
(* IS_RANGE *)

(* ### 5.52 Ruler widget *)
(* ruler_get_type *)
(* ruler_set_metric *)
(* ruler_set_range *)
(* ruler_draw_ticks *)
(* ruler_draw_pos *)
(* RULER *)
(* RULER_CLASS *)
(* IS_RULER *)

(* ### 5.53 Scale widget *)
(* scale_get_type *)
(* scale_set_digits *)
(* scale_set_draw_value *)
(* scale_set_value_pos *)
(* scale_value_width *)
(* scale_draw_value *)
(* SCALE *)
(* SCALE_CLASS *)
(* IS_SCALE *)

(* ### 5.54 Scrollbar widget *)
(* scrollbar_get_type *)
(* SCROLLBAR *)
(* SCROLLBAR_CLASS *)
(* IS_SCROLLBAR *)

(* ### 5.55 Scrolled window widget *)
(* scrolled_window_get_type *)
external scrolled_window_new : unit -> gtkobject =
  "mlgtk_scrolled_window_new"
external scrolled_window_add_with_viewport : gtkobject -> gtkobject -> unit =
  "mlgtk_scrolled_window_add_with_viewport"
  
(* scrolled_window_get_hadjustment *)
(* scrolled_window_get_vadjustment *)
(* scrolled_window_set_policy *)
(* SCROLLED_WINDOW *)
(* SCROLLED_WINDOW_CLASS *)
(* IS_SCROLLED_WINDOW *)

(* ### 5.56 Separator widget *)
(* separator_get_type *)
(* SEPARATOR *)
(* SEPARATOR_CLASS *)
(* IS_SEPARATOR *)

(* ### 5.57 Statusbar widget *)
external statusbar_new :unit->gtkobject = "mlgtk_statusbar_new"
external statusbar_get_context_id :gtkobject->string->int
 = "mlgtk_statusbar_get_context_id"
external statusbar_push :gtkobject->int->string->int = "mlgtk_statusbar_push"
external statusbar_pop :gtkobject->int->unit = "mlgtk_statusbar_pop"
external statusbar_remove :gtkobject->int->int->unit = "mlgtk_statusbar_remove"

(* mask to attach objets in a table *)
type option_mask =
    | GTK_FILL
    | GTK_SHRINK
    | GTK_EXPAND

(* ### 5.58 Table widget *)
(* table_get_type *)
external table_new : int->int->bool->gtkobject = "mlgtk_table_new"
external table_attach : gtkobject->gtkobject->int->int->int->int->
   option_mask list->option_mask list->int->int->unit =
   "mlgtk_true_table_attach" "mlgtk_table_attach"
(* table_attach_defaults *)
(* table_set_row_spacing *)
(* table_set_col_spacing *)
(* table_set_row_spacings *)
(* table_set_col_spacings *)
(* TABLE *)
(* TABLE_CLASS *)
(* IS_TABLE *)

(* ### 5.59 Text widget *)
(* text_get_type *)
external text_new : unit->gtkobject = "mlgtk_text_new"
external text_set_editable : gtkobject -> bool -> unit = "mlgtk_text_set_editable" 
external text_get_vadj : gtkobject -> gtkobject = "mlgtk_text_get_vadj" 
external text_get_hadj : gtkobject -> gtkobject = "mlgtk_text_get_hadj" 
(* text_set_adjustments *)
external text_get_point : gtkobject->int = "mlgtk_text_get_point"
external text_set_point : gtkobject->int->unit = "mlgtk_text_set_point"
external text_get_length : gtkobject->int = "mlgtk_text_get_length"
external text_freeze : gtkobject->unit = "mlgtk_text_freeze"
external text_thaw : gtkobject->unit = "mlgtk_text_thaw"
external text_insert : 
  gtkobject -> (Gdk.font option) -> string -> int -> int -> unit 
    = "mlgtk_text_insert" 
external text_forward_delete : gtkobject -> int -> int = "mlgtk_text_forward_delete" 
external text_backward_delete : gtkobject -> int -> int = "mlgtk_text_backward_delete" 
(* TEXT *)
(* TEXT_CLASS *)
(* IS_TEXT *)

(* ### 5.60 Toggle button widget *)
(* toggle_button_get_type *)
external toggle_button_new_with_label : string->gtkobject = "mlgtk_toggle_button_new_with_label"
external toggle_button_new : unit->gtkobject = "mlgtk_toggle_button_new"
external toggle_button_set_state : gtkobject->bool->unit = "mlgtk_toggle_button_set_state"
external toggle_button_set_mode : gtkobject->bool->unit = "mlgtk_toggle_button_set_mode"
external toggle_button_toggled : gtkobject->unit = "mlgtk_toggle_button_toggled"
external toggle_button_set_active : gtkobject->bool->unit =
  "mlgtk_toggle_button_set_active"
 

(* TOGGLE_BUTTON *)
(* TOGGLE_BUTTON_CLASS *)
(* IS_TOGGLE_BUTTON *)

(* ### 5.61 Tool bar widget *)
(* toolbar_get_type *)
(* toolbar_new *)
(* toolbar_append_item *)
(* toolbar_prepend_item *)
(* toolbar_insert_item *)
(* toolbar_append_space *)
(* toolbar_prepend_space *)
(* toolbar_insert_space *)
(* toolbar_set_orientation *)
(* toolbar_set_style *)
(* toolbar_set_space_size *)
(* toolbar_set_tooltips *)
(* TOOLBAR *)
(* TOOLBAR_CLASS *)
(* IS_TOOLBAR *)

(* ### 5.62 Tool tips widget *)
external tooltips_new : unit->gtkobject = "mlgtk_tooltips_new"
(* tooltips_ref *)
(* tooltips_unref *)
(* tooltips_free_string *)
(* tooltips_enable *)
(* tooltips_disable *)
(* tooltips_set_delay *)
(* tooltips_set_colors *)
external tooltips_set_tip : gtkobject->gtkobject->string->string->unit = "mlgtk_tooltips_set_tip"
(* TOOLTIPS *)
(* TOOLTIPS_CLASS *)
(* IS_TOOLTIPS *)

(* ### 5.63 Tree widget *)
(* tree_get_type *)
(* tree_new *)
(* tree_append *)
(* tree_prepend *)
(* tree_insert *)
(* tree_child_position *)
(* tree_clear_items *)
(* tree_remove_items *)
(* tree_select_child *)
(* tree_select_item *)
(* tree_unselect_child *)
(* tree_unselect_item *)
(* tree_set_selection_mode *)
(* tree_set_view_mode *)
(* tree_set_view_lines *)
(* TREE *)
(* TREE_CLASS *)
(* IS_TREE *)

(* ### 5.64 Tree item widget *)
(* tree_item_get_type *)
(* tree_item_new *)
(* tree_item_new_with_label *)
(* tree_item_set_subtree *)
(* tree_item_select *)
(* tree_item_deselect *)
(* tree_item_expand *)
(* tree_item_collapse *)
(* tree_item_remove_subtree *)
(* TREE_ITEM *)
(* TREE_ITEM_CLASS *)
(* IS_TREE_ITEM *)

(* ### 5.65 Vertical box widget *)
(* vbox_get_type *)
external vbox_new : bool->int->gtkobject = "mlgtk_vbox_new"
(* VBOX *)
(* VBOX_CLASS *)
(* IS_VBOX *)

(* ### 5.66 Vertical button box widget *)
(* vbutton_box_get_type *)
external vbutton_box_new : unit -> gtkobject = "gtk_vbutton_box_new"
(* vbutton_box_set_spacing_default *)
(* vbutton_box_set_layout_default *)
(* vbutton_box_get_spacing_default *)
(* vbutton_box_get_layout_default *)
(* VBUTTON_BOX *)
(* VBUTTON_BOX_CLASS *)
(* IS_VBUTTON_BOX *)

(* ### 5.67 Viewport widget *)
(* viewport_get_type *)
(* viewport_new *)
(* viewport_get_hadjustment *)
(* viewport_get_vadjustment *)
(* viewport_set_hadjustment *)
(* viewport_set_vadjustment *)
(* viewport_set_shadow_type *)
(* VIEWPORT *)
(* VIEWPORT_CLASS *)
(* IS_VIEWPORT *)

(* ### 5.68 Vertical paned *)
(* vpaned_get_type *)
external vpaned_new : unit -> gtkobject = "mlgtk_vpaned_new"
(* VPANED *)
(* VPANED_CLASS *)
(* IS_VPANED *)

(* ### 5.69 Vertical ruler widget *)
(* vruler_get_type *)
(* vruler_new *)
(* VRULER *)
(* VRULER_CLASS *)
(* IS_VRULER *)

(* ### 5.70 Vertical scale widget *)
(* vscale_get_type *)
(* vscale_new *)
(* VSCALE *)
(* VSCALE_CLASS *)
(* IS_VSCALE *)

(* ### 5.71 Vertical scrollbar widget *)
(* vscrollbar_get_type *)
external vscrollbar_new : gtkobject option -> gtkobject = "mlgtk_vscrollbar_new"
(* VSCROLLBAR *)
(* VSCROLLBAR_CLASS *)
(* IS_VSCROLLBAR *)

(* ### 5.72 Vertical separator widget *)
(* vseparator_get_type *)
external vseparator_new : unit->gtkobject = "mlgtk_vseparator_new"
(* VSEPARATOR *)
(* VSEPARATOR_CLASS *)
(* IS_VSEPARATOR *)

(* ### 5.73 Base widget *)
(* widget_get_type *)
(* widget_class_init *)
(* widget_init *)
(* widget_destroy *)
external widget_show : gtkobject->unit = "mlgtk_widget_show"
external widget_hide : gtkobject->unit = "mlgtk_widget_hide"
(* widget_map *)
(* widget_unmap *)
external widget_realize : gtkobject -> unit = "mlgtk_widget_realize" 
external widget_unrealize : gtkobject -> unit = "mlgtk_widget_unrealize" 
(* widget_draw *)
external widget_draw : gtkobject->Gdk.rectangle->unit = "mlgtk_widget_draw"
(* widget_draw_focus *)
(* widget_draw_children *)
(* widget_size_request *)
(* widget_size_allocate *)
(* widget_install_accelerator *)
(* widget_remove_accelerator *)
(* widget_event *)
external widget_unparent : gtkobject -> unit = "mlgtk_widget_unparent"
external widget_reparent : gtkobject -> gtkobject -> unit = "mlgtk_widget_reparent"
(* widget_popup *)
(* widget_intersect *)
(* widget_grab_focus *)
(* widget_grab_default *)
(* widget_restore_state *)
external widget_set_events : gtkobject -> Gdk.Event.mask list -> unit =
  "mlgtk_widget_set_events"
(* widget_set_name *)
(* widget_set_state *)
external widget_set_sensitive : gtkobject -> bool -> unit =
  "mlgtk_widget_set_sensitive"
(* widget_set_parent *)
(* widget_set_style *)
(* widget_set_uposition *)
external widget_set_usize : gtkobject -> int -> int -> unit = "mlgtk_widget_set_usize"
(* widget_get_toplevel *)
(* widget_get_ancestor *)
(* widget_get_colormap *)
(* widget_get_visual *)
(* widget_get_style *)
(* WIDGET *)
(* WIDGET_CLASS *)
(* IS_WIDGET *)

(* ### 5.74 Window widget *)
(* window_get_type *)
external window_new : window_type->gtkobject = "mlgtk_window_new"
external window_set_title : gtkobject->string->unit = "mlgtk_window_set_title"
(* window_set_focus *)
(* window_set_default *)
(* window_set_policy *)
(* window_add_accelerator_table *)
(* window_remove_accelerator_table *)
(* window_position *)
(* WINDOW *)
(* WINDOW_CLASS *)
(* IS_WINDOW *)

external window_of : gtkobject->Gdk.window = "mlgtk_window_of"
external style_of : gtkobject->style = "mlgtk_style_of"
external fg_gc_of : gtkobject->int->Gdk.gc = "mlgtk_fg_gc_of"
external allocation_of : gtkobject->allocation = "mlgtk_allocation_of"
external state_of : gtkobject->int = "mlgtk_state_of"

(* ### Editable widget *)
external editable_insert_text : gtkobject -> string -> int -> int -> int 
    = "mlgtk_editable_insert_text" 
external editable_select_region : gtkobject -> int -> int -> unit
    = "mlgtk_editable_select_region" 
external editable_get_chars : gtkobject -> int -> int -> string
    = "mlgtk_editable_get_chars" 
external editable_get_position : gtkobject -> int
    = "mlgtk_editable_get_position"


external object_destroy : gtkobject->unit = "mlgtk_object_destroy"
external timeout_add_internal : int->gtkCallBack->int = "mlgtk_timeout_add"
end

external button_box_set_child_size_default : int->int->unit=
  "mlgtk_button_box_set_child_size_default"
external button_box_set_child_ipadding_default : int->int->unit=
  "mlgtk_button_box_set_child_ipadding_default"
external button_box_get_child_size_default : unit->int*int=
  "mlgtk_button_box_get_child_size_default"
external button_box_get_child_ipadding_default : unit->int*int=
  "mlgtk_button_box_get_child_ipadding_default"

let timeout_add delay func = Unsafe.timeout_add_internal delay
  (function _ -> function _ -> Unsafe.Bool(func ()));
external timeout_remove : int->unit = "mlgtk_timeout_remove"
external main_quit : unit->unit = "mlgtk_main_quit"
external main_gtk : unit->unit = "mlgtk_main_gtk"
