/*
 * A simple "Hello World" example that uses the POA
 */

#include "hello.h"

/*
 * Hello World implementation. This implementation does not inherit
 * any skeleton class, but is tied to the POA skeleton template.
 */

class HelloWorld_impl
{
public:
  void hello ();
};

void
HelloWorld_impl::hello ()
{
  printf ("Hello World\n");
}

int
main (int argc, char *argv[])
{
  /*
   * Initialize the ORB
   */

  CORBA::ORB_var orb = CORBA::ORB_init (argc, argv, "mico-local-orb");

  /*
   * Obtain a reference to the RootPOA and its Manager
   */

  CORBA::Object_var poaobj = orb->resolve_initial_references ("RootPOA");
  PortableServer::POA_var poa = PortableServer::POA::_narrow (poaobj);
  PortableServer::POAManager_var mgr = poa->the_POAManager();

  /*
   * Create a Hello World object and tie it to the skeleton template
   */

  HelloWorld_impl hello;
  POA_HelloWorld_tie<HelloWorld_impl> tie_hello (hello);

  /*
   * Activate the Servant
   */

  PortableServer::ObjectId_var oid = poa->activate_object (&tie_hello);

  /*
   * Activate the POA and start serving requests
   */

  printf ("Running.\n");

  mgr->activate ();
  orb->run();

  /*
   * Shutdown (never reached)
   */

  poa->destroy (TRUE, TRUE);

  return 0;
}
