...\" $Header: /cvs/gnome/gtk-doc/doc/manpage.man,v 1.1.1.1 1998/11/24 06:00:34 owen Exp $
...\"
...\"	transcript compatibility for postscript use.
...\"
...\"	synopsis:  .P! <file.ps>
...\"
.de P!
.fl
\!!1 setgray
.fl
\\&.\"
.fl
\!!0 setgray
.fl			\" force out current output buffer
\!!save /psv exch def currentpoint translate 0 0 moveto
\!!/showpage{}def
.fl			\" prolog
.sy sed -e 's/^/!/' \\$1\" bring in postscript file
\!!psv restore
.
.de pF
.ie     \\*(f1 .ds f1 \\n(.f
.el .ie \\*(f2 .ds f2 \\n(.f
.el .ie \\*(f3 .ds f3 \\n(.f
.el .ie \\*(f4 .ds f4 \\n(.f
.el .tm ? font overflow
.ft \\$1
..
.de fP
.ie     !\\*(f4 \{\
.	ft \\*(f4
.	ds f4\"
'	br \}
.el .ie !\\*(f3 \{\
.	ft \\*(f3
.	ds f3\"
'	br \}
.el .ie !\\*(f2 \{\
.	ft \\*(f2
.	ds f2\"
'	br \}
.el .ie !\\*(f1 \{\
.	ft \\*(f1
.	ds f1\"
'	br \}
.el .tm ? font underflow
..
.ds f1\"
.ds f2\"
.ds f3\"
.ds f4\"
.ta 8n 16n 24n 32n 40n 48n 56n 64n 72n 
.TH "XtUnmanageChildren" "3
"
.SH "NAME"
XtUnmanageChildren \(em remove a list of children from a parent widget\&'s managed list\&.
.iX "widgets" "removing"
.iX "XtUnmanageChildren"
.SH "SYNOPSIS"
4 March 1996; 
.PP
.nf
void XtUnmanageChildren(\fIchildren\fP, \fInum_children\fP)
    WidgetList \fIchildren\fP;
    Cardinal \fInum_children\fP;
.fi
.SS "Inputs"
6 March 1996; 
.IP "\fIchildren\fP" 10
Specifies an array of child widgets\&.  Each child must be of
class RectObj or any subclass thereof\&.
.IP "\fInum_children\fP" 10
Specifies the number of elements in \fIchildren\fP\&.
.SS "Subsidiary Inputs"
.PP
Inputs into unmanageable children may also include
food, drink, and discipline\&.
.SH "Description"
5 March 1996; 
.PP
\fBXtUnmanageChildren()\fP unmaps the specified widgets
and removes them from their parent\&'s geometry management\&.
The widgets will disappear from the screen, and (depending
on its parent) may no longer have screen space allocated for
them\&.
.PP
Each of the widgets in the \fIchildren\fP array must have
the same parent\&.
.PP
See the Algorithm section below for full details of the
widget unmanagement procedure\&.
.SH "Usage"
.PP
Unmanaging widgets is the usual method for temporarily
making them invisible\&.  They can be re-managed with
\fBXtManageChildren()\fP\&.
.PP
You can unmap a widget, but leave it under geometry
management by calling \fBXtUnmapWidget()\fP\&.  You can
destroy a widget\&'s window without destroying the widget by
calling \fBXtUnrealizeWidget()\fP\&.  You can destroy a
widget completely with \fBXtDestroyWidget()\fP\&.
.PP
If you are only going to unmanage a single widget, it is
more convenient to call \fBXtUnmanageChild()\fP\&.  It is
often more convenient to call \fBXtUnmanageChild()\fP
several times than it is to declare and initialize an array
of widgets to pass to \fBXtUnmanageChildren()\fP\&.  Calling
\fBXtUnmanageChildren()\fP is more efficient, however,
because it only calls the parent\&'s \fBchange_managed()\fP
method once\&.
.SH "Algorithm"
.PP
\fBXtUnmanageChildren()\fP performs the following:
.IP "" 10
Issues an error if the children do not all have the same
parent or if the parent is not a subclass of
\fBcompositeWidgetClass\fP\&.
.IP "" 10
Returns immediately if the common parent is being destroyed;
otherwise, for each unique child on the list,
\fBXtUnmanageChildren()\fP performs the following:
.IP "-" 10
Ignores the child if it already is unmanaged or is being
destroyed\&.
.IP "-" 10
Otherwise, if the child is realized, it makes it nonvisible
by unmapping it\&.
.IP "" 10
Calls the \fBchange_managed()\fP method of the widgets\&'
parent if the parent is realized\&.
.PP
.SH "Structures"
.PP
The \fBWidgetList\fP type is simply an array of widgets:
.PP
.nf
typedef Widget *WidgetList;
.fi
...\" created by instant / docbook-to-man, Mon 31 Aug 1998, 22:15
