(*							*)
(*	lex_cld.mll	(JCF  4/5/94)			*)
(*							*)
{
 open Init;;
 open Lexing;;
 
 let comment_depth = ref 0;;
 let modname = ref "";;

 exception Fin_fichier;;

}

let lowercase = ['a'-'z' '\223'-'\246' '\248'-'\255']
let uppercase = ['A'-'Z' '\192'-'\214' '\216'-'\222']
let identchar = 
  ['A'-'Z' 'a'-'z' '_' '\192'-'\214' '\216'-'\246' '\248'-'\255' '\'' '0'-'9']

rule action = parse
    [' ' '\010' '\013' '\009' '\012'] +
      { action lexbuf }
  | "open" [' ' '\010' '\013' '\009' '\012']*
        { opened_file lexbuf }
  | lowercase identchar*
      { action lexbuf }
  | uppercase identchar*
      { modname := Lexing.lexeme lexbuf;
        qual_id lexbuf }
  | ['0'-'9']+
    | '0' ['x' 'X'] ['0'-'9' 'A'-'F' 'a'-'f']+
    | '0' ['o' 'O'] ['0'-'7']+
    | '0' ['b' 'B'] ['0'-'1']+
      { action lexbuf }
  | ['0'-'9']+ ('.' ['0'-'9']*)? (['e' 'E'] ['+' '-']? ['0'-'9']+)?
      { action lexbuf }
  | "\""
      { string lexbuf; action lexbuf }
  | "'" [^ '\\' '\''] "'"
      { action lexbuf }
  | "'" '\\' ['\\' '\'' 'n' 't' 'b' 'r'] "'"
      { action lexbuf }
  | "'" '\\' ['0'-'9'] ['0'-'9'] ['0'-'9'] "'"
      { action lexbuf }
  | "(*"
      { comment_depth := 1; comment lexbuf; action lexbuf }
  | "#" | "&"  | "&&" | "'" | "(" | ")" | "*" | "," | "?" | "->" | "." | ".."
   | ".(" | ".[" | ":" | "::" | ":=" | ";" | ";;" | "<-" | "=" | "[" | "[|"
   | "[<" | "]" | "_" | "{" | "|" | "||" | "|]" | ">]" | "}" | "!=" | "-"
   | "-."    { action lexbuf }

  | ['!' '?' '~']
    ['!' '$' '%' '&' '*' '+' '-' '.' '/' ':' '<' '=' '>' '?' '@' '^' '|' '~'] *
            { action lexbuf }
  | ['=' '<' '>' '@' '^' '|' '&' '$']
    ['!' '$' '%' '&' '*' '+' '-' '.' '/' ':' '<' '=' '>' '?' '@' '^' '|' '~'] *
            { action lexbuf }
  | ['+' '-']
    ['!' '$' '%' '&' '*' '+' '-' '.' '/' ':' '<' '=' '>' '?' '@' '^' '|' '~'] *
            { action lexbuf }
  | "**"
    ['!' '$' '%' '&' '*' '+' '-' '.' '/' ':' '<' '=' '>' '?' '@' '^' '|' '~'] *
            { action lexbuf }
  | ['*' '/' '%']
    ['!' '$' '%' '&' '*' '+' '-' '.' '/' ':' '<' '=' '>' '?' '@' '^' '|' '~'] *
            { action lexbuf }
  | eof { raise Fin_fichier }
  | _ { action lexbuf }

and comment = parse
    "(*"
      { comment_depth := succ !comment_depth; comment lexbuf }
  | "*)"
      { comment_depth := pred !comment_depth;
        if !comment_depth > 0 then comment lexbuf }
  | "\""
      { string lexbuf; comment lexbuf }
  | "''"
      { comment lexbuf }
  | "'" [^ '\\' '\''] "'"
      { comment lexbuf }
  | "'\\" ['\\' '\'' 'n' 't' 'b' 'r'] "'"
      { comment lexbuf }
  | "'\\" ['0'-'9'] ['0'-'9'] ['0'-'9'] "'"
      { comment lexbuf }
  | eof
      { raise Fin_fichier }
  | _
      { comment lexbuf }

and string = parse
    '"'
      { () }
  | '\\' ("\010" | "\013" | "\010\013") [' ' '\009'] *
      { string lexbuf }
  | '\\' ['\\' '"' 'n' 't' 'b' 'r']
      { string lexbuf }
  | '\\' ['0'-'9'] ['0'-'9'] ['0'-'9']
      { string lexbuf }
  | eof
      { raise Fin_fichier }
  | _
      { string lexbuf }

and qual_id = parse
    '.' [^ '.' '(' '['] { Use_module (change_lower !modname) }
  | eof { raise Fin_fichier }
  | _ { action lexbuf }

and opened_file = parse
    uppercase identchar*
      { let lex = (Lexing.lexeme lexbuf) in 
        let str = String.sub lex 0 (String.length lex) in
        (Use_module (change_lower str)) }
 | eof {raise Fin_fichier }
 | _ { action lexbuf }

(*
rule action = parse
    "open" [' ' '\t' '\n']* 
      { opened_file lexbuf }
  | ['a'-'z' '_' '0'-'9' 'A'-'Z']+"." [^'(']
      { let lex = (Lexing.lexeme lexbuf) in
        let str =(String.sub lex 0 (String.length lex - 2)) in 
        (prerr_endline str; Use_module (change_lower str)) }
  | "'" { Char lexbuf; action lexbuf }
  | "\""
      { chaine lexbuf; action lexbuf }
  | "(*"
      { comment_depth := 1; Comment lexbuf; action lexbuf }  
  | eof    { raise Fin_fichier} 
  | _      { action lexbuf }
and Comment = parse
    "(*"
      { comment_depth := succ !comment_depth; Comment lexbuf }
  | "*)"
      { comment_depth := pred !comment_depth;
        if !comment_depth > 0 then Comment lexbuf }
  | eof
      { raise Fin_fichier} 
  | _ {Comment lexbuf}
and chaine = parse
    '"'             { () }
  | '\\' ['"' '\\'] { chaine lexbuf }
  | _               { chaine lexbuf }
and Char = parse
    "\\''" { () }
  | . 
and opened_file = parse
   ['a'-'z' '_' '0'-'9' 'A'-'Z']+
      { let lex = (Lexing.lexeme lexbuf) in 
        let str = String.sub lex 0 (String.length lex) in
        (Use_module (change_lower str)) }
 | eof {raise Fin_fichier }
 | _ { action lexbuf }
;;
*)
