#!/usr/local/bin/perl

$linelen = 72;
$output = "";
$cut_at_blanks = 0;
$image = "";

while ($#ARGV >= 0) {
  $_ = $ARGV[0];
  last unless (/^-/);
  $linelen = $ARGV[1], shift, shift, next    if (/^-n$/);
  $output  = $ARGV[1], shift, shift, next    if (/^-o$/);
  $cut_at_blanks = 1, shift, next            if (/^-w$/);
  $image = $ARGV[1], shift, shift, next             if (/^-image$/);
  printf STDERR ("Unknown option '%s', ignored\n", $_);
  shift;
}

# Is the coqtop image valid ?

if ($image eq "") {
  print "Warning: preprocessing with default image \"coqtop\"\n";
  $image = "coqtop";
} else {
  print "Preprocessing with $image\n";
}

if (system "$image -batch >& /dev/null") {
  $| = 1; # Force flush
  print "Error: ";
  system "$image -batch";
  die;
} else {
  print "Your version of coqtop seems OK\n";
}

# First pass: extract the Coq phrases to evaluate

open(VERNAC, "> .input.v") || die("Cannot create .input.v : $!");

foreach $infile (@ARGV) {
  open(IN, $infile) || die("Cannot open $infile : $!");
  while(<IN>) {
    if (m/^\\begin{coq_(example|example\*|eval)}\s*$/) {
      while(<IN>) {
        last if m/^\\end{coq_(example|example\*|eval)}\s*$/;
        print VERNAC $_;
      }
    }
  }
  close(IN);
}

close(VERNAC);

# Feed the phrases to a Coq toplevel

open(TOPLEVEL, "$image 2>&1 < .input.v |") ||
       die("Cannot start coqtop : $!\n");

<TOPLEVEL>; <TOPLEVEL>;         # skip the coq banner
$lastread = <TOPLEVEL>;		# read the first line
$lastread =~ s/^Coq < //;       # skip the prompt

# Second pass: shuffle the TeX source and the output of the toplevel

if ($output) {
  if ($output eq "-") {
    open(OUT, ">&STDOUT");
  } else {
    open(OUT, ">$output") || die("Cannot create $output: $!");
  }
}

foreach $infile (@ARGV) {
  open(IN, $infile) || die("Cannot open $infile: $!");
  if (! $output) {
    $outfile = $infile;
    $outfile =~ s/\.tex$//;
    open(OUT, "> $outfile.v.tex") || die("Cannot create $outfile.v.tex: $!");
  }
  while(<IN>) {
    if (m/^\\begin{coq_example(\*?)}\s*$/) {
      $omit_answer = $1;     # true if coq_example*, false if coq_example
      print OUT "\n\\begin{flushleft}\n";
      $severalphrases = 0;
      while(<IN>) {
        last if m/\\end{coq_example\*?}\s*$/;
        print OUT "\\medskip\n" if ($severalphrases);
        $cpt = 0;     # to count the newline
        while(1) {
          $phr = "Coq < ".substr($_, 0, length($_) - 1);
          print OUT encapsule($phr);
          last if m/\.\s*$/;
          $cpt = $cpt+1;
          $_ = <IN>;
        }
        while($cpt) {  # skip the $cpt promts
	    $lastread =~ s/^[\w\$\']+ < //; 
	    $cpt = $cpt-1;
        }
        while($lastread) {
          $current = $lastread;  # Always a \n to skip before the prompt
          $lastread = <TOPLEVEL>;
          last if $lastread =~ s/^[\w\$']+ < //;
          print $current unless ($output eq "-");
          if (! $omit_answer) {
            while (length($current) > $linelen) {
              if ($cut_at_blanks) {
                $cutpos = rindex($current, ' ', $linelen);
                if ($cutpos == -1) { $cutpos = $linelen; } else { $cutpos++; }
              } else {
                $cutpos = $linelen;
              }
              $line = substr($current, 0, $cutpos);
              print OUT encapsule($line);
              $current = substr($current, $cutpos,
                                 length($current) - $cutpos);
            }
            $current = substr($current, 0, length($current) - 1);
            print OUT encapsule($current);
          }
        }
        $severalphrases = 1;
      }
      print OUT "\\end{flushleft}\n";
    }
    elsif (m/^\\begin{coq_eval}\s*$/) {
      while(<IN>) {
        last if m/^\\end{coq_eval}\s*$/;
        if (m/.\s*$/) {
          while($lastread) {
            last if $lastread =~ s/^[\w\$']+ < //;
            print $lastread;
            $lastread = <TOPLEVEL>;
          }
        }
      }
    }
    else {
      print OUT $_;
    }
  }
  close(IN);
}

sub encapsule {
    my $toprint = $_[0];
    $mark = "@";
    $mark="!" if m/@/;
    die ('Fatal error: you need to extend coq-tex to handle ! and @ together in Coq output\n') if ((m/@/) && (m/!/));
    $toprint = "\\verb$mark$_[0]$mark\\\\\n";
    return $toprint;
}

close(TOPLEVEL);
unlink(".input.v");
