open More_util;;

(***************************************************************************)
let for_all_vect2 f v1 v2 =
 let len = Array.length v1 in
 if Array.length v2 <> len then raise (Failure "for_all_vect2")
  else begin
   try for i = 0 to len - 1 do
         if (not (f v1.(i) v2.(i))) then raise (Failure "for_all_vect2_not")
         done; true
   with
   | Failure "for_all_vect2_not" -> false
 end;;

let rec combine_3 =
 fun
      p0 p1 p2 -> match (p0,p1,p2) with ((x1 :: l1), (x2 :: l2), (x3 :: l3)) -> (x1, x2, x3)::combine_3 l1 l2 l3
    | ([], [], []) -> []
    | (_, _, _) -> raise (Failure "combine_3");;

let rec split_snd =
 function
    | (i, (t, p)) :: l ->
     let t_l, p_l = split_snd l in
     (i, t)::t_l, (i, p)::p_l
    | [] -> [], [];;

(***************************************************************************)
let char_list_of_string str =
 let rec f l =
  function
     | 0 -> l
     | i ->
      let i = i - 1 in
      f (str.[i]::l) i in
 f [] (String.length str);;

let string_of_char_list l =
 let n = List.length l in
 let str = String.create n in
 let i = ref 0 in
 List.iter (function c -> String.set str !i c; i:=!i + 1) l; str;;

let rec list_number f =
 function
    | a :: l -> if f a then list_number f l + 1
                 else list_number f l
    | [] -> 0;;

(***************************************************************************)
let rec list_last_aux x =
 function
    | y :: l -> list_last_aux y l
    | [] -> x;;

let list_last =
 function
    | x :: l -> Some (list_last_aux x l)
    | [] -> None;;

