(**************************************************************************
  *********                      aux.ml                           *********
  **************************************************************************)
open Term;;
open More_util;;
open Ntdef;;
open Ntaux;;
open Ntpprinter;;

(********************
  |                   |
  ********************)
let bool_to_int =
 function
    | false -> 0
    | true -> 1;;

let nt_sort_to_int =
 function
    | Ns_Prop -> 1
    | Ns_Set -> 2
    | Ns_Type -> 3
    | Ns_TypeSet -> 4;;

let nt_lambda_nat_to_int =
 function
    | Nln_std -> 1
    | Nln_triv -> 2
    | Nln_not -> 3
    | Nln_abs -> 4
    | Nln_noocc -> 5;;

let nt_coord_to_int =
 function
    | Nc_misc -> 1
    | Nc_such_that -> 2;;

let nt_id_nat_to_int =
 function
    | Nin -> 0
    | Nin_var _ -> 1
    | Nin_theorem -> 2
    | Nin_axiom -> 3
    | Nin_construct _ -> 4
    | Nin_elim_theorem _ -> 5;;

let nt_case_nat_to_int =
 function
    | Ncn_std -> 1
    | Ncn_triv -> 2
    | Ncn_abs -> 3
    | Ncn_base -> 4
    | Ncn_induc -> 5;;

let sorts_option_to_int =
 function
    | Some (Prop Null) -> 1
    | Some (Prop Pos) -> 2
(* remplacement de 
    | SOME (Type (Null, _)) -> 3
    | SOME (Type (Pos, _)) -> 4
par *)
    | Some (Type _ )  -> 3
(* pour adaptation a la V6 (o'caml) qui renonce a TypeSet *)
    | _ -> 0;;

(**********
  |   div   |
  **********)
let nc_atm_text_int i = !text_of_int i;;

let nc_int_is_type_False c = bool_to_int (nc_is_type_False c);;

(********************
  |     text info     |
  ********************)
(**********
  | lambda  |
  **********)
let nc_int_lambda_sort nc = nt_sort_to_int (nc_lambda_sort nc);;

let nc_int_is_lambda_in_case nc = bool_to_int (nc_is_lambda_in_case nc);;

let nc_int_lambda_nat nc = nt_lambda_nat_to_int (nc_lambda_nat nc);;

let nc_int_lambda_coord nc = nt_coord_to_int (nc_lambda_coord nc);;

let nc_int_lambda_var_list_length nc = nc_lambda_var_list_length nc;;

let nc_int_lambda_var_right nc = nc_lambda_var_right nc;;

let nc_int_lambda_type_right nc = nc_lambda_type_right nc;;

let nc_int_lambda_sort_right nc = nc_lambda_sort_right nc;;

let nc_atm_lambda_text_var_list_length nc =
 !text_of_int (nc_lambda_var_list_length nc);;

let nc_int_lambda_typ_is_a_sort nc =
 sorts_option_to_int (nc_lambda_typ_is_a_sort nc);;

let nc_int_is_lambda_var_list_anonymous nc =
 bool_to_int (nc_is_lambda_var_list_anonymous nc);;

(**********
  |   app   |
  **********)
let nc_int_is_apply_head_up nc = bool_to_int (nc_is_apply_head_up nc);;

let nc_int_apply_subs_number nc = nc_apply_subs_number nc;;

let nc_int_nbr_elim_cases nc = nc_nbr_elim_cases nc;;

let nc_atm_text_nbr_elim_cases nc = !text_of_int (nc_nbr_elim_cases nc);;

(**********
  |  fix    |
  **********)
(**********
  | metavar |
  **********)
(**********
  |   id    |
  **********)
let nc_int_is_immediate_hypothesis nc =
 bool_to_int (nc_is_immediate_hypothesis nc);;

let nc_int_id_nat nc = nt_id_nat_to_int (nc_id_nat nc);;

(********************
  |     text arg      |
  ********************)
(**********
  | lambda  |
  **********)
(**********
  |   app   |
  **********)
let nc_int_elim_case_nat nc = nt_case_nat_to_int (nc_elim_case_nat nc);;

let nc_int_is_case_of_induc_elim nc = bool_to_int (nc_is_case_of_induc_elim nc);;

let nc_int_is_induc_case nc = bool_to_int (nc_is_induc_case nc);;

(**********
  |  fix    |
  **********)
(********************
  |     text type     |
  ********************)
let nc_int_number_of_types nc = nc_number_of_types nc;;

let nc_int_is_type_expected nc = bool_to_int (nc_is_type_expected nc);;

let nc_int_is_concl_false nc = bool_to_int (nc_is_concl_false nc);;

(********************
  |  text format dot  |
  ********************)
let nc_int_select_intro_elements nc = nc_select_elements 'I' nc;;

let nc_int_select_concl_elements nc = nc_select_elements 'C' nc;;
(********************************************************************************************************************************************************************************************************)

