(**************************************************************************
  *********                          ntuse.ml                     *********
  **************************************************************************)
open Generic;;
open Term;;
open More_util;;
open Reduction;;
open Vectops;;
open Ntdef;;
open Ntparam;;
open Ntaux;;
open Ntsons;;

(**************************************************************************
  **                                types                                **
  **************************************************************************)
let nc_loc_use_suppress_some_types rc nc =
 match nc_get_n_i nc with
 | Ni_lambda (_, _, ((true, _, _), _)) -> nc_set_type_use false nc
 | Ni_lambda _ ->
  (match nc_get_n_j nc, nc_get_n_t nc with
  | None, (_, _, _, (t :: _)) ->
   let son = nc_lambda_son nc in
   (match nc_get_n_i son, nc_get_n_t son with
    | (Ni_lambda _), (_, _, _, (t' :: [])) ->
     if immediate_prod_conv rc t t' then nc_set_first_type_use false son
    | _ -> ())
  | _ -> ())
 | Ni_id _ -> nc_set_first_type_use false nc
 | _ -> ();;

let rec suppress_abs_type nc =
 match nc_get_n_i nc with
 | Ni_lambda _ -> suppress_abs_type (nc_lambda_son nc)
 | _ -> if (not (nc_is_concl_false nc)) then nc_set_type_use false nc;;

let nc_loc_use_absurd_case_type nc =
 match nc_get_n_i nc with
 | Ni_app (_, (Nauc_elim _)) ->
  let son_l = nc_rec_elim_cases nc in
  List.iter
   (function nc -> if nc_elim_case_nat nc = Ncn_abs then suppress_abs_type nc)
   son_l
 | _ -> ();;

let nc_loc_use_type_pos nc =
 (match nc_get_n_i nc with
  | Ni_lambda (_, _, (_, ((Nln_std | Nln_triv | Nln_noocc), _))) ->
   nc_set_type_pos (true, false) (nc_lambda_son nc)
  | _ -> List.iter (nc_set_type_pos (false, true)) (nc_sons nc)); nc_set_n_f (
 (false, true), snd (nc_get_n_f nc)) nc;;

(**************************************************************************
  **                                 elim                                **
  **************************************************************************)
let rec tag_lambdas_in_case in_case nc =
 match nc_get_n_i nc with
 | Ni_lambda ((_, _, (Some _) as data), data2, ((_, link, coord), count)) ->
  let n_i = Ni_lambda (data, data2, 
   (
    (in_case, link, coord), count)) in
  nc_set_n_i n_i nc; tag_lambdas_in_case in_case (nc_lambda_son nc)
 | _ -> ();;

let nc_loc_use_elim nc =
 match nc_get_n_i nc with
 | Ni_app ((_, (Some (induc, omit, _)) as data), _) ->
  let use =
   match nc_rec_elim_cases nc with
   | nc' :: [] ->
    (match nc_get_n_a nc' with
    | Na_app_son (_, _, (Nase_case (_, _, 0, _, _))) -> false
    | _ -> true)
   | _ -> true in
  if use then begin
    let n_i = Ni_app (data, Nauc_elim (
                             (induc, omit), 
                             (Nii_not, 0, 
                              (0, 0, 0)))) in
    nc_set_n_i n_i nc; List.iter (tag_lambdas_in_case true) (nc_elim_cases nc)
  end
 | _ -> ();;

let nc_loc_use_case_number nc =
 match nc_get_n_i nc with
 | Ni_app ((_, (Some (induc, _, _))), _) ->
  let f_aux with_case nc =
   match nc_get_n_a nc with
   | Na_app_son (use, apply, (Nase_case (recur, induc, n_lamb, nat, _))) ->
    let
    n_a =
     Na_app_son (use, apply, Nase_case (recur, induc, n_lamb, nat, with_case))
    in
    nc_set_n_a n_a nc
   | _ -> () in
  (match induc, nc_elim_cases nc with
   | true, l -> List.iter (f_aux (Some [])) l
   | false, (nc :: []) -> f_aux None nc
   | false, l -> List.iter (f_aux (Some [])) l)
 | _ -> ();;

(**************************************************************************
  **                             lambda link                             **
  **************************************************************************)
let cmp_case c c' = c = c';;

let cmp_sort s s' =
 match s, s' with
 | Ns_Prop, Ns_Prop -> true
 | Ns_Set, Ns_Set -> true
 | Ns_Prop, _ | Ns_Set, _ | _, Ns_Prop | _, Ns_Set -> false
 | _ -> true;;

let cmp_types_use t t' =
 match t, t' with
 | _, (false, false) -> true
 | _ -> false;;

let cmp_typ rc i t t' = conv rc (lift i (c_of_nc t)) (c_of_nc t');;

let nc_loc_use_lambda_link rc nc =
 match nc_get_n_i nc with
 | Ni_lambda ((sort, _, _ as data), data_elim, ((case, _, coord), count)) ->
  let link =
   match nc_body nc with
   | DOP2 (_, typ, _) ->
    let i, son = nc_jump_count (nc_lambda_son nc) in
    (match nc_get_n_i son with
     | Ni_lambda ((sort', _, _), _, ((case', _, _), _)) ->
      (match nc_body son with
      | DOP2 (_, typ', _) ->
       let types_use' = nc_is_type_used son in
       if cmp_case case case' & (not (types_use')) then
        (if cmp_sort sort sort' then
        (if cmp_typ rc (i + 1) typ typ' then Nll_type
        else Nll_sort)
        else Nll_sentence)
        else Nll_none
      | _ -> Nll_none)
     | _ -> Nll_none)
   | _ -> Nll_none in
  let n_i = Ni_lambda (data, data_elim, 
   (
    (case, link, coord), count)) in
  nc_set_n_i n_i nc
 | _ -> ();;

(**************************************************************************
  **                             lambda elim                             **
  **************************************************************************)
let get_case_index nc =
 match nc_body nc with
 | DOPN (_, v) ->
  let f_aux nc =
   match nc_get_n_a nc with
   | Na_app_son (_, _, (Nase_case _)) -> true
   | _ -> false in
  let i = first_vect f_aux v in
  tag_lambdas_in_case false v.(i); i
 | _ -> raise Not_found;;

let nc_loc_use_lambda_elim nc =
 if nc_get_n_j nc = None then (match nc_get_n_i nc with
 | Ni_lambda (_, (Some (DOPN ((MutInd (x0,x1)), _))), _) ->
  let son = nc_lambda_son nc in
  if ref_set_mem (x0,x1) elim_omit_cst_set & (match nc_rec_elim_cases son with
      | son :: [] ->
       (match nc_get_n_a son with
       | Na_app_son (_, _, (Nase_case (_, _, n_lamb, _, _))) -> n_lamb > 0
       | _ -> false)
      | _ -> false) then begin
    try nc_set_n_j (Some (get_case_index son)) nc
    with
    | Not_found -> ()
  end
 | _ -> ());;

(**************************************************************************
  **                              app recur                              **
  **************************************************************************)
let test_apply_recur thm nc =
 match nc_get_n_i nc, nc_get_n_a nc with
 | (Ni_app (_, (Nauc_apply _))),
     (Na_app_son (use, (Nasa_sub (recur, n_right)), elim_son)) ->
  let
  recur =
   if thm = c_of_nc (nc_apply_head nc) & (not (nc_are_sev_types_used nc)) then
   Some (Nii_not, 0)
   else None in
  let n_a = Na_app_son (use, Nasa_sub (recur, n_right), elim_son) in
  nc_set_n_a n_a nc
 | _ -> ();;

let test_elim_recur cst nc =
 match nc_get_n_i nc, nc_get_n_a nc with
 | (Ni_lambda (_, (Some cst'), _)),
     (Na_app_son (use, apply_son,
                    (Nase_case (_, induc_elim, n_lamb, nat, number)))) ->
  let recur = cst = cst' & (not (nc_are_sev_types_used nc)) in
  let
  n_a =
   Na_app_son
   (use, apply_son, Nase_case (recur, induc_elim, n_lamb, nat, number)) in
  nc_set_n_a n_a nc
 | _ -> ();;

let nc_loc_use_app_recur nc =
 match nc_get_n_i nc with
 | Ni_app ((_, elim_data), _) -> begin
                                   let thm = c_of_nc (nc_apply_head nc) in
                                   match thm with
                                    | DOPN ((Const sp), _) ->
                                     if ref_set_mem sp apply_rec_sub_const_set
                                      then
                                      List.iter (test_apply_recur thm)
                                      (nc_apply_subs nc)
                                    | DOPN ((MutConstruct (x0,x1)), _) ->
                                     if
                                      ref_set_mem (x0,x1)
                                      apply_rec_sub_construct_set then
                                      List.iter (test_apply_recur thm)
                                      (nc_apply_subs nc)
                                    | _ -> ()
                                 end; (match elim_data with
  | Some (false, _, cst) -> List.iter (test_elim_recur cst) (nc_elim_cases nc)
  | _ -> ())
 | _ -> ();;

(**************************************************************************
  **                   id used first for apply subs                      **
  **************************************************************************)
let rec id_first_type_use nc =
 (match nc_get_n_i nc with
  | Ni_app (_, (Nauc_apply (_, (_, (Nii_not, _))))) ->
   List.iter id_first_type_use_sub (nc_rec_apply_subs nc)
  | _ -> ()); List.iter id_first_type_use (nc_rec_sons nc)
and id_first_type_use_sub nc =
 match nc_get_n_i nc with
 | Ni_id _ ->
  if nc_get_type_list_if_used nc = [] then nc_set_first_type_use true nc
 | _ -> ();;

let rec nc_glob_use_id_first_type_use nc = id_first_type_use nc;;

