(**************************************************************************
  *********                          nttop.ml                     *********
  **************************************************************************)

open Std;;
open Pp;;
open More_util;;
open Names;;
open Proof_trees;;
open Tacmach;;
open Pfedit;;
open Evd;;


open Libobject;;
open Constrtypes;;
open Environ;;
open Reduction;;
open Mach;;
open Term;;
open Generic;;
open Constants;;
open Vartab;;
open Ntdef;;
open Nttrans;;
open Ntsons;;
open Ntdata;;
open Ntuse;;
open Ntcount;;
open Ntformat;;
open Ntrefiner;;

(**************************************************************************
  nc_do_down_top loc_elim_one_repeated_type nc;
  nc_do_down_top nc_loc_immediate_hypothesis nc;
  nc_glob_supress_extern_type nc;*)
let nc_std_modif rc nc =
 nc_do_down_top nc_loc_fun_data_metavar_in_apply_head nc;
 nc_do_down_top (nc_loc_data_double_type rc) nc;
 nc_do_down_top (nc_loc_data_to_elim rc) nc;
 nc_do_down_top nc_loc_data_lambda_elim nc;
 nc_do_down_top nc_loc_use_elim nc;
 nc_do_down_top (nc_loc_use_suppress_some_types rc) nc;
 nc_glob_data_suppress_extern_type nc;
 nc_do_down_top nc_loc_use_lambda_elim nc;
 nc_do_down_top (nc_loc_use_lambda_link rc) nc;
 nc_do_down_top nc_loc_use_app_recur nc;
 nc_do_down_top nc_loc_use_case_number nc;
 nc_do_down_top nc_loc_count nc;
 nc_glob_count_case_number nc;
 nc_glob_use_id_first_type_use nc;
 nc_do_down_top nc_loc_use_absurd_case_type nc;
 nc_do_down_top nc_loc_use_type_pos nc;
 nc_do_down_top nc_loc_format_no_type_no_pos nc;
 nc_do_top_down nc_loc_format_dot nc;
 nc_do_down_top nc_loc_count_immediate_hyp nc;
 nc_do_top_down nc_loc_format_main nc;
 nc;;

(*let print_leaf_entry with_values sep (spopt,lobj) =
  let tag = object_tag lobj in
  match (spopt,tag) with
  | (sp,"CONSTANT") ->
  let (cmap,_,_) = outConstant lobj in
  let {CONSTBODY=val;CONSTTYPE=typ;_} = listmap__map cmap CCI
  in (match val with NONE -> 
  [< 'S"*** [ "; 'S (nametab__print_name (ccisp_of sp));  'S " : "; 'CUT ;
  pTERM typ ; 'S" ]"; 'FNL >] 
  | _ -> 
  [< 'S(nametab__print_name (ccisp_of sp)) ; 'S sep; 'CUT ;
  if with_values then print_typed_recipe (val,typ) 
  else [< pTERM typ ; 'FNL >] >])
  | (sp,"MUTUALINDUCTIVE") ->
  let (cmap,_) = outMutualInductive lobj in
  [< print_mutual CCI (listmap__map cmap CCI); 'FNL >]
  ;;
  from pretty__print_name and pretty__print_leaf_entry *)
let definition_of_id id =
 let str = string_of_id id in
 try let sp = Nametab.sp_of_id CCI id in
     let lobj = Lib.map_leaf (objsp_of sp) in
     let tag = object_tag lobj in
     match tag with
      | "CONSTANT" ->
       let cmap, _, _ = outConstant lobj in
       let {cONSTBODY=val0; cONSTTYPE=typ} = Listmap.map cmap CCI in
       let typ = body_of_type typ in
       (match val0 with
        | None -> N_axiom ("AXIOM", id, typ)
        | Some ({contents=COOKED c}) -> N_definition ("DEFINITION", id, c, typ)
        | Some ({contents=RECIPE dr} as r) -> cook_constant sp;
         let lobj = Lib.map_leaf (objsp_of sp) in
         let tag = object_tag lobj in
         let cmap, _, _ = outConstant lobj in
         let {cONSTBODY=val0; cONSTTYPE=typ} = Listmap.map cmap CCI in
	 let typ = body_of_type typ in
         (match val0 with
          | Some ({contents=COOKED c}) -> N_definition ("DEFINITION", id, c, typ)
          | _ -> error "nttop__definition_of_id not cooked"))
      | _ ->
       errorlabstrm
        ("nttop__definition_of_id unable to print definition of " ^ str ^
          " tag " ^ tag ^ ".")
        (let m = match tag with
            "MUTUALINDUCTIVE" -> "inductive"
          | "SYNTAXCONSTANT"  -> "syntactic"
          |  _                -> "this kind of" in
        [< 'sTR "Printing of "; 'sTR m;
           'sTR " definitions in natural language not available" >])
 with
 | Not_found ->
 errorlabstrm
     ("nttop__definition_of_id unable to print definition of " ^ str ^ ".")
     [< 'sTR str; 'sTR " not a defined construction" >];;

let definition_to_prooftext rc def =
 match def with
 | N_definition (str, id, val0, typ) ->
  let ty = type_of (Evd.mt_evd()) (initial_sign()) typ in
  if conv (Evd.mt_evd()) ty (DOP0 (Sort (Prop Null))) then
  begin
   let nc = natural_constr_of_constr rc [] (gLOB (initial_sign ())) val0 typ in
   let nc = nc_std_modif rc nc in
   N_prooftext ("THEOREM", id, nc, typ)
  end
   else def
 | _ -> def;;

let nt_def_of_current () =
 let pftst = get_pftreestate () in
 let id = id_of_string (get_proof ()) in
 let pf = proof_of_pftreestate pftst in
 let typ = (goal_of_proof pf).concl in
 let val0, mv = nt_extract_open_proof (initial_sign ()) pf in
 let mv_t = List.map (function i, (t, _) -> i, t) mv in
 let rc = (Evd.mt_evd()) in
 let nc = natural_constr_of_constr rc mv (gLOB (initial_sign ())) val0 typ in
 let nc = nc_std_modif rc nc in
 N_prooftext ("THEOREM", id, nc, typ);;

let nt_def_of_id id =
 let def = definition_of_id id in
 let rc = (Evd.mt_evd()) in
 definition_to_prooftext rc def;;

