(**************************************************************************
  *********                    ntparam.mli                        *********
  **************************************************************************)
open Term;;
open Names;;
open Proof_trees;;

open Reduction;;
open More_util;;

(**********************)
type 'a nt_list;;

val ref_list_init : 'a nt_list ref -> unit;;

val ref_list_mem : 'a -> 'a nt_list ref -> bool;;

val ref_list_add : 'a -> 'a nt_list ref -> unit;;

val ref_list_remove : 'a -> 'a nt_list ref -> unit;;

val ref_list_elements : 'a nt_list ref -> 'a list;;

(**********************)
type 'a nt_set;;

val ref_set_init : 'a nt_set ref -> unit;;

val ref_set_mem : 'a -> 'a nt_set ref -> bool;;

val ref_set_add : 'a -> 'a nt_set ref -> unit;;

val ref_set_remove : 'a -> 'a nt_set ref -> unit;;

val ref_set_elements : 'a nt_set ref -> 'a list;;

(**********************)
(* DEBUT MODIFICATION POUR PRISE EN COMPTE PAR RESET *)

type nt_param =
| Apply_omit_construct of ((section_path * int) * int)
| Apply_omit_const of section_path
| Elim_omit_cst of (section_path * int)
| Apply_rec_sub_construct of ((section_path * int) * int)
| Apply_rec_sub_const of section_path
| Elim_rec_sub of (section_path * int)
| Immediate_elim of (section_path * int)
| Immediate_delta_red of section_path;;

(* actuellement inutile dans l'interface avec ntcommand *)
val mem_param : nt_param -> bool

val remove_param : nt_param -> unit

val add_param : nt_param -> unit

(* FIN MODIFICATION POUR PRISE EN COMPTE PAR RESET *)

val apply_omit_construct_set : ((section_path * int) * int) nt_set ref;;

val apply_omit_const_set : section_path nt_set ref;;

val elim_omit_cst_set : (section_path * int) nt_set ref;;

val apply_rec_sub_construct_set : ((section_path * int) * int) nt_set ref;;

val apply_rec_sub_const_set : section_path nt_set ref;;

val elim_rec_sub_set : (section_path * int) nt_set ref;;

val immediate_elim_set : (section_path * int) nt_set ref;;

val immediate_delta_red_list : section_path nt_list ref;;

val init_False : string -> unit;;

val is_False : constr -> bool;;

val is_const_defined : section_path -> bool;;

val immediate_prod_conv : evar_declarations -> constr -> constr -> bool;;

val immediate_conv : evar_declarations -> constr -> constr -> bool;;

val change_type_names : constr -> constr -> constr;;

val try_red_to_prod : evar_declarations -> reduction_function;;

val force_red_to_prod : evar_declarations -> reduction_function;;

val add_to_projector_list : string * string list -> unit;;

val suppress_from_projector_list : string -> unit;;

val clear_projector_list : unit -> unit;;

val red_record : evar_declarations -> reduction_function;;

val red_to_show : evar_declarations -> reduction_function;;

val inc : int ref -> unit;;

val is_constr_id : constr -> bool;;

val is_constr_var : constr -> bool;;
