(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                mlterm.mli                                *)
(****************************************************************************)

open Names

(* identifiers of type are either parameters or type names. *)

type typeid = TYPEparam of identifier
            | TYPEname  of identifier

(* ML type expressions. *)

type mLtype = TYvar  of typeid
      	    | TYapp  of mLtype list
	    | TYarr  of mLtype * mLtype
	    | TYglob of identifier

(* ML inductive types. *)

type mLind = identifier list * identifier * (identifier * mLtype list) list

(* ML terms. *)

type mLast = MLrel  of int
      	   | MLapp  of mLast * mLast list
	   | MLlam  of identifier * mLast
	   | MLglob of identifier
	   | MLcons of int * identifier * mLast list
	   | MLcase of mLast * (identifier * identifier list * mLast) array
	   | MLfix  of int * bool * (identifier list) * (mLast list)
	   | MLexn  of identifier

(* ML declarations. *)

type mLdecl = DECLtype   of mLind list
            | DECLabbrev of identifier * (identifier list) * mLtype
            | DECLglob   of identifier * mLast

(* ML names. *)

val lo_string_of_id : identifier -> string
val up_string_of_id : identifier -> string
val reset_caml_names : unit -> unit
val is_caml_keyword : string -> bool
val caml_name_of : identifier list -> name -> identifier
val lo_caml_name_of : identifier list -> name -> identifier
val up_caml_name_of : identifier list -> name -> identifier
val new_vars : identifier list -> int -> identifier list
val rename_list : identifier list -> identifier list -> identifier list

val rename_bindings : identifier list -> mLast -> mLast

(* Lifting and substitution. *)

val ml_lift : int -> mLast -> mLast
val ml_pop : mLast -> mLast
val ml_subst1 : identifier list -> mLast -> mLast -> mLast
val ml_liftn_branch : int -> 'a * 'b list * mLast -> 'a * 'b list * mLast

(* Occurences. *)

val occurs : int -> mLast -> bool

(* Misc *)

val collect_lambda : mLast -> identifier list * mLast

(* $Id: mlterm.mli,v 1.7 1999/06/29 07:48:05 loiseleu Exp $ *)
