(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 Point.v                                  *)
(****************************************************************************)

Declare ML Module "Point".

Grammar tactic simple_tactic :=
  phyp [ "PHyp" identarg($id) ] -> [(PHyp $id)]
| cphyp [ "CPHyp" identarg($id) ] -> [(CPHyp $id)]
| pconcl [ "PConcl" ] -> [(PConcl)]
| p_id [ "P" identarg($id) ] -> [(PHyp $id)]
| cp [ "CP" identarg($id) ] -> [(CPHyp $id)]
| p [ "P" ] -> [(PConcl)]
| point_start [ "PointStart" numarg($n) comarg($c) ] -> [(PointStart $n $c)]
| point_end   [ "PointEnd" ] -> [(PointEnd)]
| point [ "Point" comarg($c) ] -> [(Point $c)]
| point_in [ "Point" comarg($c) "in" identarg($id)] -> [(Point $id $c)]
| cpoint [ "CPoint" comarg($c) ] -> [(CPoint $c)]
| cpoint_in [ "CPoint" comarg($c) "in" identarg($id)] -> [(CPoint $id $c)].

Grammar vernac point_result :=
  pointr_concl [ "Conclusion" ] -> [(CONCL)]
| pointr_hyp   [ "Hypothesis" numarg($rank) ] -> [(HYP $rank)]
| pointr_none  [ "None" ] -> [(NONE)].

Grammar vernac point_result_list: List :=
  pointr_one  [ point_result($r) ] -> [$r]
| pointr_cons [ point_result($r) point_result_list($l)] -> [$r ($LIST $l)].

Grammar vernac vernac :=
  hint_point [ "Hint" "Point" destruct_location($loc) identarg($na)
               comarg($hyptyp) numarg($pri) "[" numarg($sub)
               point_result_list($rl) "]" prim:astact($tac) "." ]
          -> [(HintPoint $na (AST $loc) $hyptyp $pri $sub
                     (AST (result_list ($LIST $rl))) (AST $tac))].
(*
| print_hint_point [ "PrintHintPoint" "." ] -> [(PrintPointTable)].
*)

Abstraction mark [0] := <<M>>M.

Grammar command command10 := 
  pointmark 
  [ "#" "[" command($c) "]" ] -> [(ABST #Point#mark.cci $c)].


Syntax tactic level 0:
  phyp [(PHyp $id)] -> ["P " $id ]
| cphyp [(CPHyp $id)] -> ["CP " $id]

| pconcl [(PConcl)] -> ["P"]

| pointstart [(PointStart ($NUM $n) $c)] -> ["PointStart " $n [1 0] $c]

| pointend [(PointEnd)] -> ["PointEnd"]

| point [(Point $c)] -> ["Point " $c]
| pointin [(Point $id $c)] -> ["Point " $c " in " $id]

| cpoint [(CPoint $c)] -> ["CPoint " $c]
| cpointin [(CPoint $id $c)] -> ["CPoint " $c" in "$id].

Syntax constr level 0:
  pointmark [(ABST #Point#mark.cci $c)] -> ["#[" $c "]"].


(* $Id: Point.v,v 1.13 1999/06/29 07:47:57 loiseleu Exp $ *)
