(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 trad.mli                                 *)
(****************************************************************************)

open Names
open Term
open Evd

val type_of_com : context -> CoqAst.t -> type_judgement

val constr_of_com_casted : 'c evar_map -> context -> CoqAst.t -> constr ->
  constr

val constr_of_com1 : bool -> 'c evar_map -> context -> CoqAst.t -> constr
val constr_of_com : 'c evar_map -> context -> CoqAst.t -> constr
val constr_of_com_sort : 'c evar_map -> context -> CoqAst.t -> constr

val fconstr_of_com1 : bool -> 'c evar_map -> context -> CoqAst.t -> constr
val fconstr_of_com : 'c evar_map -> context -> CoqAst.t -> constr
val fconstr_of_com_sort : 'c evar_map -> context -> CoqAst.t -> constr


(* Typing with Trad, and re-checking with Mach *)
val fconstruct :'c evar_map -> context -> CoqAst.t -> judgement
val fconstruct_type :
  'c evar_map -> context -> CoqAst.t -> type_judgement

val infconstruct_type :
  'c evar_map -> (context * context) ->
    CoqAst.t -> type_judgement * information
val infconstruct :
  'c evar_map -> (context * context) ->
    CoqAst.t -> judgement * information

(* Typing, re-checking with universes constraints *)
val fconstruct_with_univ :
  'c evar_map -> context -> CoqAst.t -> judgement
val fconstruct_with_univ_sp : 'c evar_map -> context
  -> section_path -> constr -> Impuniv.universes * judgement
val fconstruct_type_with_univ_sp : 'c evar_map -> context
  -> section_path -> constr -> Impuniv.universes * type_judgement
val infconstruct_with_univ_sp :
  'c evar_map -> (context * context)
  -> section_path -> constr -> Impuniv.universes * (judgement * information)
val infconstruct_type_with_univ_sp :
  'c evar_map -> (context * context)
  -> section_path -> constr 
  -> Impuniv.universes * (type_judgement * information)


(* Low level typing functions, for terms with de Bruijn indices and Metas *)

(* Raw calls to the inference machine of Trad: boolean says if we must fail
 * on unresolved evars, or replace them by Metas *)
val ise_resolve : bool -> 'c evar_map -> (int * constr) list ->
  environment -> constr -> judgement
val ise_resolve_type : bool -> 'c evar_map -> (int * constr) list ->
  environment -> constr -> type_judgement

(* Call ise_resolve with empty metamap and fail_evar=true. The boolean says
 * if we must coerce to a type *)
val ise_resolve1 : bool -> 'c evar_map -> environment -> constr -> constr

(* progmach.ml tries to type ill-typed terms: does not perform the conversion
 * test in application.
 *)
val ise_resolve_nocheck : 'c evar_map -> (int * constr) list ->
  environment -> constr -> judgement


(* Internals of Trad...
 * Unused outside Trad, but useful for debugging
 *)
val solve_pb : 'c evar_map ref -> conv_pb * constr * constr -> bool
val evar_conv_x : 'c evar_map ref -> environment option ->
  conv_pb -> constr -> constr -> bool
val evar_eqappr_x : 'c evar_map ref -> environment option ->
  conv_pb -> constr * constr list -> constr * constr list -> bool
val the_conv_x : 'c evar_map ref -> environment ->
                 constr -> constr -> bool 
val the_conv_x_leq : 'c evar_map ref -> environment ->
                     constr -> constr -> bool

val inh_coerce_to : 'c evar_map ref -> environment -> constr -> judgement ->
  judgement
val inh_coerce_to1 : 'c evar_map ref -> environment -> constr -> constr ->
  constr -> constr option -> judgement
val inh_conv_coerce1 : 'c evar_map ref -> environment -> constr -> constr ->
  constr -> constr option -> judgement
val inh_conv_coerce : 'c evar_map ref -> environment -> constr -> judgement ->
  judgement

val exemeta_rec : bool * (constr option * constr option) -> 'c evar_map ref
  -> environment -> constr -> judgement

(* $Id: trad.mli,v 1.15 1999/09/06 14:25:15 barras Exp $ *)
