(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               termast.mli                                *)
(****************************************************************************)

open Term
open Names

val print_implicits : bool ref

(* In [bdize b env c] or [bdize_no_casts b env c], if [b=true],
   the names in [env] are avoided in bound variables names *)
val bdize          : bool -> unit assumptions -> constr -> CoqAst.t
val bdize_no_casts : bool -> unit assumptions -> constr -> CoqAst.t

(* look for the index of a named var or a nondep var as it is renamed *)
val lookup_name_as_renamed :
     unit assumptions -> constr ->identifier -> int option
val lookup_index_as_renamed : constr -> int -> int option

(* $Id: termast.mli,v 1.12 1999/10/12 13:17:31 herbelin Exp $ *)

