(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               indtypes.mli                               *)
(****************************************************************************)

open Names
open Term
open Constrtypes
open Generic
open Termenv

(*
val inf_minductive : constr assumptions -> constr assumptions -> int -> constr -> constr -> bool -> (int * constr option * modification_action list * constr option)
*)

val infexecute_minductive : context * context -> int -> (name * identifier * identifier array) array ->bool-> (type_judgement * constr) array ->
  (path_kind,mutual_inductive_body) Listmap.t

val execute_minductive : context -> int -> (name * identifier * identifier array) array -> bool -> (type_judgement * constr) array ->
  (path_kind,mutual_inductive_body) Listmap.t
 
val abstract_mimap : section_path * section_path -> identifier list -> (path_kind * mutual_inductive_body) list -> 
('a oper * 'b oper modification) list * (path_kind * mutual_inductive_body) list

val expmod_mimap : (sorts oper * sorts oper modification) list -> ('a * mutual_inductive_body) list -> ('a * mutual_inductive_body) list

val process_mimap : (section_path * section_path) -> (identifier list * (sorts oper * sorts oper modification) list) -> (path_kind * mutual_inductive_body) list -> ((sorts oper * sorts oper modification) list) * (path_kind * mutual_inductive_body) list


(** DEBUG **)
val decomp_par : int -> constr -> constr
val check_correct_par : int -> int -> int -> int -> Term.constr array -> bool
val abstract_mibody :
  section_path * section_path -> identifier list -> mutual_inductive_body ->
  mutual_inductive_body * ('a oper * 'b oper modification) list
val abstract_mimap :
  section_path * section_path ->
  identifier list ->
  (path_kind * mutual_inductive_body) list ->
  ('a Term.oper * 'b oper modification) list *
  (path_kind * mutual_inductive_body) list
val abs_var_on_minductive :
  identifier -> type_judgement -> (type_judgement * constr) array ->
  (type_judgement * constr) array * modification_action
val abstract_minductive_once :
  (type_judgement signature * (type_judgement * constr) array) *
   modification_action list ->
  identifier ->
  (type_judgement signature * (type_judgement * constr) array) *
  modification_action list
