(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                termdn.mli                                *)
(****************************************************************************)
open Generic;;
open Term;;
open More_util;;

type lbl =
    TERM of constr
  | DOPER of sorts oper
  | DLAMBDA
;;

type 'a t = (lbl,constr,'a) Dn.t;;

val create : unit -> 'a t;;

val add : 'a t -> (constr * 'a) -> 'a t;;
val rmv : 'a t -> (constr * 'a) -> 'a t;;

val lookup : 'a t -> constr -> (constr * 'a) list;;
val app : ((constr * 'a) -> unit) -> 'a t -> unit;;

val constr_pat_discr : constr -> (lbl * constr list) option;;
val constr_val_discr : constr -> (lbl * constr list) option;;

(* $Id: termdn.mli,v 1.6 1999/06/29 07:47:42 loiseleu Exp $ *)
