(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                             evar_refiner.mli                             *)
(****************************************************************************)

open Initial
open Names
open More_util
open Term
open Mach
open Pp
open Proof_trees
open Refiner

val rc_of_pfsigma : proof_tree sigma -> readable_constraints
val rc_of_glsigma : goal sigma  -> readable_constraints

type walking_constraints

type 'a result_w_tactic = walking_constraints -> walking_constraints * 'a
type w_tactic           = walking_constraints -> walking_constraints

val local_Constraints : local_constraints -> goal sigma 
                        -> goal list sigma * validation

val startWalk       : goal sigma -> 
                       walking_constraints * (walking_constraints -> tactic)
val walking_THEN    : 'a result_w_tactic -> ('a -> tactic) -> tactic
val walking         : w_tactic -> tactic
val w_Focusing_THEN : section_path -> 'a result_w_tactic 
                      -> ('a -> w_tactic) -> w_tactic
val w_Declare    : section_path -> constr -> w_tactic
val w_Declare_At : section_path -> section_path -> constr -> w_tactic
val w_Define     : section_path -> constr -> w_tactic

val w_Underlying : walking_constraints -> evar_declarations
val w_hyps       : walking_constraints -> context
val w_type_of    : walking_constraints -> constr -> constr
val w_add_sign   : (identifier * type_judgement) -> walking_constraints 
                     -> walking_constraints

val w_IDTAC      : w_tactic
val w_ORELSE     : w_tactic -> w_tactic -> w_tactic
val ctxt_type_of : readable_constraints -> constr -> constr

val evars_of     : readable_constraints -> constr -> local_constraints

(* $Id: evar_refiner.mli,v 1.10 1999/08/06 20:49:10 herbelin Exp $ *)
