(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                clenv.mli                                 *)
(****************************************************************************)

open Names
open Term
open Tacmach
open Proof_trees
open Pp


(****************************************************************************)
(*         The Type of Constructions Clausale Environments                  *)
(****************************************************************************)

type 'a freelisted = {rebus : 'a;
                      freemetas : Intavs.t}
type clbinding = CLTYP of constr freelisted
               | CLVAL of constr freelisted * constr freelisted
type 'a clausenv = {templval : constr freelisted;
                    templtyp : constr freelisted;
                    namenv : identifier Intavm.t;
                    env : clbinding Intavm.t;
                    hook : 'a}
(* templval is the template which we are trying to fill out.
 * templtyp is its type.
 * namenv is a mapping from metavar numbers to names, for
 *        use in instanciating metavars by name.
 * env is the mapping from metavar numbers to their types
 *     and values.
 * hook is the pointer to the current walking context, for
 *      integrating existential vars and metavars.
 *)

type wc = walking_constraints (* Pour une meilleure lisibilit *)

(* Non utilis  l'extrieur
val whd_deltat : wc -> constr -> constr
val applyHead : int -> constr -> wc -> wc * constr
val mimick_evar : constr -> int -> section_path -> wc -> wc
val unirec_rec : wc -> (int * constr) list * (constr * constr) list -> constr -> constr -> (int * constr) list * (constr * constr) list
val w_Unify : constr -> constr -> (int * constr) list -> wc -> wc * (int * constr) list
val unifyTerms : constr -> constr -> tactic
val metavars_of : constr -> Intavs.t
val mk_freelisted : constr -> constr freelisted
val mentions : 'a clausenv -> int -> int -> bool
val mk_clenv_rename_type_of : wc -> constr -> wc clausenv
val mk_clenv_rename_hnf_constr_type_of : wc -> constr -> wc clausenv
val clenv_val_of : 'a clausenv -> int -> constr
val clenv_instance : 'a clausenv -> constr freelisted -> constr
val clenv_defined : 'a clausenv -> int -> bool
val clenv_value : 'a clausenv -> int -> constr freelisted
val clenv_type : 'a clausenv -> int -> constr freelisted
val clenv_instance_value : 'a clausenv -> int -> constr
val clenv_bchain : int -> 'a clausenv -> wc clausenv -> wc clausenv
val clenv_metavars : 'a clausenv -> int -> Intavs.t
val clenv_template_metavars : 'a clausenv -> Intavs.t
val dependent_metas : 'a clausenv -> int list -> Intavs.t -> Intavs.t
val clenv_dependent : 'a clausenv -> constr freelisted * constr freelisted -> int list
val clenv_pose_dependent_evars : wc clausenv -> wc clausenv
*)

val pr_clenv : 'a clausenv -> std_ppcmds

val unify : constr -> tactic
val unify_0 : (int * constr) list -> wc -> constr -> constr -> (int * constr) list * (constr * constr) list
val collect_metas : constr -> int list
val mk_clenv : 'a -> constr -> 'a clausenv
val mk_clenv_from : 'a -> constr * constr -> 'a clausenv
val mk_clenv_rename_from : 'a -> constr * constr -> 'a clausenv
val mk_clenv_hnf_constr_type_of : wc -> constr -> wc clausenv
val mk_clenv_printable_type_of : wc -> constr -> wc clausenv
val mk_clenv_type_of : wc -> constr -> wc clausenv

val connect_clenv : wc -> 'a clausenv -> wc clausenv
val clenv_change_head : constr * constr -> 'a clausenv -> 'a clausenv
val clenv_assign : int -> constr -> 'a clausenv -> 'a clausenv
val clenv_instance_term : 'a clausenv -> constr -> constr
val clenv_pose : name * int * constr -> 'a clausenv -> 'a clausenv
val clenv_template : 'a clausenv -> constr freelisted
val clenv_template_type : 'a clausenv -> constr freelisted
val clenv_instance_type : 'a clausenv -> int -> constr
val clenv_instance_template : 'a clausenv -> constr
val clenv_instance_template_type : 'a clausenv -> constr
val clenv_unify : constr -> constr -> wc clausenv -> wc clausenv
val clenv_fchain : int -> 'a clausenv -> wc clausenv -> wc clausenv
val clenv_refine : (wc -> tactic) -> wc clausenv -> tactic
val res_pf      : (wc -> tactic) -> wc clausenv -> tactic
val res_pf_cast : (wc -> tactic) -> wc clausenv -> tactic
val res_pf_cast_all : (wc -> tactic) -> wc clausenv -> tactic
val elim_res_pf : (wc -> tactic) -> wc clausenv -> tactic
val clenv_independent : 'a clausenv -> constr freelisted * constr freelisted -> int list
val clenv_missing : 'a clausenv -> constr freelisted * constr freelisted -> int list
val clenv_constrain_missing_args : constr list -> wc clausenv -> wc clausenv
val clenv_constrain_dep_args : constr list -> wc clausenv -> wc clausenv
val clenv_lookup_name : 'a clausenv -> identifier -> int
val clenv_match_args : (bindOcc * constr) list -> wc clausenv -> wc clausenv
val e_res_pf : (wc -> tactic) -> wc clausenv -> tactic
val clenv_type_of : wc clausenv -> constr -> constr
val clenv_unique_resolver : bool -> wc clausenv -> goal sigma -> wc clausenv

(* [abstract_list_all sig c t l]                           *)
(* abstracts the terms in l over c to get a term of type t *)
val abstract_list_all : goal sigma -> constr -> constr -> constr list -> constr

(* Exported for program.ml only *)
val clenv_add_sign : (identifier * type_judgement) -> wc clausenv -> wc clausenv
val constrain_clenv_to_subterm : wc clausenv -> constr * constr -> wc clausenv * constr
val clenv_constrain_dep_args_of : int -> constr list -> wc clausenv -> wc clausenv
val constrain_clenv_using_subterm_list : bool -> wc clausenv -> constr list -> constr -> wc clausenv * constr list
val clenv_typed_unify : constr -> constr -> wc clausenv -> wc clausenv

(* $Id: clenv.mli,v 1.10 1999/11/30 19:25:44 mohring Exp $ *)
