(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                states.mli                                *)
(****************************************************************************)

open Names;;
open More_util;;
open Lib;;
open Summary;;

type state = Lib.frozen_t * Summary.frozen_t;;

val raw_save_state : string -> string -> unit;;
val raw_restore_state : string -> unit;;
val raw_restore_last_saved_state : unit -> unit;;
val forget_state : bool -> string -> unit;;
val list_saved_states : unit -> (string * string) list;;

val extern_state : string -> unit;;
val intern_state : string -> unit;;

(* $Id: states.mli,v 1.4 1999/06/29 07:47:27 loiseleu Exp $ *)
