(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 mlm.mli                                  *)
(****************************************************************************)

type ('a,'b) t;;

(* A mlm is a reference to a listmap (which is a functional datatype).
   The operations are the same as Listmap, but we can freeze/unfreeze it. *)

val create : unit -> ('a,'b) t;;
val empty : ('a,'b)t -> unit;;
val map : ('a,'b) t -> 'a -> 'b;;
val dom : ('a,'b) t -> 'a list;;
val rng : ('a,'b) t -> 'b list;;
val in_dom : ('a,'b) t -> 'a -> bool;;
val in_rng : ('a,'b) t -> 'b -> bool;;
val inv : ('a,'b) t -> 'b -> 'a list;;
val add : ('a,'b) t -> 'a * 'b -> unit;;
val rmv : ('a,'b) t -> 'a -> unit;;
val remap : ('a,'b) t -> 'a -> 'b -> unit;;
val app : (('a * 'b) -> unit) -> ('a,'b) t -> unit;;
val toList : ('a,'b) t -> ('a * 'b) list;;

(* $Id: mlm.mli,v 1.7 1999/06/29 07:47:19 loiseleu Exp $ *)
