(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                mhmfs.mli                                 *)
(****************************************************************************)

(* A mhmfs is a mhm that maps lists of 'b *)

type ('a,'b) t = ('a,'b list) Mhm.t;;
type ('a,'b) frozen_t = ('a,'b list) Mhm.frozen_t;;

val create : int -> ('a,'b) t;;
val empty : ('a,'b)t -> unit;;
val map : ('a,'b) t -> 'a -> 'b list;;
val dom : ('a,'b) t -> 'a list;;
val in_dom : ('a,'b) t -> 'a -> bool;;
val add : ('a,'b) t -> 'a * 'b -> unit;;
val rmv : ('a,'b) t -> 'a * 'b -> unit;;
val app : (('a * 'b list) -> 'c) -> ('a,'b) t -> unit;;
val toList : ('a,'b) t -> ('a * 'b list) list;;

val freeze : ('a,'b) t -> ('a,'b) frozen_t;;
val unfreeze : ('a,'b) frozen_t -> ('a,'b) t -> unit;;

(* $Id: mhmfs.mli,v 1.7 1999/06/29 07:47:19 loiseleu Exp $ *)
