(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 mhm.mli                                  *)
(****************************************************************************)


(* A mhm is like an hashtabl, with more operations *)

type ('a,'b) t;;

val create : int -> ('a,'b) t;;
val empty : ('a,'b)t -> unit;;
val map : ('a,'b) t -> 'a -> 'b;;
val add : ('a,'b) t -> 'a * 'b -> unit;;
val rmv : ('a,'b) t -> 'a -> unit;;
val app : (('a * 'b) -> 'c) -> ('a,'b) t -> unit;;
val in_dom : ('a,'b) t -> 'a -> bool;;
val toList : ('a,'b) t -> ('a * 'b) list;;
val dom : ('a,'b) t -> 'a list;;
val remap : ('a,'b) t -> 'a -> 'b -> unit;;

type ('a,'b) frozen_t;;

val freeze : ('a,'b) t -> ('a,'b) frozen_t;;
val unfreeze : ('a,'b) frozen_t -> ('a,'b) t -> unit;;
val set_meanlen : ('a,'b) t -> int -> unit;;

(* $Id: mhm.mli,v 1.7 1999/06/29 07:47:18 loiseleu Exp $ *)
