(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  mhb.ml                                  *)
(****************************************************************************)
type ('a,'b) t = {f:('a,'b) Mhm.t;
                   finv: ('b,'a) Mhm.t};;
type ('a,'b) frozen_t = (('a,'b) Mhm.frozen_t * ('b,'a) Mhm.frozen_t);;

let create n = {f = Mhm.create n;
             finv = Mhm.create n};;

let map b k = Mhm.map b.f k;;
let pam b k = Mhm.map b.finv k;;
let dom b = Mhm.dom b.f;;
let rng b = Mhm.dom b.finv;;
let in_dom b k = Mhm.in_dom b.f k;;
let in_rng b v = Mhm.in_dom b.finv v;;

let add b (k,v) =
    if (not(in_dom b k)) & (not(in_rng b v)) then
        (Mhm.add b.f (k,v);
         Mhm.add b.finv (v,k))
    else failwith "mhb__add"
;;

let rmv b k =
let v = map b k
in (Mhm.rmv b.f k;
    Mhm.rmv b.finv v)
;;

let app f b = Mhm.app f b.f;;

let toList b = Mhm.toList b.f;;

let freeze b = (Mhm.freeze b.f,Mhm.freeze b.finv);;

let unfreeze (ff,ffinv) b =
    (Mhm.unfreeze ff b.f;
     Mhm.unfreeze ffinv b.finv)
;;

let set_meanlen b n =
    (Mhm.set_meanlen b.f n;
     Mhm.set_meanlen b.finv n)
;;

(* $Id: mhb.ml,v 1.7 1999/06/29 07:47:18 loiseleu Exp $ *)
