(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                listmap.ml                                *)
(****************************************************************************)

open Std

type ('a,'b) t = ('a * 'b) list

let rec delete n = function
    [] -> invalid_arg "Listmap.delete"
  | ((a,b) as h)::t ->
      if n = a then
        t
      else
        ((a,b)::(delete n t))


let create() = []
let map l a = List.assoc a l

let dom l = List.map fst l

let rng l = List.map snd l

let in_dom l a = 
  let rec in_dom_a = function
      [] -> false
    | ((a',_)::l) -> (a = a') or in_dom_a l
  in in_dom_a l 


let in_rng l b = 
  let rec in_rng_b = function
      [] -> false
    | ((_,b')::l) -> (b = b') or in_rng_b l
  in in_rng_b l


let inv l b = List.map fst (filter (fun (a',b') -> b' = b) l)

let add l (a,b) =
  if in_dom l a then invalid_arg "Listmap.add"
  else ((a,b)::l)

let rmv l a =
  if in_dom l a then
    delete a l
  else
    raise Not_found

let remap l a b =
  let rec aux = function
      ((k,v)::t) ->
    	if k = a then (a,b)::t
    	else (k,v)::(aux t)
    | _ -> invalid_arg "Listmap.remap"
  in
    aux l

let app f l = List.iter f l

let toList l = l

let for_all2_list f x y =  
  let rec fall = function 
      [],[] -> true
    | (a::x), (b::y) -> (f a b) & fall  (x,y)
    |  _ , _ -> invalid_arg "Listmap.for_all2_list"
  in  fall (x,y)


let rec map_append f = function
    [] -> []
  | x::xs -> (f x)@(map_append f xs)


let rec map2_append f a b =
  match a,b with 
      [], [] -> []
    | (x::la), (y::lb) -> (f x y)::(map2_append f la lb)
    |  _ , _ -> invalid_arg "Listmap.map2_append"


let split_list n l =
  let rec split_rec  i before = function
      [] -> invalid_arg "Listmap.split_list"
    | [a] -> (before,a,[]) 
    | a::l' -> if i=n then (before, a, l') else split_rec (i+1) (before@[a]) l'
  in 
    if n <= List.length l then split_rec 1 [] l 
    else invalid_arg "Listmap.split_list"


(* $Id: listmap.ml,v 1.10 1999/06/29 07:47:18 loiseleu Exp $ *)
