(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                intavm.ml                                 *)
(****************************************************************************)

open Std;;

type 'b t = 'b Intmap.t;;

let create () = Intmap.empty ;;

let toList m =
let r = ref []
in (Intmap.iter (fun k v -> r := (k,v)::!r) m;
    !r)
;;

let dom m = List.map fst (toList m);;
let rng m = List.map snd (toList m);;

let map m k = Intmap.find k m;;

let in_dom m k =
    try (map m k;true)
    with Not_found -> false
;;

let rmv m k = Intmap.remove k m;;

let add m (k,v) =
    if in_dom m k then raise (Failure "intavm__add")
    else Intmap.add k v m
;;

let remap m k v = (add (rmv m k) (k,v));;

let app f m = Intmap.iter (fun k v -> (f(k,v))) m;;

let ofList l = List.fold_left add (create()) l;;

let inv l b = List.map fst (filter (fun (a',b') -> b' = b) (toList l));;

(* $Id: intavm.ml,v 1.6 1999/06/29 07:47:17 loiseleu Exp $ *)
