(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 avm.mli                                  *)
(****************************************************************************)

type ('a,'b) t;;
type ('a,'b) frozen_t;;

val create : ('a -> 'a -> int) -> ('a,'b) t;;
val map : ('a,'b) t -> 'a -> 'b;;
val dom : ('a,'b) t -> 'a list;;
val rng : ('a,'b) t -> 'b list;;
val in_dom : ('a,'b) t -> 'a -> bool;;
val add : ('a,'b) t -> 'a * 'b -> ('a,'b) t;;
val rmv : ('a,'b) t -> 'a -> ('a,'b) t;;
val remap : ('a,'b) t -> 'a -> 'b -> ('a,'b) t;;
val app : (('a * 'c) -> unit) -> ('a,'c) t -> unit;;
val toList : ('a,'b) t -> ('a * 'b) list;;
val ofList : ('a -> 'a -> int) -> ('a * 'b) list -> ('a,'b) t;;
val inv : ('a,'b) t -> 'b -> 'a list;;

val freeze : ('a,'b) t -> ('a,'b) frozen_t;;
val unfreeze : ('a,'b) frozen_t -> ('a,'b) t -> ('a,'b) t;;

val clone_empty : ('a,'b) t -> ('a,'b) t;;


(* $Id: avm.mli,v 1.6 1999/06/29 07:47:14 loiseleu Exp $ *)
