------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                          A 4 G . C _ U _ I N F O                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

with Asis;        use Asis;

with A4G.A_Types; use A4G.A_Types;

with Types;       use Types;

--  This package contains the low-level routines which compute the unit
--  attributes for the newly compiled Ada compilation unit and its
--  supporters to make them ASIS Compilation Units for ASIS
--  implementation. (A4G.C_U_Info = Compute_Unit_Information). These routines
--  are used to implement the setting routines from A4G.S_U_Info
--  (Set_Unit_Information)

--  ???THIS COMMENT HEADER SHOULD BE REVISED???

package A4G.C_U_Info is

   function Enclosing_Unit
     (Cont : Context_Id; Node : Node_Id)
      return Asis.Compilation_Unit;
   --  This function is intended to be used to define the enclosing
   --  unit for an Element obtained as a result of some ASIS semantic query.
   --  It finds the N_Compilation_Unit node for the suntree, enclosing
   --  the Node given as its argument, and then defines the corresponding
   --  Unit Id, which is supposed to be the Id of Enclosing Unit for an
   --  Element built up on the base of Node. It does not change the tree
   --  being currently accessed. All these computations are supposed
   --  to be performed for a Context Cont.
   --  Node should not be a result of Atree.Original_Node, because
   --  it is used as an argument for Atree.Parent function
   --
   --  Note, that this function does no consistency check, that is, the
   --  currently accessed tree may be not from the list of consistent trees
   --  for the resultted Unit.
   --
   --  IS THIS PACKAGE A RIGHT PLACE FOR THIS FUNCTION??!!

end A4G.C_U_Info;