



package Debian::DebConf::Template;
use strict;
use POSIX;
use Debian::DebConf::Base;
use vars qw(@ISA $AUTOLOAD);
@ISA=qw{Debian::DebConf::Base};

sub _savefield {
	my $this=shift;
	my $field=shift;
	my $value=shift;
	my $extended=shift;

	if ($field ne '') {
		$this->$field($value);
		my $e="extended_$field";
		$this->$e($extended);
	}
}


sub merge {
	my $this=shift;
	my $other=shift;

	foreach my $key (keys %$other) {
		delete $other->{$key};
	}

	foreach my $key (keys %$this) {
		$other->$key($this->{$key});
	}
}


sub parse {
	my $this=shift;
	my $text=shift;

	my ($field, $value, $extended)=('', '', '');
	foreach (split "\n", $text) {
		chomp;
		if (/^([-_.A-Za-z0-9]*): (.*)/) {
			$this->_savefield($field, $value, $extended);
			$field=lc $1;
			$value=$2;
			$extended='';
		}
		elsif (/^\s+\.$/) {
			$extended.="\n\n";
		}
		elsif (/^\s+(.*)/) {
			$extended.=$1." ";
		}
		else {
			die "Template parse error near \"$_\"";
		}
	}

	$this->_savefield($field, $value, $extended);

	die "Template does not contain a Template: line"
		unless $this->{template};
}

sub _getlangs {
	my $language=setlocale(5); # LC_MESSAGES
	if ($language eq 'C' || $language eq 'POSIX') {
		return;
	}
	elsif ($language=~m/^(\w\w)_/) {
		return $language, $1;
	}
	return $language;
}


{
	my @langs=(); # this would call getlangs(), but I have disabled

	sub AUTOLOAD {
		my $this=shift;
		my $property = $AUTOLOAD;
		$property =~ s|.*:||; # strip fully-qualified portion
		
		$this->{$property}=shift if @_;
		
		if (@langs) {
			foreach my $lang (@langs) {
				if (exists $$this{$property.'-'.$lang}) {
					$property.='-'.$lang;
					last;
				}
			}
		}
		
		return $this->{$property};
	}
}


1
