



package Debian::DebConf::Element::Container;
use Debian::DebConf::Element;
use Debian::DebConf::ConfigDb;
use strict;
use UNIVERSAL qw(isa);
use vars qw(@ISA);
@ISA=qw(Debian::DebConf::Element);


sub question {
	my $this=shift;

	if (@_) {
		if (! $this->frontend) {
			die "Container element question medthod called before frontend was set.";
		}
	
		$this->{'question'}=shift;

		my @contained=();
		my @subcontainers=();	
		foreach my $question (Debian::DebConf::ConfigDb::gettree($this->{'question'})) {
			my $ok=1;
			foreach (@subcontainers) {
				$ok='' if Debian::DebConf::ConfigDb::isunder($_, $question);
			}
			next unless $ok;
			
			my $element=$this->frontend->makeelement($question);
			if (isa($element, "Debian::DebConf::Element::Container")) {
				push @subcontainers, $element;
			}
			push @contained, $element;
		}
		$this->{'contained'}=\@contained;
	}
	return $this->{'question'};
}




sub show {
	my $this=shift;
	my @contained=@{$this->contained};
	
	foreach my $elt (@contained) {
		$elt->show;
	}
}


1
