# help.tcl
#
# shows HTML 2.0 files
# no directory handling

proc hlp_taglink {} {
  global hlp

  if {$hlp(tag) == {}} {return}
  .help.t tag configure $hlp(tag) -borderwidth 0 -relief flat
  regsub L: $hlp(tag) {} link
  HMlink_callback .help.t $link
}

proc hlp_Next {{delta 1}} {
  global hlp

  if {$hlp(tag) != {}} {
    .help.t tag configure $hlp(tag) -borderwidth 0 -relief flat
    set hlp(tag) {}
  }
  set pos [.help.t index insert]
  set l [llength $hlp(links)]
  if {$delta > 0} {
    for {set i 0} {$i < $l} {incr i} {
      if {[.help.t compare $pos < [lindex [lindex $hlp(links) $i] 0]]} {break}
    }
    if {$i == $l} {return}
  } else {
    for {set i [expr $l-1]} {$i >= 0} {incr i -1} {
      if {[.help.t compare $pos > [lindex [lindex $hlp(links) $i] 0]]} {break}
    }
    if {$i == 0} {return}
  }
  set entry [lindex $hlp(links) $i]
  set pos [lindex $entry 0]
  set hlp(tag) [lindex $entry 1]
  .help.t tag configure $hlp(tag) -borderwidth 2 -relief raised
  .help.t mark set insert $pos
  .help.t see $pos
}

      

proc hlp_Copy {} {
  global hlp ted_buf

  set ted_buf [selection get]
}

proc ReadHtml {win file {pos ""}} {
  
  set fd [open $file r]
  set text [read $fd]
  close $fd
  HMparse_html $text "HMrender $win"
  if {$pos != ""} {
    HMgoto $win $pos
  }
}

proc HMlink_callback {win file {his 0}} {
  global hlp
  
  if {$hlp(locked)} {return}
  set pos ""
  if {$his < 0} {
    set l [expr [llength $hlp(history)]-2]
    if {$l >= 0} {
      set file [lindex $hlp(history) $l]
      set hlp(history) [lreplace $hlp(history) $l end]
    } else {
      return
    }
  }
  set hlp(locked) 1
  regexp {([^#]*)#(.*)} $file dummy file pos
  debug $pos
  if {$file == "" && $pos != ""} {
    HMgoto $win $pos
    .help.t mark set insert N:$pos
    set hlp(locked) 0
    return
  }
  WaitHint $win "Please be patient"
  HMreset_win $win
  cd [file dirname $file]
  set file [file tail $file]
  lappend hlp(history) [pwd]/$file#$pos
  ReadHtml $win $file $pos
  .help.t mark set insert 1.0
  set hlp(links) {}
  foreach tag [.help.t tag names] {
    if [regexp {^L:.*} $tag] {
      set r [.help.t tag ranges $tag]
      set l [llength $r]
      for {set i 0} {$i < $l} {incr i 2} {
        debug "[lindex $r $i] $tag]"
        lappend hlp(links) [list [lindex $r $i] $tag]
      }
    }
  }
  if {$pos != {}} {
    .help.t mark set insert N:$pos
  }
  DelWaitHint
  set hlp(locked) 0
}

proc hlpcmp {a b} {
  set x [lindex $a 0]
  set y [lindex $b 0]
  if {$x < $y} {return -1}
  if {$x > $y} {return 1}
  return 0
}

proc Help {win} {
  global hlp params gparams

  if [winfo exists .help] {return}
  set hlp(dir) $params(hlpdir)/$gparams(hlplan)

  toplevel .help
  wm geometry .help +0+100
  wm title .help Help

  frame .help.m -relief raised -bd 1
  pack .help.m -fill x

  menu .help.menubar
  .help config -menu .help.menubar
  foreach m {File Topics} {
    set $m [menu .help.menubar.m$m -tearoff 0]
    .help.menubar add cascade -label $m -underline 0 -menu .help.menubar.m$m
  }
  $File add command -label Exit -accelerator Esc \
    -command {set hlp(ok) 1}

  $Topics add command -label Main -accelerator M \
    -command "HMlink_callback .help.t $hlp(dir)/main.html#main"
#  $Topics add command -label Index -accelerator I \
#    -command "HMlink_callback .help.t $hlp(dir)/index.html"
  $Topics add command -label LaTeX \
    -command "HMlink_callback .help.t $hlp(dir)/latex/index.html"

  frame .help.b
  pack .help.b -fill x

  button .help.b.home -bitmap @$params(icon_dir)/home.ico \
    -command "HMlink_callback .help.t $hlp(dir)/main.html#main"
  button .help.b.latex -bitmap @$params(icon_dir)/tex1.ico \
    -command "HMlink_callback .help.t $hlp(dir)/latex/index.html"
  button .help.b.ref -bitmap @$params(icon_dir)/man1.ico \
    -command "HMlink_callback .help.t $hlp(dir)/latex/sec184.html"
  button .help.b.left -bitmap @$params(icon_dir)/left.ico \
    -command "HMlink_callback .help.t dummy -1"
  button .help.b.exit -bitmap @$params(icon_dir)/door1.ico \
    -command {set hlp(ok) 1}
  pack .help.b.home .help.b.latex .help.b.ref .help.b.left -side left
  pack .help.b.exit -side right

  scrollbar .help.sb -command {.help.t yview}
  pack .help.sb -side right -fill y
  text .help.t -yscroll {.help.sb set}
  catch {
    .help.t configure -font \
      [list $gparams(font) $gparams(fontsize) $gparams(fontstyle)]
  }
  pack .help.t -fill both -expand true 
  HMinit_win .help.t
  set hlp(history) {}
  set hlp(history_pos) 0

  bindtags .help.t {.help.t}
  bind .help.t <Tab>    {hlp_Next}
  bind .help.t <Shift-Tab> {hlp_Next -1}
  bind .help.t <Any-i> "HMlink_callback .help.t $hlp(dir)/latex/sec184.html"
  bind .help.t <Any-m> "HMlink_callback .help.t $hlp(dir)/main.html#main"
  bind .help.t <Control-c> {hlp_Copy}
  bind .help.t <Return> {hlp_taglink} 
  bind .help.t <Escape> {set hlp(ok) 1}
  bind .help.t <Prior> [bind Text <Prior>]
  bind .help.t <Next>  [bind Text <Next>]
  bind .help.t <Up>  [bind Text <Up>]
  bind .help.t <Down>  [bind Text <Down>]
  bind .help.t <Alt-Key>  [bind all <Alt-Key>]
  bind .help.t <Any-Key> { }
  
  bind .help.b.home <Enter> {ButtonHint %W "Main Help"}
  bind .help.b.home <Leave> {DelButtonHint}
  bind .help.b.latex <Enter> {ButtonHint %W "LaTeX Help"}
  bind .help.b.latex <Leave> {DelButtonHint}
  bind .help.b.ref <Enter> {ButtonHint %W "LaTeX Index"}
  bind .help.b.ref <Leave> {DelButtonHint}
  bind .help.b.left <Enter> {ButtonHint %W "Back"}
  bind .help.b.left <Leave> {DelButtonHint}
  bind .help.b.exit <Enter> {ButtonHint %W "Exit Help"}
  bind .help.b.exit <Leave> {DelButtonHint}
    
  set hlp(old_focus) [focus]
  xfocus .help.t
  grab .help
  update
  set x [winfo rootx .help.t]
  set y [winfo rooty .help.t]
  set hlp(dlg_geom) 300x200+$x+$y

  switch $win {
    "."     {set item "main.html#main"}
    default {set item "tedit.html#main"}
  }
  cd $hlp(dir)
  set hlp(locked) 0
  HMlink_callback .help.t $item
  set hlp(tag) {}
  set hlp(links) [lsort -command hlpcmp $hlp(links)]
  debug $hlp(links)
  set hlp(pos) -1
  tkwait variable hlp(ok)
  grab release .help
  xfocus $hlp(old_focus)
  catch {destroy .hint}
  destroy .help
  cd $params(Primary_dir)
}
