/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Alan W Black                            */
/*                     Date   :  April 1996                              */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*             Top level .h file: main public functions                  */
/*=======================================================================*/
#ifndef __FESTIVAL_H__
#define __FESTIVAL_H__

#include <stdlib.h>
#include <fstream.h>
#include "EST.h"
#include "EST_cutils.h"
#include "siod.h"

#include "Phone.h"

#ifndef streq
#define streq(X,Y) (strcmp(X,Y)==0)
#endif

struct ModuleDescription;

/* An iostream for outputing debug messages, switchable    */
/* to /dev/null or cerr                                    */
extern ostream *cdebug;
#define cwarn cout
extern "C" FILE* stddebug;
extern int ft_server_socket;
extern char *festival_version;

/* For server/client */
#define FESTIVAL_DEFAULT_PORT 1314
int festival_socket_client(const char *host,int port);
int festival_start_server(int port);

/* Should be in EST_Wave.h (or done some other way) */
#define WaveC(cell) ((EST_Wave *)((cell).contents()))

void festival_initialize(int load_init_files,int heap_size);
void festival_init_lang(const EST_String &language);
void festival_load_file(const EST_String &fname);
void festival_say_file(const EST_String &fname);
void festival_repl(int interactive);
void festival_server_mode(void);
void festival_wait_for_spooler(void);

typedef void (*FT_Module)(EST_Utterance &utt);

/* Feature functions */
typedef EST_Val (*FT_ff_func)(EST_Utterance &u,EST_Stream_Item &s);
typedef EST_Val (*FT_ff_pref_func)(EST_Utterance &u,EST_Stream_Item &s,
				   const EST_String &name);
void festival_def_ff(const EST_String &name,const EST_String &sname, 
		     FT_ff_func func,char *doc);
void festival_def_ff_pref(const EST_String &pref,const EST_String &sname, 
			  FT_ff_pref_func func, char *doc);
EST_Val ffeature(EST_Utterance &u,EST_Stream_Item &s, const EST_String &name);
LISP lisp_val(const EST_Val &pv);

/* proclaim a new module 
   option Copyright to add to startup banner
   description is a computer readable description of the
   module
 */
void proclaim_module(const EST_String &name,
		     const EST_String &banner_copyright,
		     const ModuleDescription *description = NULL);

void proclaim_module(const EST_String &name,
			    const ModuleDescription *description = NULL);

void init_module_subr(const char *name, LISP (*fcn)(LISP), const ModuleDescription *description);

/* Some basic functions for accessing structures created by */
/* various modelling techniques                             */
EST_Val wagon_predict(EST_Utterance &u, EST_Stream_Item &s, LISP tree);
LISP wagon_pd(EST_Utterance &u, EST_Stream_Item &s, LISP tree);
EST_Val lr_predict(EST_Utterance &u, EST_Stream_Item &s, LISP lr_model);

/* On error do a longjmp to appropriate place */
/* This is done as a macro so the compiler can tell its non-returnable */
#define festival_error()  (errjmp_ok ? longjmp(*errjmp,1) : exit(-1))

/* Add new (utterance) module */
void festival_def_utt_module(char *name,LISP (*fcn)(LISP),char *docstring);

EST_Utterance *GETUTTVAL(LISP x);
EST_Stream_Item *GETSTREAMITEMVAL(LISP x);
void utt_cleanup(EST_Utterance &u); // delete all streams except IForm
/* This function increments a refcount in u */
LISP siod_make_utt(EST_Utterance &u);
const EST_String utt_iform_string(EST_Utterance &utt);
LISP utt_iform(EST_Utterance &utt);
const EST_String utt_type(EST_Utterance &utt);
void add_item_features(EST_Stream_Item &s,LISP features);

extern char *festival_libdir;

/* Endian and byte swaping */
extern int ft_endian_loc;
/* Sun, HP, SGI Mips, M68000 */
#define FT_BIG_ENDIAN (((char *)&ft_endian_loc)[0] == 0)
/* Intel, Alpha, DEC Mips, Vax */
#define FT_LITTLE_ENDIAN (((char *)&ft_endian_loc)[0] != 0)

//  Module specific LISP/etc definitions
void festival_init_modules(void);

// Some general functions 
LISP ft_get_param(const EST_String &pname);

// SIOD user defined types used by festival

#define tc_festival_dummyobject tc_application_1
#define tc_festival_unit tc_application_2
#define tc_festival_unitdatabase tc_application_3
#define tc_festival_unitindex tc_application_4
#define tc_festival_join tc_application_5
#define tc_festival_schememoduledescription tc_application_6

// used to recognise our types
#define tc_festival_first_type tc_festival_dummyobject
#define tc_festival_last_type tc_festival_schememoduledescription
#define is_festival_type(X) ((X) >= tc_festival_first_type && (X) <= tc_festival_last_type)

#endif
