 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                                                                      */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon Mar  3 1997                              */
 /* ------------------------------------------------------------------   */
 /* Abstraction for indecies. Different selection methods can have       */
 /* different indexing styles. This interface just defines what the      */
 /* general database handler needs to know about them.                   */
 /*                                                                      */
 /************************************************************************/

class UnitIndex;

#ifndef __UNITINDEX_H__
#define __UNITINDEX_H__

#include "EST.h"
#include "UnitDatabase.h"
#include "SubtypedObject.h"

class UnitIndex : public SubtypedObject<UnitIndex> {

private:
  UnitDatabase *p_database;

protected:
  void set_database(UnitDatabase *db) {p_database=db;};

public:

  UnitIndex(void);
  virtual ~UnitIndex(void); 

  UnitDatabase *database(void) const {return p_database;};

  virtual EST_read_status fill_from(FILE *stream, int binary=1);
  virtual EST_write_status write_to(FILE *stream, int binary=1);

  virtual int set_property(EST_String property, ValueType value);

// required by the FestivalObject interface, but not useful for unitindexes.
  void set_filename(EST_String) { };

  virtual void associate_database(UnitDatabase *db);
  virtual void index(void);

  // Additionally an index type will define one or more lookup
  // functions.
#if 0
  EST_Vector<UnitName> lookup(YOUR_ARGUMENTS_HERE) const;
#endif

  virtual void gc_mark(void) 
	{if (p_database) p_database->gc_mark(); else p_gc_mark++;} ;
  virtual void gc_clear_mark(void) 
	{if (p_database) p_database->gc_clear_mark(); else p_gc_mark=0;};
  virtual int  gc_marked(void) 
	{return (p_database?(p_database->gc_marked()):p_gc_mark);};

#if defined(INCLUDE_LISP)
  //lisp interface
  static void lisp_print(LISP, FILE *);
  static void lisp_print_string(LISP, char *);
  static void lisp_declare(void);
#endif

  friend class SubtypedObject<UnitIndex>;
};


#endif
