 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Mon Mar 17 1997                               */
 /* -------------------------------------------------------------------   */
 /* Common code for objects available from scheme.                        */
 /*                                                                       */
 /*************************************************************************/

#if !defined(__SCHEMEOBJECT_H__)
#define __SCHEMEOBJECT_H__

// remove to use these types outside SIOD. This is not quite all it should be
// yet since some of the methods take property lists as parameters and
// we use the lisp reader once, but the thought is there
#define INCLUDE_LISP (1)

// There is a bug in (some versions of?) gcc when not optimising and dealing
// with inline member functions which are used inside others inside functions
// whose address is taken. Or at least that's where it bit me (rjc).
#if defined(__GNUC__) && !defined(__OPTIMIZE__)
#   define DONT_INLINE_EVERYTHING (1)
#endif

#if defined(DONT_INLINE_EVERYTHING)
#   define INLINE_IF_OK(X) // empty
#else
#   define INLINE_IF_OK(X) X
#endif

#if defined(INCLUDE_LISP)
#   include <stdio.h>
#   include "siod.h"
#   include "festival.h"
typedef LISP ValueType;
#define value_as_c_string(V) get_c_string(V)
#define value_as_string(V) EST_String(get_c_string(V))
#define value_as_int(V) (TYPEP(V,tc_flonum)?(int)FLONM(V):0)
#define value_as_float(V) (TYPEP(V,tc_flonum)?FLONM(V):0.0)
#define value_as_list(V) (V)
#define string_as_value(S) string_cell((const char *)(S), (S).length())
#define c_string_as_value(S) string_cell((S), ((S)?(strlen(S)):0))
#define int_as_value(N)  flocons(N)
#define float_as_value(N)  flocons(N)
#define null_as_value (LISP)NULL
#define list_as_value(L) (L)
#endif

class SchemeObject {
protected:
  static EST_String error_string;
protected:
  int p_gc_mark;
  unsigned int p_reference_count;
  EST_String p_name;

public: 
  SchemeObject(void);
  virtual ~SchemeObject(void);

  virtual EST_String type_name(void) const {return "SchemeObject";};

  EST_String name(void) const INLINE_IF_OK({return p_name;});
  void set_name(EST_String name) INLINE_IF_OK({p_name = name;});

  int set_properties(LISP properties);

  virtual void property_names(EST_TList<EST_String> &list) const;
  virtual ValueType property(EST_String name) const;
  virtual int set_property(EST_String name, ValueType value);
  
  virtual void gc_mark(void) INLINE_IF_OK({(gc_master_pointer()->p_gc_mark)++;});
  virtual void gc_clear_mark(void) INLINE_IF_OK({(gc_master_pointer()->p_gc_mark)=0;});
  virtual int  gc_marked(void) INLINE_IF_OK({return (gc_master_pointer()->p_gc_mark);});

  virtual void gc_ref(void) INLINE_IF_OK({(gc_master_pointer()->p_reference_count)++;});
  virtual void gc_unref(void) INLINE_IF_OK({(gc_master_pointer()->p_reference_count)--;});
  virtual int  gc_referenced(void) INLINE_IF_OK({return (gc_master_pointer()->p_reference_count)>0;});

  virtual SchemeObject *gc_master_pointer(void) INLINE_IF_OK({return this;});

  static void decrease_reference_count(void *it);

#if defined(INCLUDE_LISP)
protected:
  static int s_lisp_type;
public:
  static LISP lisp_gc_mark(LISP);
  static void lisp_gc_clear_mark(LISP);
  static void lisp_gc_free(LISP);

  static LISP lisp_set_property(LISP object, LISP property, LISP value);
  static LISP lisp_property_names(LISP object);
  static LISP lisp_get_property(LISP object, LISP property);
  static LISP lisp_set_properties(LISP object, LISP properties);

  static void lisp_print(LISP, FILE *);
  static void lisp_print_string(LISP, char *);

  static void lisp_declare(void);
#endif
};

#endif
