/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Alan W Black                            */
/*                     Date   :  April 1996                              */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*                 A bunch of system related functions                   */
/*                                                                       */
/*=======================================================================*/
#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "EST_unix.h"
#include "EST_cutils.h"
#include "siod.h"
#include "siodline.h"

LISP lgetenv(LISP name)
{
    return rintern(getenv(get_c_string(name)));
}

LISP lsetenv(LISP name,LISP value)
{
    char *entry=walloc(char,strlen(get_c_string(name))+
		       strlen(get_c_string(value))+16);
    sprintf(entry,"%s=%s",get_c_string(name),get_c_string(value));
    putenv(entry);
    return name;
}

LISP lsystem(LISP name)
{
    system(get_c_string(name));
    return NIL;
}

LISP lunlink(LISP name)
{
    unlink(get_c_string(name));
    return NIL;
}

LISP lpwd(void)
{
    char *cwd;

    cwd = getcwd(NULL,1024);

    return cintern(cwd);
}

LISP lchdir(LISP args, LISP env)
{
    (void)env;
    char *home;
    
    if (siod_llength(args) == 0)
    {
	home = getenv("HOME");
	chdir(home);
	return rintern(home);
    }
    else
    {
	chdir(get_c_string(car(args)));
	return (car(args));
    }
}

LISP lgetpid(void)
{
    return flocons((float)getpid());
}

    
