/* This file Copyright 1992 by Clifford A. Adams */
/* score.h
 *
 */

/* RETHINK LOWSCORE: (especially for 16-bit scores?) */
/* score given to unavailable articles */
#define LOWSCORE (-999999)

/* specific scoreflag meanings:  (note: bad placement, but where else?) */
/* author has a score (match on FROM: line) */
#define SFLAG_AUTHOR 1
/* if TRUE, the article has been scored */
#define SFLAG_SCORED 16
#define SCORED(a) (scoreflags[AOFFSET(a)] & SFLAG_SCORED)

/* array of scores (AOFFSET(artnum))*/
EXT int *scores;

/* 1 byte per article.  Note: shorts or longs may be used later... */
/* bit format:
   0-3: for scorefile.c
   4-7: not currently used.
 */
EXT char *scoreflags;

bool kill_thresh_active INIT(FALSE);
int kill_thresh INIT(LOWSCORE);   /* KILL articles at or below this score */

ART_NUM sc_fill_max;	/* maximum art# scored by fill-routine */
bool sc_fill_read INIT(FALSE); /* TRUE if also scoring read arts... */

/* has score been initialized (are we "in" scoring?) */
EXT bool sc_initialized INIT(FALSE);

/* are we currently scoring an article (prevents loops) */
EXT bool sc_scoring INIT(FALSE);

/* changes order of sorting (artnum comparison) when scores are equal */
bool score_newfirst INIT(FALSE);

#ifdef NICEBG
EXT bool sc_mode_nicebg INIT(TRUE);
#endif

#ifdef NEWSFILTER
EXT bool sc_have_newsclip INIT(FALSE);
/* Whether to use NewsClip or not (even if available).  */
EXT bool sc_use_newsclip INIT(FALSE);
#endif

/* If true, save the scores for this group on exit. */
EXT bool sc_savescores INIT(FALSE);

/* If true, delay initialization of scoring until explicitly required */
EXT bool sc_delay INIT(FALSE);

EXT bool sc_announce_elig INIT(FALSE); /* print '!' when elig. scored... */
EXT bool sc_rescoring INIT(FALSE);	/* are we rescoring now? */

EXT bool sc_do_spin INIT(FALSE);	/* actually do the score spinner */

EXT bool sc_sf_delay INIT(FALSE);	/* if TRUE, delay loading rule files */
EXT bool sc_sf_force_init INIT(FALSE);	/* If true, always sf_init() */

void	sc_init		_((bool_int));
void	sc_grow		_((ART_NUM,ART_NUM));
void	sc_cleanup	_((void));
int	sc_score_art	_((ART_NUM,bool_int));
void	sc_fill_scorelist _((ART_NUM,ART_NUM)); /* private */
void	sc_lookahead	_((bool_int,bool_int));
int	sc_percent_scored _((void));
void	sc_append	_((char *));
/* mark as read all article at or below threshold int... */
void	sc_kill_threshold _((int));
void	sc_rescore	_((void));
void	sc_score_cmd	_((char *));	/* exec a single-quote command */
void	sc_set_score	_((ART_NUM,int));
