/* This file Copyright 1993 by Clifford A. Adams */
/* url.c
 *
 * Routines for handling WWW URL references.
 */

#include "EXTERN.h"
#include "common.h"
#ifdef USEURL
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "term.h"
#include "INTERN.h"
#include "url.h"

/* just a little bit larger than necessary... */
static char url_buf[1030];

static char url_type[256];
static char url_host[256];
static int  url_port;
static char url_path[1024];

/* returns TRUE if successful */
bool
fetch_http(host,port,path,outname)
char *host;
int port;
char *path;
char *outname;
{
    struct sockaddr_in server;
    struct hostent *hp;
    int sock;
    struct fd_set ready;
    struct timeval to;
    FILE *fp_out;
    int i;

#if 0
    /* for those times you want to see what's hapenning... */
    printf("grabbing URL using HTTP!\n") FLUSH;
    while (!input_pending())
	;
    eat_typeahead();
#endif
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
	printf("\nError opening stream socket.\n");
	return(FALSE);
    }
    server.sin_family = AF_INET;
    hp = gethostbyname(host);
    if (hp == 0) {
	printf("\n%s: unknown host\n", host);
	return(FALSE);
    }
    bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
    server.sin_port = htons(port);
    if (connect(sock, &server, sizeof(server)) < 0) {
	printf("\nError connecting stream socket.\n");
	return(FALSE);
    }

    sprintf(url_buf, "GET %s\n",path);
    if (write(sock, url_buf, strlen(url_buf)+1) < 0) {
	printf("\nError: writing on stream socket\n");
	return(FALSE);
    }

#ifdef NICEBG
    /* if NICEBG didn't work, this probably won't either */
    /* wait up to 15 seconds for a reply */
    FD_ZERO(&ready);
    FD_SET(sock, &ready);
    to.tv_sec = 15;
    to.tv_usec = 0;
    if (select(sock + 1, &ready, NULL, NULL, &to) < 0) {
	printf("\nError while waiting for a reply.\n");
	return(FALSE);
    }
#if 0
    printf("\nTime to spare: %d sec, %d us\n",to.tv_sec,to.tv_usec);
#endif
#endif

    fp_out = fopen(outname,"w");
    if (!fp_out) {
	printf("\nURL output file could not be opened.\n");
	return(FALSE);
    }
    while (1) {
#ifdef NICEBG
	if (FD_ISSET(sock, &ready)) {
#endif
	    if ((i = read(sock, url_buf, 1024)) < 0) {
		printf("\nError: reading stream message\n");
		return(FALSE);
	    } else if (i == 0) {
#if 0
		printf("Ending connection\n");
#endif
		break;
	    } else {
		fwrite(url_buf,1,i,fp_out);
#if 0
		/* only good for ASCII (no NULLs) */
		fprintf(fp_out,"%s",url_buf);
#endif
	    }
#ifdef NICEBG
	} else {
	    printf("\nNo message received.\n");
	    return(FALSE);	/* no message */
	}
#endif
    }
  fclose(fp_out);
  close(sock);
  return(1);
}

/* right now only full, absolute URLs are allowed. */
/* use relative URLs later? */
/* later: pay more attention to long URLs */
bool
parse_url(url)
char *url;
{
    char *s,*p;

    url_port = 80;	/* the default */
    if (!url || !*url) {
	printf("Empty URL -- ignoring.\n") FLUSH;
	return(FALSE);
    }
    p = url_type;
    for (s=url;(*s && (*s != ':'));s++)
	*p++ = *s;
    *p = '\0';
    if (!*s) {
	printf("Incomplete URL: %s\n",url) FLUSH;
	return(FALSE);
    }
    s++;
    if (strnEQ(s,"//",2)) {
	/* normal URL type, will have host (optional portnum) */
	s += 2;
	p = url_host;
	for (;(*s && (*s != '/') && (*s != ':'));)
	    *p++ = *s++;
	*p = '\0';
	if (!*s) {
	    printf("Incomplete URL: %s\n",url) FLUSH;
	    return(FALSE);
	}
	if (*s == ':') {
	    s++;
	    p = url_buf;	/* temp space */
	    if (!isdigit(*s)) {
		printf("Bad URL (non-numeric portnum): %s\n") FLUSH;
		return(FALSE);
	    }
	    while (isdigit(*s))
		*p++ = *s++;
	    *p = '\0';
	    url_port = atoi(url_buf);
	}
    } else {
	if (!strEQ(url_type,"news")) {
	    printf("URL needs a hostname: %s\n",url);
	    return(FALSE);
	}
    }
    /* finally, just do the path */
    if (*s != '/') {
	printf("Bad URL (path does not start with /): %s\n",url) FLUSH;
	return(FALSE);
    }
    strcpy(url_path,s);
    return(TRUE);
}

bool
url_get(url,outfile)
char *url;
char *outfile;
{
    bool flag;
    
    if (!parse_url(url))
	return(FALSE);

    if (strEQ(url_type,"http")) {
	flag = fetch_http(url_host,url_port,url_path,outfile);
    } else {
	printf("\nURL type %s not supported (yet?)\n") FLUSH;
	flag = FALSE;
    }
    return(flag);
}
#endif /* USEURL */
