
/*
 * DEFS.H
 *
 *
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution
 *    for specific rights granted.
 */

#include "config.h"

#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/socket.h>		/* internet sockets	*/
#include <sys/un.h>		/* unix domain sockets	*/
#include <sys/mman.h>		/* mmap()		*/
#ifdef _AIX
#include <sys/select.h>
#endif
#include <netinet/in.h>		/* internet sockets	*/
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#if USE_BSTRING_H
#include <bstring.h>
#endif

#if USE_PCOMMIT_SHM || USE_SPAM_SHM
#include <sys/ipc.h>		/* SYSV shared memory	*/
#include <sys/shm.h>		/* SYSV shared memory	*/
#endif

#include <stdarg.h>
#include <stddef.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <netdb.h>		/* internet sockets	*/
#include <arpa/inet.h>
#include <signal.h>
#include <syslog.h>
#include <pwd.h>
#include <grp.h>
#include <math.h>
#include <fcntl.h>

typedef signed char	int8;
typedef short		int16;
typedef int		int32;
typedef unsigned char	uint8;
typedef unsigned short	uint16;
typedef unsigned int	uint32;

#define Prototype extern

typedef struct {
    int32	h1;
    int32	h2;
} hash_t;

typedef struct HistHead {
    uint32	hmagic;		/* 0xA1B2C3D4			*/
    uint32	hashSize;	/* entries in hash table	*/
    uint16	version;	/* version of history file	*/
    uint16	henSize;	/* size of history entry	*/
    uint16	headSize;	/* size of history header	*/
} HistHead;

#define HMAGIC		((uint32)0xA1B2C3D4)
#define HVERSION	1

/*
 * History file entry.  The filename is calculated from the gmt start
 * (calculates the directory), and file id.  Each incoming process
 * allocates its own file & id and appends to it.
 */

typedef struct History {
    uint32 	next;	/* next link		*/
    uint32	gmt;	/* gmt time in minutes	*/
    hash_t	hv;	/* hash value		*/
    uint16 	iter;	/* file id 		*/
    uint16	exp;	/* hours relative to gmt minutes */
    uint32	boffset;/* starting offset in file	*/
    int32	bsize;	/* size of file		*/
} History;

/*
 * Article blocks terminate with 0x00 0xFF 0xAA 0x55 magic
 */

#define TERM0	0x00
#define TERM1	0xFF
#define TERM2	0xAA
#define TERM3	0x55

#ifdef FUTURE

typedef struct Active {
    uint32	next;	/* next link		*/
    uint32	sub;	/* subhierarchy		*/
    uint32	loWat;	/* low water mark	*/
    uint32	hiWat;	/* high water mark	*/
    uint32	id;	/* Overview file id	*/
    uint16 	bytes;
    char	data[2];
} Active;

typedef struct OverRef {
    uint32 offset;	/* offset in file -> OverView		*/
    uint16 artMod;	/* article number MSB mod value		*/
    uint16 reserved;
} OverRef;

typedef struct OverHead {
    int32		arts;	/* (fixed) max articles for this group	*/
    int32		rollov;	/* roll-over point			*/
    OverRef		ref[1];	/* index array			        */
} OverHead;

typedef struct OverView {
    int32		artno;		/* article number double-check	*/
    int16		nelm;		/* number of elements		*/
    int16		reserved;	/* future			*/
    int16		elen[1];	/* element byte lens [nelm]	*/
    /* elen[N]		*/
    /* elements		*/
} OverView;

#endif

#define HGF_FAST	0x01
#define HGF_NOSEARCH	0x02

typedef struct Node {
    struct Node		*no_Next;
    int32		no_Value;
    const char		*no_Name;
    const char		*no_Name2;
    void		*no_Data;
} Node;

#define MAXLINE		16384
#define MAXMSGIDLEN	512
#define MAXGNAME	256
#define MAXFORKS	256
#define MAXFEEDS	128
#define MAXFDS		(MAXFORKS+MAXFEEDS+32)
#if MAXFDS > FD_SETSIZE
#undef MAXFDS
#define MAXFDS FD_SETSIZE
#endif


#ifndef HSIZE

#if USE_SMALL_HASH
#define HSIZE		(1024*1024)		
#else
#if USE_LARGE_HASH
#define HSIZE		(4096*1024)
#else
#if USE_REALLY_LARGE_HASH
#define HSIZE		(8192*1024)
#else
#define HSIZE		(4096*1024)
#endif
#endif
#endif

#endif

/*
 * Default history retention, in days.   Articles are rejected if they
 * are older the the specified number of days.  History retention is
 * 2 days longer.
 */

#ifndef REMEMBERDAYS
#if USE_SHORT_REMEMBER
#define REMEMBERDAYS	7
#else
#define REMEMBERDAYS	14
#endif
#endif

#define MAXSIMUL	5	/* maximum simultanious from same label */

#define RCOK		0	/* article accepted		*/
#define RCALREADY	1	/* we already have this article	*/
#define RCTRYAGAIN	2	/* something went wrong, requeue it for later */
#define RCREJECT	3	/* there is something wrong with your article */
#define RCERROR		4	/* an unexpected error occured  */

#define XLOCK_SH	1
#define XLOCK_EX	2
#define XLOCK_UN	3
#define XLOCK_NB	0x10

#define MAXFEEDTABLE	256

typedef struct Buffer {
    int			bu_Beg;
    int			bu_NLScan;
    int			bu_End;
    int			bu_BufMax;	/* normal maximum	*/
    int			bu_DataMax;	/* extended maximum	*/
    int			bu_Fd;
    int			bu_Error;
    char		*bu_Data;	/* included/extended buffer	*/
    char		bu_Buf[1024];	/* included buffer		*/
} Buffer;

typedef struct MemNode {
    struct MemNode	*mr_Next;
    int32		mr_Bytes;
} MemNode;

typedef struct MemPool {
    struct MemPool	*mp_Next;
    void		*mp_Base;
    MemNode		*mp_First;
    int			mp_Size;
    int			mp_Used;
} MemPool;

/*
 * MISC
 */

#ifndef LOG_PERROR
#define LOG_PERROR	0
#endif

#include "protos.h"

/*
 * can't use Prototype stuff for functions which may
 * already be prototyped.
 */

#if USE_STRERROR
char *strerror(int e);
#endif
#if USE_MEMMOVE
void *memmove(char *dst0, const char *src0, size_t length);
#endif

