#!/usr/bin/make -f
#
# source:
#   $Source: /var/cvs/projects/debian/dpkg.common/rules_var.mk,v $
#
# revision:
#   @(#) $Id: rules_var.mk,v 1.5 1998/04/25 03:23:27 jplejacq Exp $
#
# copyright:
#   Copyright (C) 1998 Jean Pierre LeJacq <jplejacq@quoininc.com>
#
#   Distributed under the GNU GENERAL PUBLIC LICENSE.
#
# description:
#   Standard variables for package building script for package.
#
#   This program is package independent and should work unmodified
#   with any package.
#
# bugs:
#   rules_pkgs creates the link debian/control since this is required
#   by the other dynamic variables.  Unfortunately, the link isn't
#   available after checkout from CVS which causes an error message to 
#   be printed.  This solves this problem but not in an elegant way.



#
# Generate list of all binary packages for this source package.
#
rules_pkgs=\
  $(shell\
    test -L debian/control || ln -f -s dpkg.src/control debian;\
    PATH=$${PATH}:/usr/lib/debhelper;\
    . /usr/lib/debhelper/dh_lib;\
    echo $${DH_DOPACKAGES}\
  )


#
# Generate list of architecture indep binary packages for this source
# package.
#
rules_pkgs_indep=\
  $(shell\
    PATH=$${PATH}:/usr/lib/debhelper;\
    . /usr/lib/debhelper/dh_lib;\
    get_arch_indep_packages;\
    echo $${INDEP_PACKAGES}\
  )


#
# Generate list of architecture dependent binary packages for this
# source package.
#
rules_pkgs_arch=\
  $(shell\
    PATH=$${PATH}:/usr/lib/debhelper;\
    . /usr/lib/debhelper/dh_lib;\
    get_arch_indep_packages;\
    echo $${ARCH_PACKAGES}\
  )


#
# Generate temporary directory to build debian binary package.
#
define rules_tmpdir
$(patsubst %.stamp-check,%.tmp,$(patsubst %.stamp-modify,%.tmp,$(patsubst %.stamp-binary,%.tmp,$(patsubst %.stamp-build,%.tmp,$(@)))))
endef


#
# Generate name of debian binary package.
#
define rules_pkg
$(patsubst debian/%.stamp-check,%,$(patsubst debian/%.stamp-modify,%,$(patsubst debian/%.stamp-binary,%,$(patsubst debian/%.stamp-build,%,$(@)))))
endef
